/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpayaccount;

import com.adyen.model.marketpayaccount.JSON;
import com.adyen.model.marketpayaccount.KYCCheckStatusData;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"checks", "ultimateParentCompanyCode"})
public class KYCUltimateParentCompanyCheckResult {
    public static final String JSON_PROPERTY_CHECKS = "checks";
    private List<KYCCheckStatusData> checks = null;
    public static final String JSON_PROPERTY_ULTIMATE_PARENT_COMPANY_CODE = "ultimateParentCompanyCode";
    private String ultimateParentCompanyCode;

    public KYCUltimateParentCompanyCheckResult checks(List<KYCCheckStatusData> checks) {
        this.checks = checks;
        return this;
    }

    public KYCUltimateParentCompanyCheckResult addChecksItem(KYCCheckStatusData checksItem) {
        if (this.checks == null) {
            this.checks = new ArrayList<KYCCheckStatusData>();
        }
        this.checks.add(checksItem);
        return this;
    }

    @ApiModelProperty(value="A list of the checks and their statuses.")
    @JsonProperty(value="checks")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<KYCCheckStatusData> getChecks() {
        return this.checks;
    }

    @JsonProperty(value="checks")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChecks(List<KYCCheckStatusData> checks) {
        this.checks = checks;
    }

    public KYCUltimateParentCompanyCheckResult ultimateParentCompanyCode(String ultimateParentCompanyCode) {
        this.ultimateParentCompanyCode = ultimateParentCompanyCode;
        return this;
    }

    @ApiModelProperty(value="The code of the Ultimate Parent Company to which the check applies.")
    @JsonProperty(value="ultimateParentCompanyCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUltimateParentCompanyCode() {
        return this.ultimateParentCompanyCode;
    }

    @JsonProperty(value="ultimateParentCompanyCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUltimateParentCompanyCode(String ultimateParentCompanyCode) {
        this.ultimateParentCompanyCode = ultimateParentCompanyCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KYCUltimateParentCompanyCheckResult kyCUltimateParentCompanyCheckResult = (KYCUltimateParentCompanyCheckResult)o;
        return Objects.equals(this.checks, kyCUltimateParentCompanyCheckResult.checks) && Objects.equals(this.ultimateParentCompanyCode, kyCUltimateParentCompanyCheckResult.ultimateParentCompanyCode);
    }

    public int hashCode() {
        return Objects.hash(this.checks, this.ultimateParentCompanyCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KYCUltimateParentCompanyCheckResult {\n");
        sb.append("    checks: ").append(this.toIndentedString(this.checks)).append("\n");
        sb.append("    ultimateParentCompanyCode: ").append(this.toIndentedString(this.ultimateParentCompanyCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static KYCUltimateParentCompanyCheckResult fromJson(String jsonString) throws JsonProcessingException {
        return (KYCUltimateParentCompanyCheckResult)JSON.getMapper().readValue(jsonString, KYCUltimateParentCompanyCheckResult.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

