/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.payout;

import com.adyen.model.payout.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"city", "country", "houseNumberOrName", "postalCode", "stateOrProvince", "street"})
public class Address {
    public static final String JSON_PROPERTY_CITY = "city";
    private String city;
    public static final String JSON_PROPERTY_COUNTRY = "country";
    private String country;
    public static final String JSON_PROPERTY_HOUSE_NUMBER_OR_NAME = "houseNumberOrName";
    private String houseNumberOrName;
    public static final String JSON_PROPERTY_POSTAL_CODE = "postalCode";
    private String postalCode;
    public static final String JSON_PROPERTY_STATE_OR_PROVINCE = "stateOrProvince";
    private String stateOrProvince;
    public static final String JSON_PROPERTY_STREET = "street";
    private String street;

    public Address city(String city) {
        this.city = city;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the city. Maximum length: 3000 characters.")
    @JsonProperty(value="city")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCity() {
        return this.city;
    }

    @JsonProperty(value="city")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCity(String city) {
        this.city = city;
    }

    public Address country(String country) {
        this.country = country;
        return this;
    }

    @ApiModelProperty(required=true, value="The two-character ISO-3166-1 alpha-2 country code. For example, **US**. > If you don't know the country or are not collecting the country from the shopper, provide `country` as `ZZ`.")
    @JsonProperty(value="country")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCountry() {
        return this.country;
    }

    @JsonProperty(value="country")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCountry(String country) {
        this.country = country;
    }

    public Address houseNumberOrName(String houseNumberOrName) {
        this.houseNumberOrName = houseNumberOrName;
        return this;
    }

    @ApiModelProperty(required=true, value="The number or name of the house. Maximum length: 3000 characters.")
    @JsonProperty(value="houseNumberOrName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHouseNumberOrName() {
        return this.houseNumberOrName;
    }

    @JsonProperty(value="houseNumberOrName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHouseNumberOrName(String houseNumberOrName) {
        this.houseNumberOrName = houseNumberOrName;
    }

    public Address postalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    @ApiModelProperty(required=true, value="A maximum of five digits for an address in the US, or a maximum of ten characters for an address in all other countries.")
    @JsonProperty(value="postalCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPostalCode() {
        return this.postalCode;
    }

    @JsonProperty(value="postalCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public Address stateOrProvince(String stateOrProvince) {
        this.stateOrProvince = stateOrProvince;
        return this;
    }

    @ApiModelProperty(value="The two-character ISO 3166-2 state or province code. For example, **CA** in the US or **ON** in Canada. > Required for the US and Canada.")
    @JsonProperty(value="stateOrProvince")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStateOrProvince() {
        return this.stateOrProvince;
    }

    @JsonProperty(value="stateOrProvince")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStateOrProvince(String stateOrProvince) {
        this.stateOrProvince = stateOrProvince;
    }

    public Address street(String street) {
        this.street = street;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the street. Maximum length: 3000 characters. > The house number should not be included in this field; it should be separately provided via `houseNumberOrName`.")
    @JsonProperty(value="street")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStreet() {
        return this.street;
    }

    @JsonProperty(value="street")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStreet(String street) {
        this.street = street;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Address address = (Address)o;
        return Objects.equals(this.city, address.city) && Objects.equals(this.country, address.country) && Objects.equals(this.houseNumberOrName, address.houseNumberOrName) && Objects.equals(this.postalCode, address.postalCode) && Objects.equals(this.stateOrProvince, address.stateOrProvince) && Objects.equals(this.street, address.street);
    }

    public int hashCode() {
        return Objects.hash(this.city, this.country, this.houseNumberOrName, this.postalCode, this.stateOrProvince, this.street);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Address {\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("    houseNumberOrName: ").append(this.toIndentedString(this.houseNumberOrName)).append("\n");
        sb.append("    postalCode: ").append(this.toIndentedString(this.postalCode)).append("\n");
        sb.append("    stateOrProvince: ").append(this.toIndentedString(this.stateOrProvince)).append("\n");
        sb.append("    street: ").append(this.toIndentedString(this.street)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Address fromJson(String jsonString) throws JsonProcessingException {
        return (Address)JSON.getMapper().readValue(jsonString, Address.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

