/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 71
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.checkout;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.checkout.EncryptedOrderData;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * CancelOrderRequest
 */
@JsonPropertyOrder({
  CancelOrderRequest.JSON_PROPERTY_MERCHANT_ACCOUNT,
  CancelOrderRequest.JSON_PROPERTY_ORDER
})

public class CancelOrderRequest {
  public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
  private String merchantAccount;

  public static final String JSON_PROPERTY_ORDER = "order";
  private EncryptedOrderData order;

  public CancelOrderRequest() { 
  }

  /**
   * The merchant account identifier that orderData belongs to.
   *
   * @param merchantAccount
   * @return the current {@code CancelOrderRequest} instance, allowing for method chaining
   */
  public CancelOrderRequest merchantAccount(String merchantAccount) {
    this.merchantAccount = merchantAccount;
    return this;
  }

  /**
   * The merchant account identifier that orderData belongs to.
   * @return merchantAccount
   */
  @ApiModelProperty(required = true, value = "The merchant account identifier that orderData belongs to.")
  @JsonProperty(JSON_PROPERTY_MERCHANT_ACCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMerchantAccount() {
    return merchantAccount;
  }

  /**
   * The merchant account identifier that orderData belongs to.
   *
   * @param merchantAccount
   */ 
  @JsonProperty(JSON_PROPERTY_MERCHANT_ACCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMerchantAccount(String merchantAccount) {
    this.merchantAccount = merchantAccount;
  }

  /**
   * order
   *
   * @param order
   * @return the current {@code CancelOrderRequest} instance, allowing for method chaining
   */
  public CancelOrderRequest order(EncryptedOrderData order) {
    this.order = order;
    return this;
  }

  /**
   * order
   * @return order
   */
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_ORDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public EncryptedOrderData getOrder() {
    return order;
  }

  /**
   * order
   *
   * @param order
   */ 
  @JsonProperty(JSON_PROPERTY_ORDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOrder(EncryptedOrderData order) {
    this.order = order;
  }

  /**
   * Return true if this CancelOrderRequest object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CancelOrderRequest cancelOrderRequest = (CancelOrderRequest) o;
    return Objects.equals(this.merchantAccount, cancelOrderRequest.merchantAccount) &&
        Objects.equals(this.order, cancelOrderRequest.order);
  }

  @Override
  public int hashCode() {
    return Objects.hash(merchantAccount, order);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CancelOrderRequest {\n");
    sb.append("    merchantAccount: ").append(toIndentedString(merchantAccount)).append("\n");
    sb.append("    order: ").append(toIndentedString(order)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of CancelOrderRequest given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of CancelOrderRequest
   * @throws JsonProcessingException if the JSON string is invalid with respect to CancelOrderRequest
   */
  public static CancelOrderRequest fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, CancelOrderRequest.class);
  }
/**
  * Convert an instance of CancelOrderRequest to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
