/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 71
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.checkout;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * SepaDirectDebitDetails
 */
@JsonPropertyOrder({
  SepaDirectDebitDetails.JSON_PROPERTY_CHECKOUT_ATTEMPT_ID,
  SepaDirectDebitDetails.JSON_PROPERTY_IBAN,
  SepaDirectDebitDetails.JSON_PROPERTY_OWNER_NAME,
  SepaDirectDebitDetails.JSON_PROPERTY_RECURRING_DETAIL_REFERENCE,
  SepaDirectDebitDetails.JSON_PROPERTY_STORED_PAYMENT_METHOD_ID,
  SepaDirectDebitDetails.JSON_PROPERTY_TRANSFER_INSTRUMENT_ID,
  SepaDirectDebitDetails.JSON_PROPERTY_TYPE
})

public class SepaDirectDebitDetails {
  public static final String JSON_PROPERTY_CHECKOUT_ATTEMPT_ID = "checkoutAttemptId";
  private String checkoutAttemptId;

  public static final String JSON_PROPERTY_IBAN = "iban";
  private String iban;

  public static final String JSON_PROPERTY_OWNER_NAME = "ownerName";
  private String ownerName;

  public static final String JSON_PROPERTY_RECURRING_DETAIL_REFERENCE = "recurringDetailReference";
  @Deprecated // deprecated since Adyen Checkout API v49: Use `storedPaymentMethodId` instead.
  private String recurringDetailReference;

  public static final String JSON_PROPERTY_STORED_PAYMENT_METHOD_ID = "storedPaymentMethodId";
  private String storedPaymentMethodId;

  public static final String JSON_PROPERTY_TRANSFER_INSTRUMENT_ID = "transferInstrumentId";
  private String transferInstrumentId;

  /**
   * **sepadirectdebit**
   */
  public enum TypeEnum {
    SEPADIRECTDEBIT("sepadirectdebit"),
    
    SEPADIRECTDEBIT_AMAZONPAY("sepadirectdebit_amazonpay");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public SepaDirectDebitDetails() { 
  }

  /**
   * The checkout attempt identifier.
   *
   * @param checkoutAttemptId
   * @return the current {@code SepaDirectDebitDetails} instance, allowing for method chaining
   */
  public SepaDirectDebitDetails checkoutAttemptId(String checkoutAttemptId) {
    this.checkoutAttemptId = checkoutAttemptId;
    return this;
  }

  /**
   * The checkout attempt identifier.
   * @return checkoutAttemptId
   */
  @ApiModelProperty(value = "The checkout attempt identifier.")
  @JsonProperty(JSON_PROPERTY_CHECKOUT_ATTEMPT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCheckoutAttemptId() {
    return checkoutAttemptId;
  }

  /**
   * The checkout attempt identifier.
   *
   * @param checkoutAttemptId
   */ 
  @JsonProperty(JSON_PROPERTY_CHECKOUT_ATTEMPT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCheckoutAttemptId(String checkoutAttemptId) {
    this.checkoutAttemptId = checkoutAttemptId;
  }

  /**
   * The International Bank Account Number (IBAN).
   *
   * @param iban
   * @return the current {@code SepaDirectDebitDetails} instance, allowing for method chaining
   */
  public SepaDirectDebitDetails iban(String iban) {
    this.iban = iban;
    return this;
  }

  /**
   * The International Bank Account Number (IBAN).
   * @return iban
   */
  @ApiModelProperty(required = true, value = "The International Bank Account Number (IBAN).")
  @JsonProperty(JSON_PROPERTY_IBAN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getIban() {
    return iban;
  }

  /**
   * The International Bank Account Number (IBAN).
   *
   * @param iban
   */ 
  @JsonProperty(JSON_PROPERTY_IBAN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIban(String iban) {
    this.iban = iban;
  }

  /**
   * The name of the bank account holder.
   *
   * @param ownerName
   * @return the current {@code SepaDirectDebitDetails} instance, allowing for method chaining
   */
  public SepaDirectDebitDetails ownerName(String ownerName) {
    this.ownerName = ownerName;
    return this;
  }

  /**
   * The name of the bank account holder.
   * @return ownerName
   */
  @ApiModelProperty(required = true, value = "The name of the bank account holder.")
  @JsonProperty(JSON_PROPERTY_OWNER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getOwnerName() {
    return ownerName;
  }

  /**
   * The name of the bank account holder.
   *
   * @param ownerName
   */ 
  @JsonProperty(JSON_PROPERTY_OWNER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwnerName(String ownerName) {
    this.ownerName = ownerName;
  }

  /**
   * This is the &#x60;recurringDetailReference&#x60; returned in the response when you created the token.
   *
   * @param recurringDetailReference
   * @return the current {@code SepaDirectDebitDetails} instance, allowing for method chaining
   *
   * @deprecated since Adyen Checkout API v49
   * Use &#x60;storedPaymentMethodId&#x60; instead.
   */
  @Deprecated
  public SepaDirectDebitDetails recurringDetailReference(String recurringDetailReference) {
    this.recurringDetailReference = recurringDetailReference;
    return this;
  }

  /**
   * This is the &#x60;recurringDetailReference&#x60; returned in the response when you created the token.
   * @return recurringDetailReference
   *
   * @deprecated since Adyen Checkout API v49
   * Use &#x60;storedPaymentMethodId&#x60; instead.
   */
  @Deprecated
  @ApiModelProperty(value = "This is the `recurringDetailReference` returned in the response when you created the token.")
  @JsonProperty(JSON_PROPERTY_RECURRING_DETAIL_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getRecurringDetailReference() {
    return recurringDetailReference;
  }

  /**
   * This is the &#x60;recurringDetailReference&#x60; returned in the response when you created the token.
   *
   * @param recurringDetailReference
   *
   * @deprecated since Adyen Checkout API v49
   * Use &#x60;storedPaymentMethodId&#x60; instead.
   */ 
  @Deprecated
  @JsonProperty(JSON_PROPERTY_RECURRING_DETAIL_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecurringDetailReference(String recurringDetailReference) {
    this.recurringDetailReference = recurringDetailReference;
  }

  /**
   * This is the &#x60;recurringDetailReference&#x60; returned in the response when you created the token.
   *
   * @param storedPaymentMethodId
   * @return the current {@code SepaDirectDebitDetails} instance, allowing for method chaining
   */
  public SepaDirectDebitDetails storedPaymentMethodId(String storedPaymentMethodId) {
    this.storedPaymentMethodId = storedPaymentMethodId;
    return this;
  }

  /**
   * This is the &#x60;recurringDetailReference&#x60; returned in the response when you created the token.
   * @return storedPaymentMethodId
   */
  @ApiModelProperty(value = "This is the `recurringDetailReference` returned in the response when you created the token.")
  @JsonProperty(JSON_PROPERTY_STORED_PAYMENT_METHOD_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getStoredPaymentMethodId() {
    return storedPaymentMethodId;
  }

  /**
   * This is the &#x60;recurringDetailReference&#x60; returned in the response when you created the token.
   *
   * @param storedPaymentMethodId
   */ 
  @JsonProperty(JSON_PROPERTY_STORED_PAYMENT_METHOD_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStoredPaymentMethodId(String storedPaymentMethodId) {
    this.storedPaymentMethodId = storedPaymentMethodId;
  }

  /**
   * The unique identifier of your user&#39;s verified transfer instrument, which you can use to top up their balance accounts.
   *
   * @param transferInstrumentId
   * @return the current {@code SepaDirectDebitDetails} instance, allowing for method chaining
   */
  public SepaDirectDebitDetails transferInstrumentId(String transferInstrumentId) {
    this.transferInstrumentId = transferInstrumentId;
    return this;
  }

  /**
   * The unique identifier of your user&#39;s verified transfer instrument, which you can use to top up their balance accounts.
   * @return transferInstrumentId
   */
  @ApiModelProperty(value = "The unique identifier of your user's verified transfer instrument, which you can use to top up their balance accounts.")
  @JsonProperty(JSON_PROPERTY_TRANSFER_INSTRUMENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getTransferInstrumentId() {
    return transferInstrumentId;
  }

  /**
   * The unique identifier of your user&#39;s verified transfer instrument, which you can use to top up their balance accounts.
   *
   * @param transferInstrumentId
   */ 
  @JsonProperty(JSON_PROPERTY_TRANSFER_INSTRUMENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTransferInstrumentId(String transferInstrumentId) {
    this.transferInstrumentId = transferInstrumentId;
  }

  /**
   * **sepadirectdebit**
   *
   * @param type
   * @return the current {@code SepaDirectDebitDetails} instance, allowing for method chaining
   */
  public SepaDirectDebitDetails type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * **sepadirectdebit**
   * @return type
   */
  @ApiModelProperty(value = "**sepadirectdebit**")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TypeEnum getType() {
    return type;
  }

  /**
   * **sepadirectdebit**
   *
   * @param type
   */ 
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }

  /**
   * Return true if this SepaDirectDebitDetails object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SepaDirectDebitDetails sepaDirectDebitDetails = (SepaDirectDebitDetails) o;
    return Objects.equals(this.checkoutAttemptId, sepaDirectDebitDetails.checkoutAttemptId) &&
        Objects.equals(this.iban, sepaDirectDebitDetails.iban) &&
        Objects.equals(this.ownerName, sepaDirectDebitDetails.ownerName) &&
        Objects.equals(this.recurringDetailReference, sepaDirectDebitDetails.recurringDetailReference) &&
        Objects.equals(this.storedPaymentMethodId, sepaDirectDebitDetails.storedPaymentMethodId) &&
        Objects.equals(this.transferInstrumentId, sepaDirectDebitDetails.transferInstrumentId) &&
        Objects.equals(this.type, sepaDirectDebitDetails.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(checkoutAttemptId, iban, ownerName, recurringDetailReference, storedPaymentMethodId, transferInstrumentId, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SepaDirectDebitDetails {\n");
    sb.append("    checkoutAttemptId: ").append(toIndentedString(checkoutAttemptId)).append("\n");
    sb.append("    iban: ").append(toIndentedString(iban)).append("\n");
    sb.append("    ownerName: ").append(toIndentedString(ownerName)).append("\n");
    sb.append("    recurringDetailReference: ").append(toIndentedString(recurringDetailReference)).append("\n");
    sb.append("    storedPaymentMethodId: ").append(toIndentedString(storedPaymentMethodId)).append("\n");
    sb.append("    transferInstrumentId: ").append(toIndentedString(transferInstrumentId)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of SepaDirectDebitDetails given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of SepaDirectDebitDetails
   * @throws JsonProcessingException if the JSON string is invalid with respect to SepaDirectDebitDetails
   */
  public static SepaDirectDebitDetails fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, SepaDirectDebitDetails.class);
  }
/**
  * Convert an instance of SepaDirectDebitDetails to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
