/*
 * Disputes API
 *
 * The version of the OpenAPI document: 30
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.disputes;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.disputes.DefenseReason;
import com.adyen.model.disputes.DisputeServiceResult;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * DefenseReasonsResponse
 */
@JsonPropertyOrder({
  DefenseReasonsResponse.JSON_PROPERTY_DEFENSE_REASONS,
  DefenseReasonsResponse.JSON_PROPERTY_DISPUTE_SERVICE_RESULT
})

public class DefenseReasonsResponse {
  public static final String JSON_PROPERTY_DEFENSE_REASONS = "defenseReasons";
  private List<DefenseReason> defenseReasons = null;

  public static final String JSON_PROPERTY_DISPUTE_SERVICE_RESULT = "disputeServiceResult";
  private DisputeServiceResult disputeServiceResult;

  public DefenseReasonsResponse() { 
  }

  /**
   * The defense reasons that can be used to defend the dispute.
   *
   * @param defenseReasons
   * @return the current {@code DefenseReasonsResponse} instance, allowing for method chaining
   */
  public DefenseReasonsResponse defenseReasons(List<DefenseReason> defenseReasons) {
    this.defenseReasons = defenseReasons;
    return this;
  }

  public DefenseReasonsResponse addDefenseReasonsItem(DefenseReason defenseReasonsItem) {
    if (this.defenseReasons == null) {
      this.defenseReasons = new ArrayList<>();
    }
    this.defenseReasons.add(defenseReasonsItem);
    return this;
  }

  /**
   * The defense reasons that can be used to defend the dispute.
   * @return defenseReasons
   */
  @ApiModelProperty(value = "The defense reasons that can be used to defend the dispute.")
  @JsonProperty(JSON_PROPERTY_DEFENSE_REASONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<DefenseReason> getDefenseReasons() {
    return defenseReasons;
  }

  /**
   * The defense reasons that can be used to defend the dispute.
   *
   * @param defenseReasons
   */ 
  @JsonProperty(JSON_PROPERTY_DEFENSE_REASONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDefenseReasons(List<DefenseReason> defenseReasons) {
    this.defenseReasons = defenseReasons;
  }

  /**
   * disputeServiceResult
   *
   * @param disputeServiceResult
   * @return the current {@code DefenseReasonsResponse} instance, allowing for method chaining
   */
  public DefenseReasonsResponse disputeServiceResult(DisputeServiceResult disputeServiceResult) {
    this.disputeServiceResult = disputeServiceResult;
    return this;
  }

  /**
   * disputeServiceResult
   * @return disputeServiceResult
   */
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_DISPUTE_SERVICE_RESULT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public DisputeServiceResult getDisputeServiceResult() {
    return disputeServiceResult;
  }

  /**
   * disputeServiceResult
   *
   * @param disputeServiceResult
   */ 
  @JsonProperty(JSON_PROPERTY_DISPUTE_SERVICE_RESULT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisputeServiceResult(DisputeServiceResult disputeServiceResult) {
    this.disputeServiceResult = disputeServiceResult;
  }

  /**
   * Return true if this DefenseReasonsResponse object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DefenseReasonsResponse defenseReasonsResponse = (DefenseReasonsResponse) o;
    return Objects.equals(this.defenseReasons, defenseReasonsResponse.defenseReasons) &&
        Objects.equals(this.disputeServiceResult, defenseReasonsResponse.disputeServiceResult);
  }

  @Override
  public int hashCode() {
    return Objects.hash(defenseReasons, disputeServiceResult);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DefenseReasonsResponse {\n");
    sb.append("    defenseReasons: ").append(toIndentedString(defenseReasons)).append("\n");
    sb.append("    disputeServiceResult: ").append(toIndentedString(disputeServiceResult)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of DefenseReasonsResponse given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of DefenseReasonsResponse
   * @throws JsonProcessingException if the JSON string is invalid with respect to DefenseReasonsResponse
   */
  public static DefenseReasonsResponse fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, DefenseReasonsResponse.class);
  }
/**
  * Convert an instance of DefenseReasonsResponse to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
