/*
 * Dispute webhooks
 *
 * The version of the OpenAPI document: 1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.disputewebhooks;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.disputewebhooks.Amount;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * DisputeEventNotification
 */
@JsonPropertyOrder({
  DisputeEventNotification.JSON_PROPERTY_ARN,
  DisputeEventNotification.JSON_PROPERTY_BALANCE_PLATFORM,
  DisputeEventNotification.JSON_PROPERTY_CREATION_DATE,
  DisputeEventNotification.JSON_PROPERTY_DESCRIPTION,
  DisputeEventNotification.JSON_PROPERTY_DISPUTED_AMOUNT,
  DisputeEventNotification.JSON_PROPERTY_ID,
  DisputeEventNotification.JSON_PROPERTY_STATUS,
  DisputeEventNotification.JSON_PROPERTY_STATUS_DETAIL,
  DisputeEventNotification.JSON_PROPERTY_TRANSACTION_ID,
  DisputeEventNotification.JSON_PROPERTY_TYPE
})

public class DisputeEventNotification {
  public static final String JSON_PROPERTY_ARN = "arn";
  private String arn;

  public static final String JSON_PROPERTY_BALANCE_PLATFORM = "balancePlatform";
  private String balancePlatform;

  public static final String JSON_PROPERTY_CREATION_DATE = "creationDate";
  private OffsetDateTime creationDate;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_DISPUTED_AMOUNT = "disputedAmount";
  private Amount disputedAmount;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_STATUS = "status";
  private String status;

  public static final String JSON_PROPERTY_STATUS_DETAIL = "statusDetail";
  private String statusDetail;

  public static final String JSON_PROPERTY_TRANSACTION_ID = "transactionId";
  private String transactionId;

  /**
   * The type of dispute raised for the transaction.
   */
  public enum TypeEnum {
    FRAUD("fraud"),
    
    NOTDELIVERED("notDelivered");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public DisputeEventNotification() { 
  }

  /**
   * The unique Acquirer Reference Number (arn) generated by the card scheme for each capture. You can use the arn to trace the transaction through its lifecycle.
   *
   * @param arn
   * @return the current {@code DisputeEventNotification} instance, allowing for method chaining
   */
  public DisputeEventNotification arn(String arn) {
    this.arn = arn;
    return this;
  }

  /**
   * The unique Acquirer Reference Number (arn) generated by the card scheme for each capture. You can use the arn to trace the transaction through its lifecycle.
   * @return arn
   */
  @ApiModelProperty(value = "The unique Acquirer Reference Number (arn) generated by the card scheme for each capture. You can use the arn to trace the transaction through its lifecycle.")
  @JsonProperty(JSON_PROPERTY_ARN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getArn() {
    return arn;
  }

  /**
   * The unique Acquirer Reference Number (arn) generated by the card scheme for each capture. You can use the arn to trace the transaction through its lifecycle.
   *
   * @param arn
   */ 
  @JsonProperty(JSON_PROPERTY_ARN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setArn(String arn) {
    this.arn = arn;
  }

  /**
   * The unique identifier of the balance platform.
   *
   * @param balancePlatform
   * @return the current {@code DisputeEventNotification} instance, allowing for method chaining
   */
  public DisputeEventNotification balancePlatform(String balancePlatform) {
    this.balancePlatform = balancePlatform;
    return this;
  }

  /**
   * The unique identifier of the balance platform.
   * @return balancePlatform
   */
  @ApiModelProperty(value = "The unique identifier of the balance platform.")
  @JsonProperty(JSON_PROPERTY_BALANCE_PLATFORM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getBalancePlatform() {
    return balancePlatform;
  }

  /**
   * The unique identifier of the balance platform.
   *
   * @param balancePlatform
   */ 
  @JsonProperty(JSON_PROPERTY_BALANCE_PLATFORM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBalancePlatform(String balancePlatform) {
    this.balancePlatform = balancePlatform;
  }

  /**
   * The date and time when the event was triggered, in ISO 8601 extended format. For example, **2020-12-18T10:15:30+01:00**.
   *
   * @param creationDate
   * @return the current {@code DisputeEventNotification} instance, allowing for method chaining
   */
  public DisputeEventNotification creationDate(OffsetDateTime creationDate) {
    this.creationDate = creationDate;
    return this;
  }

  /**
   * The date and time when the event was triggered, in ISO 8601 extended format. For example, **2020-12-18T10:15:30+01:00**.
   * @return creationDate
   */
  @ApiModelProperty(value = "The date and time when the event was triggered, in ISO 8601 extended format. For example, **2020-12-18T10:15:30+01:00**.")
  @JsonProperty(JSON_PROPERTY_CREATION_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OffsetDateTime getCreationDate() {
    return creationDate;
  }

  /**
   * The date and time when the event was triggered, in ISO 8601 extended format. For example, **2020-12-18T10:15:30+01:00**.
   *
   * @param creationDate
   */ 
  @JsonProperty(JSON_PROPERTY_CREATION_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreationDate(OffsetDateTime creationDate) {
    this.creationDate = creationDate;
  }

  /**
   * Contains information about the dispute.
   *
   * @param description
   * @return the current {@code DisputeEventNotification} instance, allowing for method chaining
   */
  public DisputeEventNotification description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Contains information about the dispute.
   * @return description
   */
  @ApiModelProperty(value = "Contains information about the dispute.")
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDescription() {
    return description;
  }

  /**
   * Contains information about the dispute.
   *
   * @param description
   */ 
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }

  /**
   * disputedAmount
   *
   * @param disputedAmount
   * @return the current {@code DisputeEventNotification} instance, allowing for method chaining
   */
  public DisputeEventNotification disputedAmount(Amount disputedAmount) {
    this.disputedAmount = disputedAmount;
    return this;
  }

  /**
   * disputedAmount
   * @return disputedAmount
   */
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DISPUTED_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Amount getDisputedAmount() {
    return disputedAmount;
  }

  /**
   * disputedAmount
   *
   * @param disputedAmount
   */ 
  @JsonProperty(JSON_PROPERTY_DISPUTED_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisputedAmount(Amount disputedAmount) {
    this.disputedAmount = disputedAmount;
  }

  /**
   * The ID of the resource.
   *
   * @param id
   * @return the current {@code DisputeEventNotification} instance, allowing for method chaining
   */
  public DisputeEventNotification id(String id) {
    this.id = id;
    return this;
  }

  /**
   * The ID of the resource.
   * @return id
   */
  @ApiModelProperty(value = "The ID of the resource.")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getId() {
    return id;
  }

  /**
   * The ID of the resource.
   *
   * @param id
   */ 
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }

  /**
   * The current status of the dispute.
   *
   * @param status
   * @return the current {@code DisputeEventNotification} instance, allowing for method chaining
   */
  public DisputeEventNotification status(String status) {
    this.status = status;
    return this;
  }

  /**
   * The current status of the dispute.
   * @return status
   */
  @ApiModelProperty(value = "The current status of the dispute.")
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getStatus() {
    return status;
  }

  /**
   * The current status of the dispute.
   *
   * @param status
   */ 
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatus(String status) {
    this.status = status;
  }

  /**
   * Additional information about the status of the dispute, when available.
   *
   * @param statusDetail
   * @return the current {@code DisputeEventNotification} instance, allowing for method chaining
   */
  public DisputeEventNotification statusDetail(String statusDetail) {
    this.statusDetail = statusDetail;
    return this;
  }

  /**
   * Additional information about the status of the dispute, when available.
   * @return statusDetail
   */
  @ApiModelProperty(value = "Additional information about the status of the dispute, when available.")
  @JsonProperty(JSON_PROPERTY_STATUS_DETAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getStatusDetail() {
    return statusDetail;
  }

  /**
   * Additional information about the status of the dispute, when available.
   *
   * @param statusDetail
   */ 
  @JsonProperty(JSON_PROPERTY_STATUS_DETAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatusDetail(String statusDetail) {
    this.statusDetail = statusDetail;
  }

  /**
   * The unique reference of the transaction for which the dispute is requested.
   *
   * @param transactionId
   * @return the current {@code DisputeEventNotification} instance, allowing for method chaining
   */
  public DisputeEventNotification transactionId(String transactionId) {
    this.transactionId = transactionId;
    return this;
  }

  /**
   * The unique reference of the transaction for which the dispute is requested.
   * @return transactionId
   */
  @ApiModelProperty(value = "The unique reference of the transaction for which the dispute is requested.")
  @JsonProperty(JSON_PROPERTY_TRANSACTION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getTransactionId() {
    return transactionId;
  }

  /**
   * The unique reference of the transaction for which the dispute is requested.
   *
   * @param transactionId
   */ 
  @JsonProperty(JSON_PROPERTY_TRANSACTION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTransactionId(String transactionId) {
    this.transactionId = transactionId;
  }

  /**
   * The type of dispute raised for the transaction.
   *
   * @param type
   * @return the current {@code DisputeEventNotification} instance, allowing for method chaining
   */
  public DisputeEventNotification type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * The type of dispute raised for the transaction.
   * @return type
   */
  @ApiModelProperty(value = "The type of dispute raised for the transaction.")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TypeEnum getType() {
    return type;
  }

  /**
   * The type of dispute raised for the transaction.
   *
   * @param type
   */ 
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }

  /**
   * Return true if this DisputeEventNotification object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DisputeEventNotification disputeEventNotification = (DisputeEventNotification) o;
    return Objects.equals(this.arn, disputeEventNotification.arn) &&
        Objects.equals(this.balancePlatform, disputeEventNotification.balancePlatform) &&
        Objects.equals(this.creationDate, disputeEventNotification.creationDate) &&
        Objects.equals(this.description, disputeEventNotification.description) &&
        Objects.equals(this.disputedAmount, disputeEventNotification.disputedAmount) &&
        Objects.equals(this.id, disputeEventNotification.id) &&
        Objects.equals(this.status, disputeEventNotification.status) &&
        Objects.equals(this.statusDetail, disputeEventNotification.statusDetail) &&
        Objects.equals(this.transactionId, disputeEventNotification.transactionId) &&
        Objects.equals(this.type, disputeEventNotification.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(arn, balancePlatform, creationDate, description, disputedAmount, id, status, statusDetail, transactionId, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DisputeEventNotification {\n");
    sb.append("    arn: ").append(toIndentedString(arn)).append("\n");
    sb.append("    balancePlatform: ").append(toIndentedString(balancePlatform)).append("\n");
    sb.append("    creationDate: ").append(toIndentedString(creationDate)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    disputedAmount: ").append(toIndentedString(disputedAmount)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    statusDetail: ").append(toIndentedString(statusDetail)).append("\n");
    sb.append("    transactionId: ").append(toIndentedString(transactionId)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of DisputeEventNotification given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of DisputeEventNotification
   * @throws JsonProcessingException if the JSON string is invalid with respect to DisputeEventNotification
   */
  public static DisputeEventNotification fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, DisputeEventNotification.class);
  }
/**
  * Convert an instance of DisputeEventNotification to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
