/*
 * Legal Entity Management API
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.legalentitymanagement;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.legalentitymanagement.SourceOfFunds;
import com.adyen.model.legalentitymanagement.WebData;
import com.adyen.model.legalentitymanagement.WebDataExemption;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * BusinessLineInfoUpdate
 */
@JsonPropertyOrder({
  BusinessLineInfoUpdate.JSON_PROPERTY_INDUSTRY_CODE,
  BusinessLineInfoUpdate.JSON_PROPERTY_SALES_CHANNELS,
  BusinessLineInfoUpdate.JSON_PROPERTY_SOURCE_OF_FUNDS,
  BusinessLineInfoUpdate.JSON_PROPERTY_WEB_DATA,
  BusinessLineInfoUpdate.JSON_PROPERTY_WEB_DATA_EXEMPTION
})

public class BusinessLineInfoUpdate {
  public static final String JSON_PROPERTY_INDUSTRY_CODE = "industryCode";
  private String industryCode;

  public static final String JSON_PROPERTY_SALES_CHANNELS = "salesChannels";
  private List<String> salesChannels = null;

  public static final String JSON_PROPERTY_SOURCE_OF_FUNDS = "sourceOfFunds";
  private SourceOfFunds sourceOfFunds;

  public static final String JSON_PROPERTY_WEB_DATA = "webData";
  private List<WebData> webData = null;

  public static final String JSON_PROPERTY_WEB_DATA_EXEMPTION = "webDataExemption";
  private WebDataExemption webDataExemption;

  public BusinessLineInfoUpdate() { 
  }

  /**
   * A code that represents the industry of your legal entity. For example, **4431A** for computer software stores.
   *
   * @param industryCode
   * @return the current {@code BusinessLineInfoUpdate} instance, allowing for method chaining
   */
  public BusinessLineInfoUpdate industryCode(String industryCode) {
    this.industryCode = industryCode;
    return this;
  }

  /**
   * A code that represents the industry of your legal entity. For example, **4431A** for computer software stores.
   * @return industryCode
   */
  @ApiModelProperty(value = "A code that represents the industry of your legal entity. For example, **4431A** for computer software stores.")
  @JsonProperty(JSON_PROPERTY_INDUSTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getIndustryCode() {
    return industryCode;
  }

  /**
   * A code that represents the industry of your legal entity. For example, **4431A** for computer software stores.
   *
   * @param industryCode
   */ 
  @JsonProperty(JSON_PROPERTY_INDUSTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIndustryCode(String industryCode) {
    this.industryCode = industryCode;
  }

  /**
   * A list of channels where goods or services are sold.  Possible values: **pos**, **posMoto**, **eCommerce**, **ecomMoto**, **payByLink**.  Required only in combination with the &#x60;service&#x60; **paymentProcessing**.
   *
   * @param salesChannels
   * @return the current {@code BusinessLineInfoUpdate} instance, allowing for method chaining
   */
  public BusinessLineInfoUpdate salesChannels(List<String> salesChannels) {
    this.salesChannels = salesChannels;
    return this;
  }

  public BusinessLineInfoUpdate addSalesChannelsItem(String salesChannelsItem) {
    if (this.salesChannels == null) {
      this.salesChannels = new ArrayList<>();
    }
    this.salesChannels.add(salesChannelsItem);
    return this;
  }

  /**
   * A list of channels where goods or services are sold.  Possible values: **pos**, **posMoto**, **eCommerce**, **ecomMoto**, **payByLink**.  Required only in combination with the &#x60;service&#x60; **paymentProcessing**.
   * @return salesChannels
   */
  @ApiModelProperty(value = "A list of channels where goods or services are sold.  Possible values: **pos**, **posMoto**, **eCommerce**, **ecomMoto**, **payByLink**.  Required only in combination with the `service` **paymentProcessing**.")
  @JsonProperty(JSON_PROPERTY_SALES_CHANNELS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getSalesChannels() {
    return salesChannels;
  }

  /**
   * A list of channels where goods or services are sold.  Possible values: **pos**, **posMoto**, **eCommerce**, **ecomMoto**, **payByLink**.  Required only in combination with the &#x60;service&#x60; **paymentProcessing**.
   *
   * @param salesChannels
   */ 
  @JsonProperty(JSON_PROPERTY_SALES_CHANNELS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSalesChannels(List<String> salesChannels) {
    this.salesChannels = salesChannels;
  }

  /**
   * sourceOfFunds
   *
   * @param sourceOfFunds
   * @return the current {@code BusinessLineInfoUpdate} instance, allowing for method chaining
   */
  public BusinessLineInfoUpdate sourceOfFunds(SourceOfFunds sourceOfFunds) {
    this.sourceOfFunds = sourceOfFunds;
    return this;
  }

  /**
   * sourceOfFunds
   * @return sourceOfFunds
   */
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SOURCE_OF_FUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public SourceOfFunds getSourceOfFunds() {
    return sourceOfFunds;
  }

  /**
   * sourceOfFunds
   *
   * @param sourceOfFunds
   */ 
  @JsonProperty(JSON_PROPERTY_SOURCE_OF_FUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceOfFunds(SourceOfFunds sourceOfFunds) {
    this.sourceOfFunds = sourceOfFunds;
  }

  /**
   * List of website URLs where your user&#39;s goods or services are sold. When this is required for a service but your user does not have an online presence, provide the reason in the &#x60;webDataExemption&#x60; object.
   *
   * @param webData
   * @return the current {@code BusinessLineInfoUpdate} instance, allowing for method chaining
   */
  public BusinessLineInfoUpdate webData(List<WebData> webData) {
    this.webData = webData;
    return this;
  }

  public BusinessLineInfoUpdate addWebDataItem(WebData webDataItem) {
    if (this.webData == null) {
      this.webData = new ArrayList<>();
    }
    this.webData.add(webDataItem);
    return this;
  }

  /**
   * List of website URLs where your user&#39;s goods or services are sold. When this is required for a service but your user does not have an online presence, provide the reason in the &#x60;webDataExemption&#x60; object.
   * @return webData
   */
  @ApiModelProperty(value = "List of website URLs where your user's goods or services are sold. When this is required for a service but your user does not have an online presence, provide the reason in the `webDataExemption` object.")
  @JsonProperty(JSON_PROPERTY_WEB_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<WebData> getWebData() {
    return webData;
  }

  /**
   * List of website URLs where your user&#39;s goods or services are sold. When this is required for a service but your user does not have an online presence, provide the reason in the &#x60;webDataExemption&#x60; object.
   *
   * @param webData
   */ 
  @JsonProperty(JSON_PROPERTY_WEB_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWebData(List<WebData> webData) {
    this.webData = webData;
  }

  /**
   * webDataExemption
   *
   * @param webDataExemption
   * @return the current {@code BusinessLineInfoUpdate} instance, allowing for method chaining
   */
  public BusinessLineInfoUpdate webDataExemption(WebDataExemption webDataExemption) {
    this.webDataExemption = webDataExemption;
    return this;
  }

  /**
   * webDataExemption
   * @return webDataExemption
   */
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_WEB_DATA_EXEMPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public WebDataExemption getWebDataExemption() {
    return webDataExemption;
  }

  /**
   * webDataExemption
   *
   * @param webDataExemption
   */ 
  @JsonProperty(JSON_PROPERTY_WEB_DATA_EXEMPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWebDataExemption(WebDataExemption webDataExemption) {
    this.webDataExemption = webDataExemption;
  }

  /**
   * Return true if this BusinessLineInfoUpdate object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BusinessLineInfoUpdate businessLineInfoUpdate = (BusinessLineInfoUpdate) o;
    return Objects.equals(this.industryCode, businessLineInfoUpdate.industryCode) &&
        Objects.equals(this.salesChannels, businessLineInfoUpdate.salesChannels) &&
        Objects.equals(this.sourceOfFunds, businessLineInfoUpdate.sourceOfFunds) &&
        Objects.equals(this.webData, businessLineInfoUpdate.webData) &&
        Objects.equals(this.webDataExemption, businessLineInfoUpdate.webDataExemption);
  }

  @Override
  public int hashCode() {
    return Objects.hash(industryCode, salesChannels, sourceOfFunds, webData, webDataExemption);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BusinessLineInfoUpdate {\n");
    sb.append("    industryCode: ").append(toIndentedString(industryCode)).append("\n");
    sb.append("    salesChannels: ").append(toIndentedString(salesChannels)).append("\n");
    sb.append("    sourceOfFunds: ").append(toIndentedString(sourceOfFunds)).append("\n");
    sb.append("    webData: ").append(toIndentedString(webData)).append("\n");
    sb.append("    webDataExemption: ").append(toIndentedString(webDataExemption)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of BusinessLineInfoUpdate given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of BusinessLineInfoUpdate
   * @throws JsonProcessingException if the JSON string is invalid with respect to BusinessLineInfoUpdate
   */
  public static BusinessLineInfoUpdate fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, BusinessLineInfoUpdate.class);
  }
/**
  * Convert an instance of BusinessLineInfoUpdate to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
