/*
 * Notification Configuration API
 * This API is used for the classic integration. If you are just starting your implementation, refer to our [new integration guide](https://docs.adyen.com/marketplaces-and-platforms) instead.  The Notification Configuration API provides endpoints for setting up and testing notifications that inform you of events on your platform, for example when a verification check or a payout has been completed.  For more information, refer to our [documentation](https://docs.adyen.com/marketplaces-and-platforms/classic/notifications). ## Authentication Your Adyen contact will provide your API credential and an API key. To connect to the API, add an `X-API-Key` header with the API key as the value, for example:   ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: YOUR_API_KEY\" \\ ... ```  Alternatively, you can use the username and password to connect to the API using basic authentication. For example:  ``` curl -U \"ws@MarketPlace.YOUR_PLATFORM_ACCOUNT\":\"YOUR_WS_PASSWORD\" \\ -H \"Content-Type: application/json\" \\ ... ``` When going live, you need to generate new web service user credentials to access the [live endpoints](https://docs.adyen.com/development-resources/live-endpoints).  ## Versioning The Notification Configuration API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://cal-test.adyen.com/cal/services/Notification/v6/createNotificationConfiguration ```
 *
 * The version of the OpenAPI document: 6
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.marketpayconfiguration;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.marketpayconfiguration.ErrorFieldType;
import com.adyen.model.marketpayconfiguration.ExchangeMessage;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * TestNotificationConfigurationResponse
 */
@JsonPropertyOrder({
  TestNotificationConfigurationResponse.JSON_PROPERTY_ERROR_MESSAGES,
  TestNotificationConfigurationResponse.JSON_PROPERTY_EVENT_TYPES,
  TestNotificationConfigurationResponse.JSON_PROPERTY_EXCHANGE_MESSAGES,
  TestNotificationConfigurationResponse.JSON_PROPERTY_INVALID_FIELDS,
  TestNotificationConfigurationResponse.JSON_PROPERTY_NOTIFICATION_ID,
  TestNotificationConfigurationResponse.JSON_PROPERTY_OK_MESSAGES,
  TestNotificationConfigurationResponse.JSON_PROPERTY_PSP_REFERENCE,
  TestNotificationConfigurationResponse.JSON_PROPERTY_RESULT_CODE
})

public class TestNotificationConfigurationResponse {
  public static final String JSON_PROPERTY_ERROR_MESSAGES = "errorMessages";
  private List<String> errorMessages = null;

  /**
   * Gets or Sets eventTypes
   */
  public enum EventTypesEnum {
    ACCOUNT_CLOSED("ACCOUNT_CLOSED"),
    
    ACCOUNT_CREATED("ACCOUNT_CREATED"),
    
    ACCOUNT_FUNDS_BELOW_THRESHOLD("ACCOUNT_FUNDS_BELOW_THRESHOLD"),
    
    ACCOUNT_HOLDER_CREATED("ACCOUNT_HOLDER_CREATED"),
    
    ACCOUNT_HOLDER_LIMIT_REACHED("ACCOUNT_HOLDER_LIMIT_REACHED"),
    
    ACCOUNT_HOLDER_MIGRATED("ACCOUNT_HOLDER_MIGRATED"),
    
    ACCOUNT_HOLDER_PAYOUT("ACCOUNT_HOLDER_PAYOUT"),
    
    ACCOUNT_HOLDER_STATUS_CHANGE("ACCOUNT_HOLDER_STATUS_CHANGE"),
    
    ACCOUNT_HOLDER_STORE_STATUS_CHANGE("ACCOUNT_HOLDER_STORE_STATUS_CHANGE"),
    
    ACCOUNT_HOLDER_UPCOMING_DEADLINE("ACCOUNT_HOLDER_UPCOMING_DEADLINE"),
    
    ACCOUNT_HOLDER_UPDATED("ACCOUNT_HOLDER_UPDATED"),
    
    ACCOUNT_HOLDER_VERIFICATION("ACCOUNT_HOLDER_VERIFICATION"),
    
    ACCOUNT_UPDATED("ACCOUNT_UPDATED"),
    
    BENEFICIARY_SETUP("BENEFICIARY_SETUP"),
    
    COMPENSATE_NEGATIVE_BALANCE("COMPENSATE_NEGATIVE_BALANCE"),
    
    DIRECT_DEBIT_INITIATED("DIRECT_DEBIT_INITIATED"),
    
    FUNDS_MIGRATED("FUNDS_MIGRATED"),
    
    PAYMENT_FAILURE("PAYMENT_FAILURE"),
    
    PENDING_CREDIT("PENDING_CREDIT"),
    
    REFUND_FUNDS_TRANSFER("REFUND_FUNDS_TRANSFER"),
    
    REPORT_AVAILABLE("REPORT_AVAILABLE"),
    
    SCHEDULED_REFUNDS("SCHEDULED_REFUNDS"),
    
    SCORE_SIGNAL_TRIGGERED("SCORE_SIGNAL_TRIGGERED"),
    
    TRANSFER_FUNDS("TRANSFER_FUNDS"),
    
    TRANSFER_NOT_PAIDOUT_TRANSFERS("TRANSFER_NOT_PAIDOUT_TRANSFERS");

    private String value;

    EventTypesEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static EventTypesEnum fromValue(String value) {
      for (EventTypesEnum b : EventTypesEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_EVENT_TYPES = "eventTypes";
  private List<EventTypesEnum> eventTypes = null;

  public static final String JSON_PROPERTY_EXCHANGE_MESSAGES = "exchangeMessages";
  private List<ExchangeMessage> exchangeMessages = null;

  public static final String JSON_PROPERTY_INVALID_FIELDS = "invalidFields";
  private List<ErrorFieldType> invalidFields = null;

  public static final String JSON_PROPERTY_NOTIFICATION_ID = "notificationId";
  private Long notificationId;

  public static final String JSON_PROPERTY_OK_MESSAGES = "okMessages";
  private List<String> okMessages = null;

  public static final String JSON_PROPERTY_PSP_REFERENCE = "pspReference";
  private String pspReference;

  public static final String JSON_PROPERTY_RESULT_CODE = "resultCode";
  private String resultCode;

  public TestNotificationConfigurationResponse() { 
  }

  public TestNotificationConfigurationResponse errorMessages(List<String> errorMessages) {
    this.errorMessages = errorMessages;
    return this;
  }

  public TestNotificationConfigurationResponse addErrorMessagesItem(String errorMessagesItem) {
    if (this.errorMessages == null) {
      this.errorMessages = new ArrayList<>();
    }
    this.errorMessages.add(errorMessagesItem);
    return this;
  }

   /**
   * Any error messages encountered.
   * @return errorMessages
  **/
  @ApiModelProperty(value = "Any error messages encountered.")
  @JsonProperty(JSON_PROPERTY_ERROR_MESSAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getErrorMessages() {
    return errorMessages;
  }


  @JsonProperty(JSON_PROPERTY_ERROR_MESSAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setErrorMessages(List<String> errorMessages) {
    this.errorMessages = errorMessages;
  }


  public TestNotificationConfigurationResponse eventTypes(List<EventTypesEnum> eventTypes) {
    this.eventTypes = eventTypes;
    return this;
  }

  public TestNotificationConfigurationResponse addEventTypesItem(EventTypesEnum eventTypesItem) {
    if (this.eventTypes == null) {
      this.eventTypes = new ArrayList<>();
    }
    this.eventTypes.add(eventTypesItem);
    return this;
  }

   /**
   * The event types that were tested. &gt;Permitted values: &#x60;ACCOUNT_HOLDER_CREATED&#x60;, &#x60;ACCOUNT_CREATED&#x60;, &#x60;ACCOUNT_UPDATED&#x60;, &#x60;ACCOUNT_HOLDER_UPDATED&#x60;, &#x60;ACCOUNT_HOLDER_STATUS_CHANGE&#x60;, &#x60;ACCOUNT_HOLDER_STORE_STATUS_CHANGE&#x60; &#x60;ACCOUNT_HOLDER_VERIFICATION&#x60;, &#x60;ACCOUNT_HOLDER_LIMIT_REACHED&#x60;, &#x60;ACCOUNT_HOLDER_PAYOUT&#x60;, &#x60;PAYMENT_FAILURE&#x60;, &#x60;SCHEDULED_REFUNDS&#x60;, &#x60;REPORT_AVAILABLE&#x60;, &#x60;TRANSFER_FUNDS&#x60;, &#x60;BENEFICIARY_SETUP&#x60;, &#x60;COMPENSATE_NEGATIVE_BALANCE&#x60;.
   * @return eventTypes
  **/
  @ApiModelProperty(value = "The event types that were tested. >Permitted values: `ACCOUNT_HOLDER_CREATED`, `ACCOUNT_CREATED`, `ACCOUNT_UPDATED`, `ACCOUNT_HOLDER_UPDATED`, `ACCOUNT_HOLDER_STATUS_CHANGE`, `ACCOUNT_HOLDER_STORE_STATUS_CHANGE` `ACCOUNT_HOLDER_VERIFICATION`, `ACCOUNT_HOLDER_LIMIT_REACHED`, `ACCOUNT_HOLDER_PAYOUT`, `PAYMENT_FAILURE`, `SCHEDULED_REFUNDS`, `REPORT_AVAILABLE`, `TRANSFER_FUNDS`, `BENEFICIARY_SETUP`, `COMPENSATE_NEGATIVE_BALANCE`.")
  @JsonProperty(JSON_PROPERTY_EVENT_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<EventTypesEnum> getEventTypes() {
    return eventTypes;
  }


  @JsonProperty(JSON_PROPERTY_EVENT_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEventTypes(List<EventTypesEnum> eventTypes) {
    this.eventTypes = eventTypes;
  }


  public TestNotificationConfigurationResponse exchangeMessages(List<ExchangeMessage> exchangeMessages) {
    this.exchangeMessages = exchangeMessages;
    return this;
  }

  public TestNotificationConfigurationResponse addExchangeMessagesItem(ExchangeMessage exchangeMessagesItem) {
    if (this.exchangeMessages == null) {
      this.exchangeMessages = new ArrayList<>();
    }
    this.exchangeMessages.add(exchangeMessagesItem);
    return this;
  }

   /**
   * The notification message and related response messages.
   * @return exchangeMessages
  **/
  @ApiModelProperty(value = "The notification message and related response messages.")
  @JsonProperty(JSON_PROPERTY_EXCHANGE_MESSAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ExchangeMessage> getExchangeMessages() {
    return exchangeMessages;
  }


  @JsonProperty(JSON_PROPERTY_EXCHANGE_MESSAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExchangeMessages(List<ExchangeMessage> exchangeMessages) {
    this.exchangeMessages = exchangeMessages;
  }


  public TestNotificationConfigurationResponse invalidFields(List<ErrorFieldType> invalidFields) {
    this.invalidFields = invalidFields;
    return this;
  }

  public TestNotificationConfigurationResponse addInvalidFieldsItem(ErrorFieldType invalidFieldsItem) {
    if (this.invalidFields == null) {
      this.invalidFields = new ArrayList<>();
    }
    this.invalidFields.add(invalidFieldsItem);
    return this;
  }

   /**
   * Contains field validation errors that would prevent requests from being processed.
   * @return invalidFields
  **/
  @ApiModelProperty(value = "Contains field validation errors that would prevent requests from being processed.")
  @JsonProperty(JSON_PROPERTY_INVALID_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ErrorFieldType> getInvalidFields() {
    return invalidFields;
  }


  @JsonProperty(JSON_PROPERTY_INVALID_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInvalidFields(List<ErrorFieldType> invalidFields) {
    this.invalidFields = invalidFields;
  }


  public TestNotificationConfigurationResponse notificationId(Long notificationId) {
    this.notificationId = notificationId;
    return this;
  }

   /**
   * The ID of the notification subscription configuration.
   * @return notificationId
  **/
  @ApiModelProperty(required = true, value = "The ID of the notification subscription configuration.")
  @JsonProperty(JSON_PROPERTY_NOTIFICATION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getNotificationId() {
    return notificationId;
  }


  @JsonProperty(JSON_PROPERTY_NOTIFICATION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNotificationId(Long notificationId) {
    this.notificationId = notificationId;
  }


  public TestNotificationConfigurationResponse okMessages(List<String> okMessages) {
    this.okMessages = okMessages;
    return this;
  }

  public TestNotificationConfigurationResponse addOkMessagesItem(String okMessagesItem) {
    if (this.okMessages == null) {
      this.okMessages = new ArrayList<>();
    }
    this.okMessages.add(okMessagesItem);
    return this;
  }

   /**
   * A list of messages describing the testing steps.
   * @return okMessages
  **/
  @ApiModelProperty(value = "A list of messages describing the testing steps.")
  @JsonProperty(JSON_PROPERTY_OK_MESSAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getOkMessages() {
    return okMessages;
  }


  @JsonProperty(JSON_PROPERTY_OK_MESSAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOkMessages(List<String> okMessages) {
    this.okMessages = okMessages;
  }


  public TestNotificationConfigurationResponse pspReference(String pspReference) {
    this.pspReference = pspReference;
    return this;
  }

   /**
   * The reference of a request. Can be used to uniquely identify the request.
   * @return pspReference
  **/
  @ApiModelProperty(value = "The reference of a request. Can be used to uniquely identify the request.")
  @JsonProperty(JSON_PROPERTY_PSP_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPspReference() {
    return pspReference;
  }


  @JsonProperty(JSON_PROPERTY_PSP_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPspReference(String pspReference) {
    this.pspReference = pspReference;
  }


  public TestNotificationConfigurationResponse resultCode(String resultCode) {
    this.resultCode = resultCode;
    return this;
  }

   /**
   * The result code.
   * @return resultCode
  **/
  @ApiModelProperty(value = "The result code.")
  @JsonProperty(JSON_PROPERTY_RESULT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getResultCode() {
    return resultCode;
  }


  @JsonProperty(JSON_PROPERTY_RESULT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setResultCode(String resultCode) {
    this.resultCode = resultCode;
  }


  /**
   * Return true if this TestNotificationConfigurationResponse object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TestNotificationConfigurationResponse testNotificationConfigurationResponse = (TestNotificationConfigurationResponse) o;
    return Objects.equals(this.errorMessages, testNotificationConfigurationResponse.errorMessages) &&
        Objects.equals(this.eventTypes, testNotificationConfigurationResponse.eventTypes) &&
        Objects.equals(this.exchangeMessages, testNotificationConfigurationResponse.exchangeMessages) &&
        Objects.equals(this.invalidFields, testNotificationConfigurationResponse.invalidFields) &&
        Objects.equals(this.notificationId, testNotificationConfigurationResponse.notificationId) &&
        Objects.equals(this.okMessages, testNotificationConfigurationResponse.okMessages) &&
        Objects.equals(this.pspReference, testNotificationConfigurationResponse.pspReference) &&
        Objects.equals(this.resultCode, testNotificationConfigurationResponse.resultCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(errorMessages, eventTypes, exchangeMessages, invalidFields, notificationId, okMessages, pspReference, resultCode);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TestNotificationConfigurationResponse {\n");
    sb.append("    errorMessages: ").append(toIndentedString(errorMessages)).append("\n");
    sb.append("    eventTypes: ").append(toIndentedString(eventTypes)).append("\n");
    sb.append("    exchangeMessages: ").append(toIndentedString(exchangeMessages)).append("\n");
    sb.append("    invalidFields: ").append(toIndentedString(invalidFields)).append("\n");
    sb.append("    notificationId: ").append(toIndentedString(notificationId)).append("\n");
    sb.append("    okMessages: ").append(toIndentedString(okMessages)).append("\n");
    sb.append("    pspReference: ").append(toIndentedString(pspReference)).append("\n");
    sb.append("    resultCode: ").append(toIndentedString(resultCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of TestNotificationConfigurationResponse given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of TestNotificationConfigurationResponse
   * @throws JsonProcessingException if the JSON string is invalid with respect to TestNotificationConfigurationResponse
   */
  public static TestNotificationConfigurationResponse fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, TestNotificationConfigurationResponse.class);
  }
/**
  * Convert an instance of TestNotificationConfigurationResponse to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

