/*
 * Fund API
 * This API is used for the classic integration. If you are just starting your implementation, refer to our [new integration guide](https://docs.adyen.com/marketplaces-and-platforms) instead.  The Fund API provides endpoints for managing the funds in the accounts on your platform. These management operations include, for example, the transfer of funds from one account to another, the payout of funds to an account holder, and the retrieval of balances in an account.  For more information, refer to our [documentation](https://docs.adyen.com/marketplaces-and-platforms/classic/). ## Authentication Your Adyen contact will provide your API credential and an API key. To connect to the API, add an `X-API-Key` header with the API key as the value, for example:   ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: YOUR_API_KEY\" \\ ... ```  Alternatively, you can use the username and password to connect to the API using basic authentication. For example:  ``` curl -U \"ws@MarketPlace.YOUR_PLATFORM_ACCOUNT\":\"YOUR_WS_PASSWORD\" \\ -H \"Content-Type: application/json\" \\ ... ``` When going live, you need to generate new web service user credentials to access the [live endpoints](https://docs.adyen.com/development-resources/live-endpoints).  ## Versioning The Fund API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://cal-test.adyen.com/cal/services/Fund/v6/accountHolderBalance ```
 *
 * The version of the OpenAPI document: 6
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.marketpayfund;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.marketpayfund.ErrorFieldType;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * RefundFundsTransferResponse
 */
@JsonPropertyOrder({
  RefundFundsTransferResponse.JSON_PROPERTY_INVALID_FIELDS,
  RefundFundsTransferResponse.JSON_PROPERTY_MERCHANT_REFERENCE,
  RefundFundsTransferResponse.JSON_PROPERTY_MESSAGE,
  RefundFundsTransferResponse.JSON_PROPERTY_ORIGINAL_REFERENCE,
  RefundFundsTransferResponse.JSON_PROPERTY_PSP_REFERENCE,
  RefundFundsTransferResponse.JSON_PROPERTY_RESULT_CODE
})

public class RefundFundsTransferResponse {
  public static final String JSON_PROPERTY_INVALID_FIELDS = "invalidFields";
  private List<ErrorFieldType> invalidFields = null;

  public static final String JSON_PROPERTY_MERCHANT_REFERENCE = "merchantReference";
  private String merchantReference;

  public static final String JSON_PROPERTY_MESSAGE = "message";
  private String message;

  public static final String JSON_PROPERTY_ORIGINAL_REFERENCE = "originalReference";
  private String originalReference;

  public static final String JSON_PROPERTY_PSP_REFERENCE = "pspReference";
  private String pspReference;

  public static final String JSON_PROPERTY_RESULT_CODE = "resultCode";
  private String resultCode;

  public RefundFundsTransferResponse() { 
  }

  public RefundFundsTransferResponse invalidFields(List<ErrorFieldType> invalidFields) {
    this.invalidFields = invalidFields;
    return this;
  }

  public RefundFundsTransferResponse addInvalidFieldsItem(ErrorFieldType invalidFieldsItem) {
    if (this.invalidFields == null) {
      this.invalidFields = new ArrayList<>();
    }
    this.invalidFields.add(invalidFieldsItem);
    return this;
  }

   /**
   * Contains field validation errors that would prevent requests from being processed.
   * @return invalidFields
  **/
  @ApiModelProperty(value = "Contains field validation errors that would prevent requests from being processed.")
  @JsonProperty(JSON_PROPERTY_INVALID_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ErrorFieldType> getInvalidFields() {
    return invalidFields;
  }


  @JsonProperty(JSON_PROPERTY_INVALID_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInvalidFields(List<ErrorFieldType> invalidFields) {
    this.invalidFields = invalidFields;
  }


  public RefundFundsTransferResponse merchantReference(String merchantReference) {
    this.merchantReference = merchantReference;
    return this;
  }

   /**
   * The value supplied by the executing user when initiating the transfer refund; may be used to link multiple transactions.
   * @return merchantReference
  **/
  @ApiModelProperty(value = "The value supplied by the executing user when initiating the transfer refund; may be used to link multiple transactions.")
  @JsonProperty(JSON_PROPERTY_MERCHANT_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMerchantReference() {
    return merchantReference;
  }


  @JsonProperty(JSON_PROPERTY_MERCHANT_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMerchantReference(String merchantReference) {
    this.merchantReference = merchantReference;
  }


  public RefundFundsTransferResponse message(String message) {
    this.message = message;
    return this;
  }

   /**
   * The message of the response.
   * @return message
  **/
  @ApiModelProperty(value = "The message of the response.")
  @JsonProperty(JSON_PROPERTY_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMessage() {
    return message;
  }


  @JsonProperty(JSON_PROPERTY_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMessage(String message) {
    this.message = message;
  }


  public RefundFundsTransferResponse originalReference(String originalReference) {
    this.originalReference = originalReference;
    return this;
  }

   /**
   * A PSP reference of the original fund transfer.
   * @return originalReference
  **/
  @ApiModelProperty(value = "A PSP reference of the original fund transfer.")
  @JsonProperty(JSON_PROPERTY_ORIGINAL_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOriginalReference() {
    return originalReference;
  }


  @JsonProperty(JSON_PROPERTY_ORIGINAL_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOriginalReference(String originalReference) {
    this.originalReference = originalReference;
  }


  public RefundFundsTransferResponse pspReference(String pspReference) {
    this.pspReference = pspReference;
    return this;
  }

   /**
   * The reference of a request. Can be used to uniquely identify the request.
   * @return pspReference
  **/
  @ApiModelProperty(value = "The reference of a request. Can be used to uniquely identify the request.")
  @JsonProperty(JSON_PROPERTY_PSP_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPspReference() {
    return pspReference;
  }


  @JsonProperty(JSON_PROPERTY_PSP_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPspReference(String pspReference) {
    this.pspReference = pspReference;
  }


  public RefundFundsTransferResponse resultCode(String resultCode) {
    this.resultCode = resultCode;
    return this;
  }

   /**
   * The result code.
   * @return resultCode
  **/
  @ApiModelProperty(value = "The result code.")
  @JsonProperty(JSON_PROPERTY_RESULT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getResultCode() {
    return resultCode;
  }


  @JsonProperty(JSON_PROPERTY_RESULT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setResultCode(String resultCode) {
    this.resultCode = resultCode;
  }


  /**
   * Return true if this RefundFundsTransferResponse object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RefundFundsTransferResponse refundFundsTransferResponse = (RefundFundsTransferResponse) o;
    return Objects.equals(this.invalidFields, refundFundsTransferResponse.invalidFields) &&
        Objects.equals(this.merchantReference, refundFundsTransferResponse.merchantReference) &&
        Objects.equals(this.message, refundFundsTransferResponse.message) &&
        Objects.equals(this.originalReference, refundFundsTransferResponse.originalReference) &&
        Objects.equals(this.pspReference, refundFundsTransferResponse.pspReference) &&
        Objects.equals(this.resultCode, refundFundsTransferResponse.resultCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(invalidFields, merchantReference, message, originalReference, pspReference, resultCode);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RefundFundsTransferResponse {\n");
    sb.append("    invalidFields: ").append(toIndentedString(invalidFields)).append("\n");
    sb.append("    merchantReference: ").append(toIndentedString(merchantReference)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    originalReference: ").append(toIndentedString(originalReference)).append("\n");
    sb.append("    pspReference: ").append(toIndentedString(pspReference)).append("\n");
    sb.append("    resultCode: ").append(toIndentedString(resultCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of RefundFundsTransferResponse given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of RefundFundsTransferResponse
   * @throws JsonProcessingException if the JSON string is invalid with respect to RefundFundsTransferResponse
   */
  public static RefundFundsTransferResponse fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, RefundFundsTransferResponse.class);
  }
/**
  * Convert an instance of RefundFundsTransferResponse to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

