/*
 * Adyen Payment API
 *
 * The version of the OpenAPI document: 68
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.payment;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * SecureRemoteCommerceCheckoutData
 */
@JsonPropertyOrder({
  SecureRemoteCommerceCheckoutData.JSON_PROPERTY_CHECKOUT_PAYLOAD,
  SecureRemoteCommerceCheckoutData.JSON_PROPERTY_CORRELATION_ID,
  SecureRemoteCommerceCheckoutData.JSON_PROPERTY_CVC,
  SecureRemoteCommerceCheckoutData.JSON_PROPERTY_DIGITAL_CARD_ID,
  SecureRemoteCommerceCheckoutData.JSON_PROPERTY_SCHEME,
  SecureRemoteCommerceCheckoutData.JSON_PROPERTY_TOKEN_REFERENCE
})

public class SecureRemoteCommerceCheckoutData {
  public static final String JSON_PROPERTY_CHECKOUT_PAYLOAD = "checkoutPayload";
  private String checkoutPayload;

  public static final String JSON_PROPERTY_CORRELATION_ID = "correlationId";
  private String correlationId;

  public static final String JSON_PROPERTY_CVC = "cvc";
  private String cvc;

  public static final String JSON_PROPERTY_DIGITAL_CARD_ID = "digitalCardId";
  private String digitalCardId;

  /**
   * The Secure Remote Commerce scheme.
   */
  public enum SchemeEnum {
    MC("mc"),
    
    VISA("visa");

    private String value;

    SchemeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SchemeEnum fromValue(String value) {
      for (SchemeEnum b : SchemeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SCHEME = "scheme";
  private SchemeEnum scheme;

  public static final String JSON_PROPERTY_TOKEN_REFERENCE = "tokenReference";
  private String tokenReference;

  public SecureRemoteCommerceCheckoutData() { 
  }

  /**
   * The Secure Remote Commerce checkout payload to process the payment with.
   *
   * @param checkoutPayload
   * @return the current {@code SecureRemoteCommerceCheckoutData} instance, allowing for method chaining
   */
  public SecureRemoteCommerceCheckoutData checkoutPayload(String checkoutPayload) {
    this.checkoutPayload = checkoutPayload;
    return this;
  }

  /**
   * The Secure Remote Commerce checkout payload to process the payment with.
   * @return checkoutPayload
   */
  @ApiModelProperty(value = "The Secure Remote Commerce checkout payload to process the payment with.")
  @JsonProperty(JSON_PROPERTY_CHECKOUT_PAYLOAD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCheckoutPayload() {
    return checkoutPayload;
  }

  /**
   * The Secure Remote Commerce checkout payload to process the payment with.
   *
   * @param checkoutPayload
   */ 
  @JsonProperty(JSON_PROPERTY_CHECKOUT_PAYLOAD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCheckoutPayload(String checkoutPayload) {
    this.checkoutPayload = checkoutPayload;
  }

  /**
   * This is the unique identifier generated by SRC system to track and link SRC messages. Available within the present checkout session (e.g. received in an earlier API response during the present session).
   *
   * @param correlationId
   * @return the current {@code SecureRemoteCommerceCheckoutData} instance, allowing for method chaining
   */
  public SecureRemoteCommerceCheckoutData correlationId(String correlationId) {
    this.correlationId = correlationId;
    return this;
  }

  /**
   * This is the unique identifier generated by SRC system to track and link SRC messages. Available within the present checkout session (e.g. received in an earlier API response during the present session).
   * @return correlationId
   */
  @ApiModelProperty(value = "This is the unique identifier generated by SRC system to track and link SRC messages. Available within the present checkout session (e.g. received in an earlier API response during the present session).")
  @JsonProperty(JSON_PROPERTY_CORRELATION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCorrelationId() {
    return correlationId;
  }

  /**
   * This is the unique identifier generated by SRC system to track and link SRC messages. Available within the present checkout session (e.g. received in an earlier API response during the present session).
   *
   * @param correlationId
   */ 
  @JsonProperty(JSON_PROPERTY_CORRELATION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCorrelationId(String correlationId) {
    this.correlationId = correlationId;
  }

  /**
   * The [card verification code](https://docs.adyen.com/get-started-with-adyen/payment-glossary/#card-security-code-cvc-cvv-cid).
   *
   * @param cvc
   * @return the current {@code SecureRemoteCommerceCheckoutData} instance, allowing for method chaining
   */
  public SecureRemoteCommerceCheckoutData cvc(String cvc) {
    this.cvc = cvc;
    return this;
  }

  /**
   * The [card verification code](https://docs.adyen.com/get-started-with-adyen/payment-glossary/#card-security-code-cvc-cvv-cid).
   * @return cvc
   */
  @ApiModelProperty(value = "The [card verification code](https://docs.adyen.com/get-started-with-adyen/payment-glossary/#card-security-code-cvc-cvv-cid).")
  @JsonProperty(JSON_PROPERTY_CVC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCvc() {
    return cvc;
  }

  /**
   * The [card verification code](https://docs.adyen.com/get-started-with-adyen/payment-glossary/#card-security-code-cvc-cvv-cid).
   *
   * @param cvc
   */ 
  @JsonProperty(JSON_PROPERTY_CVC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCvc(String cvc) {
    this.cvc = cvc;
  }

  /**
   * A unique identifier that represents the token associated with a card enrolled. Required for scheme &#39;mc&#39;.
   *
   * @param digitalCardId
   * @return the current {@code SecureRemoteCommerceCheckoutData} instance, allowing for method chaining
   */
  public SecureRemoteCommerceCheckoutData digitalCardId(String digitalCardId) {
    this.digitalCardId = digitalCardId;
    return this;
  }

  /**
   * A unique identifier that represents the token associated with a card enrolled. Required for scheme &#39;mc&#39;.
   * @return digitalCardId
   */
  @ApiModelProperty(value = "A unique identifier that represents the token associated with a card enrolled. Required for scheme 'mc'.")
  @JsonProperty(JSON_PROPERTY_DIGITAL_CARD_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDigitalCardId() {
    return digitalCardId;
  }

  /**
   * A unique identifier that represents the token associated with a card enrolled. Required for scheme &#39;mc&#39;.
   *
   * @param digitalCardId
   */ 
  @JsonProperty(JSON_PROPERTY_DIGITAL_CARD_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDigitalCardId(String digitalCardId) {
    this.digitalCardId = digitalCardId;
  }

  /**
   * The Secure Remote Commerce scheme.
   *
   * @param scheme
   * @return the current {@code SecureRemoteCommerceCheckoutData} instance, allowing for method chaining
   */
  public SecureRemoteCommerceCheckoutData scheme(SchemeEnum scheme) {
    this.scheme = scheme;
    return this;
  }

  /**
   * The Secure Remote Commerce scheme.
   * @return scheme
   */
  @ApiModelProperty(value = "The Secure Remote Commerce scheme.")
  @JsonProperty(JSON_PROPERTY_SCHEME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public SchemeEnum getScheme() {
    return scheme;
  }

  /**
   * The Secure Remote Commerce scheme.
   *
   * @param scheme
   */ 
  @JsonProperty(JSON_PROPERTY_SCHEME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setScheme(SchemeEnum scheme) {
    this.scheme = scheme;
  }

  /**
   * A unique identifier that represents the token associated with a card enrolled. Required for scheme &#39;visa&#39;.
   *
   * @param tokenReference
   * @return the current {@code SecureRemoteCommerceCheckoutData} instance, allowing for method chaining
   */
  public SecureRemoteCommerceCheckoutData tokenReference(String tokenReference) {
    this.tokenReference = tokenReference;
    return this;
  }

  /**
   * A unique identifier that represents the token associated with a card enrolled. Required for scheme &#39;visa&#39;.
   * @return tokenReference
   */
  @ApiModelProperty(value = "A unique identifier that represents the token associated with a card enrolled. Required for scheme 'visa'.")
  @JsonProperty(JSON_PROPERTY_TOKEN_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getTokenReference() {
    return tokenReference;
  }

  /**
   * A unique identifier that represents the token associated with a card enrolled. Required for scheme &#39;visa&#39;.
   *
   * @param tokenReference
   */ 
  @JsonProperty(JSON_PROPERTY_TOKEN_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTokenReference(String tokenReference) {
    this.tokenReference = tokenReference;
  }

  /**
   * Return true if this SecureRemoteCommerceCheckoutData object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SecureRemoteCommerceCheckoutData secureRemoteCommerceCheckoutData = (SecureRemoteCommerceCheckoutData) o;
    return Objects.equals(this.checkoutPayload, secureRemoteCommerceCheckoutData.checkoutPayload) &&
        Objects.equals(this.correlationId, secureRemoteCommerceCheckoutData.correlationId) &&
        Objects.equals(this.cvc, secureRemoteCommerceCheckoutData.cvc) &&
        Objects.equals(this.digitalCardId, secureRemoteCommerceCheckoutData.digitalCardId) &&
        Objects.equals(this.scheme, secureRemoteCommerceCheckoutData.scheme) &&
        Objects.equals(this.tokenReference, secureRemoteCommerceCheckoutData.tokenReference);
  }

  @Override
  public int hashCode() {
    return Objects.hash(checkoutPayload, correlationId, cvc, digitalCardId, scheme, tokenReference);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SecureRemoteCommerceCheckoutData {\n");
    sb.append("    checkoutPayload: ").append(toIndentedString(checkoutPayload)).append("\n");
    sb.append("    correlationId: ").append(toIndentedString(correlationId)).append("\n");
    sb.append("    cvc: ").append(toIndentedString(cvc)).append("\n");
    sb.append("    digitalCardId: ").append(toIndentedString(digitalCardId)).append("\n");
    sb.append("    scheme: ").append(toIndentedString(scheme)).append("\n");
    sb.append("    tokenReference: ").append(toIndentedString(tokenReference)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of SecureRemoteCommerceCheckoutData given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of SecureRemoteCommerceCheckoutData
   * @throws JsonProcessingException if the JSON string is invalid with respect to SecureRemoteCommerceCheckoutData
   */
  public static SecureRemoteCommerceCheckoutData fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, SecureRemoteCommerceCheckoutData.class);
  }
/**
  * Convert an instance of SecureRemoteCommerceCheckoutData to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
