/*
 * Transfer webhooks
 *
 * The version of the OpenAPI document: 4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.transferwebhooks;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.transferwebhooks.Leg;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * Airline
 */
@JsonPropertyOrder({
  Airline.JSON_PROPERTY_LEGS,
  Airline.JSON_PROPERTY_TICKET_NUMBER
})

public class Airline {
  public static final String JSON_PROPERTY_LEGS = "legs";
  private List<Leg> legs = null;

  public static final String JSON_PROPERTY_TICKET_NUMBER = "ticketNumber";
  private String ticketNumber;

  public Airline() { 
  }

  /**
   * Details about the flight legs for this ticket.
   *
   * @param legs
   * @return the current {@code Airline} instance, allowing for method chaining
   */
  public Airline legs(List<Leg> legs) {
    this.legs = legs;
    return this;
  }

  public Airline addLegsItem(Leg legsItem) {
    if (this.legs == null) {
      this.legs = new ArrayList<>();
    }
    this.legs.add(legsItem);
    return this;
  }

  /**
   * Details about the flight legs for this ticket.
   * @return legs
   */
  @ApiModelProperty(value = "Details about the flight legs for this ticket.")
  @JsonProperty(JSON_PROPERTY_LEGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<Leg> getLegs() {
    return legs;
  }

  /**
   * Details about the flight legs for this ticket.
   *
   * @param legs
   */ 
  @JsonProperty(JSON_PROPERTY_LEGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLegs(List<Leg> legs) {
    this.legs = legs;
  }

  /**
   * The ticket&#39;s unique identifier
   *
   * @param ticketNumber
   * @return the current {@code Airline} instance, allowing for method chaining
   */
  public Airline ticketNumber(String ticketNumber) {
    this.ticketNumber = ticketNumber;
    return this;
  }

  /**
   * The ticket&#39;s unique identifier
   * @return ticketNumber
   */
  @ApiModelProperty(value = "The ticket's unique identifier")
  @JsonProperty(JSON_PROPERTY_TICKET_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getTicketNumber() {
    return ticketNumber;
  }

  /**
   * The ticket&#39;s unique identifier
   *
   * @param ticketNumber
   */ 
  @JsonProperty(JSON_PROPERTY_TICKET_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTicketNumber(String ticketNumber) {
    this.ticketNumber = ticketNumber;
  }

  /**
   * Return true if this Airline object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Airline airline = (Airline) o;
    return Objects.equals(this.legs, airline.legs) &&
        Objects.equals(this.ticketNumber, airline.ticketNumber);
  }

  @Override
  public int hashCode() {
    return Objects.hash(legs, ticketNumber);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Airline {\n");
    sb.append("    legs: ").append(toIndentedString(legs)).append("\n");
    sb.append("    ticketNumber: ").append(toIndentedString(ticketNumber)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of Airline given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of Airline
   * @throws JsonProcessingException if the JSON string is invalid with respect to Airline
   */
  public static Airline fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, Airline.class);
  }
/**
  * Convert an instance of Airline to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
