/*
 * Transfer webhooks
 *
 * The version of the OpenAPI document: 4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.transferwebhooks;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.transferwebhooks.TransferData;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * TransferNotificationRequest
 */
@JsonPropertyOrder({
  TransferNotificationRequest.JSON_PROPERTY_DATA,
  TransferNotificationRequest.JSON_PROPERTY_ENVIRONMENT,
  TransferNotificationRequest.JSON_PROPERTY_TIMESTAMP,
  TransferNotificationRequest.JSON_PROPERTY_TYPE
})

public class TransferNotificationRequest {
  public static final String JSON_PROPERTY_DATA = "data";
  private TransferData data;

  public static final String JSON_PROPERTY_ENVIRONMENT = "environment";
  private String environment;

  public static final String JSON_PROPERTY_TIMESTAMP = "timestamp";
  private OffsetDateTime timestamp;

  /**
   * The type of webhook.
   */
  public enum TypeEnum {
    CREATED("balancePlatform.transfer.created"),
    
    UPDATED("balancePlatform.transfer.updated");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public TransferNotificationRequest() { 
  }

  /**
   * data
   *
   * @param data
   * @return the current {@code TransferNotificationRequest} instance, allowing for method chaining
   */
  public TransferNotificationRequest data(TransferData data) {
    this.data = data;
    return this;
  }

  /**
   * data
   * @return data
   */
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TransferData getData() {
    return data;
  }

  /**
   * data
   *
   * @param data
   */ 
  @JsonProperty(JSON_PROPERTY_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setData(TransferData data) {
    this.data = data;
  }

  /**
   * The environment from which the webhook originated.  Possible values: **test**, **live**.
   *
   * @param environment
   * @return the current {@code TransferNotificationRequest} instance, allowing for method chaining
   */
  public TransferNotificationRequest environment(String environment) {
    this.environment = environment;
    return this;
  }

  /**
   * The environment from which the webhook originated.  Possible values: **test**, **live**.
   * @return environment
   */
  @ApiModelProperty(required = true, value = "The environment from which the webhook originated.  Possible values: **test**, **live**.")
  @JsonProperty(JSON_PROPERTY_ENVIRONMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getEnvironment() {
    return environment;
  }

  /**
   * The environment from which the webhook originated.  Possible values: **test**, **live**.
   *
   * @param environment
   */ 
  @JsonProperty(JSON_PROPERTY_ENVIRONMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEnvironment(String environment) {
    this.environment = environment;
  }

  /**
   * When the event was queued.
   *
   * @param timestamp
   * @return the current {@code TransferNotificationRequest} instance, allowing for method chaining
   */
  public TransferNotificationRequest timestamp(OffsetDateTime timestamp) {
    this.timestamp = timestamp;
    return this;
  }

  /**
   * When the event was queued.
   * @return timestamp
   */
  @ApiModelProperty(value = "When the event was queued.")
  @JsonProperty(JSON_PROPERTY_TIMESTAMP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OffsetDateTime getTimestamp() {
    return timestamp;
  }

  /**
   * When the event was queued.
   *
   * @param timestamp
   */ 
  @JsonProperty(JSON_PROPERTY_TIMESTAMP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTimestamp(OffsetDateTime timestamp) {
    this.timestamp = timestamp;
  }

  /**
   * The type of webhook.
   *
   * @param type
   * @return the current {@code TransferNotificationRequest} instance, allowing for method chaining
   */
  public TransferNotificationRequest type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * The type of webhook.
   * @return type
   */
  @ApiModelProperty(value = "The type of webhook.")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TypeEnum getType() {
    return type;
  }

  /**
   * The type of webhook.
   *
   * @param type
   */ 
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }

  /**
   * Return true if this TransferNotificationRequest object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TransferNotificationRequest transferNotificationRequest = (TransferNotificationRequest) o;
    return Objects.equals(this.data, transferNotificationRequest.data) &&
        Objects.equals(this.environment, transferNotificationRequest.environment) &&
        Objects.equals(this.timestamp, transferNotificationRequest.timestamp) &&
        Objects.equals(this.type, transferNotificationRequest.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(data, environment, timestamp, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TransferNotificationRequest {\n");
    sb.append("    data: ").append(toIndentedString(data)).append("\n");
    sb.append("    environment: ").append(toIndentedString(environment)).append("\n");
    sb.append("    timestamp: ").append(toIndentedString(timestamp)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of TransferNotificationRequest given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of TransferNotificationRequest
   * @throws JsonProcessingException if the JSON string is invalid with respect to TransferNotificationRequest
   */
  public static TransferNotificationRequest fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, TransferNotificationRequest.class);
  }
/**
  * Convert an instance of TransferNotificationRequest to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
