/*
 * Transfer webhooks
 *
 * The version of the OpenAPI document: 4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.transferwebhooks;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * DirectDebitInformation
 */
@JsonPropertyOrder({
  DirectDebitInformation.JSON_PROPERTY_DATE_OF_SIGNATURE,
  DirectDebitInformation.JSON_PROPERTY_DUE_DATE,
  DirectDebitInformation.JSON_PROPERTY_MANDATE_ID,
  DirectDebitInformation.JSON_PROPERTY_SEQUENCE_TYPE
})

public class DirectDebitInformation {
  public static final String JSON_PROPERTY_DATE_OF_SIGNATURE = "dateOfSignature";
  private OffsetDateTime dateOfSignature;

  public static final String JSON_PROPERTY_DUE_DATE = "dueDate";
  private OffsetDateTime dueDate;

  public static final String JSON_PROPERTY_MANDATE_ID = "mandateId";
  private String mandateId;

  public static final String JSON_PROPERTY_SEQUENCE_TYPE = "sequenceType";
  private String sequenceType;

  public DirectDebitInformation() { 
  }

  /**
   * The date when the direct debit mandate was accepted by your user, in [ISO-8601](https://www.w3.org/TR/NOTE-datetime) format.
   *
   * @param dateOfSignature
   * @return the current {@code DirectDebitInformation} instance, allowing for method chaining
   */
  public DirectDebitInformation dateOfSignature(OffsetDateTime dateOfSignature) {
    this.dateOfSignature = dateOfSignature;
    return this;
  }

  /**
   * The date when the direct debit mandate was accepted by your user, in [ISO-8601](https://www.w3.org/TR/NOTE-datetime) format.
   * @return dateOfSignature
   */
  @ApiModelProperty(value = "The date when the direct debit mandate was accepted by your user, in [ISO-8601](https://www.w3.org/TR/NOTE-datetime) format.")
  @JsonProperty(JSON_PROPERTY_DATE_OF_SIGNATURE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OffsetDateTime getDateOfSignature() {
    return dateOfSignature;
  }

  /**
   * The date when the direct debit mandate was accepted by your user, in [ISO-8601](https://www.w3.org/TR/NOTE-datetime) format.
   *
   * @param dateOfSignature
   */ 
  @JsonProperty(JSON_PROPERTY_DATE_OF_SIGNATURE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDateOfSignature(OffsetDateTime dateOfSignature) {
    this.dateOfSignature = dateOfSignature;
  }

  /**
   * The date when the funds are deducted from your user&#39;s balance account.
   *
   * @param dueDate
   * @return the current {@code DirectDebitInformation} instance, allowing for method chaining
   */
  public DirectDebitInformation dueDate(OffsetDateTime dueDate) {
    this.dueDate = dueDate;
    return this;
  }

  /**
   * The date when the funds are deducted from your user&#39;s balance account.
   * @return dueDate
   */
  @ApiModelProperty(value = "The date when the funds are deducted from your user's balance account.")
  @JsonProperty(JSON_PROPERTY_DUE_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OffsetDateTime getDueDate() {
    return dueDate;
  }

  /**
   * The date when the funds are deducted from your user&#39;s balance account.
   *
   * @param dueDate
   */ 
  @JsonProperty(JSON_PROPERTY_DUE_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDueDate(OffsetDateTime dueDate) {
    this.dueDate = dueDate;
  }

  /**
   * Your unique identifier for the direct debit mandate.
   *
   * @param mandateId
   * @return the current {@code DirectDebitInformation} instance, allowing for method chaining
   */
  public DirectDebitInformation mandateId(String mandateId) {
    this.mandateId = mandateId;
    return this;
  }

  /**
   * Your unique identifier for the direct debit mandate.
   * @return mandateId
   */
  @ApiModelProperty(value = "Your unique identifier for the direct debit mandate.")
  @JsonProperty(JSON_PROPERTY_MANDATE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMandateId() {
    return mandateId;
  }

  /**
   * Your unique identifier for the direct debit mandate.
   *
   * @param mandateId
   */ 
  @JsonProperty(JSON_PROPERTY_MANDATE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMandateId(String mandateId) {
    this.mandateId = mandateId;
  }

  /**
   * Identifies the direct debit transfer&#39;s type. Possible values: **OneOff**, **First**, **Recurring**, **Final**.
   *
   * @param sequenceType
   * @return the current {@code DirectDebitInformation} instance, allowing for method chaining
   */
  public DirectDebitInformation sequenceType(String sequenceType) {
    this.sequenceType = sequenceType;
    return this;
  }

  /**
   * Identifies the direct debit transfer&#39;s type. Possible values: **OneOff**, **First**, **Recurring**, **Final**.
   * @return sequenceType
   */
  @ApiModelProperty(value = "Identifies the direct debit transfer's type. Possible values: **OneOff**, **First**, **Recurring**, **Final**.")
  @JsonProperty(JSON_PROPERTY_SEQUENCE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getSequenceType() {
    return sequenceType;
  }

  /**
   * Identifies the direct debit transfer&#39;s type. Possible values: **OneOff**, **First**, **Recurring**, **Final**.
   *
   * @param sequenceType
   */ 
  @JsonProperty(JSON_PROPERTY_SEQUENCE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSequenceType(String sequenceType) {
    this.sequenceType = sequenceType;
  }

  /**
   * Return true if this DirectDebitInformation object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DirectDebitInformation directDebitInformation = (DirectDebitInformation) o;
    return Objects.equals(this.dateOfSignature, directDebitInformation.dateOfSignature) &&
        Objects.equals(this.dueDate, directDebitInformation.dueDate) &&
        Objects.equals(this.mandateId, directDebitInformation.mandateId) &&
        Objects.equals(this.sequenceType, directDebitInformation.sequenceType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(dateOfSignature, dueDate, mandateId, sequenceType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DirectDebitInformation {\n");
    sb.append("    dateOfSignature: ").append(toIndentedString(dateOfSignature)).append("\n");
    sb.append("    dueDate: ").append(toIndentedString(dueDate)).append("\n");
    sb.append("    mandateId: ").append(toIndentedString(mandateId)).append("\n");
    sb.append("    sequenceType: ").append(toIndentedString(sequenceType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of DirectDebitInformation given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of DirectDebitInformation
   * @throws JsonProcessingException if the JSON string is invalid with respect to DirectDebitInformation
   */
  public static DirectDebitInformation fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, DirectDebitInformation.class);
  }
/**
  * Convert an instance of DirectDebitInformation to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
