/*
 * Legal Entity Management API
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.legalentitymanagement;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * BirthData
 */
@JsonPropertyOrder({
  BirthData.JSON_PROPERTY_DATE_OF_BIRTH
})

public class BirthData {
  public static final String JSON_PROPERTY_DATE_OF_BIRTH = "dateOfBirth";
  private String dateOfBirth;

  public BirthData() { 
  }

  /**
   * The individual&#39;s date of birth, in YYYY-MM-DD format.
   *
   * @param dateOfBirth
   * @return the current {@code BirthData} instance, allowing for method chaining
   */
  public BirthData dateOfBirth(String dateOfBirth) {
    this.dateOfBirth = dateOfBirth;
    return this;
  }

  /**
   * The individual&#39;s date of birth, in YYYY-MM-DD format.
   * @return dateOfBirth
   */
  @ApiModelProperty(value = "The individual's date of birth, in YYYY-MM-DD format.")
  @JsonProperty(JSON_PROPERTY_DATE_OF_BIRTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDateOfBirth() {
    return dateOfBirth;
  }

  /**
   * The individual&#39;s date of birth, in YYYY-MM-DD format.
   *
   * @param dateOfBirth
   */ 
  @JsonProperty(JSON_PROPERTY_DATE_OF_BIRTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDateOfBirth(String dateOfBirth) {
    this.dateOfBirth = dateOfBirth;
  }

  /**
   * Return true if this BirthData object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BirthData birthData = (BirthData) o;
    return Objects.equals(this.dateOfBirth, birthData.dateOfBirth);
  }

  @Override
  public int hashCode() {
    return Objects.hash(dateOfBirth);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BirthData {\n");
    sb.append("    dateOfBirth: ").append(toIndentedString(dateOfBirth)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of BirthData given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of BirthData
   * @throws JsonProcessingException if the JSON string is invalid with respect to BirthData
   */
  public static BirthData fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, BirthData.class);
  }
/**
  * Convert an instance of BirthData to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
