/*
 * Classic Platforms - Notifications
 *
 * The version of the OpenAPI document: 6
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.marketpaywebhooks;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.marketpaywebhooks.Amount;
import com.adyen.model.marketpaywebhooks.BankAccountDetail;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * Transaction
 */
@JsonPropertyOrder({
  Transaction.JSON_PROPERTY_AMOUNT,
  Transaction.JSON_PROPERTY_BANK_ACCOUNT_DETAIL,
  Transaction.JSON_PROPERTY_CAPTURE_MERCHANT_REFERENCE,
  Transaction.JSON_PROPERTY_CAPTURE_PSP_REFERENCE,
  Transaction.JSON_PROPERTY_CREATION_DATE,
  Transaction.JSON_PROPERTY_DESCRIPTION,
  Transaction.JSON_PROPERTY_DESTINATION_ACCOUNT_CODE,
  Transaction.JSON_PROPERTY_DISPUTE_PSP_REFERENCE,
  Transaction.JSON_PROPERTY_DISPUTE_REASON_CODE,
  Transaction.JSON_PROPERTY_MERCHANT_REFERENCE,
  Transaction.JSON_PROPERTY_PAYMENT_PSP_REFERENCE,
  Transaction.JSON_PROPERTY_PAYOUT_PSP_REFERENCE,
  Transaction.JSON_PROPERTY_PSP_REFERENCE,
  Transaction.JSON_PROPERTY_SOURCE_ACCOUNT_CODE,
  Transaction.JSON_PROPERTY_TRANSACTION_STATUS,
  Transaction.JSON_PROPERTY_TRANSFER_CODE
})

public class Transaction {
  public static final String JSON_PROPERTY_AMOUNT = "amount";
  private Amount amount;

  public static final String JSON_PROPERTY_BANK_ACCOUNT_DETAIL = "bankAccountDetail";
  private BankAccountDetail bankAccountDetail;

  public static final String JSON_PROPERTY_CAPTURE_MERCHANT_REFERENCE = "captureMerchantReference";
  private String captureMerchantReference;

  public static final String JSON_PROPERTY_CAPTURE_PSP_REFERENCE = "capturePspReference";
  private String capturePspReference;

  public static final String JSON_PROPERTY_CREATION_DATE = "creationDate";
  private OffsetDateTime creationDate;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_DESTINATION_ACCOUNT_CODE = "destinationAccountCode";
  private String destinationAccountCode;

  public static final String JSON_PROPERTY_DISPUTE_PSP_REFERENCE = "disputePspReference";
  private String disputePspReference;

  public static final String JSON_PROPERTY_DISPUTE_REASON_CODE = "disputeReasonCode";
  private String disputeReasonCode;

  public static final String JSON_PROPERTY_MERCHANT_REFERENCE = "merchantReference";
  private String merchantReference;

  public static final String JSON_PROPERTY_PAYMENT_PSP_REFERENCE = "paymentPspReference";
  private String paymentPspReference;

  public static final String JSON_PROPERTY_PAYOUT_PSP_REFERENCE = "payoutPspReference";
  private String payoutPspReference;

  public static final String JSON_PROPERTY_PSP_REFERENCE = "pspReference";
  private String pspReference;

  public static final String JSON_PROPERTY_SOURCE_ACCOUNT_CODE = "sourceAccountCode";
  private String sourceAccountCode;

  /**
   * The status of the transaction. &gt;Permitted values: &#x60;PendingCredit&#x60;, &#x60;CreditFailed&#x60;, &#x60;CreditClosed&#x60;, &#x60;CreditSuspended&#x60;, &#x60;Credited&#x60;, &#x60;Converted&#x60;, &#x60;PendingDebit&#x60;, &#x60;DebitFailed&#x60;, &#x60;Debited&#x60;, &#x60;DebitReversedReceived&#x60;, &#x60;DebitedReversed&#x60;, &#x60;ChargebackReceived&#x60;, &#x60;Chargeback&#x60;, &#x60;ChargebackReversedReceived&#x60;, &#x60;ChargebackReversed&#x60;, &#x60;Payout&#x60;, &#x60;PayoutReversed&#x60;, &#x60;FundTransfer&#x60;, &#x60;PendingFundTransfer&#x60;, &#x60;ManualCorrected&#x60;.
   */
  public enum TransactionStatusEnum {
    BALANCENOTPAIDOUTTRANSFER("BalanceNotPaidOutTransfer"),
    
    BALANCEPLATFORMSWEEP("BalancePlatformSweep"),
    
    BALANCEPLATFORMSWEEPRETURNED("BalancePlatformSweepReturned"),
    
    CHARGEBACK("Chargeback"),
    
    CHARGEBACKCORRECTION("ChargebackCorrection"),
    
    CHARGEBACKCORRECTIONRECEIVED("ChargebackCorrectionReceived"),
    
    CHARGEBACKRECEIVED("ChargebackReceived"),
    
    CHARGEBACKREVERSED("ChargebackReversed"),
    
    CHARGEBACKREVERSEDCORRECTION("ChargebackReversedCorrection"),
    
    CHARGEBACKREVERSEDCORRECTIONRECEIVED("ChargebackReversedCorrectionReceived"),
    
    CHARGEBACKREVERSEDRECEIVED("ChargebackReversedReceived"),
    
    CONVERTED("Converted"),
    
    CREDITCLOSED("CreditClosed"),
    
    CREDITFAILED("CreditFailed"),
    
    CREDITREVERSED("CreditReversed"),
    
    CREDITREVERSEDRECEIVED("CreditReversedReceived"),
    
    CREDITSUSPENDED("CreditSuspended"),
    
    CREDITED("Credited"),
    
    DEBITFAILED("DebitFailed"),
    
    DEBITREVERSEDRECEIVED("DebitReversedReceived"),
    
    DEBITED("Debited"),
    
    DEBITEDREVERSED("DebitedReversed"),
    
    DEPOSITCORRECTIONCREDITED("DepositCorrectionCredited"),
    
    DEPOSITCORRECTIONDEBITED("DepositCorrectionDebited"),
    
    FEE("Fee"),
    
    FUNDTRANSFER("FundTransfer"),
    
    FUNDTRANSFERREVERSED("FundTransferReversed"),
    
    INVOICEDEDUCTIONCREDITED("InvoiceDeductionCredited"),
    
    INVOICEDEDUCTIONDEBITED("InvoiceDeductionDebited"),
    
    MANUALCORRECTED("ManualCorrected"),
    
    MANUALCORRECTIONCREDITED("ManualCorrectionCredited"),
    
    MANUALCORRECTIONDEBITED("ManualCorrectionDebited"),
    
    MERCHANTPAYIN("MerchantPayin"),
    
    MERCHANTPAYINREVERSED("MerchantPayinReversed"),
    
    PAYOUT("Payout"),
    
    PAYOUTREVERSED("PayoutReversed"),
    
    PENDINGCREDIT("PendingCredit"),
    
    PENDINGDEBIT("PendingDebit"),
    
    PENDINGFUNDTRANSFER("PendingFundTransfer"),
    
    RECREDITED("ReCredited"),
    
    RECREDITEDRECEIVED("ReCreditedReceived"),
    
    SECONDCHARGEBACK("SecondChargeback"),
    
    SECONDCHARGEBACKCORRECTION("SecondChargebackCorrection"),
    
    SECONDCHARGEBACKCORRECTIONRECEIVED("SecondChargebackCorrectionReceived"),
    
    SECONDCHARGEBACKRECEIVED("SecondChargebackReceived");

    private String value;

    TransactionStatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TransactionStatusEnum fromValue(String value) {
      for (TransactionStatusEnum b : TransactionStatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TRANSACTION_STATUS = "transactionStatus";
  private TransactionStatusEnum transactionStatus;

  public static final String JSON_PROPERTY_TRANSFER_CODE = "transferCode";
  private String transferCode;

  public Transaction() { 
  }

  public Transaction amount(Amount amount) {
    this.amount = amount;
    return this;
  }

   /**
   * Get amount
   * @return amount
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Amount getAmount() {
    return amount;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmount(Amount amount) {
    this.amount = amount;
  }


  public Transaction bankAccountDetail(BankAccountDetail bankAccountDetail) {
    this.bankAccountDetail = bankAccountDetail;
    return this;
  }

   /**
   * Get bankAccountDetail
   * @return bankAccountDetail
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_BANK_ACCOUNT_DETAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BankAccountDetail getBankAccountDetail() {
    return bankAccountDetail;
  }


  @JsonProperty(JSON_PROPERTY_BANK_ACCOUNT_DETAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBankAccountDetail(BankAccountDetail bankAccountDetail) {
    this.bankAccountDetail = bankAccountDetail;
  }


  public Transaction captureMerchantReference(String captureMerchantReference) {
    this.captureMerchantReference = captureMerchantReference;
    return this;
  }

   /**
   * The merchant reference of a related capture.
   * @return captureMerchantReference
  **/
  @ApiModelProperty(value = "The merchant reference of a related capture.")
  @JsonProperty(JSON_PROPERTY_CAPTURE_MERCHANT_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCaptureMerchantReference() {
    return captureMerchantReference;
  }


  @JsonProperty(JSON_PROPERTY_CAPTURE_MERCHANT_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCaptureMerchantReference(String captureMerchantReference) {
    this.captureMerchantReference = captureMerchantReference;
  }


  public Transaction capturePspReference(String capturePspReference) {
    this.capturePspReference = capturePspReference;
    return this;
  }

   /**
   * The psp reference of a related capture.
   * @return capturePspReference
  **/
  @ApiModelProperty(value = "The psp reference of a related capture.")
  @JsonProperty(JSON_PROPERTY_CAPTURE_PSP_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCapturePspReference() {
    return capturePspReference;
  }


  @JsonProperty(JSON_PROPERTY_CAPTURE_PSP_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCapturePspReference(String capturePspReference) {
    this.capturePspReference = capturePspReference;
  }


  public Transaction creationDate(OffsetDateTime creationDate) {
    this.creationDate = creationDate;
    return this;
  }

   /**
   * The date on which the transaction was performed.
   * @return creationDate
  **/
  @ApiModelProperty(value = "The date on which the transaction was performed.")
  @JsonProperty(JSON_PROPERTY_CREATION_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getCreationDate() {
    return creationDate;
  }


  @JsonProperty(JSON_PROPERTY_CREATION_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreationDate(OffsetDateTime creationDate) {
    this.creationDate = creationDate;
  }


  public Transaction description(String description) {
    this.description = description;
    return this;
  }

   /**
   * A description of the transaction.
   * @return description
  **/
  @ApiModelProperty(value = "A description of the transaction.")
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }


  public Transaction destinationAccountCode(String destinationAccountCode) {
    this.destinationAccountCode = destinationAccountCode;
    return this;
  }

   /**
   * The code of the account to which funds were credited during an outgoing fund transfer.
   * @return destinationAccountCode
  **/
  @ApiModelProperty(value = "The code of the account to which funds were credited during an outgoing fund transfer.")
  @JsonProperty(JSON_PROPERTY_DESTINATION_ACCOUNT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDestinationAccountCode() {
    return destinationAccountCode;
  }


  @JsonProperty(JSON_PROPERTY_DESTINATION_ACCOUNT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDestinationAccountCode(String destinationAccountCode) {
    this.destinationAccountCode = destinationAccountCode;
  }


  public Transaction disputePspReference(String disputePspReference) {
    this.disputePspReference = disputePspReference;
    return this;
  }

   /**
   * The psp reference of the related dispute.
   * @return disputePspReference
  **/
  @ApiModelProperty(value = "The psp reference of the related dispute.")
  @JsonProperty(JSON_PROPERTY_DISPUTE_PSP_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDisputePspReference() {
    return disputePspReference;
  }


  @JsonProperty(JSON_PROPERTY_DISPUTE_PSP_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisputePspReference(String disputePspReference) {
    this.disputePspReference = disputePspReference;
  }


  public Transaction disputeReasonCode(String disputeReasonCode) {
    this.disputeReasonCode = disputeReasonCode;
    return this;
  }

   /**
   * The reason code of a dispute.
   * @return disputeReasonCode
  **/
  @ApiModelProperty(value = "The reason code of a dispute.")
  @JsonProperty(JSON_PROPERTY_DISPUTE_REASON_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDisputeReasonCode() {
    return disputeReasonCode;
  }


  @JsonProperty(JSON_PROPERTY_DISPUTE_REASON_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisputeReasonCode(String disputeReasonCode) {
    this.disputeReasonCode = disputeReasonCode;
  }


  public Transaction merchantReference(String merchantReference) {
    this.merchantReference = merchantReference;
    return this;
  }

   /**
   * The merchant reference of a transaction.
   * @return merchantReference
  **/
  @ApiModelProperty(value = "The merchant reference of a transaction.")
  @JsonProperty(JSON_PROPERTY_MERCHANT_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMerchantReference() {
    return merchantReference;
  }


  @JsonProperty(JSON_PROPERTY_MERCHANT_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMerchantReference(String merchantReference) {
    this.merchantReference = merchantReference;
  }


  public Transaction paymentPspReference(String paymentPspReference) {
    this.paymentPspReference = paymentPspReference;
    return this;
  }

   /**
   * The psp reference of the related authorisation or transfer.
   * @return paymentPspReference
  **/
  @ApiModelProperty(value = "The psp reference of the related authorisation or transfer.")
  @JsonProperty(JSON_PROPERTY_PAYMENT_PSP_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPaymentPspReference() {
    return paymentPspReference;
  }


  @JsonProperty(JSON_PROPERTY_PAYMENT_PSP_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaymentPspReference(String paymentPspReference) {
    this.paymentPspReference = paymentPspReference;
  }


  public Transaction payoutPspReference(String payoutPspReference) {
    this.payoutPspReference = payoutPspReference;
    return this;
  }

   /**
   * The psp reference of the related payout.
   * @return payoutPspReference
  **/
  @ApiModelProperty(value = "The psp reference of the related payout.")
  @JsonProperty(JSON_PROPERTY_PAYOUT_PSP_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPayoutPspReference() {
    return payoutPspReference;
  }


  @JsonProperty(JSON_PROPERTY_PAYOUT_PSP_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPayoutPspReference(String payoutPspReference) {
    this.payoutPspReference = payoutPspReference;
  }


  public Transaction pspReference(String pspReference) {
    this.pspReference = pspReference;
    return this;
  }

   /**
   * The psp reference of a transaction.
   * @return pspReference
  **/
  @ApiModelProperty(value = "The psp reference of a transaction.")
  @JsonProperty(JSON_PROPERTY_PSP_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPspReference() {
    return pspReference;
  }


  @JsonProperty(JSON_PROPERTY_PSP_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPspReference(String pspReference) {
    this.pspReference = pspReference;
  }


  public Transaction sourceAccountCode(String sourceAccountCode) {
    this.sourceAccountCode = sourceAccountCode;
    return this;
  }

   /**
   * The code of the account from which funds were debited during an incoming fund transfer.
   * @return sourceAccountCode
  **/
  @ApiModelProperty(value = "The code of the account from which funds were debited during an incoming fund transfer.")
  @JsonProperty(JSON_PROPERTY_SOURCE_ACCOUNT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSourceAccountCode() {
    return sourceAccountCode;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_ACCOUNT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceAccountCode(String sourceAccountCode) {
    this.sourceAccountCode = sourceAccountCode;
  }


  public Transaction transactionStatus(TransactionStatusEnum transactionStatus) {
    this.transactionStatus = transactionStatus;
    return this;
  }

   /**
   * The status of the transaction. &gt;Permitted values: &#x60;PendingCredit&#x60;, &#x60;CreditFailed&#x60;, &#x60;CreditClosed&#x60;, &#x60;CreditSuspended&#x60;, &#x60;Credited&#x60;, &#x60;Converted&#x60;, &#x60;PendingDebit&#x60;, &#x60;DebitFailed&#x60;, &#x60;Debited&#x60;, &#x60;DebitReversedReceived&#x60;, &#x60;DebitedReversed&#x60;, &#x60;ChargebackReceived&#x60;, &#x60;Chargeback&#x60;, &#x60;ChargebackReversedReceived&#x60;, &#x60;ChargebackReversed&#x60;, &#x60;Payout&#x60;, &#x60;PayoutReversed&#x60;, &#x60;FundTransfer&#x60;, &#x60;PendingFundTransfer&#x60;, &#x60;ManualCorrected&#x60;.
   * @return transactionStatus
  **/
  @ApiModelProperty(value = "The status of the transaction. >Permitted values: `PendingCredit`, `CreditFailed`, `CreditClosed`, `CreditSuspended`, `Credited`, `Converted`, `PendingDebit`, `DebitFailed`, `Debited`, `DebitReversedReceived`, `DebitedReversed`, `ChargebackReceived`, `Chargeback`, `ChargebackReversedReceived`, `ChargebackReversed`, `Payout`, `PayoutReversed`, `FundTransfer`, `PendingFundTransfer`, `ManualCorrected`.")
  @JsonProperty(JSON_PROPERTY_TRANSACTION_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TransactionStatusEnum getTransactionStatus() {
    return transactionStatus;
  }


  @JsonProperty(JSON_PROPERTY_TRANSACTION_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTransactionStatus(TransactionStatusEnum transactionStatus) {
    this.transactionStatus = transactionStatus;
  }


  public Transaction transferCode(String transferCode) {
    this.transferCode = transferCode;
    return this;
  }

   /**
   * The transfer code of the transaction.
   * @return transferCode
  **/
  @ApiModelProperty(value = "The transfer code of the transaction.")
  @JsonProperty(JSON_PROPERTY_TRANSFER_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTransferCode() {
    return transferCode;
  }


  @JsonProperty(JSON_PROPERTY_TRANSFER_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTransferCode(String transferCode) {
    this.transferCode = transferCode;
  }


  /**
   * Return true if this Transaction object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Transaction transaction = (Transaction) o;
    return Objects.equals(this.amount, transaction.amount) &&
        Objects.equals(this.bankAccountDetail, transaction.bankAccountDetail) &&
        Objects.equals(this.captureMerchantReference, transaction.captureMerchantReference) &&
        Objects.equals(this.capturePspReference, transaction.capturePspReference) &&
        Objects.equals(this.creationDate, transaction.creationDate) &&
        Objects.equals(this.description, transaction.description) &&
        Objects.equals(this.destinationAccountCode, transaction.destinationAccountCode) &&
        Objects.equals(this.disputePspReference, transaction.disputePspReference) &&
        Objects.equals(this.disputeReasonCode, transaction.disputeReasonCode) &&
        Objects.equals(this.merchantReference, transaction.merchantReference) &&
        Objects.equals(this.paymentPspReference, transaction.paymentPspReference) &&
        Objects.equals(this.payoutPspReference, transaction.payoutPspReference) &&
        Objects.equals(this.pspReference, transaction.pspReference) &&
        Objects.equals(this.sourceAccountCode, transaction.sourceAccountCode) &&
        Objects.equals(this.transactionStatus, transaction.transactionStatus) &&
        Objects.equals(this.transferCode, transaction.transferCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(amount, bankAccountDetail, captureMerchantReference, capturePspReference, creationDate, description, destinationAccountCode, disputePspReference, disputeReasonCode, merchantReference, paymentPspReference, payoutPspReference, pspReference, sourceAccountCode, transactionStatus, transferCode);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Transaction {\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    bankAccountDetail: ").append(toIndentedString(bankAccountDetail)).append("\n");
    sb.append("    captureMerchantReference: ").append(toIndentedString(captureMerchantReference)).append("\n");
    sb.append("    capturePspReference: ").append(toIndentedString(capturePspReference)).append("\n");
    sb.append("    creationDate: ").append(toIndentedString(creationDate)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    destinationAccountCode: ").append(toIndentedString(destinationAccountCode)).append("\n");
    sb.append("    disputePspReference: ").append(toIndentedString(disputePspReference)).append("\n");
    sb.append("    disputeReasonCode: ").append(toIndentedString(disputeReasonCode)).append("\n");
    sb.append("    merchantReference: ").append(toIndentedString(merchantReference)).append("\n");
    sb.append("    paymentPspReference: ").append(toIndentedString(paymentPspReference)).append("\n");
    sb.append("    payoutPspReference: ").append(toIndentedString(payoutPspReference)).append("\n");
    sb.append("    pspReference: ").append(toIndentedString(pspReference)).append("\n");
    sb.append("    sourceAccountCode: ").append(toIndentedString(sourceAccountCode)).append("\n");
    sb.append("    transactionStatus: ").append(toIndentedString(transactionStatus)).append("\n");
    sb.append("    transferCode: ").append(toIndentedString(transferCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of Transaction given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of Transaction
   * @throws JsonProcessingException if the JSON string is invalid with respect to Transaction
   */
  public static Transaction fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, Transaction.class);
  }
/**
  * Convert an instance of Transaction to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

