/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.transfers;

import com.adyen.model.transfers.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"acquirerId", "city", "country", "mcc", "merchantId", "name", "postalCode"})
public class TransferNotificationMerchantData {
    public static final String JSON_PROPERTY_ACQUIRER_ID = "acquirerId";
    private String acquirerId;
    public static final String JSON_PROPERTY_CITY = "city";
    private String city;
    public static final String JSON_PROPERTY_COUNTRY = "country";
    private String country;
    public static final String JSON_PROPERTY_MCC = "mcc";
    private String mcc;
    public static final String JSON_PROPERTY_MERCHANT_ID = "merchantId";
    private String merchantId;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_POSTAL_CODE = "postalCode";
    private String postalCode;

    public TransferNotificationMerchantData acquirerId(String acquirerId) {
        this.acquirerId = acquirerId;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the merchant's acquirer.")
    @JsonProperty(value="acquirerId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAcquirerId() {
        return this.acquirerId;
    }

    @JsonProperty(value="acquirerId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAcquirerId(String acquirerId) {
        this.acquirerId = acquirerId;
    }

    public TransferNotificationMerchantData city(String city) {
        this.city = city;
        return this;
    }

    @ApiModelProperty(value="The city where the merchant is located.")
    @JsonProperty(value="city")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCity() {
        return this.city;
    }

    @JsonProperty(value="city")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCity(String city) {
        this.city = city;
    }

    public TransferNotificationMerchantData country(String country) {
        this.country = country;
        return this;
    }

    @ApiModelProperty(value="The country where the merchant is located.")
    @JsonProperty(value="country")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCountry() {
        return this.country;
    }

    @JsonProperty(value="country")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCountry(String country) {
        this.country = country;
    }

    public TransferNotificationMerchantData mcc(String mcc) {
        this.mcc = mcc;
        return this;
    }

    @ApiModelProperty(value="The merchant category code.")
    @JsonProperty(value="mcc")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMcc() {
        return this.mcc;
    }

    @JsonProperty(value="mcc")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMcc(String mcc) {
        this.mcc = mcc;
    }

    public TransferNotificationMerchantData merchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    @ApiModelProperty(value="The merchant identifier.")
    @JsonProperty(value="merchantId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantId() {
        return this.merchantId;
    }

    @JsonProperty(value="merchantId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public TransferNotificationMerchantData name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The name of the merchant's shop or service.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public TransferNotificationMerchantData postalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    @ApiModelProperty(value="The merchant postal code.")
    @JsonProperty(value="postalCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPostalCode() {
        return this.postalCode;
    }

    @JsonProperty(value="postalCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferNotificationMerchantData transferNotificationMerchantData = (TransferNotificationMerchantData)o;
        return Objects.equals(this.acquirerId, transferNotificationMerchantData.acquirerId) && Objects.equals(this.city, transferNotificationMerchantData.city) && Objects.equals(this.country, transferNotificationMerchantData.country) && Objects.equals(this.mcc, transferNotificationMerchantData.mcc) && Objects.equals(this.merchantId, transferNotificationMerchantData.merchantId) && Objects.equals(this.name, transferNotificationMerchantData.name) && Objects.equals(this.postalCode, transferNotificationMerchantData.postalCode);
    }

    public int hashCode() {
        return Objects.hash(this.acquirerId, this.city, this.country, this.mcc, this.merchantId, this.name, this.postalCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferNotificationMerchantData {\n");
        sb.append("    acquirerId: ").append(this.toIndentedString(this.acquirerId)).append("\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("    mcc: ").append(this.toIndentedString(this.mcc)).append("\n");
        sb.append("    merchantId: ").append(this.toIndentedString(this.merchantId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    postalCode: ").append(this.toIndentedString(this.postalCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static TransferNotificationMerchantData fromJson(String jsonString) throws JsonProcessingException {
        return (TransferNotificationMerchantData)JSON.getMapper().readValue(jsonString, TransferNotificationMerchantData.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

