/*
 * Configuration API
 *
 * The version of the OpenAPI document: 2
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.balanceplatform;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * AssociationFinaliseResponse
 */
@JsonPropertyOrder({
  AssociationFinaliseResponse.JSON_PROPERTY_DEVICE_ID,
  AssociationFinaliseResponse.JSON_PROPERTY_IDS,
  AssociationFinaliseResponse.JSON_PROPERTY_TYPE
})

public class AssociationFinaliseResponse {
  public static final String JSON_PROPERTY_DEVICE_ID = "deviceId";
  private String deviceId;

  public static final String JSON_PROPERTY_IDS = "ids";
  private List<String> ids = null;

  /**
   * The type of resource that you associated with the SCA device.
   */
  public enum TypeEnum {
    PAYMENT_INSTRUMENT("PAYMENT_INSTRUMENT");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public AssociationFinaliseResponse() { 
  }

  /**
   * The unique identifier of the SCA device you associated with a resource.
   *
   * @param deviceId
   * @return the current {@code AssociationFinaliseResponse} instance, allowing for method chaining
   */
  public AssociationFinaliseResponse deviceId(String deviceId) {
    this.deviceId = deviceId;
    return this;
  }

  /**
   * The unique identifier of the SCA device you associated with a resource.
   * @return deviceId
   */
  @ApiModelProperty(value = "The unique identifier of the SCA device you associated with a resource.")
  @JsonProperty(JSON_PROPERTY_DEVICE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDeviceId() {
    return deviceId;
  }

  /**
   * The unique identifier of the SCA device you associated with a resource.
   *
   * @param deviceId
   */ 
  @JsonProperty(JSON_PROPERTY_DEVICE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeviceId(String deviceId) {
    this.deviceId = deviceId;
  }

  /**
   * The list of unique identifiers of the resources that you associated with the SCA device.
   *
   * @param ids
   * @return the current {@code AssociationFinaliseResponse} instance, allowing for method chaining
   */
  public AssociationFinaliseResponse ids(List<String> ids) {
    this.ids = ids;
    return this;
  }

  public AssociationFinaliseResponse addIdsItem(String idsItem) {
    if (this.ids == null) {
      this.ids = new ArrayList<>();
    }
    this.ids.add(idsItem);
    return this;
  }

  /**
   * The list of unique identifiers of the resources that you associated with the SCA device.
   * @return ids
   */
  @ApiModelProperty(value = "The list of unique identifiers of the resources that you associated with the SCA device.")
  @JsonProperty(JSON_PROPERTY_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getIds() {
    return ids;
  }

  /**
   * The list of unique identifiers of the resources that you associated with the SCA device.
   *
   * @param ids
   */ 
  @JsonProperty(JSON_PROPERTY_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIds(List<String> ids) {
    this.ids = ids;
  }

  /**
   * The type of resource that you associated with the SCA device.
   *
   * @param type
   * @return the current {@code AssociationFinaliseResponse} instance, allowing for method chaining
   */
  public AssociationFinaliseResponse type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * The type of resource that you associated with the SCA device.
   * @return type
   */
  @ApiModelProperty(required = true, value = "The type of resource that you associated with the SCA device.")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TypeEnum getType() {
    return type;
  }

  /**
   * The type of resource that you associated with the SCA device.
   *
   * @param type
   */ 
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }

  /**
   * Return true if this AssociationFinaliseResponse object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AssociationFinaliseResponse associationFinaliseResponse = (AssociationFinaliseResponse) o;
    return Objects.equals(this.deviceId, associationFinaliseResponse.deviceId) &&
        Objects.equals(this.ids, associationFinaliseResponse.ids) &&
        Objects.equals(this.type, associationFinaliseResponse.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(deviceId, ids, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AssociationFinaliseResponse {\n");
    sb.append("    deviceId: ").append(toIndentedString(deviceId)).append("\n");
    sb.append("    ids: ").append(toIndentedString(ids)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of AssociationFinaliseResponse given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of AssociationFinaliseResponse
   * @throws JsonProcessingException if the JSON string is invalid with respect to AssociationFinaliseResponse
   */
  public static AssociationFinaliseResponse fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, AssociationFinaliseResponse.class);
  }
/**
  * Convert an instance of AssociationFinaliseResponse to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
