/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 71
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.checkout;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * EBankingFinlandDetails
 */
@JsonPropertyOrder({
  EBankingFinlandDetails.JSON_PROPERTY_CHECKOUT_ATTEMPT_ID,
  EBankingFinlandDetails.JSON_PROPERTY_ISSUER,
  EBankingFinlandDetails.JSON_PROPERTY_TYPE
})

public class EBankingFinlandDetails {
  public static final String JSON_PROPERTY_CHECKOUT_ATTEMPT_ID = "checkoutAttemptId";
  private String checkoutAttemptId;

  public static final String JSON_PROPERTY_ISSUER = "issuer";
  private String issuer;

  /**
   * **ebanking_FI**
   */
  public enum TypeEnum {
    EBANKING_FI("ebanking_FI");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public EBankingFinlandDetails() { 
  }

  /**
   * The checkout attempt identifier.
   *
   * @param checkoutAttemptId
   * @return the current {@code EBankingFinlandDetails} instance, allowing for method chaining
   */
  public EBankingFinlandDetails checkoutAttemptId(String checkoutAttemptId) {
    this.checkoutAttemptId = checkoutAttemptId;
    return this;
  }

  /**
   * The checkout attempt identifier.
   * @return checkoutAttemptId
   */
  @ApiModelProperty(value = "The checkout attempt identifier.")
  @JsonProperty(JSON_PROPERTY_CHECKOUT_ATTEMPT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCheckoutAttemptId() {
    return checkoutAttemptId;
  }

  /**
   * The checkout attempt identifier.
   *
   * @param checkoutAttemptId
   */ 
  @JsonProperty(JSON_PROPERTY_CHECKOUT_ATTEMPT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCheckoutAttemptId(String checkoutAttemptId) {
    this.checkoutAttemptId = checkoutAttemptId;
  }

  /**
   * The Ebanking Finland issuer value of the shopper&#39;s selected bank.
   *
   * @param issuer
   * @return the current {@code EBankingFinlandDetails} instance, allowing for method chaining
   */
  public EBankingFinlandDetails issuer(String issuer) {
    this.issuer = issuer;
    return this;
  }

  /**
   * The Ebanking Finland issuer value of the shopper&#39;s selected bank.
   * @return issuer
   */
  @ApiModelProperty(value = "The Ebanking Finland issuer value of the shopper's selected bank.")
  @JsonProperty(JSON_PROPERTY_ISSUER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getIssuer() {
    return issuer;
  }

  /**
   * The Ebanking Finland issuer value of the shopper&#39;s selected bank.
   *
   * @param issuer
   */ 
  @JsonProperty(JSON_PROPERTY_ISSUER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIssuer(String issuer) {
    this.issuer = issuer;
  }

  /**
   * **ebanking_FI**
   *
   * @param type
   * @return the current {@code EBankingFinlandDetails} instance, allowing for method chaining
   */
  public EBankingFinlandDetails type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * **ebanking_FI**
   * @return type
   */
  @ApiModelProperty(required = true, value = "**ebanking_FI**")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TypeEnum getType() {
    return type;
  }

  /**
   * **ebanking_FI**
   *
   * @param type
   */ 
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }

  /**
   * Return true if this EBankingFinlandDetails object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    EBankingFinlandDetails ebankingFinlandDetails = (EBankingFinlandDetails) o;
    return Objects.equals(this.checkoutAttemptId, ebankingFinlandDetails.checkoutAttemptId) &&
        Objects.equals(this.issuer, ebankingFinlandDetails.issuer) &&
        Objects.equals(this.type, ebankingFinlandDetails.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(checkoutAttemptId, issuer, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class EBankingFinlandDetails {\n");
    sb.append("    checkoutAttemptId: ").append(toIndentedString(checkoutAttemptId)).append("\n");
    sb.append("    issuer: ").append(toIndentedString(issuer)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of EBankingFinlandDetails given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of EBankingFinlandDetails
   * @throws JsonProcessingException if the JSON string is invalid with respect to EBankingFinlandDetails
   */
  public static EBankingFinlandDetails fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, EBankingFinlandDetails.class);
  }
/**
  * Convert an instance of EBankingFinlandDetails to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
