/*
 * Authentication webhooks
 *
 * The version of the OpenAPI document: 1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.acswebhooks;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.acswebhooks.ChallengeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * AuthenticationInfo
 */
@JsonPropertyOrder({
  AuthenticationInfo.JSON_PROPERTY_ACS_TRANS_ID,
  AuthenticationInfo.JSON_PROPERTY_CHALLENGE,
  AuthenticationInfo.JSON_PROPERTY_CHALLENGE_INDICATOR,
  AuthenticationInfo.JSON_PROPERTY_CREATED_AT,
  AuthenticationInfo.JSON_PROPERTY_DEVICE_CHANNEL,
  AuthenticationInfo.JSON_PROPERTY_DS_TRANS_I_D,
  AuthenticationInfo.JSON_PROPERTY_EXEMPTION_INDICATOR,
  AuthenticationInfo.JSON_PROPERTY_IN_P_S_D2_SCOPE,
  AuthenticationInfo.JSON_PROPERTY_MESSAGE_CATEGORY,
  AuthenticationInfo.JSON_PROPERTY_MESSAGE_VERSION,
  AuthenticationInfo.JSON_PROPERTY_RISK_SCORE,
  AuthenticationInfo.JSON_PROPERTY_THREE_D_S_SERVER_TRANS_I_D,
  AuthenticationInfo.JSON_PROPERTY_TRANS_STATUS,
  AuthenticationInfo.JSON_PROPERTY_TRANS_STATUS_REASON,
  AuthenticationInfo.JSON_PROPERTY_TYPE
})

public class AuthenticationInfo {
  public static final String JSON_PROPERTY_ACS_TRANS_ID = "acsTransId";
  private String acsTransId;

  public static final String JSON_PROPERTY_CHALLENGE = "challenge";
  private ChallengeInfo challenge;

  /**
   * Specifies a preference for receiving a challenge. Possible values:  * **01**: No preference * **02**: No challenge requested * **03**: Challenge requested (preference) * **04**: Challenge requested (mandate) * **05**: No challenge requested (transactional risk analysis is already performed) * **07**: No challenge requested (SCA is already performed) * **08**: No challenge requested (trusted beneficiaries exemption of no challenge required) * **09**: Challenge requested (trusted beneficiaries prompt requested if challenge required) * **80**: No challenge requested (secure corporate payment with Mastercard) * **82**: No challenge requested (secure corporate payment with Visa) 
   */
  public enum ChallengeIndicatorEnum {
    _01(String.valueOf("01")),
    
    _02(String.valueOf("02")),
    
    _03(String.valueOf("03")),
    
    _04(String.valueOf("04")),
    
    _05(String.valueOf("05")),
    
    _07(String.valueOf("07")),
    
    _08(String.valueOf("08")),
    
    _09(String.valueOf("09")),
    
    _80(String.valueOf("80")),
    
    _82(String.valueOf("82"));

    private String value;

    ChallengeIndicatorEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ChallengeIndicatorEnum fromValue(String value) {
      for (ChallengeIndicatorEnum b : ChallengeIndicatorEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CHALLENGE_INDICATOR = "challengeIndicator";
  private ChallengeIndicatorEnum challengeIndicator;

  public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
  private OffsetDateTime createdAt;

  /**
   * Indicates the type of channel interface being used to initiate the transaction. Possible values:  * **app** * **browser** * **3DSRequestorInitiated** (initiated by a merchant when the cardholder is not available)
   */
  public enum DeviceChannelEnum {
    APP(String.valueOf("app")),
    
    BROWSER(String.valueOf("browser")),
    
    THREEDSREQUESTORINITIATED(String.valueOf("ThreeDSRequestorInitiated"));

    private String value;

    DeviceChannelEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static DeviceChannelEnum fromValue(String value) {
      for (DeviceChannelEnum b : DeviceChannelEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_DEVICE_CHANNEL = "deviceChannel";
  private DeviceChannelEnum deviceChannel;

  public static final String JSON_PROPERTY_DS_TRANS_I_D = "dsTransID";
  private String dsTransID;

  /**
   * Indicates the exemption type that was applied to the authentication by the issuer, if exemption applied. Possible values:  * **lowValue** * **secureCorporate** * **trustedBeneficiary** * **transactionRiskAnalysis** * **acquirerExemption** * **noExemptionApplied** * **visaDAFExemption** 
   */
  public enum ExemptionIndicatorEnum {
    LOWVALUE(String.valueOf("lowValue")),
    
    SECURECORPORATE(String.valueOf("secureCorporate")),
    
    TRUSTEDBENEFICIARY(String.valueOf("trustedBeneficiary")),
    
    TRANSACTIONRISKANALYSIS(String.valueOf("transactionRiskAnalysis")),
    
    ACQUIREREXEMPTION(String.valueOf("acquirerExemption")),
    
    NOEXEMPTIONAPPLIED(String.valueOf("noExemptionApplied")),
    
    VISADAFEXEMPTION(String.valueOf("visaDAFExemption"));

    private String value;

    ExemptionIndicatorEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ExemptionIndicatorEnum fromValue(String value) {
      for (ExemptionIndicatorEnum b : ExemptionIndicatorEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_EXEMPTION_INDICATOR = "exemptionIndicator";
  private ExemptionIndicatorEnum exemptionIndicator;

  public static final String JSON_PROPERTY_IN_P_S_D2_SCOPE = "inPSD2Scope";
  private Boolean inPSD2Scope;

  /**
   * Identifies the category of the message for a specific use case. Possible values:  * **payment** * **nonPayment**
   */
  public enum MessageCategoryEnum {
    PAYMENT(String.valueOf("payment")),
    
    NONPAYMENT(String.valueOf("nonPayment"));

    private String value;

    MessageCategoryEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static MessageCategoryEnum fromValue(String value) {
      for (MessageCategoryEnum b : MessageCategoryEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_MESSAGE_CATEGORY = "messageCategory";
  private MessageCategoryEnum messageCategory;

  public static final String JSON_PROPERTY_MESSAGE_VERSION = "messageVersion";
  private String messageVersion;

  public static final String JSON_PROPERTY_RISK_SCORE = "riskScore";
  private Integer riskScore;

  public static final String JSON_PROPERTY_THREE_D_S_SERVER_TRANS_I_D = "threeDSServerTransID";
  private String threeDSServerTransID;

  /**
   * The &#x60;transStatus&#x60; value as defined in the 3D Secure 2 specification. Possible values:  * **Y**: Authentication / Account verification successful. * **N**: Not Authenticated / Account not verified. Transaction denied. * **U**: Authentication / Account verification could not be performed. * **I**: Informational Only / 3D Secure Requestor challenge preference acknowledged. * **R**: Authentication / Account verification rejected by the Issuer. 
   */
  public enum TransStatusEnum {
    Y(String.valueOf("Y")),
    
    N(String.valueOf("N")),
    
    R(String.valueOf("R")),
    
    I(String.valueOf("I")),
    
    U(String.valueOf("U"));

    private String value;

    TransStatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TransStatusEnum fromValue(String value) {
      for (TransStatusEnum b : TransStatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TRANS_STATUS = "transStatus";
  private TransStatusEnum transStatus;

  /**
   * Provides information on why the &#x60;transStatus&#x60; field has the specified value. For possible values, refer to [our docs](https://docs.adyen.com/online-payments/3d-secure/api-reference#possible-transstatusreason-values).
   */
  public enum TransStatusReasonEnum {
    _01(String.valueOf("01")),
    
    _02(String.valueOf("02")),
    
    _03(String.valueOf("03")),
    
    _04(String.valueOf("04")),
    
    _05(String.valueOf("05")),
    
    _06(String.valueOf("06")),
    
    _07(String.valueOf("07")),
    
    _08(String.valueOf("08")),
    
    _09(String.valueOf("09")),
    
    _10(String.valueOf("10")),
    
    _11(String.valueOf("11")),
    
    _12(String.valueOf("12")),
    
    _13(String.valueOf("13")),
    
    _14(String.valueOf("14")),
    
    _15(String.valueOf("15")),
    
    _16(String.valueOf("16")),
    
    _17(String.valueOf("17")),
    
    _18(String.valueOf("18")),
    
    _19(String.valueOf("19")),
    
    _20(String.valueOf("20")),
    
    _21(String.valueOf("21")),
    
    _22(String.valueOf("22")),
    
    _23(String.valueOf("23")),
    
    _24(String.valueOf("24")),
    
    _25(String.valueOf("25")),
    
    _26(String.valueOf("26")),
    
    _80(String.valueOf("80")),
    
    _81(String.valueOf("81")),
    
    _82(String.valueOf("82")),
    
    _83(String.valueOf("83")),
    
    _84(String.valueOf("84")),
    
    _85(String.valueOf("85")),
    
    _86(String.valueOf("86")),
    
    _87(String.valueOf("87")),
    
    _88(String.valueOf("88"));

    private String value;

    TransStatusReasonEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TransStatusReasonEnum fromValue(String value) {
      for (TransStatusReasonEnum b : TransStatusReasonEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TRANS_STATUS_REASON = "transStatusReason";
  private TransStatusReasonEnum transStatusReason;

  /**
   * The type of authentication performed. Possible values:  * **frictionless** * **challenge**
   */
  public enum TypeEnum {
    FRICTIONLESS(String.valueOf("frictionless")),
    
    CHALLENGE(String.valueOf("challenge"));

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public AuthenticationInfo() { 
  }

  /**
   * Universally unique transaction identifier assigned by the Access Control Server (ACS) to identify a single transaction.
   *
   * @param acsTransId
   * @return the current {@code AuthenticationInfo} instance, allowing for method chaining
   */
  public AuthenticationInfo acsTransId(String acsTransId) {
    this.acsTransId = acsTransId;
    return this;
  }

  /**
   * Universally unique transaction identifier assigned by the Access Control Server (ACS) to identify a single transaction.
   * @return acsTransId
   */
  @JsonProperty(JSON_PROPERTY_ACS_TRANS_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getAcsTransId() {
    return acsTransId;
  }

  /**
   * Universally unique transaction identifier assigned by the Access Control Server (ACS) to identify a single transaction.
   *
   * @param acsTransId
   */
  @JsonProperty(JSON_PROPERTY_ACS_TRANS_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAcsTransId(String acsTransId) {
    this.acsTransId = acsTransId;
  }

  /**
   * challenge
   *
   * @param challenge
   * @return the current {@code AuthenticationInfo} instance, allowing for method chaining
   */
  public AuthenticationInfo challenge(ChallengeInfo challenge) {
    this.challenge = challenge;
    return this;
  }

  /**
   * Get challenge
   * @return challenge
   */
  @JsonProperty(JSON_PROPERTY_CHALLENGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ChallengeInfo getChallenge() {
    return challenge;
  }

  /**
   * challenge
   *
   * @param challenge
   */
  @JsonProperty(JSON_PROPERTY_CHALLENGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChallenge(ChallengeInfo challenge) {
    this.challenge = challenge;
  }

  /**
   * Specifies a preference for receiving a challenge. Possible values:  * **01**: No preference * **02**: No challenge requested * **03**: Challenge requested (preference) * **04**: Challenge requested (mandate) * **05**: No challenge requested (transactional risk analysis is already performed) * **07**: No challenge requested (SCA is already performed) * **08**: No challenge requested (trusted beneficiaries exemption of no challenge required) * **09**: Challenge requested (trusted beneficiaries prompt requested if challenge required) * **80**: No challenge requested (secure corporate payment with Mastercard) * **82**: No challenge requested (secure corporate payment with Visa) 
   *
   * @param challengeIndicator
   * @return the current {@code AuthenticationInfo} instance, allowing for method chaining
   */
  public AuthenticationInfo challengeIndicator(ChallengeIndicatorEnum challengeIndicator) {
    this.challengeIndicator = challengeIndicator;
    return this;
  }

  /**
   * Specifies a preference for receiving a challenge. Possible values:  * **01**: No preference * **02**: No challenge requested * **03**: Challenge requested (preference) * **04**: Challenge requested (mandate) * **05**: No challenge requested (transactional risk analysis is already performed) * **07**: No challenge requested (SCA is already performed) * **08**: No challenge requested (trusted beneficiaries exemption of no challenge required) * **09**: Challenge requested (trusted beneficiaries prompt requested if challenge required) * **80**: No challenge requested (secure corporate payment with Mastercard) * **82**: No challenge requested (secure corporate payment with Visa) 
   * @return challengeIndicator
   */
  @JsonProperty(JSON_PROPERTY_CHALLENGE_INDICATOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ChallengeIndicatorEnum getChallengeIndicator() {
    return challengeIndicator;
  }

  /**
   * Specifies a preference for receiving a challenge. Possible values:  * **01**: No preference * **02**: No challenge requested * **03**: Challenge requested (preference) * **04**: Challenge requested (mandate) * **05**: No challenge requested (transactional risk analysis is already performed) * **07**: No challenge requested (SCA is already performed) * **08**: No challenge requested (trusted beneficiaries exemption of no challenge required) * **09**: Challenge requested (trusted beneficiaries prompt requested if challenge required) * **80**: No challenge requested (secure corporate payment with Mastercard) * **82**: No challenge requested (secure corporate payment with Visa) 
   *
   * @param challengeIndicator
   */
  @JsonProperty(JSON_PROPERTY_CHALLENGE_INDICATOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChallengeIndicator(ChallengeIndicatorEnum challengeIndicator) {
    this.challengeIndicator = challengeIndicator;
  }

  /**
   * Date and time in UTC of the cardholder authentication.   [ISO 8601](https://www.w3.org/TR/NOTE-datetime) format: YYYY-MM-DDThh:mm:ss+TZD, for example, **2020-12-18T10:15:30+01:00**.
   *
   * @param createdAt
   * @return the current {@code AuthenticationInfo} instance, allowing for method chaining
   */
  public AuthenticationInfo createdAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
    return this;
  }

  /**
   * Date and time in UTC of the cardholder authentication.   [ISO 8601](https://www.w3.org/TR/NOTE-datetime) format: YYYY-MM-DDThh:mm:ss+TZD, for example, **2020-12-18T10:15:30+01:00**.
   * @return createdAt
   */
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  /**
   * Date and time in UTC of the cardholder authentication.   [ISO 8601](https://www.w3.org/TR/NOTE-datetime) format: YYYY-MM-DDThh:mm:ss+TZD, for example, **2020-12-18T10:15:30+01:00**.
   *
   * @param createdAt
   */
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  /**
   * Indicates the type of channel interface being used to initiate the transaction. Possible values:  * **app** * **browser** * **3DSRequestorInitiated** (initiated by a merchant when the cardholder is not available)
   *
   * @param deviceChannel
   * @return the current {@code AuthenticationInfo} instance, allowing for method chaining
   */
  public AuthenticationInfo deviceChannel(DeviceChannelEnum deviceChannel) {
    this.deviceChannel = deviceChannel;
    return this;
  }

  /**
   * Indicates the type of channel interface being used to initiate the transaction. Possible values:  * **app** * **browser** * **3DSRequestorInitiated** (initiated by a merchant when the cardholder is not available)
   * @return deviceChannel
   */
  @JsonProperty(JSON_PROPERTY_DEVICE_CHANNEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public DeviceChannelEnum getDeviceChannel() {
    return deviceChannel;
  }

  /**
   * Indicates the type of channel interface being used to initiate the transaction. Possible values:  * **app** * **browser** * **3DSRequestorInitiated** (initiated by a merchant when the cardholder is not available)
   *
   * @param deviceChannel
   */
  @JsonProperty(JSON_PROPERTY_DEVICE_CHANNEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeviceChannel(DeviceChannelEnum deviceChannel) {
    this.deviceChannel = deviceChannel;
  }

  /**
   * Universally unique transaction identifier assigned by the DS (card scheme) to identify a single transaction.
   *
   * @param dsTransID
   * @return the current {@code AuthenticationInfo} instance, allowing for method chaining
   */
  public AuthenticationInfo dsTransID(String dsTransID) {
    this.dsTransID = dsTransID;
    return this;
  }

  /**
   * Universally unique transaction identifier assigned by the DS (card scheme) to identify a single transaction.
   * @return dsTransID
   */
  @JsonProperty(JSON_PROPERTY_DS_TRANS_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDsTransID() {
    return dsTransID;
  }

  /**
   * Universally unique transaction identifier assigned by the DS (card scheme) to identify a single transaction.
   *
   * @param dsTransID
   */
  @JsonProperty(JSON_PROPERTY_DS_TRANS_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDsTransID(String dsTransID) {
    this.dsTransID = dsTransID;
  }

  /**
   * Indicates the exemption type that was applied to the authentication by the issuer, if exemption applied. Possible values:  * **lowValue** * **secureCorporate** * **trustedBeneficiary** * **transactionRiskAnalysis** * **acquirerExemption** * **noExemptionApplied** * **visaDAFExemption** 
   *
   * @param exemptionIndicator
   * @return the current {@code AuthenticationInfo} instance, allowing for method chaining
   */
  public AuthenticationInfo exemptionIndicator(ExemptionIndicatorEnum exemptionIndicator) {
    this.exemptionIndicator = exemptionIndicator;
    return this;
  }

  /**
   * Indicates the exemption type that was applied to the authentication by the issuer, if exemption applied. Possible values:  * **lowValue** * **secureCorporate** * **trustedBeneficiary** * **transactionRiskAnalysis** * **acquirerExemption** * **noExemptionApplied** * **visaDAFExemption** 
   * @return exemptionIndicator
   */
  @JsonProperty(JSON_PROPERTY_EXEMPTION_INDICATOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ExemptionIndicatorEnum getExemptionIndicator() {
    return exemptionIndicator;
  }

  /**
   * Indicates the exemption type that was applied to the authentication by the issuer, if exemption applied. Possible values:  * **lowValue** * **secureCorporate** * **trustedBeneficiary** * **transactionRiskAnalysis** * **acquirerExemption** * **noExemptionApplied** * **visaDAFExemption** 
   *
   * @param exemptionIndicator
   */
  @JsonProperty(JSON_PROPERTY_EXEMPTION_INDICATOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExemptionIndicator(ExemptionIndicatorEnum exemptionIndicator) {
    this.exemptionIndicator = exemptionIndicator;
  }

  /**
   * Indicates if the purchase was in the PSD2 scope.
   *
   * @param inPSD2Scope
   * @return the current {@code AuthenticationInfo} instance, allowing for method chaining
   */
  public AuthenticationInfo inPSD2Scope(Boolean inPSD2Scope) {
    this.inPSD2Scope = inPSD2Scope;
    return this;
  }

  /**
   * Indicates if the purchase was in the PSD2 scope.
   * @return inPSD2Scope
   */
  @JsonProperty(JSON_PROPERTY_IN_P_S_D2_SCOPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getInPSD2Scope() {
    return inPSD2Scope;
  }

  /**
   * Indicates if the purchase was in the PSD2 scope.
   *
   * @param inPSD2Scope
   */
  @JsonProperty(JSON_PROPERTY_IN_P_S_D2_SCOPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInPSD2Scope(Boolean inPSD2Scope) {
    this.inPSD2Scope = inPSD2Scope;
  }

  /**
   * Identifies the category of the message for a specific use case. Possible values:  * **payment** * **nonPayment**
   *
   * @param messageCategory
   * @return the current {@code AuthenticationInfo} instance, allowing for method chaining
   */
  public AuthenticationInfo messageCategory(MessageCategoryEnum messageCategory) {
    this.messageCategory = messageCategory;
    return this;
  }

  /**
   * Identifies the category of the message for a specific use case. Possible values:  * **payment** * **nonPayment**
   * @return messageCategory
   */
  @JsonProperty(JSON_PROPERTY_MESSAGE_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public MessageCategoryEnum getMessageCategory() {
    return messageCategory;
  }

  /**
   * Identifies the category of the message for a specific use case. Possible values:  * **payment** * **nonPayment**
   *
   * @param messageCategory
   */
  @JsonProperty(JSON_PROPERTY_MESSAGE_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMessageCategory(MessageCategoryEnum messageCategory) {
    this.messageCategory = messageCategory;
  }

  /**
   * The &#x60;messageVersion&#x60; value as defined in the 3D Secure 2 specification.
   *
   * @param messageVersion
   * @return the current {@code AuthenticationInfo} instance, allowing for method chaining
   */
  public AuthenticationInfo messageVersion(String messageVersion) {
    this.messageVersion = messageVersion;
    return this;
  }

  /**
   * The &#x60;messageVersion&#x60; value as defined in the 3D Secure 2 specification.
   * @return messageVersion
   */
  @JsonProperty(JSON_PROPERTY_MESSAGE_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMessageVersion() {
    return messageVersion;
  }

  /**
   * The &#x60;messageVersion&#x60; value as defined in the 3D Secure 2 specification.
   *
   * @param messageVersion
   */
  @JsonProperty(JSON_PROPERTY_MESSAGE_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMessageVersion(String messageVersion) {
    this.messageVersion = messageVersion;
  }

  /**
   * Risk score calculated from the transaction rules.
   *
   * @param riskScore
   * @return the current {@code AuthenticationInfo} instance, allowing for method chaining
   */
  public AuthenticationInfo riskScore(Integer riskScore) {
    this.riskScore = riskScore;
    return this;
  }

  /**
   * Risk score calculated from the transaction rules.
   * @return riskScore
   */
  @JsonProperty(JSON_PROPERTY_RISK_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Integer getRiskScore() {
    return riskScore;
  }

  /**
   * Risk score calculated from the transaction rules.
   *
   * @param riskScore
   */
  @JsonProperty(JSON_PROPERTY_RISK_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRiskScore(Integer riskScore) {
    this.riskScore = riskScore;
  }

  /**
   * The &#x60;threeDSServerTransID&#x60; value as defined in the 3D Secure 2 specification.
   *
   * @param threeDSServerTransID
   * @return the current {@code AuthenticationInfo} instance, allowing for method chaining
   */
  public AuthenticationInfo threeDSServerTransID(String threeDSServerTransID) {
    this.threeDSServerTransID = threeDSServerTransID;
    return this;
  }

  /**
   * The &#x60;threeDSServerTransID&#x60; value as defined in the 3D Secure 2 specification.
   * @return threeDSServerTransID
   */
  @JsonProperty(JSON_PROPERTY_THREE_D_S_SERVER_TRANS_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getThreeDSServerTransID() {
    return threeDSServerTransID;
  }

  /**
   * The &#x60;threeDSServerTransID&#x60; value as defined in the 3D Secure 2 specification.
   *
   * @param threeDSServerTransID
   */
  @JsonProperty(JSON_PROPERTY_THREE_D_S_SERVER_TRANS_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setThreeDSServerTransID(String threeDSServerTransID) {
    this.threeDSServerTransID = threeDSServerTransID;
  }

  /**
   * The &#x60;transStatus&#x60; value as defined in the 3D Secure 2 specification. Possible values:  * **Y**: Authentication / Account verification successful. * **N**: Not Authenticated / Account not verified. Transaction denied. * **U**: Authentication / Account verification could not be performed. * **I**: Informational Only / 3D Secure Requestor challenge preference acknowledged. * **R**: Authentication / Account verification rejected by the Issuer. 
   *
   * @param transStatus
   * @return the current {@code AuthenticationInfo} instance, allowing for method chaining
   */
  public AuthenticationInfo transStatus(TransStatusEnum transStatus) {
    this.transStatus = transStatus;
    return this;
  }

  /**
   * The &#x60;transStatus&#x60; value as defined in the 3D Secure 2 specification. Possible values:  * **Y**: Authentication / Account verification successful. * **N**: Not Authenticated / Account not verified. Transaction denied. * **U**: Authentication / Account verification could not be performed. * **I**: Informational Only / 3D Secure Requestor challenge preference acknowledged. * **R**: Authentication / Account verification rejected by the Issuer. 
   * @return transStatus
   */
  @JsonProperty(JSON_PROPERTY_TRANS_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TransStatusEnum getTransStatus() {
    return transStatus;
  }

  /**
   * The &#x60;transStatus&#x60; value as defined in the 3D Secure 2 specification. Possible values:  * **Y**: Authentication / Account verification successful. * **N**: Not Authenticated / Account not verified. Transaction denied. * **U**: Authentication / Account verification could not be performed. * **I**: Informational Only / 3D Secure Requestor challenge preference acknowledged. * **R**: Authentication / Account verification rejected by the Issuer. 
   *
   * @param transStatus
   */
  @JsonProperty(JSON_PROPERTY_TRANS_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTransStatus(TransStatusEnum transStatus) {
    this.transStatus = transStatus;
  }

  /**
   * Provides information on why the &#x60;transStatus&#x60; field has the specified value. For possible values, refer to [our docs](https://docs.adyen.com/online-payments/3d-secure/api-reference#possible-transstatusreason-values).
   *
   * @param transStatusReason
   * @return the current {@code AuthenticationInfo} instance, allowing for method chaining
   */
  public AuthenticationInfo transStatusReason(TransStatusReasonEnum transStatusReason) {
    this.transStatusReason = transStatusReason;
    return this;
  }

  /**
   * Provides information on why the &#x60;transStatus&#x60; field has the specified value. For possible values, refer to [our docs](https://docs.adyen.com/online-payments/3d-secure/api-reference#possible-transstatusreason-values).
   * @return transStatusReason
   */
  @JsonProperty(JSON_PROPERTY_TRANS_STATUS_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TransStatusReasonEnum getTransStatusReason() {
    return transStatusReason;
  }

  /**
   * Provides information on why the &#x60;transStatus&#x60; field has the specified value. For possible values, refer to [our docs](https://docs.adyen.com/online-payments/3d-secure/api-reference#possible-transstatusreason-values).
   *
   * @param transStatusReason
   */
  @JsonProperty(JSON_PROPERTY_TRANS_STATUS_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTransStatusReason(TransStatusReasonEnum transStatusReason) {
    this.transStatusReason = transStatusReason;
  }

  /**
   * The type of authentication performed. Possible values:  * **frictionless** * **challenge**
   *
   * @param type
   * @return the current {@code AuthenticationInfo} instance, allowing for method chaining
   */
  public AuthenticationInfo type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * The type of authentication performed. Possible values:  * **frictionless** * **challenge**
   * @return type
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TypeEnum getType() {
    return type;
  }

  /**
   * The type of authentication performed. Possible values:  * **frictionless** * **challenge**
   *
   * @param type
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }

  /**
   * Return true if this AuthenticationInfo object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AuthenticationInfo authenticationInfo = (AuthenticationInfo) o;
    return Objects.equals(this.acsTransId, authenticationInfo.acsTransId) &&
        Objects.equals(this.challenge, authenticationInfo.challenge) &&
        Objects.equals(this.challengeIndicator, authenticationInfo.challengeIndicator) &&
        Objects.equals(this.createdAt, authenticationInfo.createdAt) &&
        Objects.equals(this.deviceChannel, authenticationInfo.deviceChannel) &&
        Objects.equals(this.dsTransID, authenticationInfo.dsTransID) &&
        Objects.equals(this.exemptionIndicator, authenticationInfo.exemptionIndicator) &&
        Objects.equals(this.inPSD2Scope, authenticationInfo.inPSD2Scope) &&
        Objects.equals(this.messageCategory, authenticationInfo.messageCategory) &&
        Objects.equals(this.messageVersion, authenticationInfo.messageVersion) &&
        Objects.equals(this.riskScore, authenticationInfo.riskScore) &&
        Objects.equals(this.threeDSServerTransID, authenticationInfo.threeDSServerTransID) &&
        Objects.equals(this.transStatus, authenticationInfo.transStatus) &&
        Objects.equals(this.transStatusReason, authenticationInfo.transStatusReason) &&
        Objects.equals(this.type, authenticationInfo.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(acsTransId, challenge, challengeIndicator, createdAt, deviceChannel, dsTransID, exemptionIndicator, inPSD2Scope, messageCategory, messageVersion, riskScore, threeDSServerTransID, transStatus, transStatusReason, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AuthenticationInfo {\n");
    sb.append("    acsTransId: ").append(toIndentedString(acsTransId)).append("\n");
    sb.append("    challenge: ").append(toIndentedString(challenge)).append("\n");
    sb.append("    challengeIndicator: ").append(toIndentedString(challengeIndicator)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    deviceChannel: ").append(toIndentedString(deviceChannel)).append("\n");
    sb.append("    dsTransID: ").append(toIndentedString(dsTransID)).append("\n");
    sb.append("    exemptionIndicator: ").append(toIndentedString(exemptionIndicator)).append("\n");
    sb.append("    inPSD2Scope: ").append(toIndentedString(inPSD2Scope)).append("\n");
    sb.append("    messageCategory: ").append(toIndentedString(messageCategory)).append("\n");
    sb.append("    messageVersion: ").append(toIndentedString(messageVersion)).append("\n");
    sb.append("    riskScore: ").append(toIndentedString(riskScore)).append("\n");
    sb.append("    threeDSServerTransID: ").append(toIndentedString(threeDSServerTransID)).append("\n");
    sb.append("    transStatus: ").append(toIndentedString(transStatus)).append("\n");
    sb.append("    transStatusReason: ").append(toIndentedString(transStatusReason)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of AuthenticationInfo given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of AuthenticationInfo
   * @throws JsonProcessingException if the JSON string is invalid with respect to AuthenticationInfo
   */
  public static AuthenticationInfo fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, AuthenticationInfo.class);
  }
/**
  * Convert an instance of AuthenticationInfo to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
