/*
 * Authentication webhooks
 *
 * The version of the OpenAPI document: 1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.acswebhooks;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.acswebhooks.Amount;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * Purchase
 */
@JsonPropertyOrder({
  Purchase.JSON_PROPERTY_DATE,
  Purchase.JSON_PROPERTY_MERCHANT_NAME,
  Purchase.JSON_PROPERTY_ORIGINAL_AMOUNT
})

public class Purchase {
  public static final String JSON_PROPERTY_DATE = "date";
  private OffsetDateTime date;

  public static final String JSON_PROPERTY_MERCHANT_NAME = "merchantName";
  private String merchantName;

  public static final String JSON_PROPERTY_ORIGINAL_AMOUNT = "originalAmount";
  private Amount originalAmount;

  public Purchase() { 
  }

  /**
   * The time of the purchase.
   *
   * @param date
   * @return the current {@code Purchase} instance, allowing for method chaining
   */
  public Purchase date(OffsetDateTime date) {
    this.date = date;
    return this;
  }

  /**
   * The time of the purchase.
   * @return date
   */
  @JsonProperty(JSON_PROPERTY_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OffsetDateTime getDate() {
    return date;
  }

  /**
   * The time of the purchase.
   *
   * @param date
   */
  @JsonProperty(JSON_PROPERTY_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDate(OffsetDateTime date) {
    this.date = date;
  }

  /**
   * The name of the merchant.
   *
   * @param merchantName
   * @return the current {@code Purchase} instance, allowing for method chaining
   */
  public Purchase merchantName(String merchantName) {
    this.merchantName = merchantName;
    return this;
  }

  /**
   * The name of the merchant.
   * @return merchantName
   */
  @JsonProperty(JSON_PROPERTY_MERCHANT_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMerchantName() {
    return merchantName;
  }

  /**
   * The name of the merchant.
   *
   * @param merchantName
   */
  @JsonProperty(JSON_PROPERTY_MERCHANT_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMerchantName(String merchantName) {
    this.merchantName = merchantName;
  }

  /**
   * originalAmount
   *
   * @param originalAmount
   * @return the current {@code Purchase} instance, allowing for method chaining
   */
  public Purchase originalAmount(Amount originalAmount) {
    this.originalAmount = originalAmount;
    return this;
  }

  /**
   * Get originalAmount
   * @return originalAmount
   */
  @JsonProperty(JSON_PROPERTY_ORIGINAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Amount getOriginalAmount() {
    return originalAmount;
  }

  /**
   * originalAmount
   *
   * @param originalAmount
   */
  @JsonProperty(JSON_PROPERTY_ORIGINAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOriginalAmount(Amount originalAmount) {
    this.originalAmount = originalAmount;
  }

  /**
   * Return true if this Purchase object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Purchase purchase = (Purchase) o;
    return Objects.equals(this.date, purchase.date) &&
        Objects.equals(this.merchantName, purchase.merchantName) &&
        Objects.equals(this.originalAmount, purchase.originalAmount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(date, merchantName, originalAmount);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Purchase {\n");
    sb.append("    date: ").append(toIndentedString(date)).append("\n");
    sb.append("    merchantName: ").append(toIndentedString(merchantName)).append("\n");
    sb.append("    originalAmount: ").append(toIndentedString(originalAmount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of Purchase given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of Purchase
   * @throws JsonProcessingException if the JSON string is invalid with respect to Purchase
   */
  public static Purchase fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, Purchase.class);
  }
/**
  * Convert an instance of Purchase to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
