/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 71
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.checkout;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.checkout.AccountInfo;
import com.adyen.model.checkout.Address;
import com.adyen.model.checkout.Amount;
import com.adyen.model.checkout.ApplicationInfo;
import com.adyen.model.checkout.BrowserInfo;
import com.adyen.model.checkout.ForexQuote;
import com.adyen.model.checkout.Installments;
import com.adyen.model.checkout.MerchantRiskIndicator;
import com.adyen.model.checkout.Name;
import com.adyen.model.checkout.Recurring;
import com.adyen.model.checkout.Split;
import com.adyen.model.checkout.ThreeDS2RequestData;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * BalanceCheckRequest
 */
@JsonPropertyOrder({
  BalanceCheckRequest.JSON_PROPERTY_ACCOUNT_INFO,
  BalanceCheckRequest.JSON_PROPERTY_ADDITIONAL_AMOUNT,
  BalanceCheckRequest.JSON_PROPERTY_ADDITIONAL_DATA,
  BalanceCheckRequest.JSON_PROPERTY_AMOUNT,
  BalanceCheckRequest.JSON_PROPERTY_APPLICATION_INFO,
  BalanceCheckRequest.JSON_PROPERTY_BILLING_ADDRESS,
  BalanceCheckRequest.JSON_PROPERTY_BROWSER_INFO,
  BalanceCheckRequest.JSON_PROPERTY_CAPTURE_DELAY_HOURS,
  BalanceCheckRequest.JSON_PROPERTY_DATE_OF_BIRTH,
  BalanceCheckRequest.JSON_PROPERTY_DCC_QUOTE,
  BalanceCheckRequest.JSON_PROPERTY_DELIVERY_ADDRESS,
  BalanceCheckRequest.JSON_PROPERTY_DELIVERY_DATE,
  BalanceCheckRequest.JSON_PROPERTY_DEVICE_FINGERPRINT,
  BalanceCheckRequest.JSON_PROPERTY_FRAUD_OFFSET,
  BalanceCheckRequest.JSON_PROPERTY_INSTALLMENTS,
  BalanceCheckRequest.JSON_PROPERTY_LOCALIZED_SHOPPER_STATEMENT,
  BalanceCheckRequest.JSON_PROPERTY_MCC,
  BalanceCheckRequest.JSON_PROPERTY_MERCHANT_ACCOUNT,
  BalanceCheckRequest.JSON_PROPERTY_MERCHANT_ORDER_REFERENCE,
  BalanceCheckRequest.JSON_PROPERTY_MERCHANT_RISK_INDICATOR,
  BalanceCheckRequest.JSON_PROPERTY_METADATA,
  BalanceCheckRequest.JSON_PROPERTY_ORDER_REFERENCE,
  BalanceCheckRequest.JSON_PROPERTY_PAYMENT_METHOD,
  BalanceCheckRequest.JSON_PROPERTY_RECURRING,
  BalanceCheckRequest.JSON_PROPERTY_RECURRING_PROCESSING_MODEL,
  BalanceCheckRequest.JSON_PROPERTY_REFERENCE,
  BalanceCheckRequest.JSON_PROPERTY_SELECTED_BRAND,
  BalanceCheckRequest.JSON_PROPERTY_SELECTED_RECURRING_DETAIL_REFERENCE,
  BalanceCheckRequest.JSON_PROPERTY_SESSION_ID,
  BalanceCheckRequest.JSON_PROPERTY_SHOPPER_EMAIL,
  BalanceCheckRequest.JSON_PROPERTY_SHOPPER_I_P,
  BalanceCheckRequest.JSON_PROPERTY_SHOPPER_INTERACTION,
  BalanceCheckRequest.JSON_PROPERTY_SHOPPER_LOCALE,
  BalanceCheckRequest.JSON_PROPERTY_SHOPPER_NAME,
  BalanceCheckRequest.JSON_PROPERTY_SHOPPER_REFERENCE,
  BalanceCheckRequest.JSON_PROPERTY_SHOPPER_STATEMENT,
  BalanceCheckRequest.JSON_PROPERTY_SOCIAL_SECURITY_NUMBER,
  BalanceCheckRequest.JSON_PROPERTY_SPLITS,
  BalanceCheckRequest.JSON_PROPERTY_STORE,
  BalanceCheckRequest.JSON_PROPERTY_TELEPHONE_NUMBER,
  BalanceCheckRequest.JSON_PROPERTY_THREE_D_S2_REQUEST_DATA,
  BalanceCheckRequest.JSON_PROPERTY_THREE_D_S_AUTHENTICATION_ONLY,
  BalanceCheckRequest.JSON_PROPERTY_TOTALS_GROUP,
  BalanceCheckRequest.JSON_PROPERTY_TRUSTED_SHOPPER
})

public class BalanceCheckRequest {
  public static final String JSON_PROPERTY_ACCOUNT_INFO = "accountInfo";
  private AccountInfo accountInfo;

  public static final String JSON_PROPERTY_ADDITIONAL_AMOUNT = "additionalAmount";
  private Amount additionalAmount;

  public static final String JSON_PROPERTY_ADDITIONAL_DATA = "additionalData";
  private Map<String, String> additionalData = new HashMap<>();

  public static final String JSON_PROPERTY_AMOUNT = "amount";
  private Amount amount;

  public static final String JSON_PROPERTY_APPLICATION_INFO = "applicationInfo";
  private ApplicationInfo applicationInfo;

  public static final String JSON_PROPERTY_BILLING_ADDRESS = "billingAddress";
  private Address billingAddress;

  public static final String JSON_PROPERTY_BROWSER_INFO = "browserInfo";
  private BrowserInfo browserInfo;

  public static final String JSON_PROPERTY_CAPTURE_DELAY_HOURS = "captureDelayHours";
  private Integer captureDelayHours;

  public static final String JSON_PROPERTY_DATE_OF_BIRTH = "dateOfBirth";
  private LocalDate dateOfBirth;

  public static final String JSON_PROPERTY_DCC_QUOTE = "dccQuote";
  private ForexQuote dccQuote;

  public static final String JSON_PROPERTY_DELIVERY_ADDRESS = "deliveryAddress";
  private Address deliveryAddress;

  public static final String JSON_PROPERTY_DELIVERY_DATE = "deliveryDate";
  private OffsetDateTime deliveryDate;

  public static final String JSON_PROPERTY_DEVICE_FINGERPRINT = "deviceFingerprint";
  private String deviceFingerprint;

  public static final String JSON_PROPERTY_FRAUD_OFFSET = "fraudOffset";
  private Integer fraudOffset;

  public static final String JSON_PROPERTY_INSTALLMENTS = "installments";
  private Installments installments;

  public static final String JSON_PROPERTY_LOCALIZED_SHOPPER_STATEMENT = "localizedShopperStatement";
  private Map<String, String> localizedShopperStatement = new HashMap<>();

  public static final String JSON_PROPERTY_MCC = "mcc";
  private String mcc;

  public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
  private String merchantAccount;

  public static final String JSON_PROPERTY_MERCHANT_ORDER_REFERENCE = "merchantOrderReference";
  private String merchantOrderReference;

  public static final String JSON_PROPERTY_MERCHANT_RISK_INDICATOR = "merchantRiskIndicator";
  private MerchantRiskIndicator merchantRiskIndicator;

  public static final String JSON_PROPERTY_METADATA = "metadata";
  private Map<String, String> metadata = new HashMap<>();

  public static final String JSON_PROPERTY_ORDER_REFERENCE = "orderReference";
  private String orderReference;

  public static final String JSON_PROPERTY_PAYMENT_METHOD = "paymentMethod";
  private Map<String, String> paymentMethod = new HashMap<>();

  public static final String JSON_PROPERTY_RECURRING = "recurring";
  private Recurring recurring;

  /**
   * Defines a recurring payment type. Required when creating a token to store payment details or using stored payment details. Allowed values: * &#x60;Subscription&#x60; – A transaction for a fixed or variable amount, which follows a fixed schedule. * &#x60;CardOnFile&#x60; – With a card-on-file (CoF) transaction, card details are stored to enable one-click or omnichannel journeys, or simply to streamline the checkout process. Any subscription not following a fixed schedule is also considered a card-on-file transaction. * &#x60;UnscheduledCardOnFile&#x60; – An unscheduled card-on-file (UCoF) transaction is a transaction that occurs on a non-fixed schedule and/or have variable amounts. For example, automatic top-ups when a cardholder&#39;s balance drops below a certain amount. 
   */
  public enum RecurringProcessingModelEnum {
    CARDONFILE(String.valueOf("CardOnFile")),
    
    SUBSCRIPTION(String.valueOf("Subscription")),
    
    UNSCHEDULEDCARDONFILE(String.valueOf("UnscheduledCardOnFile"));

    private String value;

    RecurringProcessingModelEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RecurringProcessingModelEnum fromValue(String value) {
      for (RecurringProcessingModelEnum b : RecurringProcessingModelEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_RECURRING_PROCESSING_MODEL = "recurringProcessingModel";
  private RecurringProcessingModelEnum recurringProcessingModel;

  public static final String JSON_PROPERTY_REFERENCE = "reference";
  private String reference;

  public static final String JSON_PROPERTY_SELECTED_BRAND = "selectedBrand";
  private String selectedBrand;

  public static final String JSON_PROPERTY_SELECTED_RECURRING_DETAIL_REFERENCE = "selectedRecurringDetailReference";
  private String selectedRecurringDetailReference;

  public static final String JSON_PROPERTY_SESSION_ID = "sessionId";
  private String sessionId;

  public static final String JSON_PROPERTY_SHOPPER_EMAIL = "shopperEmail";
  private String shopperEmail;

  public static final String JSON_PROPERTY_SHOPPER_I_P = "shopperIP";
  private String shopperIP;

  /**
   * Specifies the sales channel, through which the shopper gives their card details, and whether the shopper is a returning customer. For the web service API, Adyen assumes Ecommerce shopper interaction by default.  This field has the following possible values: * &#x60;Ecommerce&#x60; - Online transactions where the cardholder is present (online). For better authorisation rates, we recommend sending the card security code (CSC) along with the request. * &#x60;ContAuth&#x60; - Card on file and/or subscription transactions, where the cardholder is known to the merchant (returning customer). If the shopper is present (online), you can supply also the CSC to improve authorisation (one-click payment). * &#x60;Moto&#x60; - Mail-order and telephone-order transactions where the shopper is in contact with the merchant via email or telephone. * &#x60;POS&#x60; - Point-of-sale transactions where the shopper is physically present to make a payment using a secure payment terminal.
   */
  public enum ShopperInteractionEnum {
    ECOMMERCE(String.valueOf("Ecommerce")),
    
    CONTAUTH(String.valueOf("ContAuth")),
    
    MOTO(String.valueOf("Moto")),
    
    POS(String.valueOf("POS"));

    private String value;

    ShopperInteractionEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ShopperInteractionEnum fromValue(String value) {
      for (ShopperInteractionEnum b : ShopperInteractionEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SHOPPER_INTERACTION = "shopperInteraction";
  private ShopperInteractionEnum shopperInteraction;

  public static final String JSON_PROPERTY_SHOPPER_LOCALE = "shopperLocale";
  private String shopperLocale;

  public static final String JSON_PROPERTY_SHOPPER_NAME = "shopperName";
  private Name shopperName;

  public static final String JSON_PROPERTY_SHOPPER_REFERENCE = "shopperReference";
  private String shopperReference;

  public static final String JSON_PROPERTY_SHOPPER_STATEMENT = "shopperStatement";
  private String shopperStatement;

  public static final String JSON_PROPERTY_SOCIAL_SECURITY_NUMBER = "socialSecurityNumber";
  private String socialSecurityNumber;

  public static final String JSON_PROPERTY_SPLITS = "splits";
  private List<Split> splits = new ArrayList<>();

  public static final String JSON_PROPERTY_STORE = "store";
  private String store;

  public static final String JSON_PROPERTY_TELEPHONE_NUMBER = "telephoneNumber";
  private String telephoneNumber;

  public static final String JSON_PROPERTY_THREE_D_S2_REQUEST_DATA = "threeDS2RequestData";
  private ThreeDS2RequestData threeDS2RequestData;

  public static final String JSON_PROPERTY_THREE_D_S_AUTHENTICATION_ONLY = "threeDSAuthenticationOnly";
  @Deprecated // deprecated since Adyen Checkout API v69: Use `authenticationData.authenticationOnly` instead.
  private Boolean threeDSAuthenticationOnly = false;

  public static final String JSON_PROPERTY_TOTALS_GROUP = "totalsGroup";
  private String totalsGroup;

  public static final String JSON_PROPERTY_TRUSTED_SHOPPER = "trustedShopper";
  private Boolean trustedShopper;

  public BalanceCheckRequest() { 
  }

  /**
   * accountInfo
   *
   * @param accountInfo
   * @return the current {@code BalanceCheckRequest} instance, allowing for method chaining
   */
  public BalanceCheckRequest accountInfo(AccountInfo accountInfo) {
    this.accountInfo = accountInfo;
    return this;
  }

  /**
   * Get accountInfo
   * @return accountInfo
   */
  @JsonProperty(JSON_PROPERTY_ACCOUNT_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public AccountInfo getAccountInfo() {
    return accountInfo;
  }

  /**
   * accountInfo
   *
   * @param accountInfo
   */
  @JsonProperty(JSON_PROPERTY_ACCOUNT_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccountInfo(AccountInfo accountInfo) {
    this.accountInfo = accountInfo;
  }

  /**
   * additionalAmount
   *
   * @param additionalAmount
   * @return the current {@code BalanceCheckRequest} instance, allowing for method chaining
   */
  public BalanceCheckRequest additionalAmount(Amount additionalAmount) {
    this.additionalAmount = additionalAmount;
    return this;
  }

  /**
   * Get additionalAmount
   * @return additionalAmount
   */
  @JsonProperty(JSON_PROPERTY_ADDITIONAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Amount getAdditionalAmount() {
    return additionalAmount;
  }

  /**
   * additionalAmount
   *
   * @param additionalAmount
   */
  @JsonProperty(JSON_PROPERTY_ADDITIONAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAdditionalAmount(Amount additionalAmount) {
    this.additionalAmount = additionalAmount;
  }

  /**
   * This field contains additional data, which may be required for a particular payment request.  The &#x60;additionalData&#x60; object consists of entries, each of which includes the key and value.
   *
   * @param additionalData
   * @return the current {@code BalanceCheckRequest} instance, allowing for method chaining
   */
  public BalanceCheckRequest additionalData(Map<String, String> additionalData) {
    this.additionalData = additionalData;
    return this;
  }

  public BalanceCheckRequest putAdditionalDataItem(String key, String additionalDataItem) {
    if (this.additionalData == null) {
      this.additionalData = new HashMap<>();
    }
    this.additionalData.put(key, additionalDataItem);
    return this;
  }

  /**
   * This field contains additional data, which may be required for a particular payment request.  The &#x60;additionalData&#x60; object consists of entries, each of which includes the key and value.
   * @return additionalData
   */
  @JsonProperty(JSON_PROPERTY_ADDITIONAL_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Map<String, String> getAdditionalData() {
    return additionalData;
  }

  /**
   * This field contains additional data, which may be required for a particular payment request.  The &#x60;additionalData&#x60; object consists of entries, each of which includes the key and value.
   *
   * @param additionalData
   */
  @JsonProperty(JSON_PROPERTY_ADDITIONAL_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAdditionalData(Map<String, String> additionalData) {
    this.additionalData = additionalData;
  }

  /**
   * amount
   *
   * @param amount
   * @return the current {@code BalanceCheckRequest} instance, allowing for method chaining
   */
  public BalanceCheckRequest amount(Amount amount) {
    this.amount = amount;
    return this;
  }

  /**
   * Get amount
   * @return amount
   */
  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Amount getAmount() {
    return amount;
  }

  /**
   * amount
   *
   * @param amount
   */
  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmount(Amount amount) {
    this.amount = amount;
  }

  /**
   * applicationInfo
   *
   * @param applicationInfo
   * @return the current {@code BalanceCheckRequest} instance, allowing for method chaining
   */
  public BalanceCheckRequest applicationInfo(ApplicationInfo applicationInfo) {
    this.applicationInfo = applicationInfo;
    return this;
  }

  /**
   * Get applicationInfo
   * @return applicationInfo
   */
  @JsonProperty(JSON_PROPERTY_APPLICATION_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ApplicationInfo getApplicationInfo() {
    return applicationInfo;
  }

  /**
   * applicationInfo
   *
   * @param applicationInfo
   */
  @JsonProperty(JSON_PROPERTY_APPLICATION_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setApplicationInfo(ApplicationInfo applicationInfo) {
    this.applicationInfo = applicationInfo;
  }

  /**
   * billingAddress
   *
   * @param billingAddress
   * @return the current {@code BalanceCheckRequest} instance, allowing for method chaining
   */
  public BalanceCheckRequest billingAddress(Address billingAddress) {
    this.billingAddress = billingAddress;
    return this;
  }

  /**
   * Get billingAddress
   * @return billingAddress
   */
  @JsonProperty(JSON_PROPERTY_BILLING_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Address getBillingAddress() {
    return billingAddress;
  }

  /**
   * billingAddress
   *
   * @param billingAddress
   */
  @JsonProperty(JSON_PROPERTY_BILLING_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBillingAddress(Address billingAddress) {
    this.billingAddress = billingAddress;
  }

  /**
   * browserInfo
   *
   * @param browserInfo
   * @return the current {@code BalanceCheckRequest} instance, allowing for method chaining
   */
  public BalanceCheckRequest browserInfo(BrowserInfo browserInfo) {
    this.browserInfo = browserInfo;
    return this;
  }

  /**
   * Get browserInfo
   * @return browserInfo
   */
  @JsonProperty(JSON_PROPERTY_BROWSER_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public BrowserInfo getBrowserInfo() {
    return browserInfo;
  }

  /**
   * browserInfo
   *
   * @param browserInfo
   */
  @JsonProperty(JSON_PROPERTY_BROWSER_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBrowserInfo(BrowserInfo browserInfo) {
    this.browserInfo = browserInfo;
  }

  /**
   * The delay between the authorisation and scheduled auto-capture, specified in hours.
   *
   * @param captureDelayHours
   * @return the current {@code BalanceCheckRequest} instance, allowing for method chaining
   */
  public BalanceCheckRequest captureDelayHours(Integer captureDelayHours) {
    this.captureDelayHours = captureDelayHours;
    return this;
  }

  /**
   * The delay between the authorisation and scheduled auto-capture, specified in hours.
   * @return captureDelayHours
   */
  @JsonProperty(JSON_PROPERTY_CAPTURE_DELAY_HOURS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Integer getCaptureDelayHours() {
    return captureDelayHours;
  }

  /**
   * The delay between the authorisation and scheduled auto-capture, specified in hours.
   *
   * @param captureDelayHours
   */
  @JsonProperty(JSON_PROPERTY_CAPTURE_DELAY_HOURS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCaptureDelayHours(Integer captureDelayHours) {
    this.captureDelayHours = captureDelayHours;
  }

  /**
   * The shopper&#39;s date of birth.  Format [ISO-8601](https://www.w3.org/TR/NOTE-datetime): YYYY-MM-DD
   *
   * @param dateOfBirth
   * @return the current {@code BalanceCheckRequest} instance, allowing for method chaining
   */
  public BalanceCheckRequest dateOfBirth(LocalDate dateOfBirth) {
    this.dateOfBirth = dateOfBirth;
    return this;
  }

  /**
   * The shopper&#39;s date of birth.  Format [ISO-8601](https://www.w3.org/TR/NOTE-datetime): YYYY-MM-DD
   * @return dateOfBirth
   */
  @JsonProperty(JSON_PROPERTY_DATE_OF_BIRTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public LocalDate getDateOfBirth() {
    return dateOfBirth;
  }

  /**
   * The shopper&#39;s date of birth.  Format [ISO-8601](https://www.w3.org/TR/NOTE-datetime): YYYY-MM-DD
   *
   * @param dateOfBirth
   */
  @JsonProperty(JSON_PROPERTY_DATE_OF_BIRTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDateOfBirth(LocalDate dateOfBirth) {
    this.dateOfBirth = dateOfBirth;
  }

  /**
   * dccQuote
   *
   * @param dccQuote
   * @return the current {@code BalanceCheckRequest} instance, allowing for method chaining
   */
  public BalanceCheckRequest dccQuote(ForexQuote dccQuote) {
    this.dccQuote = dccQuote;
    return this;
  }

  /**
   * Get dccQuote
   * @return dccQuote
   */
  @JsonProperty(JSON_PROPERTY_DCC_QUOTE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ForexQuote getDccQuote() {
    return dccQuote;
  }

  /**
   * dccQuote
   *
   * @param dccQuote
   */
  @JsonProperty(JSON_PROPERTY_DCC_QUOTE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDccQuote(ForexQuote dccQuote) {
    this.dccQuote = dccQuote;
  }

  /**
   * deliveryAddress
   *
   * @param deliveryAddress
   * @return the current {@code BalanceCheckRequest} instance, allowing for method chaining
   */
  public BalanceCheckRequest deliveryAddress(Address deliveryAddress) {
    this.deliveryAddress = deliveryAddress;
    return this;
  }

  /**
   * Get deliveryAddress
   * @return deliveryAddress
   */
  @JsonProperty(JSON_PROPERTY_DELIVERY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Address getDeliveryAddress() {
    return deliveryAddress;
  }

  /**
   * deliveryAddress
   *
   * @param deliveryAddress
   */
  @JsonProperty(JSON_PROPERTY_DELIVERY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeliveryAddress(Address deliveryAddress) {
    this.deliveryAddress = deliveryAddress;
  }

  /**
   * The date and time the purchased goods should be delivered.  Format [ISO 8601](https://www.w3.org/TR/NOTE-datetime): YYYY-MM-DDThh:mm:ss.sssTZD  Example: 2017-07-17T13:42:40.428+01:00
   *
   * @param deliveryDate
   * @return the current {@code BalanceCheckRequest} instance, allowing for method chaining
   */
  public BalanceCheckRequest deliveryDate(OffsetDateTime deliveryDate) {
    this.deliveryDate = deliveryDate;
    return this;
  }

  /**
   * The date and time the purchased goods should be delivered.  Format [ISO 8601](https://www.w3.org/TR/NOTE-datetime): YYYY-MM-DDThh:mm:ss.sssTZD  Example: 2017-07-17T13:42:40.428+01:00
   * @return deliveryDate
   */
  @JsonProperty(JSON_PROPERTY_DELIVERY_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OffsetDateTime getDeliveryDate() {
    return deliveryDate;
  }

  /**
   * The date and time the purchased goods should be delivered.  Format [ISO 8601](https://www.w3.org/TR/NOTE-datetime): YYYY-MM-DDThh:mm:ss.sssTZD  Example: 2017-07-17T13:42:40.428+01:00
   *
   * @param deliveryDate
   */
  @JsonProperty(JSON_PROPERTY_DELIVERY_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeliveryDate(OffsetDateTime deliveryDate) {
    this.deliveryDate = deliveryDate;
  }

  /**
   * A string containing the shopper&#39;s device fingerprint. For more information, refer to [Device fingerprinting](https://docs.adyen.com/risk-management/device-fingerprinting).
   *
   * @param deviceFingerprint
   * @return the current {@code BalanceCheckRequest} instance, allowing for method chaining
   */
  public BalanceCheckRequest deviceFingerprint(String deviceFingerprint) {
    this.deviceFingerprint = deviceFingerprint;
    return this;
  }

  /**
   * A string containing the shopper&#39;s device fingerprint. For more information, refer to [Device fingerprinting](https://docs.adyen.com/risk-management/device-fingerprinting).
   * @return deviceFingerprint
   */
  @JsonProperty(JSON_PROPERTY_DEVICE_FINGERPRINT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDeviceFingerprint() {
    return deviceFingerprint;
  }

  /**
   * A string containing the shopper&#39;s device fingerprint. For more information, refer to [Device fingerprinting](https://docs.adyen.com/risk-management/device-fingerprinting).
   *
   * @param deviceFingerprint
   */
  @JsonProperty(JSON_PROPERTY_DEVICE_FINGERPRINT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeviceFingerprint(String deviceFingerprint) {
    this.deviceFingerprint = deviceFingerprint;
  }

  /**
   * An integer value that is added to the normal fraud score. The value can be either positive or negative.
   *
   * @param fraudOffset
   * @return the current {@code BalanceCheckRequest} instance, allowing for method chaining
   */
  public BalanceCheckRequest fraudOffset(Integer fraudOffset) {
    this.fraudOffset = fraudOffset;
    return this;
  }

  /**
   * An integer value that is added to the normal fraud score. The value can be either positive or negative.
   * @return fraudOffset
   */
  @JsonProperty(JSON_PROPERTY_FRAUD_OFFSET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Integer getFraudOffset() {
    return fraudOffset;
  }

  /**
   * An integer value that is added to the normal fraud score. The value can be either positive or negative.
   *
   * @param fraudOffset
   */
  @JsonProperty(JSON_PROPERTY_FRAUD_OFFSET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFraudOffset(Integer fraudOffset) {
    this.fraudOffset = fraudOffset;
  }

  /**
   * installments
   *
   * @param installments
   * @return the current {@code BalanceCheckRequest} instance, allowing for method chaining
   */
  public BalanceCheckRequest installments(Installments installments) {
    this.installments = installments;
    return this;
  }

  /**
   * Get installments
   * @return installments
   */
  @JsonProperty(JSON_PROPERTY_INSTALLMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Installments getInstallments() {
    return installments;
  }

  /**
   * installments
   *
   * @param installments
   */
  @JsonProperty(JSON_PROPERTY_INSTALLMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInstallments(Installments installments) {
    this.installments = installments;
  }

  /**
   * The &#x60;localizedShopperStatement&#x60; field lets you use dynamic values for your shopper statement in a local character set. If not supplied, left empty, or for cross-border transactions, **shopperStatement** is used.  Adyen currently supports the ja-Kana character set for Visa and Mastercard payments in Japan using Japanese cards. This character set supports:  * UTF-8 based Katakana, capital letters, numbers and special characters.  * Half-width or full-width characters.
   *
   * @param localizedShopperStatement
   * @return the current {@code BalanceCheckRequest} instance, allowing for method chaining
   */
  public BalanceCheckRequest localizedShopperStatement(Map<String, String> localizedShopperStatement) {
    this.localizedShopperStatement = localizedShopperStatement;
    return this;
  }

  public BalanceCheckRequest putLocalizedShopperStatementItem(String key, String localizedShopperStatementItem) {
    if (this.localizedShopperStatement == null) {
      this.localizedShopperStatement = new HashMap<>();
    }
    this.localizedShopperStatement.put(key, localizedShopperStatementItem);
    return this;
  }

  /**
   * The &#x60;localizedShopperStatement&#x60; field lets you use dynamic values for your shopper statement in a local character set. If not supplied, left empty, or for cross-border transactions, **shopperStatement** is used.  Adyen currently supports the ja-Kana character set for Visa and Mastercard payments in Japan using Japanese cards. This character set supports:  * UTF-8 based Katakana, capital letters, numbers and special characters.  * Half-width or full-width characters.
   * @return localizedShopperStatement
   */
  @JsonProperty(JSON_PROPERTY_LOCALIZED_SHOPPER_STATEMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Map<String, String> getLocalizedShopperStatement() {
    return localizedShopperStatement;
  }

  /**
   * The &#x60;localizedShopperStatement&#x60; field lets you use dynamic values for your shopper statement in a local character set. If not supplied, left empty, or for cross-border transactions, **shopperStatement** is used.  Adyen currently supports the ja-Kana character set for Visa and Mastercard payments in Japan using Japanese cards. This character set supports:  * UTF-8 based Katakana, capital letters, numbers and special characters.  * Half-width or full-width characters.
   *
   * @param localizedShopperStatement
   */
  @JsonProperty(JSON_PROPERTY_LOCALIZED_SHOPPER_STATEMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocalizedShopperStatement(Map<String, String> localizedShopperStatement) {
    this.localizedShopperStatement = localizedShopperStatement;
  }

  /**
   * The [merchant category code](https://en.wikipedia.org/wiki/Merchant_category_code) (MCC) is a four-digit number, which relates to a particular market segment. This code reflects the predominant activity that is conducted by the merchant.
   *
   * @param mcc
   * @return the current {@code BalanceCheckRequest} instance, allowing for method chaining
   */
  public BalanceCheckRequest mcc(String mcc) {
    this.mcc = mcc;
    return this;
  }

  /**
   * The [merchant category code](https://en.wikipedia.org/wiki/Merchant_category_code) (MCC) is a four-digit number, which relates to a particular market segment. This code reflects the predominant activity that is conducted by the merchant.
   * @return mcc
   */
  @JsonProperty(JSON_PROPERTY_MCC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMcc() {
    return mcc;
  }

  /**
   * The [merchant category code](https://en.wikipedia.org/wiki/Merchant_category_code) (MCC) is a four-digit number, which relates to a particular market segment. This code reflects the predominant activity that is conducted by the merchant.
   *
   * @param mcc
   */
  @JsonProperty(JSON_PROPERTY_MCC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMcc(String mcc) {
    this.mcc = mcc;
  }

  /**
   * The merchant account identifier, with which you want to process the transaction.
   *
   * @param merchantAccount
   * @return the current {@code BalanceCheckRequest} instance, allowing for method chaining
   */
  public BalanceCheckRequest merchantAccount(String merchantAccount) {
    this.merchantAccount = merchantAccount;
    return this;
  }

  /**
   * The merchant account identifier, with which you want to process the transaction.
   * @return merchantAccount
   */
  @JsonProperty(JSON_PROPERTY_MERCHANT_ACCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMerchantAccount() {
    return merchantAccount;
  }

  /**
   * The merchant account identifier, with which you want to process the transaction.
   *
   * @param merchantAccount
   */
  @JsonProperty(JSON_PROPERTY_MERCHANT_ACCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMerchantAccount(String merchantAccount) {
    this.merchantAccount = merchantAccount;
  }

  /**
   * This reference allows linking multiple transactions to each other for reporting purposes (i.e. order auth-rate). The reference should be unique per billing cycle. The same merchant order reference should never be reused after the first authorised attempt. If used, this field should be supplied for all incoming authorisations. &gt; We strongly recommend you send the &#x60;merchantOrderReference&#x60; value to benefit from linking payment requests when authorisation retries take place. In addition, we recommend you provide &#x60;retry.orderAttemptNumber&#x60;, &#x60;retry.chainAttemptNumber&#x60;, and &#x60;retry.skipRetry&#x60; values in &#x60;PaymentRequest.additionalData&#x60;.
   *
   * @param merchantOrderReference
   * @return the current {@code BalanceCheckRequest} instance, allowing for method chaining
   */
  public BalanceCheckRequest merchantOrderReference(String merchantOrderReference) {
    this.merchantOrderReference = merchantOrderReference;
    return this;
  }

  /**
   * This reference allows linking multiple transactions to each other for reporting purposes (i.e. order auth-rate). The reference should be unique per billing cycle. The same merchant order reference should never be reused after the first authorised attempt. If used, this field should be supplied for all incoming authorisations. &gt; We strongly recommend you send the &#x60;merchantOrderReference&#x60; value to benefit from linking payment requests when authorisation retries take place. In addition, we recommend you provide &#x60;retry.orderAttemptNumber&#x60;, &#x60;retry.chainAttemptNumber&#x60;, and &#x60;retry.skipRetry&#x60; values in &#x60;PaymentRequest.additionalData&#x60;.
   * @return merchantOrderReference
   */
  @JsonProperty(JSON_PROPERTY_MERCHANT_ORDER_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMerchantOrderReference() {
    return merchantOrderReference;
  }

  /**
   * This reference allows linking multiple transactions to each other for reporting purposes (i.e. order auth-rate). The reference should be unique per billing cycle. The same merchant order reference should never be reused after the first authorised attempt. If used, this field should be supplied for all incoming authorisations. &gt; We strongly recommend you send the &#x60;merchantOrderReference&#x60; value to benefit from linking payment requests when authorisation retries take place. In addition, we recommend you provide &#x60;retry.orderAttemptNumber&#x60;, &#x60;retry.chainAttemptNumber&#x60;, and &#x60;retry.skipRetry&#x60; values in &#x60;PaymentRequest.additionalData&#x60;.
   *
   * @param merchantOrderReference
   */
  @JsonProperty(JSON_PROPERTY_MERCHANT_ORDER_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMerchantOrderReference(String merchantOrderReference) {
    this.merchantOrderReference = merchantOrderReference;
  }

  /**
   * merchantRiskIndicator
   *
   * @param merchantRiskIndicator
   * @return the current {@code BalanceCheckRequest} instance, allowing for method chaining
   */
  public BalanceCheckRequest merchantRiskIndicator(MerchantRiskIndicator merchantRiskIndicator) {
    this.merchantRiskIndicator = merchantRiskIndicator;
    return this;
  }

  /**
   * Get merchantRiskIndicator
   * @return merchantRiskIndicator
   */
  @JsonProperty(JSON_PROPERTY_MERCHANT_RISK_INDICATOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public MerchantRiskIndicator getMerchantRiskIndicator() {
    return merchantRiskIndicator;
  }

  /**
   * merchantRiskIndicator
   *
   * @param merchantRiskIndicator
   */
  @JsonProperty(JSON_PROPERTY_MERCHANT_RISK_INDICATOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMerchantRiskIndicator(MerchantRiskIndicator merchantRiskIndicator) {
    this.merchantRiskIndicator = merchantRiskIndicator;
  }

  /**
   * Metadata consists of entries, each of which includes a key and a value. Limits: * Maximum 20 key-value pairs per request. When exceeding, the \&quot;177\&quot; error occurs: \&quot;Metadata size exceeds limit\&quot;. * Maximum 20 characters per key. * Maximum 80 characters per value. 
   *
   * @param metadata
   * @return the current {@code BalanceCheckRequest} instance, allowing for method chaining
   */
  public BalanceCheckRequest metadata(Map<String, String> metadata) {
    this.metadata = metadata;
    return this;
  }

  public BalanceCheckRequest putMetadataItem(String key, String metadataItem) {
    if (this.metadata == null) {
      this.metadata = new HashMap<>();
    }
    this.metadata.put(key, metadataItem);
    return this;
  }

  /**
   * Metadata consists of entries, each of which includes a key and a value. Limits: * Maximum 20 key-value pairs per request. When exceeding, the \&quot;177\&quot; error occurs: \&quot;Metadata size exceeds limit\&quot;. * Maximum 20 characters per key. * Maximum 80 characters per value. 
   * @return metadata
   */
  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Map<String, String> getMetadata() {
    return metadata;
  }

  /**
   * Metadata consists of entries, each of which includes a key and a value. Limits: * Maximum 20 key-value pairs per request. When exceeding, the \&quot;177\&quot; error occurs: \&quot;Metadata size exceeds limit\&quot;. * Maximum 20 characters per key. * Maximum 80 characters per value. 
   *
   * @param metadata
   */
  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetadata(Map<String, String> metadata) {
    this.metadata = metadata;
  }

  /**
   * When you are doing multiple partial (gift card) payments, this is the &#x60;pspReference&#x60; of the first payment. We use this to link the multiple payments to each other. As your own reference for linking multiple payments, use the &#x60;merchantOrderReference&#x60;instead.
   *
   * @param orderReference
   * @return the current {@code BalanceCheckRequest} instance, allowing for method chaining
   */
  public BalanceCheckRequest orderReference(String orderReference) {
    this.orderReference = orderReference;
    return this;
  }

  /**
   * When you are doing multiple partial (gift card) payments, this is the &#x60;pspReference&#x60; of the first payment. We use this to link the multiple payments to each other. As your own reference for linking multiple payments, use the &#x60;merchantOrderReference&#x60;instead.
   * @return orderReference
   */
  @JsonProperty(JSON_PROPERTY_ORDER_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getOrderReference() {
    return orderReference;
  }

  /**
   * When you are doing multiple partial (gift card) payments, this is the &#x60;pspReference&#x60; of the first payment. We use this to link the multiple payments to each other. As your own reference for linking multiple payments, use the &#x60;merchantOrderReference&#x60;instead.
   *
   * @param orderReference
   */
  @JsonProperty(JSON_PROPERTY_ORDER_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOrderReference(String orderReference) {
    this.orderReference = orderReference;
  }

  /**
   * The collection that contains the type of the payment method and its specific information.
   *
   * @param paymentMethod
   * @return the current {@code BalanceCheckRequest} instance, allowing for method chaining
   */
  public BalanceCheckRequest paymentMethod(Map<String, String> paymentMethod) {
    this.paymentMethod = paymentMethod;
    return this;
  }

  public BalanceCheckRequest putPaymentMethodItem(String key, String paymentMethodItem) {
    if (this.paymentMethod == null) {
      this.paymentMethod = new HashMap<>();
    }
    this.paymentMethod.put(key, paymentMethodItem);
    return this;
  }

  /**
   * The collection that contains the type of the payment method and its specific information.
   * @return paymentMethod
   */
  @JsonProperty(JSON_PROPERTY_PAYMENT_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Map<String, String> getPaymentMethod() {
    return paymentMethod;
  }

  /**
   * The collection that contains the type of the payment method and its specific information.
   *
   * @param paymentMethod
   */
  @JsonProperty(JSON_PROPERTY_PAYMENT_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaymentMethod(Map<String, String> paymentMethod) {
    this.paymentMethod = paymentMethod;
  }

  /**
   * recurring
   *
   * @param recurring
   * @return the current {@code BalanceCheckRequest} instance, allowing for method chaining
   */
  public BalanceCheckRequest recurring(Recurring recurring) {
    this.recurring = recurring;
    return this;
  }

  /**
   * Get recurring
   * @return recurring
   */
  @JsonProperty(JSON_PROPERTY_RECURRING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Recurring getRecurring() {
    return recurring;
  }

  /**
   * recurring
   *
   * @param recurring
   */
  @JsonProperty(JSON_PROPERTY_RECURRING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecurring(Recurring recurring) {
    this.recurring = recurring;
  }

  /**
   * Defines a recurring payment type. Required when creating a token to store payment details or using stored payment details. Allowed values: * &#x60;Subscription&#x60; – A transaction for a fixed or variable amount, which follows a fixed schedule. * &#x60;CardOnFile&#x60; – With a card-on-file (CoF) transaction, card details are stored to enable one-click or omnichannel journeys, or simply to streamline the checkout process. Any subscription not following a fixed schedule is also considered a card-on-file transaction. * &#x60;UnscheduledCardOnFile&#x60; – An unscheduled card-on-file (UCoF) transaction is a transaction that occurs on a non-fixed schedule and/or have variable amounts. For example, automatic top-ups when a cardholder&#39;s balance drops below a certain amount. 
   *
   * @param recurringProcessingModel
   * @return the current {@code BalanceCheckRequest} instance, allowing for method chaining
   */
  public BalanceCheckRequest recurringProcessingModel(RecurringProcessingModelEnum recurringProcessingModel) {
    this.recurringProcessingModel = recurringProcessingModel;
    return this;
  }

  /**
   * Defines a recurring payment type. Required when creating a token to store payment details or using stored payment details. Allowed values: * &#x60;Subscription&#x60; – A transaction for a fixed or variable amount, which follows a fixed schedule. * &#x60;CardOnFile&#x60; – With a card-on-file (CoF) transaction, card details are stored to enable one-click or omnichannel journeys, or simply to streamline the checkout process. Any subscription not following a fixed schedule is also considered a card-on-file transaction. * &#x60;UnscheduledCardOnFile&#x60; – An unscheduled card-on-file (UCoF) transaction is a transaction that occurs on a non-fixed schedule and/or have variable amounts. For example, automatic top-ups when a cardholder&#39;s balance drops below a certain amount. 
   * @return recurringProcessingModel
   */
  @JsonProperty(JSON_PROPERTY_RECURRING_PROCESSING_MODEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public RecurringProcessingModelEnum getRecurringProcessingModel() {
    return recurringProcessingModel;
  }

  /**
   * Defines a recurring payment type. Required when creating a token to store payment details or using stored payment details. Allowed values: * &#x60;Subscription&#x60; – A transaction for a fixed or variable amount, which follows a fixed schedule. * &#x60;CardOnFile&#x60; – With a card-on-file (CoF) transaction, card details are stored to enable one-click or omnichannel journeys, or simply to streamline the checkout process. Any subscription not following a fixed schedule is also considered a card-on-file transaction. * &#x60;UnscheduledCardOnFile&#x60; – An unscheduled card-on-file (UCoF) transaction is a transaction that occurs on a non-fixed schedule and/or have variable amounts. For example, automatic top-ups when a cardholder&#39;s balance drops below a certain amount. 
   *
   * @param recurringProcessingModel
   */
  @JsonProperty(JSON_PROPERTY_RECURRING_PROCESSING_MODEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecurringProcessingModel(RecurringProcessingModelEnum recurringProcessingModel) {
    this.recurringProcessingModel = recurringProcessingModel;
  }

  /**
   * The reference to uniquely identify a payment. This reference is used in all communication with you about the payment status. We recommend using a unique value per payment; however, it is not a requirement. If you need to provide multiple references for a transaction, separate them with hyphens (\&quot;-\&quot;). Maximum length: 80 characters.
   *
   * @param reference
   * @return the current {@code BalanceCheckRequest} instance, allowing for method chaining
   */
  public BalanceCheckRequest reference(String reference) {
    this.reference = reference;
    return this;
  }

  /**
   * The reference to uniquely identify a payment. This reference is used in all communication with you about the payment status. We recommend using a unique value per payment; however, it is not a requirement. If you need to provide multiple references for a transaction, separate them with hyphens (\&quot;-\&quot;). Maximum length: 80 characters.
   * @return reference
   */
  @JsonProperty(JSON_PROPERTY_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getReference() {
    return reference;
  }

  /**
   * The reference to uniquely identify a payment. This reference is used in all communication with you about the payment status. We recommend using a unique value per payment; however, it is not a requirement. If you need to provide multiple references for a transaction, separate them with hyphens (\&quot;-\&quot;). Maximum length: 80 characters.
   *
   * @param reference
   */
  @JsonProperty(JSON_PROPERTY_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReference(String reference) {
    this.reference = reference;
  }

  /**
   * Some payment methods require defining a value for this field to specify how to process the transaction.  For the Bancontact payment method, it can be set to: * &#x60;maestro&#x60; (default), to be processed like a Maestro card, or * &#x60;bcmc&#x60;, to be processed like a Bancontact card.
   *
   * @param selectedBrand
   * @return the current {@code BalanceCheckRequest} instance, allowing for method chaining
   */
  public BalanceCheckRequest selectedBrand(String selectedBrand) {
    this.selectedBrand = selectedBrand;
    return this;
  }

  /**
   * Some payment methods require defining a value for this field to specify how to process the transaction.  For the Bancontact payment method, it can be set to: * &#x60;maestro&#x60; (default), to be processed like a Maestro card, or * &#x60;bcmc&#x60;, to be processed like a Bancontact card.
   * @return selectedBrand
   */
  @JsonProperty(JSON_PROPERTY_SELECTED_BRAND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getSelectedBrand() {
    return selectedBrand;
  }

  /**
   * Some payment methods require defining a value for this field to specify how to process the transaction.  For the Bancontact payment method, it can be set to: * &#x60;maestro&#x60; (default), to be processed like a Maestro card, or * &#x60;bcmc&#x60;, to be processed like a Bancontact card.
   *
   * @param selectedBrand
   */
  @JsonProperty(JSON_PROPERTY_SELECTED_BRAND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSelectedBrand(String selectedBrand) {
    this.selectedBrand = selectedBrand;
  }

  /**
   * The &#x60;recurringDetailReference&#x60; you want to use for this payment. The value &#x60;LATEST&#x60; can be used to select the most recently stored recurring detail.
   *
   * @param selectedRecurringDetailReference
   * @return the current {@code BalanceCheckRequest} instance, allowing for method chaining
   */
  public BalanceCheckRequest selectedRecurringDetailReference(String selectedRecurringDetailReference) {
    this.selectedRecurringDetailReference = selectedRecurringDetailReference;
    return this;
  }

  /**
   * The &#x60;recurringDetailReference&#x60; you want to use for this payment. The value &#x60;LATEST&#x60; can be used to select the most recently stored recurring detail.
   * @return selectedRecurringDetailReference
   */
  @JsonProperty(JSON_PROPERTY_SELECTED_RECURRING_DETAIL_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getSelectedRecurringDetailReference() {
    return selectedRecurringDetailReference;
  }

  /**
   * The &#x60;recurringDetailReference&#x60; you want to use for this payment. The value &#x60;LATEST&#x60; can be used to select the most recently stored recurring detail.
   *
   * @param selectedRecurringDetailReference
   */
  @JsonProperty(JSON_PROPERTY_SELECTED_RECURRING_DETAIL_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSelectedRecurringDetailReference(String selectedRecurringDetailReference) {
    this.selectedRecurringDetailReference = selectedRecurringDetailReference;
  }

  /**
   * A session ID used to identify a payment session.
   *
   * @param sessionId
   * @return the current {@code BalanceCheckRequest} instance, allowing for method chaining
   */
  public BalanceCheckRequest sessionId(String sessionId) {
    this.sessionId = sessionId;
    return this;
  }

  /**
   * A session ID used to identify a payment session.
   * @return sessionId
   */
  @JsonProperty(JSON_PROPERTY_SESSION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getSessionId() {
    return sessionId;
  }

  /**
   * A session ID used to identify a payment session.
   *
   * @param sessionId
   */
  @JsonProperty(JSON_PROPERTY_SESSION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSessionId(String sessionId) {
    this.sessionId = sessionId;
  }

  /**
   * The shopper&#39;s email address. We recommend that you provide this data, as it is used in velocity fraud checks. &gt; For 3D Secure 2 transactions, schemes require &#x60;shopperEmail&#x60; for all browser-based and mobile implementations.
   *
   * @param shopperEmail
   * @return the current {@code BalanceCheckRequest} instance, allowing for method chaining
   */
  public BalanceCheckRequest shopperEmail(String shopperEmail) {
    this.shopperEmail = shopperEmail;
    return this;
  }

  /**
   * The shopper&#39;s email address. We recommend that you provide this data, as it is used in velocity fraud checks. &gt; For 3D Secure 2 transactions, schemes require &#x60;shopperEmail&#x60; for all browser-based and mobile implementations.
   * @return shopperEmail
   */
  @JsonProperty(JSON_PROPERTY_SHOPPER_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getShopperEmail() {
    return shopperEmail;
  }

  /**
   * The shopper&#39;s email address. We recommend that you provide this data, as it is used in velocity fraud checks. &gt; For 3D Secure 2 transactions, schemes require &#x60;shopperEmail&#x60; for all browser-based and mobile implementations.
   *
   * @param shopperEmail
   */
  @JsonProperty(JSON_PROPERTY_SHOPPER_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShopperEmail(String shopperEmail) {
    this.shopperEmail = shopperEmail;
  }

  /**
   * The shopper&#39;s IP address. In general, we recommend that you provide this data, as it is used in a number of risk checks (for instance, number of payment attempts or location-based checks). &gt; For 3D Secure 2 transactions, schemes require &#x60;shopperIP&#x60; for all browser-based implementations. This field is also mandatory for some merchants depending on your business model. For more information, [contact Support](https://www.adyen.help/hc/en-us/requests/new).
   *
   * @param shopperIP
   * @return the current {@code BalanceCheckRequest} instance, allowing for method chaining
   */
  public BalanceCheckRequest shopperIP(String shopperIP) {
    this.shopperIP = shopperIP;
    return this;
  }

  /**
   * The shopper&#39;s IP address. In general, we recommend that you provide this data, as it is used in a number of risk checks (for instance, number of payment attempts or location-based checks). &gt; For 3D Secure 2 transactions, schemes require &#x60;shopperIP&#x60; for all browser-based implementations. This field is also mandatory for some merchants depending on your business model. For more information, [contact Support](https://www.adyen.help/hc/en-us/requests/new).
   * @return shopperIP
   */
  @JsonProperty(JSON_PROPERTY_SHOPPER_I_P)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getShopperIP() {
    return shopperIP;
  }

  /**
   * The shopper&#39;s IP address. In general, we recommend that you provide this data, as it is used in a number of risk checks (for instance, number of payment attempts or location-based checks). &gt; For 3D Secure 2 transactions, schemes require &#x60;shopperIP&#x60; for all browser-based implementations. This field is also mandatory for some merchants depending on your business model. For more information, [contact Support](https://www.adyen.help/hc/en-us/requests/new).
   *
   * @param shopperIP
   */
  @JsonProperty(JSON_PROPERTY_SHOPPER_I_P)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShopperIP(String shopperIP) {
    this.shopperIP = shopperIP;
  }

  /**
   * Specifies the sales channel, through which the shopper gives their card details, and whether the shopper is a returning customer. For the web service API, Adyen assumes Ecommerce shopper interaction by default.  This field has the following possible values: * &#x60;Ecommerce&#x60; - Online transactions where the cardholder is present (online). For better authorisation rates, we recommend sending the card security code (CSC) along with the request. * &#x60;ContAuth&#x60; - Card on file and/or subscription transactions, where the cardholder is known to the merchant (returning customer). If the shopper is present (online), you can supply also the CSC to improve authorisation (one-click payment). * &#x60;Moto&#x60; - Mail-order and telephone-order transactions where the shopper is in contact with the merchant via email or telephone. * &#x60;POS&#x60; - Point-of-sale transactions where the shopper is physically present to make a payment using a secure payment terminal.
   *
   * @param shopperInteraction
   * @return the current {@code BalanceCheckRequest} instance, allowing for method chaining
   */
  public BalanceCheckRequest shopperInteraction(ShopperInteractionEnum shopperInteraction) {
    this.shopperInteraction = shopperInteraction;
    return this;
  }

  /**
   * Specifies the sales channel, through which the shopper gives their card details, and whether the shopper is a returning customer. For the web service API, Adyen assumes Ecommerce shopper interaction by default.  This field has the following possible values: * &#x60;Ecommerce&#x60; - Online transactions where the cardholder is present (online). For better authorisation rates, we recommend sending the card security code (CSC) along with the request. * &#x60;ContAuth&#x60; - Card on file and/or subscription transactions, where the cardholder is known to the merchant (returning customer). If the shopper is present (online), you can supply also the CSC to improve authorisation (one-click payment). * &#x60;Moto&#x60; - Mail-order and telephone-order transactions where the shopper is in contact with the merchant via email or telephone. * &#x60;POS&#x60; - Point-of-sale transactions where the shopper is physically present to make a payment using a secure payment terminal.
   * @return shopperInteraction
   */
  @JsonProperty(JSON_PROPERTY_SHOPPER_INTERACTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ShopperInteractionEnum getShopperInteraction() {
    return shopperInteraction;
  }

  /**
   * Specifies the sales channel, through which the shopper gives their card details, and whether the shopper is a returning customer. For the web service API, Adyen assumes Ecommerce shopper interaction by default.  This field has the following possible values: * &#x60;Ecommerce&#x60; - Online transactions where the cardholder is present (online). For better authorisation rates, we recommend sending the card security code (CSC) along with the request. * &#x60;ContAuth&#x60; - Card on file and/or subscription transactions, where the cardholder is known to the merchant (returning customer). If the shopper is present (online), you can supply also the CSC to improve authorisation (one-click payment). * &#x60;Moto&#x60; - Mail-order and telephone-order transactions where the shopper is in contact with the merchant via email or telephone. * &#x60;POS&#x60; - Point-of-sale transactions where the shopper is physically present to make a payment using a secure payment terminal.
   *
   * @param shopperInteraction
   */
  @JsonProperty(JSON_PROPERTY_SHOPPER_INTERACTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShopperInteraction(ShopperInteractionEnum shopperInteraction) {
    this.shopperInteraction = shopperInteraction;
  }

  /**
   * The combination of a language code and a country code to specify the language to be used in the payment.
   *
   * @param shopperLocale
   * @return the current {@code BalanceCheckRequest} instance, allowing for method chaining
   */
  public BalanceCheckRequest shopperLocale(String shopperLocale) {
    this.shopperLocale = shopperLocale;
    return this;
  }

  /**
   * The combination of a language code and a country code to specify the language to be used in the payment.
   * @return shopperLocale
   */
  @JsonProperty(JSON_PROPERTY_SHOPPER_LOCALE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getShopperLocale() {
    return shopperLocale;
  }

  /**
   * The combination of a language code and a country code to specify the language to be used in the payment.
   *
   * @param shopperLocale
   */
  @JsonProperty(JSON_PROPERTY_SHOPPER_LOCALE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShopperLocale(String shopperLocale) {
    this.shopperLocale = shopperLocale;
  }

  /**
   * shopperName
   *
   * @param shopperName
   * @return the current {@code BalanceCheckRequest} instance, allowing for method chaining
   */
  public BalanceCheckRequest shopperName(Name shopperName) {
    this.shopperName = shopperName;
    return this;
  }

  /**
   * Get shopperName
   * @return shopperName
   */
  @JsonProperty(JSON_PROPERTY_SHOPPER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Name getShopperName() {
    return shopperName;
  }

  /**
   * shopperName
   *
   * @param shopperName
   */
  @JsonProperty(JSON_PROPERTY_SHOPPER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShopperName(Name shopperName) {
    this.shopperName = shopperName;
  }

  /**
   * Required for recurring payments.  Your reference to uniquely identify this shopper, for example user ID or account ID. The value is case-sensitive and must be at least three characters. &gt; Your reference must not include personally identifiable information (PII) such as name or email address.
   *
   * @param shopperReference
   * @return the current {@code BalanceCheckRequest} instance, allowing for method chaining
   */
  public BalanceCheckRequest shopperReference(String shopperReference) {
    this.shopperReference = shopperReference;
    return this;
  }

  /**
   * Required for recurring payments.  Your reference to uniquely identify this shopper, for example user ID or account ID. The value is case-sensitive and must be at least three characters. &gt; Your reference must not include personally identifiable information (PII) such as name or email address.
   * @return shopperReference
   */
  @JsonProperty(JSON_PROPERTY_SHOPPER_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getShopperReference() {
    return shopperReference;
  }

  /**
   * Required for recurring payments.  Your reference to uniquely identify this shopper, for example user ID or account ID. The value is case-sensitive and must be at least three characters. &gt; Your reference must not include personally identifiable information (PII) such as name or email address.
   *
   * @param shopperReference
   */
  @JsonProperty(JSON_PROPERTY_SHOPPER_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShopperReference(String shopperReference) {
    this.shopperReference = shopperReference;
  }

  /**
   * The text to be shown on the shopper&#39;s bank statement.  We recommend sending a maximum of 22 characters, otherwise banks might truncate the string.  Allowed characters: **a-z**, **A-Z**, **0-9**, spaces, and special characters **. , &#39; _ - ? + * /_**.
   *
   * @param shopperStatement
   * @return the current {@code BalanceCheckRequest} instance, allowing for method chaining
   */
  public BalanceCheckRequest shopperStatement(String shopperStatement) {
    this.shopperStatement = shopperStatement;
    return this;
  }

  /**
   * The text to be shown on the shopper&#39;s bank statement.  We recommend sending a maximum of 22 characters, otherwise banks might truncate the string.  Allowed characters: **a-z**, **A-Z**, **0-9**, spaces, and special characters **. , &#39; _ - ? + * /_**.
   * @return shopperStatement
   */
  @JsonProperty(JSON_PROPERTY_SHOPPER_STATEMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getShopperStatement() {
    return shopperStatement;
  }

  /**
   * The text to be shown on the shopper&#39;s bank statement.  We recommend sending a maximum of 22 characters, otherwise banks might truncate the string.  Allowed characters: **a-z**, **A-Z**, **0-9**, spaces, and special characters **. , &#39; _ - ? + * /_**.
   *
   * @param shopperStatement
   */
  @JsonProperty(JSON_PROPERTY_SHOPPER_STATEMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShopperStatement(String shopperStatement) {
    this.shopperStatement = shopperStatement;
  }

  /**
   * The shopper&#39;s social security number.
   *
   * @param socialSecurityNumber
   * @return the current {@code BalanceCheckRequest} instance, allowing for method chaining
   */
  public BalanceCheckRequest socialSecurityNumber(String socialSecurityNumber) {
    this.socialSecurityNumber = socialSecurityNumber;
    return this;
  }

  /**
   * The shopper&#39;s social security number.
   * @return socialSecurityNumber
   */
  @JsonProperty(JSON_PROPERTY_SOCIAL_SECURITY_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getSocialSecurityNumber() {
    return socialSecurityNumber;
  }

  /**
   * The shopper&#39;s social security number.
   *
   * @param socialSecurityNumber
   */
  @JsonProperty(JSON_PROPERTY_SOCIAL_SECURITY_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSocialSecurityNumber(String socialSecurityNumber) {
    this.socialSecurityNumber = socialSecurityNumber;
  }

  /**
   * An array of objects specifying how the payment should be split when using either Adyen for Platforms for [marketplaces](https://docs.adyen.com/marketplaces/split-payments) or [platforms](https://docs.adyen.com/platforms/split-payments), or standalone [Issuing](https://docs.adyen.com/issuing/add-manage-funds#split).
   *
   * @param splits
   * @return the current {@code BalanceCheckRequest} instance, allowing for method chaining
   */
  public BalanceCheckRequest splits(List<Split> splits) {
    this.splits = splits;
    return this;
  }

  public BalanceCheckRequest addSplitsItem(Split splitsItem) {
    if (this.splits == null) {
      this.splits = new ArrayList<>();
    }
    this.splits.add(splitsItem);
    return this;
  }

  /**
   * An array of objects specifying how the payment should be split when using either Adyen for Platforms for [marketplaces](https://docs.adyen.com/marketplaces/split-payments) or [platforms](https://docs.adyen.com/platforms/split-payments), or standalone [Issuing](https://docs.adyen.com/issuing/add-manage-funds#split).
   * @return splits
   */
  @JsonProperty(JSON_PROPERTY_SPLITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<Split> getSplits() {
    return splits;
  }

  /**
   * An array of objects specifying how the payment should be split when using either Adyen for Platforms for [marketplaces](https://docs.adyen.com/marketplaces/split-payments) or [platforms](https://docs.adyen.com/platforms/split-payments), or standalone [Issuing](https://docs.adyen.com/issuing/add-manage-funds#split).
   *
   * @param splits
   */
  @JsonProperty(JSON_PROPERTY_SPLITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSplits(List<Split> splits) {
    this.splits = splits;
  }

  /**
   * Required for Adyen for Platforms integrations if you are a platform model. This is your [reference](https://docs.adyen.com/api-explorer/Management/3/post/merchants/(merchantId)/stores#request-reference) (on [balance platform](https://docs.adyen.com/platforms)) or the [storeReference](https://docs.adyen.com/api-explorer/Account/latest/post/updateAccountHolder#request-accountHolderDetails-storeDetails-storeReference) (in the [classic integration](https://docs.adyen.com/classic-platforms/processing-payments/route-payment-to-store/#route-a-payment-to-a-store)) for the ecommerce or point-of-sale store that is processing the payment.
   *
   * @param store
   * @return the current {@code BalanceCheckRequest} instance, allowing for method chaining
   */
  public BalanceCheckRequest store(String store) {
    this.store = store;
    return this;
  }

  /**
   * Required for Adyen for Platforms integrations if you are a platform model. This is your [reference](https://docs.adyen.com/api-explorer/Management/3/post/merchants/(merchantId)/stores#request-reference) (on [balance platform](https://docs.adyen.com/platforms)) or the [storeReference](https://docs.adyen.com/api-explorer/Account/latest/post/updateAccountHolder#request-accountHolderDetails-storeDetails-storeReference) (in the [classic integration](https://docs.adyen.com/classic-platforms/processing-payments/route-payment-to-store/#route-a-payment-to-a-store)) for the ecommerce or point-of-sale store that is processing the payment.
   * @return store
   */
  @JsonProperty(JSON_PROPERTY_STORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getStore() {
    return store;
  }

  /**
   * Required for Adyen for Platforms integrations if you are a platform model. This is your [reference](https://docs.adyen.com/api-explorer/Management/3/post/merchants/(merchantId)/stores#request-reference) (on [balance platform](https://docs.adyen.com/platforms)) or the [storeReference](https://docs.adyen.com/api-explorer/Account/latest/post/updateAccountHolder#request-accountHolderDetails-storeDetails-storeReference) (in the [classic integration](https://docs.adyen.com/classic-platforms/processing-payments/route-payment-to-store/#route-a-payment-to-a-store)) for the ecommerce or point-of-sale store that is processing the payment.
   *
   * @param store
   */
  @JsonProperty(JSON_PROPERTY_STORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStore(String store) {
    this.store = store;
  }

  /**
   * The shopper&#39;s telephone number.
   *
   * @param telephoneNumber
   * @return the current {@code BalanceCheckRequest} instance, allowing for method chaining
   */
  public BalanceCheckRequest telephoneNumber(String telephoneNumber) {
    this.telephoneNumber = telephoneNumber;
    return this;
  }

  /**
   * The shopper&#39;s telephone number.
   * @return telephoneNumber
   */
  @JsonProperty(JSON_PROPERTY_TELEPHONE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getTelephoneNumber() {
    return telephoneNumber;
  }

  /**
   * The shopper&#39;s telephone number.
   *
   * @param telephoneNumber
   */
  @JsonProperty(JSON_PROPERTY_TELEPHONE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTelephoneNumber(String telephoneNumber) {
    this.telephoneNumber = telephoneNumber;
  }

  /**
   * threeDS2RequestData
   *
   * @param threeDS2RequestData
   * @return the current {@code BalanceCheckRequest} instance, allowing for method chaining
   */
  public BalanceCheckRequest threeDS2RequestData(ThreeDS2RequestData threeDS2RequestData) {
    this.threeDS2RequestData = threeDS2RequestData;
    return this;
  }

  /**
   * Get threeDS2RequestData
   * @return threeDS2RequestData
   */
  @JsonProperty(JSON_PROPERTY_THREE_D_S2_REQUEST_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ThreeDS2RequestData getThreeDS2RequestData() {
    return threeDS2RequestData;
  }

  /**
   * threeDS2RequestData
   *
   * @param threeDS2RequestData
   */
  @JsonProperty(JSON_PROPERTY_THREE_D_S2_REQUEST_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setThreeDS2RequestData(ThreeDS2RequestData threeDS2RequestData) {
    this.threeDS2RequestData = threeDS2RequestData;
  }

  /**
   * If set to true, you will only perform the [3D Secure 2 authentication](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only), and not the payment authorisation.
   *
   * @param threeDSAuthenticationOnly
   * @return the current {@code BalanceCheckRequest} instance, allowing for method chaining
   *
   * @deprecated since Adyen Checkout API v69
   * Use &#x60;authenticationData.authenticationOnly&#x60; instead.
   */
  @Deprecated // deprecated since Adyen Checkout API v69: Use `authenticationData.authenticationOnly` instead.
  public BalanceCheckRequest threeDSAuthenticationOnly(Boolean threeDSAuthenticationOnly) {
    this.threeDSAuthenticationOnly = threeDSAuthenticationOnly;
    return this;
  }

  /**
   * If set to true, you will only perform the [3D Secure 2 authentication](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only), and not the payment authorisation.
   * @return threeDSAuthenticationOnly
   * @deprecated // deprecated since Adyen Checkout API v69: Use `authenticationData.authenticationOnly` instead.
   */
  @Deprecated // deprecated since Adyen Checkout API v69: Use `authenticationData.authenticationOnly` instead.
  @JsonProperty(JSON_PROPERTY_THREE_D_S_AUTHENTICATION_ONLY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getThreeDSAuthenticationOnly() {
    return threeDSAuthenticationOnly;
  }

  /**
   * If set to true, you will only perform the [3D Secure 2 authentication](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only), and not the payment authorisation.
   *
   * @param threeDSAuthenticationOnly
   *
   * @deprecated since Adyen Checkout API v69
   * Use &#x60;authenticationData.authenticationOnly&#x60; instead.
   */
  @Deprecated // deprecated since Adyen Checkout API v69: Use `authenticationData.authenticationOnly` instead.
  @JsonProperty(JSON_PROPERTY_THREE_D_S_AUTHENTICATION_ONLY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setThreeDSAuthenticationOnly(Boolean threeDSAuthenticationOnly) {
    this.threeDSAuthenticationOnly = threeDSAuthenticationOnly;
  }

  /**
   * The reference value to aggregate sales totals in reporting. When not specified, the store field is used (if available).
   *
   * @param totalsGroup
   * @return the current {@code BalanceCheckRequest} instance, allowing for method chaining
   */
  public BalanceCheckRequest totalsGroup(String totalsGroup) {
    this.totalsGroup = totalsGroup;
    return this;
  }

  /**
   * The reference value to aggregate sales totals in reporting. When not specified, the store field is used (if available).
   * @return totalsGroup
   */
  @JsonProperty(JSON_PROPERTY_TOTALS_GROUP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getTotalsGroup() {
    return totalsGroup;
  }

  /**
   * The reference value to aggregate sales totals in reporting. When not specified, the store field is used (if available).
   *
   * @param totalsGroup
   */
  @JsonProperty(JSON_PROPERTY_TOTALS_GROUP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalsGroup(String totalsGroup) {
    this.totalsGroup = totalsGroup;
  }

  /**
   * Set to true if the payment should be routed to a trusted MID.
   *
   * @param trustedShopper
   * @return the current {@code BalanceCheckRequest} instance, allowing for method chaining
   */
  public BalanceCheckRequest trustedShopper(Boolean trustedShopper) {
    this.trustedShopper = trustedShopper;
    return this;
  }

  /**
   * Set to true if the payment should be routed to a trusted MID.
   * @return trustedShopper
   */
  @JsonProperty(JSON_PROPERTY_TRUSTED_SHOPPER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getTrustedShopper() {
    return trustedShopper;
  }

  /**
   * Set to true if the payment should be routed to a trusted MID.
   *
   * @param trustedShopper
   */
  @JsonProperty(JSON_PROPERTY_TRUSTED_SHOPPER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTrustedShopper(Boolean trustedShopper) {
    this.trustedShopper = trustedShopper;
  }

  /**
   * Return true if this BalanceCheckRequest object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BalanceCheckRequest balanceCheckRequest = (BalanceCheckRequest) o;
    return Objects.equals(this.accountInfo, balanceCheckRequest.accountInfo) &&
        Objects.equals(this.additionalAmount, balanceCheckRequest.additionalAmount) &&
        Objects.equals(this.additionalData, balanceCheckRequest.additionalData) &&
        Objects.equals(this.amount, balanceCheckRequest.amount) &&
        Objects.equals(this.applicationInfo, balanceCheckRequest.applicationInfo) &&
        Objects.equals(this.billingAddress, balanceCheckRequest.billingAddress) &&
        Objects.equals(this.browserInfo, balanceCheckRequest.browserInfo) &&
        Objects.equals(this.captureDelayHours, balanceCheckRequest.captureDelayHours) &&
        Objects.equals(this.dateOfBirth, balanceCheckRequest.dateOfBirth) &&
        Objects.equals(this.dccQuote, balanceCheckRequest.dccQuote) &&
        Objects.equals(this.deliveryAddress, balanceCheckRequest.deliveryAddress) &&
        Objects.equals(this.deliveryDate, balanceCheckRequest.deliveryDate) &&
        Objects.equals(this.deviceFingerprint, balanceCheckRequest.deviceFingerprint) &&
        Objects.equals(this.fraudOffset, balanceCheckRequest.fraudOffset) &&
        Objects.equals(this.installments, balanceCheckRequest.installments) &&
        Objects.equals(this.localizedShopperStatement, balanceCheckRequest.localizedShopperStatement) &&
        Objects.equals(this.mcc, balanceCheckRequest.mcc) &&
        Objects.equals(this.merchantAccount, balanceCheckRequest.merchantAccount) &&
        Objects.equals(this.merchantOrderReference, balanceCheckRequest.merchantOrderReference) &&
        Objects.equals(this.merchantRiskIndicator, balanceCheckRequest.merchantRiskIndicator) &&
        Objects.equals(this.metadata, balanceCheckRequest.metadata) &&
        Objects.equals(this.orderReference, balanceCheckRequest.orderReference) &&
        Objects.equals(this.paymentMethod, balanceCheckRequest.paymentMethod) &&
        Objects.equals(this.recurring, balanceCheckRequest.recurring) &&
        Objects.equals(this.recurringProcessingModel, balanceCheckRequest.recurringProcessingModel) &&
        Objects.equals(this.reference, balanceCheckRequest.reference) &&
        Objects.equals(this.selectedBrand, balanceCheckRequest.selectedBrand) &&
        Objects.equals(this.selectedRecurringDetailReference, balanceCheckRequest.selectedRecurringDetailReference) &&
        Objects.equals(this.sessionId, balanceCheckRequest.sessionId) &&
        Objects.equals(this.shopperEmail, balanceCheckRequest.shopperEmail) &&
        Objects.equals(this.shopperIP, balanceCheckRequest.shopperIP) &&
        Objects.equals(this.shopperInteraction, balanceCheckRequest.shopperInteraction) &&
        Objects.equals(this.shopperLocale, balanceCheckRequest.shopperLocale) &&
        Objects.equals(this.shopperName, balanceCheckRequest.shopperName) &&
        Objects.equals(this.shopperReference, balanceCheckRequest.shopperReference) &&
        Objects.equals(this.shopperStatement, balanceCheckRequest.shopperStatement) &&
        Objects.equals(this.socialSecurityNumber, balanceCheckRequest.socialSecurityNumber) &&
        Objects.equals(this.splits, balanceCheckRequest.splits) &&
        Objects.equals(this.store, balanceCheckRequest.store) &&
        Objects.equals(this.telephoneNumber, balanceCheckRequest.telephoneNumber) &&
        Objects.equals(this.threeDS2RequestData, balanceCheckRequest.threeDS2RequestData) &&
        Objects.equals(this.threeDSAuthenticationOnly, balanceCheckRequest.threeDSAuthenticationOnly) &&
        Objects.equals(this.totalsGroup, balanceCheckRequest.totalsGroup) &&
        Objects.equals(this.trustedShopper, balanceCheckRequest.trustedShopper);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountInfo, additionalAmount, additionalData, amount, applicationInfo, billingAddress, browserInfo, captureDelayHours, dateOfBirth, dccQuote, deliveryAddress, deliveryDate, deviceFingerprint, fraudOffset, installments, localizedShopperStatement, mcc, merchantAccount, merchantOrderReference, merchantRiskIndicator, metadata, orderReference, paymentMethod, recurring, recurringProcessingModel, reference, selectedBrand, selectedRecurringDetailReference, sessionId, shopperEmail, shopperIP, shopperInteraction, shopperLocale, shopperName, shopperReference, shopperStatement, socialSecurityNumber, splits, store, telephoneNumber, threeDS2RequestData, threeDSAuthenticationOnly, totalsGroup, trustedShopper);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BalanceCheckRequest {\n");
    sb.append("    accountInfo: ").append(toIndentedString(accountInfo)).append("\n");
    sb.append("    additionalAmount: ").append(toIndentedString(additionalAmount)).append("\n");
    sb.append("    additionalData: ").append(toIndentedString(additionalData)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    applicationInfo: ").append(toIndentedString(applicationInfo)).append("\n");
    sb.append("    billingAddress: ").append(toIndentedString(billingAddress)).append("\n");
    sb.append("    browserInfo: ").append(toIndentedString(browserInfo)).append("\n");
    sb.append("    captureDelayHours: ").append(toIndentedString(captureDelayHours)).append("\n");
    sb.append("    dateOfBirth: ").append(toIndentedString(dateOfBirth)).append("\n");
    sb.append("    dccQuote: ").append(toIndentedString(dccQuote)).append("\n");
    sb.append("    deliveryAddress: ").append(toIndentedString(deliveryAddress)).append("\n");
    sb.append("    deliveryDate: ").append(toIndentedString(deliveryDate)).append("\n");
    sb.append("    deviceFingerprint: ").append(toIndentedString(deviceFingerprint)).append("\n");
    sb.append("    fraudOffset: ").append(toIndentedString(fraudOffset)).append("\n");
    sb.append("    installments: ").append(toIndentedString(installments)).append("\n");
    sb.append("    localizedShopperStatement: ").append(toIndentedString(localizedShopperStatement)).append("\n");
    sb.append("    mcc: ").append(toIndentedString(mcc)).append("\n");
    sb.append("    merchantAccount: ").append(toIndentedString(merchantAccount)).append("\n");
    sb.append("    merchantOrderReference: ").append(toIndentedString(merchantOrderReference)).append("\n");
    sb.append("    merchantRiskIndicator: ").append(toIndentedString(merchantRiskIndicator)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    orderReference: ").append(toIndentedString(orderReference)).append("\n");
    sb.append("    paymentMethod: ").append(toIndentedString(paymentMethod)).append("\n");
    sb.append("    recurring: ").append(toIndentedString(recurring)).append("\n");
    sb.append("    recurringProcessingModel: ").append(toIndentedString(recurringProcessingModel)).append("\n");
    sb.append("    reference: ").append(toIndentedString(reference)).append("\n");
    sb.append("    selectedBrand: ").append(toIndentedString(selectedBrand)).append("\n");
    sb.append("    selectedRecurringDetailReference: ").append(toIndentedString(selectedRecurringDetailReference)).append("\n");
    sb.append("    sessionId: ").append(toIndentedString(sessionId)).append("\n");
    sb.append("    shopperEmail: ").append(toIndentedString(shopperEmail)).append("\n");
    sb.append("    shopperIP: ").append(toIndentedString(shopperIP)).append("\n");
    sb.append("    shopperInteraction: ").append(toIndentedString(shopperInteraction)).append("\n");
    sb.append("    shopperLocale: ").append(toIndentedString(shopperLocale)).append("\n");
    sb.append("    shopperName: ").append(toIndentedString(shopperName)).append("\n");
    sb.append("    shopperReference: ").append(toIndentedString(shopperReference)).append("\n");
    sb.append("    shopperStatement: ").append(toIndentedString(shopperStatement)).append("\n");
    sb.append("    socialSecurityNumber: ").append(toIndentedString(socialSecurityNumber)).append("\n");
    sb.append("    splits: ").append(toIndentedString(splits)).append("\n");
    sb.append("    store: ").append(toIndentedString(store)).append("\n");
    sb.append("    telephoneNumber: ").append(toIndentedString(telephoneNumber)).append("\n");
    sb.append("    threeDS2RequestData: ").append(toIndentedString(threeDS2RequestData)).append("\n");
    sb.append("    threeDSAuthenticationOnly: ").append(toIndentedString(threeDSAuthenticationOnly)).append("\n");
    sb.append("    totalsGroup: ").append(toIndentedString(totalsGroup)).append("\n");
    sb.append("    trustedShopper: ").append(toIndentedString(trustedShopper)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of BalanceCheckRequest given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of BalanceCheckRequest
   * @throws JsonProcessingException if the JSON string is invalid with respect to BalanceCheckRequest
   */
  public static BalanceCheckRequest fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, BalanceCheckRequest.class);
  }
/**
  * Convert an instance of BalanceCheckRequest to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
