/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 71
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.checkout;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.checkout.Amount;
import com.adyen.model.checkout.FraudResult;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * BalanceCheckResponse
 */
@JsonPropertyOrder({
  BalanceCheckResponse.JSON_PROPERTY_ADDITIONAL_DATA,
  BalanceCheckResponse.JSON_PROPERTY_BALANCE,
  BalanceCheckResponse.JSON_PROPERTY_FRAUD_RESULT,
  BalanceCheckResponse.JSON_PROPERTY_PSP_REFERENCE,
  BalanceCheckResponse.JSON_PROPERTY_REFUSAL_REASON,
  BalanceCheckResponse.JSON_PROPERTY_RESULT_CODE,
  BalanceCheckResponse.JSON_PROPERTY_TRANSACTION_LIMIT
})

public class BalanceCheckResponse {
  public static final String JSON_PROPERTY_ADDITIONAL_DATA = "additionalData";
  private Map<String, String> additionalData = new HashMap<>();

  public static final String JSON_PROPERTY_BALANCE = "balance";
  private Amount balance;

  public static final String JSON_PROPERTY_FRAUD_RESULT = "fraudResult";
  private FraudResult fraudResult;

  public static final String JSON_PROPERTY_PSP_REFERENCE = "pspReference";
  private String pspReference;

  public static final String JSON_PROPERTY_REFUSAL_REASON = "refusalReason";
  private String refusalReason;

  /**
   * The result of the cancellation request.  Possible values:  * **Success** – Indicates that the balance check was successful. * **NotEnoughBalance** – Commonly indicates that the card did not have enough balance to pay the amount in the request, or that the currency of the balance on the card did not match the currency of the requested amount. * **Failed** – Indicates that the balance check failed.
   */
  public enum ResultCodeEnum {
    SUCCESS(String.valueOf("Success")),
    
    NOTENOUGHBALANCE(String.valueOf("NotEnoughBalance")),
    
    FAILED(String.valueOf("Failed"));

    private String value;

    ResultCodeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ResultCodeEnum fromValue(String value) {
      for (ResultCodeEnum b : ResultCodeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_RESULT_CODE = "resultCode";
  private ResultCodeEnum resultCode;

  public static final String JSON_PROPERTY_TRANSACTION_LIMIT = "transactionLimit";
  private Amount transactionLimit;

  public BalanceCheckResponse() { 
  }

  /**
   * Contains additional information about the payment. Some data fields are included only if you select them first: Go to **Customer Area** &gt; **Developers** &gt; **Additional data**.
   *
   * @param additionalData
   * @return the current {@code BalanceCheckResponse} instance, allowing for method chaining
   */
  public BalanceCheckResponse additionalData(Map<String, String> additionalData) {
    this.additionalData = additionalData;
    return this;
  }

  public BalanceCheckResponse putAdditionalDataItem(String key, String additionalDataItem) {
    if (this.additionalData == null) {
      this.additionalData = new HashMap<>();
    }
    this.additionalData.put(key, additionalDataItem);
    return this;
  }

  /**
   * Contains additional information about the payment. Some data fields are included only if you select them first: Go to **Customer Area** &gt; **Developers** &gt; **Additional data**.
   * @return additionalData
   */
  @JsonProperty(JSON_PROPERTY_ADDITIONAL_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Map<String, String> getAdditionalData() {
    return additionalData;
  }

  /**
   * Contains additional information about the payment. Some data fields are included only if you select them first: Go to **Customer Area** &gt; **Developers** &gt; **Additional data**.
   *
   * @param additionalData
   */
  @JsonProperty(JSON_PROPERTY_ADDITIONAL_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAdditionalData(Map<String, String> additionalData) {
    this.additionalData = additionalData;
  }

  /**
   * balance
   *
   * @param balance
   * @return the current {@code BalanceCheckResponse} instance, allowing for method chaining
   */
  public BalanceCheckResponse balance(Amount balance) {
    this.balance = balance;
    return this;
  }

  /**
   * Get balance
   * @return balance
   */
  @JsonProperty(JSON_PROPERTY_BALANCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Amount getBalance() {
    return balance;
  }

  /**
   * balance
   *
   * @param balance
   */
  @JsonProperty(JSON_PROPERTY_BALANCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBalance(Amount balance) {
    this.balance = balance;
  }

  /**
   * fraudResult
   *
   * @param fraudResult
   * @return the current {@code BalanceCheckResponse} instance, allowing for method chaining
   */
  public BalanceCheckResponse fraudResult(FraudResult fraudResult) {
    this.fraudResult = fraudResult;
    return this;
  }

  /**
   * Get fraudResult
   * @return fraudResult
   */
  @JsonProperty(JSON_PROPERTY_FRAUD_RESULT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public FraudResult getFraudResult() {
    return fraudResult;
  }

  /**
   * fraudResult
   *
   * @param fraudResult
   */
  @JsonProperty(JSON_PROPERTY_FRAUD_RESULT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFraudResult(FraudResult fraudResult) {
    this.fraudResult = fraudResult;
  }

  /**
   * Adyen&#39;s 16-character reference associated with the transaction/request. This value is globally unique; quote it when communicating with us about this request.
   *
   * @param pspReference
   * @return the current {@code BalanceCheckResponse} instance, allowing for method chaining
   */
  public BalanceCheckResponse pspReference(String pspReference) {
    this.pspReference = pspReference;
    return this;
  }

  /**
   * Adyen&#39;s 16-character reference associated with the transaction/request. This value is globally unique; quote it when communicating with us about this request.
   * @return pspReference
   */
  @JsonProperty(JSON_PROPERTY_PSP_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getPspReference() {
    return pspReference;
  }

  /**
   * Adyen&#39;s 16-character reference associated with the transaction/request. This value is globally unique; quote it when communicating with us about this request.
   *
   * @param pspReference
   */
  @JsonProperty(JSON_PROPERTY_PSP_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPspReference(String pspReference) {
    this.pspReference = pspReference;
  }

  /**
   * If the payment&#39;s authorisation is refused or an error occurs during authorisation, this field holds Adyen&#39;s mapped reason for the refusal or a description of the error. When a transaction fails, the authorisation response includes &#x60;resultCode&#x60; and &#x60;refusalReason&#x60; values.  For more information, see [Refusal reasons](https://docs.adyen.com/development-resources/refusal-reasons).
   *
   * @param refusalReason
   * @return the current {@code BalanceCheckResponse} instance, allowing for method chaining
   */
  public BalanceCheckResponse refusalReason(String refusalReason) {
    this.refusalReason = refusalReason;
    return this;
  }

  /**
   * If the payment&#39;s authorisation is refused or an error occurs during authorisation, this field holds Adyen&#39;s mapped reason for the refusal or a description of the error. When a transaction fails, the authorisation response includes &#x60;resultCode&#x60; and &#x60;refusalReason&#x60; values.  For more information, see [Refusal reasons](https://docs.adyen.com/development-resources/refusal-reasons).
   * @return refusalReason
   */
  @JsonProperty(JSON_PROPERTY_REFUSAL_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getRefusalReason() {
    return refusalReason;
  }

  /**
   * If the payment&#39;s authorisation is refused or an error occurs during authorisation, this field holds Adyen&#39;s mapped reason for the refusal or a description of the error. When a transaction fails, the authorisation response includes &#x60;resultCode&#x60; and &#x60;refusalReason&#x60; values.  For more information, see [Refusal reasons](https://docs.adyen.com/development-resources/refusal-reasons).
   *
   * @param refusalReason
   */
  @JsonProperty(JSON_PROPERTY_REFUSAL_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRefusalReason(String refusalReason) {
    this.refusalReason = refusalReason;
  }

  /**
   * The result of the cancellation request.  Possible values:  * **Success** – Indicates that the balance check was successful. * **NotEnoughBalance** – Commonly indicates that the card did not have enough balance to pay the amount in the request, or that the currency of the balance on the card did not match the currency of the requested amount. * **Failed** – Indicates that the balance check failed.
   *
   * @param resultCode
   * @return the current {@code BalanceCheckResponse} instance, allowing for method chaining
   */
  public BalanceCheckResponse resultCode(ResultCodeEnum resultCode) {
    this.resultCode = resultCode;
    return this;
  }

  /**
   * The result of the cancellation request.  Possible values:  * **Success** – Indicates that the balance check was successful. * **NotEnoughBalance** – Commonly indicates that the card did not have enough balance to pay the amount in the request, or that the currency of the balance on the card did not match the currency of the requested amount. * **Failed** – Indicates that the balance check failed.
   * @return resultCode
   */
  @JsonProperty(JSON_PROPERTY_RESULT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ResultCodeEnum getResultCode() {
    return resultCode;
  }

  /**
   * The result of the cancellation request.  Possible values:  * **Success** – Indicates that the balance check was successful. * **NotEnoughBalance** – Commonly indicates that the card did not have enough balance to pay the amount in the request, or that the currency of the balance on the card did not match the currency of the requested amount. * **Failed** – Indicates that the balance check failed.
   *
   * @param resultCode
   */
  @JsonProperty(JSON_PROPERTY_RESULT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setResultCode(ResultCodeEnum resultCode) {
    this.resultCode = resultCode;
  }

  /**
   * transactionLimit
   *
   * @param transactionLimit
   * @return the current {@code BalanceCheckResponse} instance, allowing for method chaining
   */
  public BalanceCheckResponse transactionLimit(Amount transactionLimit) {
    this.transactionLimit = transactionLimit;
    return this;
  }

  /**
   * Get transactionLimit
   * @return transactionLimit
   */
  @JsonProperty(JSON_PROPERTY_TRANSACTION_LIMIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Amount getTransactionLimit() {
    return transactionLimit;
  }

  /**
   * transactionLimit
   *
   * @param transactionLimit
   */
  @JsonProperty(JSON_PROPERTY_TRANSACTION_LIMIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTransactionLimit(Amount transactionLimit) {
    this.transactionLimit = transactionLimit;
  }

  /**
   * Return true if this BalanceCheckResponse object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BalanceCheckResponse balanceCheckResponse = (BalanceCheckResponse) o;
    return Objects.equals(this.additionalData, balanceCheckResponse.additionalData) &&
        Objects.equals(this.balance, balanceCheckResponse.balance) &&
        Objects.equals(this.fraudResult, balanceCheckResponse.fraudResult) &&
        Objects.equals(this.pspReference, balanceCheckResponse.pspReference) &&
        Objects.equals(this.refusalReason, balanceCheckResponse.refusalReason) &&
        Objects.equals(this.resultCode, balanceCheckResponse.resultCode) &&
        Objects.equals(this.transactionLimit, balanceCheckResponse.transactionLimit);
  }

  @Override
  public int hashCode() {
    return Objects.hash(additionalData, balance, fraudResult, pspReference, refusalReason, resultCode, transactionLimit);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BalanceCheckResponse {\n");
    sb.append("    additionalData: ").append(toIndentedString(additionalData)).append("\n");
    sb.append("    balance: ").append(toIndentedString(balance)).append("\n");
    sb.append("    fraudResult: ").append(toIndentedString(fraudResult)).append("\n");
    sb.append("    pspReference: ").append(toIndentedString(pspReference)).append("\n");
    sb.append("    refusalReason: ").append(toIndentedString(refusalReason)).append("\n");
    sb.append("    resultCode: ").append(toIndentedString(resultCode)).append("\n");
    sb.append("    transactionLimit: ").append(toIndentedString(transactionLimit)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of BalanceCheckResponse given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of BalanceCheckResponse
   * @throws JsonProcessingException if the JSON string is invalid with respect to BalanceCheckResponse
   */
  public static BalanceCheckResponse fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, BalanceCheckResponse.class);
  }
/**
  * Convert an instance of BalanceCheckResponse to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
