/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 71
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.checkout;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.checkout.Amount;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * DeliveryMethod
 */
@JsonPropertyOrder({
  DeliveryMethod.JSON_PROPERTY_AMOUNT,
  DeliveryMethod.JSON_PROPERTY_DESCRIPTION,
  DeliveryMethod.JSON_PROPERTY_REFERENCE,
  DeliveryMethod.JSON_PROPERTY_SELECTED,
  DeliveryMethod.JSON_PROPERTY_TYPE
})

public class DeliveryMethod {
  public static final String JSON_PROPERTY_AMOUNT = "amount";
  private Amount amount;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_REFERENCE = "reference";
  private String reference;

  public static final String JSON_PROPERTY_SELECTED = "selected";
  private Boolean selected;

  /**
   * The type of the delivery method.
   */
  public enum TypeEnum {
    SHIPPING(String.valueOf("Shipping"));

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public DeliveryMethod() { 
  }

  /**
   * amount
   *
   * @param amount
   * @return the current {@code DeliveryMethod} instance, allowing for method chaining
   */
  public DeliveryMethod amount(Amount amount) {
    this.amount = amount;
    return this;
  }

  /**
   * Get amount
   * @return amount
   */
  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Amount getAmount() {
    return amount;
  }

  /**
   * amount
   *
   * @param amount
   */
  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmount(Amount amount) {
    this.amount = amount;
  }

  /**
   * The name of the delivery method as shown to the shopper.
   *
   * @param description
   * @return the current {@code DeliveryMethod} instance, allowing for method chaining
   */
  public DeliveryMethod description(String description) {
    this.description = description;
    return this;
  }

  /**
   * The name of the delivery method as shown to the shopper.
   * @return description
   */
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDescription() {
    return description;
  }

  /**
   * The name of the delivery method as shown to the shopper.
   *
   * @param description
   */
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }

  /**
   * The reference of the delivery method.
   *
   * @param reference
   * @return the current {@code DeliveryMethod} instance, allowing for method chaining
   */
  public DeliveryMethod reference(String reference) {
    this.reference = reference;
    return this;
  }

  /**
   * The reference of the delivery method.
   * @return reference
   */
  @JsonProperty(JSON_PROPERTY_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getReference() {
    return reference;
  }

  /**
   * The reference of the delivery method.
   *
   * @param reference
   */
  @JsonProperty(JSON_PROPERTY_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReference(String reference) {
    this.reference = reference;
  }

  /**
   * If you display the PayPal lightbox with delivery methods, set to **true** for the delivery method that is selected. Only one delivery method can be selected at a time.
   *
   * @param selected
   * @return the current {@code DeliveryMethod} instance, allowing for method chaining
   */
  public DeliveryMethod selected(Boolean selected) {
    this.selected = selected;
    return this;
  }

  /**
   * If you display the PayPal lightbox with delivery methods, set to **true** for the delivery method that is selected. Only one delivery method can be selected at a time.
   * @return selected
   */
  @JsonProperty(JSON_PROPERTY_SELECTED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getSelected() {
    return selected;
  }

  /**
   * If you display the PayPal lightbox with delivery methods, set to **true** for the delivery method that is selected. Only one delivery method can be selected at a time.
   *
   * @param selected
   */
  @JsonProperty(JSON_PROPERTY_SELECTED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSelected(Boolean selected) {
    this.selected = selected;
  }

  /**
   * The type of the delivery method.
   *
   * @param type
   * @return the current {@code DeliveryMethod} instance, allowing for method chaining
   */
  public DeliveryMethod type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * The type of the delivery method.
   * @return type
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TypeEnum getType() {
    return type;
  }

  /**
   * The type of the delivery method.
   *
   * @param type
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }

  /**
   * Return true if this DeliveryMethod object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DeliveryMethod deliveryMethod = (DeliveryMethod) o;
    return Objects.equals(this.amount, deliveryMethod.amount) &&
        Objects.equals(this.description, deliveryMethod.description) &&
        Objects.equals(this.reference, deliveryMethod.reference) &&
        Objects.equals(this.selected, deliveryMethod.selected) &&
        Objects.equals(this.type, deliveryMethod.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(amount, description, reference, selected, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DeliveryMethod {\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    reference: ").append(toIndentedString(reference)).append("\n");
    sb.append("    selected: ").append(toIndentedString(selected)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of DeliveryMethod given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of DeliveryMethod
   * @throws JsonProcessingException if the JSON string is invalid with respect to DeliveryMethod
   */
  public static DeliveryMethod fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, DeliveryMethod.class);
  }
/**
  * Convert an instance of DeliveryMethod to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
