/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 71
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.checkout;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.checkout.Amount;
import com.adyen.model.checkout.CheckoutAwaitAction;
import com.adyen.model.checkout.CheckoutBankTransferAction;
import com.adyen.model.checkout.CheckoutDelegatedAuthenticationAction;
import com.adyen.model.checkout.CheckoutNativeRedirectAction;
import com.adyen.model.checkout.CheckoutQrCodeAction;
import com.adyen.model.checkout.CheckoutRedirectAction;
import com.adyen.model.checkout.CheckoutSDKAction;
import com.adyen.model.checkout.CheckoutThreeDS2Action;
import com.adyen.model.checkout.CheckoutVoucherAction;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;

import com.fasterxml.jackson.core.type.TypeReference;

import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;


@JsonDeserialize(using = PaymentResponseAction.PaymentResponseActionDeserializer.class)
@JsonSerialize(using = PaymentResponseAction.PaymentResponseActionSerializer.class)
public class PaymentResponseAction extends AbstractOpenApiSchema {
    private static final Logger log = Logger.getLogger(PaymentResponseAction.class.getName());

    public static class PaymentResponseActionSerializer extends StdSerializer<PaymentResponseAction> {
        public PaymentResponseActionSerializer(Class<PaymentResponseAction> t) {
            super(t);
        }

        public PaymentResponseActionSerializer() {
            this(null);
        }

        @Override
        public void serialize(PaymentResponseAction value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject(value.getActualInstance());
        }
    }

    public static class PaymentResponseActionDeserializer extends StdDeserializer<PaymentResponseAction> {
        public PaymentResponseActionDeserializer() {
            this(PaymentResponseAction.class);
        }

        public PaymentResponseActionDeserializer(Class<?> vc) {
            super(vc);
        }

        @Override
        public PaymentResponseAction deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode tree = jp.readValueAsTree();
            Object deserialized = null;
            boolean typeCoercion = ctxt.isEnabled(MapperFeature.ALLOW_COERCION_OF_SCALARS);
            int match = 0;
            JsonToken token = tree.traverse(jp.getCodec()).nextToken();
            // deserialize CheckoutAwaitAction
            try {
                boolean attemptParsing = true;
                if (attemptParsing) {
                    // Checks if the unique type of the oneOf json matches any of the object TypeEnum values
                    boolean typeMatch = Arrays.stream(CheckoutAwaitAction.TypeEnum.values()).anyMatch((t) -> t.getValue().contains(tree.findValue("type").asText()));

                    if(typeMatch) {
                        deserialized = tree.traverse(jp.getCodec()).readValueAs(CheckoutAwaitAction.class);
                        // TODO: there is no validation against JSON schema constraints
                        // (min, max, enum, pattern...), this does not perform a strict JSON
                        // validation, which means the 'match' count may be higher than it should be.
                        match++;
                        log.log(Level.FINER, "Input data matches schema 'CheckoutAwaitAction'");
                    }
                }
            } catch (Exception e) {
                // deserialization failed, continue
                log.log(Level.FINER, "Input data does not match schema 'CheckoutAwaitAction'", e);
            }

            // deserialize CheckoutBankTransferAction
            try {
                boolean attemptParsing = true;
                if (attemptParsing) {
                    // Checks if the unique type of the oneOf json matches any of the object TypeEnum values
                    boolean typeMatch = Arrays.stream(CheckoutBankTransferAction.TypeEnum.values()).anyMatch((t) -> t.getValue().contains(tree.findValue("type").asText()));

                    if(typeMatch) {
                        deserialized = tree.traverse(jp.getCodec()).readValueAs(CheckoutBankTransferAction.class);
                        // TODO: there is no validation against JSON schema constraints
                        // (min, max, enum, pattern...), this does not perform a strict JSON
                        // validation, which means the 'match' count may be higher than it should be.
                        match++;
                        log.log(Level.FINER, "Input data matches schema 'CheckoutBankTransferAction'");
                    }
                }
            } catch (Exception e) {
                // deserialization failed, continue
                log.log(Level.FINER, "Input data does not match schema 'CheckoutBankTransferAction'", e);
            }

            // deserialize CheckoutDelegatedAuthenticationAction
            try {
                boolean attemptParsing = true;
                if (attemptParsing) {
                    // Checks if the unique type of the oneOf json matches any of the object TypeEnum values
                    boolean typeMatch = Arrays.stream(CheckoutDelegatedAuthenticationAction.TypeEnum.values()).anyMatch((t) -> t.getValue().contains(tree.findValue("type").asText()));

                    if(typeMatch) {
                        deserialized = tree.traverse(jp.getCodec()).readValueAs(CheckoutDelegatedAuthenticationAction.class);
                        // TODO: there is no validation against JSON schema constraints
                        // (min, max, enum, pattern...), this does not perform a strict JSON
                        // validation, which means the 'match' count may be higher than it should be.
                        match++;
                        log.log(Level.FINER, "Input data matches schema 'CheckoutDelegatedAuthenticationAction'");
                    }
                }
            } catch (Exception e) {
                // deserialization failed, continue
                log.log(Level.FINER, "Input data does not match schema 'CheckoutDelegatedAuthenticationAction'", e);
            }

            // deserialize CheckoutNativeRedirectAction
            try {
                boolean attemptParsing = true;
                if (attemptParsing) {
                    // Checks if the unique type of the oneOf json matches any of the object TypeEnum values
                    boolean typeMatch = Arrays.stream(CheckoutNativeRedirectAction.TypeEnum.values()).anyMatch((t) -> t.getValue().contains(tree.findValue("type").asText()));

                    if(typeMatch) {
                        deserialized = tree.traverse(jp.getCodec()).readValueAs(CheckoutNativeRedirectAction.class);
                        // TODO: there is no validation against JSON schema constraints
                        // (min, max, enum, pattern...), this does not perform a strict JSON
                        // validation, which means the 'match' count may be higher than it should be.
                        match++;
                        log.log(Level.FINER, "Input data matches schema 'CheckoutNativeRedirectAction'");
                    }
                }
            } catch (Exception e) {
                // deserialization failed, continue
                log.log(Level.FINER, "Input data does not match schema 'CheckoutNativeRedirectAction'", e);
            }

            // deserialize CheckoutQrCodeAction
            try {
                boolean attemptParsing = true;
                if (attemptParsing) {
                    // Checks if the unique type of the oneOf json matches any of the object TypeEnum values
                    boolean typeMatch = Arrays.stream(CheckoutQrCodeAction.TypeEnum.values()).anyMatch((t) -> t.getValue().contains(tree.findValue("type").asText()));

                    if(typeMatch) {
                        deserialized = tree.traverse(jp.getCodec()).readValueAs(CheckoutQrCodeAction.class);
                        // TODO: there is no validation against JSON schema constraints
                        // (min, max, enum, pattern...), this does not perform a strict JSON
                        // validation, which means the 'match' count may be higher than it should be.
                        match++;
                        log.log(Level.FINER, "Input data matches schema 'CheckoutQrCodeAction'");
                    }
                }
            } catch (Exception e) {
                // deserialization failed, continue
                log.log(Level.FINER, "Input data does not match schema 'CheckoutQrCodeAction'", e);
            }

            // deserialize CheckoutRedirectAction
            try {
                boolean attemptParsing = true;
                if (attemptParsing) {
                    // Checks if the unique type of the oneOf json matches any of the object TypeEnum values
                    boolean typeMatch = Arrays.stream(CheckoutRedirectAction.TypeEnum.values()).anyMatch((t) -> t.getValue().contains(tree.findValue("type").asText()));

                    if(typeMatch) {
                        deserialized = tree.traverse(jp.getCodec()).readValueAs(CheckoutRedirectAction.class);
                        // TODO: there is no validation against JSON schema constraints
                        // (min, max, enum, pattern...), this does not perform a strict JSON
                        // validation, which means the 'match' count may be higher than it should be.
                        match++;
                        log.log(Level.FINER, "Input data matches schema 'CheckoutRedirectAction'");
                    }
                }
            } catch (Exception e) {
                // deserialization failed, continue
                log.log(Level.FINER, "Input data does not match schema 'CheckoutRedirectAction'", e);
            }

            // deserialize CheckoutSDKAction
            try {
                boolean attemptParsing = true;
                if (attemptParsing) {
                    // Checks if the unique type of the oneOf json matches any of the object TypeEnum values
                    boolean typeMatch = Arrays.stream(CheckoutSDKAction.TypeEnum.values()).anyMatch((t) -> t.getValue().contains(tree.findValue("type").asText()));

                    if(typeMatch) {
                        deserialized = tree.traverse(jp.getCodec()).readValueAs(CheckoutSDKAction.class);
                        // TODO: there is no validation against JSON schema constraints
                        // (min, max, enum, pattern...), this does not perform a strict JSON
                        // validation, which means the 'match' count may be higher than it should be.
                        match++;
                        log.log(Level.FINER, "Input data matches schema 'CheckoutSDKAction'");
                    }
                }
            } catch (Exception e) {
                // deserialization failed, continue
                log.log(Level.FINER, "Input data does not match schema 'CheckoutSDKAction'", e);
            }

            // deserialize CheckoutThreeDS2Action
            try {
                boolean attemptParsing = true;
                if (attemptParsing) {
                    // Checks if the unique type of the oneOf json matches any of the object TypeEnum values
                    boolean typeMatch = Arrays.stream(CheckoutThreeDS2Action.TypeEnum.values()).anyMatch((t) -> t.getValue().contains(tree.findValue("type").asText()));

                    if(typeMatch) {
                        deserialized = tree.traverse(jp.getCodec()).readValueAs(CheckoutThreeDS2Action.class);
                        // TODO: there is no validation against JSON schema constraints
                        // (min, max, enum, pattern...), this does not perform a strict JSON
                        // validation, which means the 'match' count may be higher than it should be.
                        match++;
                        log.log(Level.FINER, "Input data matches schema 'CheckoutThreeDS2Action'");
                    }
                }
            } catch (Exception e) {
                // deserialization failed, continue
                log.log(Level.FINER, "Input data does not match schema 'CheckoutThreeDS2Action'", e);
            }

            // deserialize CheckoutVoucherAction
            try {
                boolean attemptParsing = true;
                if (attemptParsing) {
                    // Checks if the unique type of the oneOf json matches any of the object TypeEnum values
                    boolean typeMatch = Arrays.stream(CheckoutVoucherAction.TypeEnum.values()).anyMatch((t) -> t.getValue().contains(tree.findValue("type").asText()));

                    if(typeMatch) {
                        deserialized = tree.traverse(jp.getCodec()).readValueAs(CheckoutVoucherAction.class);
                        // TODO: there is no validation against JSON schema constraints
                        // (min, max, enum, pattern...), this does not perform a strict JSON
                        // validation, which means the 'match' count may be higher than it should be.
                        match++;
                        log.log(Level.FINER, "Input data matches schema 'CheckoutVoucherAction'");
                    }
                }
            } catch (Exception e) {
                // deserialization failed, continue
                log.log(Level.FINER, "Input data does not match schema 'CheckoutVoucherAction'", e);
            }

            if (match == 1) {
                PaymentResponseAction ret = new PaymentResponseAction();
                ret.setActualInstance(deserialized);
                return ret;
            }
            throw new IOException(String.format("Failed deserialization for PaymentResponseAction: %d classes match result, expected 1", match));
        }

        /**
         * Handle deserialization of the 'null' value.
         */
        @Override
        public PaymentResponseAction getNullValue(DeserializationContext ctxt) throws JsonMappingException {
            throw new JsonMappingException(ctxt.getParser(), "PaymentResponseAction cannot be null");
        }
    }

    // store a list of schema names defined in oneOf
    public static final Map<String, GenericType<?>> schemas = new HashMap<>();

    public PaymentResponseAction() {
        super("oneOf", Boolean.FALSE);
    }

    public PaymentResponseAction(CheckoutAwaitAction o) {
        super("oneOf", Boolean.FALSE);
        setActualInstance(o);
    }

    public PaymentResponseAction(CheckoutBankTransferAction o) {
        super("oneOf", Boolean.FALSE);
        setActualInstance(o);
    }

    public PaymentResponseAction(CheckoutDelegatedAuthenticationAction o) {
        super("oneOf", Boolean.FALSE);
        setActualInstance(o);
    }

    public PaymentResponseAction(CheckoutNativeRedirectAction o) {
        super("oneOf", Boolean.FALSE);
        setActualInstance(o);
    }

    public PaymentResponseAction(CheckoutQrCodeAction o) {
        super("oneOf", Boolean.FALSE);
        setActualInstance(o);
    }

    public PaymentResponseAction(CheckoutRedirectAction o) {
        super("oneOf", Boolean.FALSE);
        setActualInstance(o);
    }

    public PaymentResponseAction(CheckoutSDKAction o) {
        super("oneOf", Boolean.FALSE);
        setActualInstance(o);
    }

    public PaymentResponseAction(CheckoutThreeDS2Action o) {
        super("oneOf", Boolean.FALSE);
        setActualInstance(o);
    }

    public PaymentResponseAction(CheckoutVoucherAction o) {
        super("oneOf", Boolean.FALSE);
        setActualInstance(o);
    }

    static {
        schemas.put("CheckoutAwaitAction", new GenericType<CheckoutAwaitAction>() {
        });
        schemas.put("CheckoutBankTransferAction", new GenericType<CheckoutBankTransferAction>() {
        });
        schemas.put("CheckoutDelegatedAuthenticationAction", new GenericType<CheckoutDelegatedAuthenticationAction>() {
        });
        schemas.put("CheckoutNativeRedirectAction", new GenericType<CheckoutNativeRedirectAction>() {
        });
        schemas.put("CheckoutQrCodeAction", new GenericType<CheckoutQrCodeAction>() {
        });
        schemas.put("CheckoutRedirectAction", new GenericType<CheckoutRedirectAction>() {
        });
        schemas.put("CheckoutSDKAction", new GenericType<CheckoutSDKAction>() {
        });
        schemas.put("CheckoutThreeDS2Action", new GenericType<CheckoutThreeDS2Action>() {
        });
        schemas.put("CheckoutVoucherAction", new GenericType<CheckoutVoucherAction>() {
        });
        JSON.registerDescendants(PaymentResponseAction.class, Collections.unmodifiableMap(schemas));
    }

    @Override
    public Map<String, GenericType<?>> getSchemas() {
        return PaymentResponseAction.schemas;
    }

    /**
     * Set the instance that matches the oneOf child schema, check
     * the instance parameter is valid against the oneOf child schemas:
     * CheckoutAwaitAction, CheckoutBankTransferAction, CheckoutDelegatedAuthenticationAction, CheckoutNativeRedirectAction, CheckoutQrCodeAction, CheckoutRedirectAction, CheckoutSDKAction, CheckoutThreeDS2Action, CheckoutVoucherAction
     *
     * It could be an instance of the 'oneOf' schemas.
     * The oneOf child schemas may themselves be a composed schema (allOf, anyOf, oneOf).
     */
    @Override
    public void setActualInstance(Object instance) {
        if (JSON.isInstanceOf(CheckoutAwaitAction.class, instance, new HashSet<>())) {
            super.setActualInstance(instance);
            return;
        }

        if (JSON.isInstanceOf(CheckoutBankTransferAction.class, instance, new HashSet<>())) {
            super.setActualInstance(instance);
            return;
        }

        if (JSON.isInstanceOf(CheckoutDelegatedAuthenticationAction.class, instance, new HashSet<>())) {
            super.setActualInstance(instance);
            return;
        }

        if (JSON.isInstanceOf(CheckoutNativeRedirectAction.class, instance, new HashSet<>())) {
            super.setActualInstance(instance);
            return;
        }

        if (JSON.isInstanceOf(CheckoutQrCodeAction.class, instance, new HashSet<>())) {
            super.setActualInstance(instance);
            return;
        }

        if (JSON.isInstanceOf(CheckoutRedirectAction.class, instance, new HashSet<>())) {
            super.setActualInstance(instance);
            return;
        }

        if (JSON.isInstanceOf(CheckoutSDKAction.class, instance, new HashSet<>())) {
            super.setActualInstance(instance);
            return;
        }

        if (JSON.isInstanceOf(CheckoutThreeDS2Action.class, instance, new HashSet<>())) {
            super.setActualInstance(instance);
            return;
        }

        if (JSON.isInstanceOf(CheckoutVoucherAction.class, instance, new HashSet<>())) {
            super.setActualInstance(instance);
            return;
        }

        throw new RuntimeException("Invalid instance type. Must be CheckoutAwaitAction, CheckoutBankTransferAction, CheckoutDelegatedAuthenticationAction, CheckoutNativeRedirectAction, CheckoutQrCodeAction, CheckoutRedirectAction, CheckoutSDKAction, CheckoutThreeDS2Action, CheckoutVoucherAction");
    }

    /**
     * Get the actual instance, which can be the following:
     * CheckoutAwaitAction, CheckoutBankTransferAction, CheckoutDelegatedAuthenticationAction, CheckoutNativeRedirectAction, CheckoutQrCodeAction, CheckoutRedirectAction, CheckoutSDKAction, CheckoutThreeDS2Action, CheckoutVoucherAction
     *
     * @return The actual instance (CheckoutAwaitAction, CheckoutBankTransferAction, CheckoutDelegatedAuthenticationAction, CheckoutNativeRedirectAction, CheckoutQrCodeAction, CheckoutRedirectAction, CheckoutSDKAction, CheckoutThreeDS2Action, CheckoutVoucherAction)
     */
    @Override
    public Object getActualInstance() {
        return super.getActualInstance();
    }

    /**
     * Get the actual instance of `CheckoutAwaitAction`. If the actual instance is not `CheckoutAwaitAction`,
     * the ClassCastException will be thrown.
     *
     * @return The actual instance of `CheckoutAwaitAction`
     * @throws ClassCastException if the instance is not `CheckoutAwaitAction`
     */
    public CheckoutAwaitAction getCheckoutAwaitAction() throws ClassCastException {
        return (CheckoutAwaitAction)super.getActualInstance();
    }

    /**
     * Get the actual instance of `CheckoutBankTransferAction`. If the actual instance is not `CheckoutBankTransferAction`,
     * the ClassCastException will be thrown.
     *
     * @return The actual instance of `CheckoutBankTransferAction`
     * @throws ClassCastException if the instance is not `CheckoutBankTransferAction`
     */
    public CheckoutBankTransferAction getCheckoutBankTransferAction() throws ClassCastException {
        return (CheckoutBankTransferAction)super.getActualInstance();
    }

    /**
     * Get the actual instance of `CheckoutDelegatedAuthenticationAction`. If the actual instance is not `CheckoutDelegatedAuthenticationAction`,
     * the ClassCastException will be thrown.
     *
     * @return The actual instance of `CheckoutDelegatedAuthenticationAction`
     * @throws ClassCastException if the instance is not `CheckoutDelegatedAuthenticationAction`
     */
    public CheckoutDelegatedAuthenticationAction getCheckoutDelegatedAuthenticationAction() throws ClassCastException {
        return (CheckoutDelegatedAuthenticationAction)super.getActualInstance();
    }

    /**
     * Get the actual instance of `CheckoutNativeRedirectAction`. If the actual instance is not `CheckoutNativeRedirectAction`,
     * the ClassCastException will be thrown.
     *
     * @return The actual instance of `CheckoutNativeRedirectAction`
     * @throws ClassCastException if the instance is not `CheckoutNativeRedirectAction`
     */
    public CheckoutNativeRedirectAction getCheckoutNativeRedirectAction() throws ClassCastException {
        return (CheckoutNativeRedirectAction)super.getActualInstance();
    }

    /**
     * Get the actual instance of `CheckoutQrCodeAction`. If the actual instance is not `CheckoutQrCodeAction`,
     * the ClassCastException will be thrown.
     *
     * @return The actual instance of `CheckoutQrCodeAction`
     * @throws ClassCastException if the instance is not `CheckoutQrCodeAction`
     */
    public CheckoutQrCodeAction getCheckoutQrCodeAction() throws ClassCastException {
        return (CheckoutQrCodeAction)super.getActualInstance();
    }

    /**
     * Get the actual instance of `CheckoutRedirectAction`. If the actual instance is not `CheckoutRedirectAction`,
     * the ClassCastException will be thrown.
     *
     * @return The actual instance of `CheckoutRedirectAction`
     * @throws ClassCastException if the instance is not `CheckoutRedirectAction`
     */
    public CheckoutRedirectAction getCheckoutRedirectAction() throws ClassCastException {
        return (CheckoutRedirectAction)super.getActualInstance();
    }

    /**
     * Get the actual instance of `CheckoutSDKAction`. If the actual instance is not `CheckoutSDKAction`,
     * the ClassCastException will be thrown.
     *
     * @return The actual instance of `CheckoutSDKAction`
     * @throws ClassCastException if the instance is not `CheckoutSDKAction`
     */
    public CheckoutSDKAction getCheckoutSDKAction() throws ClassCastException {
        return (CheckoutSDKAction)super.getActualInstance();
    }

    /**
     * Get the actual instance of `CheckoutThreeDS2Action`. If the actual instance is not `CheckoutThreeDS2Action`,
     * the ClassCastException will be thrown.
     *
     * @return The actual instance of `CheckoutThreeDS2Action`
     * @throws ClassCastException if the instance is not `CheckoutThreeDS2Action`
     */
    public CheckoutThreeDS2Action getCheckoutThreeDS2Action() throws ClassCastException {
        return (CheckoutThreeDS2Action)super.getActualInstance();
    }

    /**
     * Get the actual instance of `CheckoutVoucherAction`. If the actual instance is not `CheckoutVoucherAction`,
     * the ClassCastException will be thrown.
     *
     * @return The actual instance of `CheckoutVoucherAction`
     * @throws ClassCastException if the instance is not `CheckoutVoucherAction`
     */
    public CheckoutVoucherAction getCheckoutVoucherAction() throws ClassCastException {
        return (CheckoutVoucherAction)super.getActualInstance();
    }


    /**
    * Create an instance of PaymentResponseAction given an JSON string
    *
    * @param jsonString JSON string
    * @return An instance of PaymentResponseAction
    * @throws IOException if the JSON string is invalid with respect to PaymentResponseAction
    */
    public static PaymentResponseAction fromJson(String jsonString) throws IOException {
        return JSON.getMapper().readValue(jsonString, PaymentResponseAction.class);
    }

    /**
    * Convert an instance of PaymentResponseAction to an JSON string
    *
    * @return JSON string
    */
    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString(this);
    }

}
