/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 71
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.checkout;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.checkout.Amount;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * PixRecurring
 */
@JsonPropertyOrder({
  PixRecurring.JSON_PROPERTY_BILLING_DATE,
  PixRecurring.JSON_PROPERTY_ENDS_AT,
  PixRecurring.JSON_PROPERTY_FREQUENCY,
  PixRecurring.JSON_PROPERTY_MIN_AMOUNT,
  PixRecurring.JSON_PROPERTY_ORIGINAL_PSP_REFERENCE,
  PixRecurring.JSON_PROPERTY_RECURRING_AMOUNT,
  PixRecurring.JSON_PROPERTY_RECURRING_STATEMENT,
  PixRecurring.JSON_PROPERTY_RETRY_POLICY,
  PixRecurring.JSON_PROPERTY_STARTS_AT
})

public class PixRecurring {
  public static final String JSON_PROPERTY_BILLING_DATE = "billingDate";
  private String billingDate;

  public static final String JSON_PROPERTY_ENDS_AT = "endsAt";
  private String endsAt;

  /**
   * The frequency at which the shopper will be charged.
   */
  public enum FrequencyEnum {
    WEEKLY(String.valueOf("weekly")),
    
    MONTHLY(String.valueOf("monthly")),
    
    QUARTERLY(String.valueOf("quarterly")),
    
    HALF_YEARLY(String.valueOf("half-yearly")),
    
    YEARLY(String.valueOf("yearly"));

    private String value;

    FrequencyEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static FrequencyEnum fromValue(String value) {
      for (FrequencyEnum b : FrequencyEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_FREQUENCY = "frequency";
  private FrequencyEnum frequency;

  public static final String JSON_PROPERTY_MIN_AMOUNT = "minAmount";
  private Amount minAmount;

  public static final String JSON_PROPERTY_ORIGINAL_PSP_REFERENCE = "originalPspReference";
  private String originalPspReference;

  public static final String JSON_PROPERTY_RECURRING_AMOUNT = "recurringAmount";
  private Amount recurringAmount;

  public static final String JSON_PROPERTY_RECURRING_STATEMENT = "recurringStatement";
  private String recurringStatement;

  public static final String JSON_PROPERTY_RETRY_POLICY = "retryPolicy";
  private Boolean retryPolicy;

  public static final String JSON_PROPERTY_STARTS_AT = "startsAt";
  private String startsAt;

  public PixRecurring() { 
  }

  /**
   * The date on which the shopper&#39;s payment method will be charged, in YYYY-MM-DD format.
   *
   * @param billingDate
   * @return the current {@code PixRecurring} instance, allowing for method chaining
   */
  public PixRecurring billingDate(String billingDate) {
    this.billingDate = billingDate;
    return this;
  }

  /**
   * The date on which the shopper&#39;s payment method will be charged, in YYYY-MM-DD format.
   * @return billingDate
   */
  @JsonProperty(JSON_PROPERTY_BILLING_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getBillingDate() {
    return billingDate;
  }

  /**
   * The date on which the shopper&#39;s payment method will be charged, in YYYY-MM-DD format.
   *
   * @param billingDate
   */
  @JsonProperty(JSON_PROPERTY_BILLING_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBillingDate(String billingDate) {
    this.billingDate = billingDate;
  }

  /**
   * End date of the billing plan, in YYYY-MM-DD format. The end date must align with the frequency and the start date of the billing plan. If left blank, the subscription will continue indefinitely unless it is cancelled by the shopper.
   *
   * @param endsAt
   * @return the current {@code PixRecurring} instance, allowing for method chaining
   */
  public PixRecurring endsAt(String endsAt) {
    this.endsAt = endsAt;
    return this;
  }

  /**
   * End date of the billing plan, in YYYY-MM-DD format. The end date must align with the frequency and the start date of the billing plan. If left blank, the subscription will continue indefinitely unless it is cancelled by the shopper.
   * @return endsAt
   */
  @JsonProperty(JSON_PROPERTY_ENDS_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getEndsAt() {
    return endsAt;
  }

  /**
   * End date of the billing plan, in YYYY-MM-DD format. The end date must align with the frequency and the start date of the billing plan. If left blank, the subscription will continue indefinitely unless it is cancelled by the shopper.
   *
   * @param endsAt
   */
  @JsonProperty(JSON_PROPERTY_ENDS_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEndsAt(String endsAt) {
    this.endsAt = endsAt;
  }

  /**
   * The frequency at which the shopper will be charged.
   *
   * @param frequency
   * @return the current {@code PixRecurring} instance, allowing for method chaining
   */
  public PixRecurring frequency(FrequencyEnum frequency) {
    this.frequency = frequency;
    return this;
  }

  /**
   * The frequency at which the shopper will be charged.
   * @return frequency
   */
  @JsonProperty(JSON_PROPERTY_FREQUENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public FrequencyEnum getFrequency() {
    return frequency;
  }

  /**
   * The frequency at which the shopper will be charged.
   *
   * @param frequency
   */
  @JsonProperty(JSON_PROPERTY_FREQUENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFrequency(FrequencyEnum frequency) {
    this.frequency = frequency;
  }

  /**
   * minAmount
   *
   * @param minAmount
   * @return the current {@code PixRecurring} instance, allowing for method chaining
   */
  public PixRecurring minAmount(Amount minAmount) {
    this.minAmount = minAmount;
    return this;
  }

  /**
   * Get minAmount
   * @return minAmount
   */
  @JsonProperty(JSON_PROPERTY_MIN_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Amount getMinAmount() {
    return minAmount;
  }

  /**
   * minAmount
   *
   * @param minAmount
   */
  @JsonProperty(JSON_PROPERTY_MIN_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinAmount(Amount minAmount) {
    this.minAmount = minAmount;
  }

  /**
   * The pspReference for the failed recurring payment. Find this in AUTHORISATION webhook you received after the billing date.
   *
   * @param originalPspReference
   * @return the current {@code PixRecurring} instance, allowing for method chaining
   */
  public PixRecurring originalPspReference(String originalPspReference) {
    this.originalPspReference = originalPspReference;
    return this;
  }

  /**
   * The pspReference for the failed recurring payment. Find this in AUTHORISATION webhook you received after the billing date.
   * @return originalPspReference
   */
  @JsonProperty(JSON_PROPERTY_ORIGINAL_PSP_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getOriginalPspReference() {
    return originalPspReference;
  }

  /**
   * The pspReference for the failed recurring payment. Find this in AUTHORISATION webhook you received after the billing date.
   *
   * @param originalPspReference
   */
  @JsonProperty(JSON_PROPERTY_ORIGINAL_PSP_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOriginalPspReference(String originalPspReference) {
    this.originalPspReference = originalPspReference;
  }

  /**
   * recurringAmount
   *
   * @param recurringAmount
   * @return the current {@code PixRecurring} instance, allowing for method chaining
   */
  public PixRecurring recurringAmount(Amount recurringAmount) {
    this.recurringAmount = recurringAmount;
    return this;
  }

  /**
   * Get recurringAmount
   * @return recurringAmount
   */
  @JsonProperty(JSON_PROPERTY_RECURRING_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Amount getRecurringAmount() {
    return recurringAmount;
  }

  /**
   * recurringAmount
   *
   * @param recurringAmount
   */
  @JsonProperty(JSON_PROPERTY_RECURRING_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecurringAmount(Amount recurringAmount) {
    this.recurringAmount = recurringAmount;
  }

  /**
   * The text that that will be shown on the shopper&#39;s bank statement for the recurring payments. We recommend to add a descriptive text about the subscription to let your shoppers recognize your recurring payments. Maximum length: 35 characters.
   *
   * @param recurringStatement
   * @return the current {@code PixRecurring} instance, allowing for method chaining
   */
  public PixRecurring recurringStatement(String recurringStatement) {
    this.recurringStatement = recurringStatement;
    return this;
  }

  /**
   * The text that that will be shown on the shopper&#39;s bank statement for the recurring payments. We recommend to add a descriptive text about the subscription to let your shoppers recognize your recurring payments. Maximum length: 35 characters.
   * @return recurringStatement
   */
  @JsonProperty(JSON_PROPERTY_RECURRING_STATEMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getRecurringStatement() {
    return recurringStatement;
  }

  /**
   * The text that that will be shown on the shopper&#39;s bank statement for the recurring payments. We recommend to add a descriptive text about the subscription to let your shoppers recognize your recurring payments. Maximum length: 35 characters.
   *
   * @param recurringStatement
   */
  @JsonProperty(JSON_PROPERTY_RECURRING_STATEMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecurringStatement(String recurringStatement) {
    this.recurringStatement = recurringStatement;
  }

  /**
   * When set to true, you can retry for failed recurring payments. The default value is true.
   *
   * @param retryPolicy
   * @return the current {@code PixRecurring} instance, allowing for method chaining
   */
  public PixRecurring retryPolicy(Boolean retryPolicy) {
    this.retryPolicy = retryPolicy;
    return this;
  }

  /**
   * When set to true, you can retry for failed recurring payments. The default value is true.
   * @return retryPolicy
   */
  @JsonProperty(JSON_PROPERTY_RETRY_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getRetryPolicy() {
    return retryPolicy;
  }

  /**
   * When set to true, you can retry for failed recurring payments. The default value is true.
   *
   * @param retryPolicy
   */
  @JsonProperty(JSON_PROPERTY_RETRY_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRetryPolicy(Boolean retryPolicy) {
    this.retryPolicy = retryPolicy;
  }

  /**
   * Start date of the billing plan, in YYYY-MM-DD format. The default value is the transaction date.
   *
   * @param startsAt
   * @return the current {@code PixRecurring} instance, allowing for method chaining
   */
  public PixRecurring startsAt(String startsAt) {
    this.startsAt = startsAt;
    return this;
  }

  /**
   * Start date of the billing plan, in YYYY-MM-DD format. The default value is the transaction date.
   * @return startsAt
   */
  @JsonProperty(JSON_PROPERTY_STARTS_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getStartsAt() {
    return startsAt;
  }

  /**
   * Start date of the billing plan, in YYYY-MM-DD format. The default value is the transaction date.
   *
   * @param startsAt
   */
  @JsonProperty(JSON_PROPERTY_STARTS_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStartsAt(String startsAt) {
    this.startsAt = startsAt;
  }

  /**
   * Return true if this PixRecurring object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PixRecurring pixRecurring = (PixRecurring) o;
    return Objects.equals(this.billingDate, pixRecurring.billingDate) &&
        Objects.equals(this.endsAt, pixRecurring.endsAt) &&
        Objects.equals(this.frequency, pixRecurring.frequency) &&
        Objects.equals(this.minAmount, pixRecurring.minAmount) &&
        Objects.equals(this.originalPspReference, pixRecurring.originalPspReference) &&
        Objects.equals(this.recurringAmount, pixRecurring.recurringAmount) &&
        Objects.equals(this.recurringStatement, pixRecurring.recurringStatement) &&
        Objects.equals(this.retryPolicy, pixRecurring.retryPolicy) &&
        Objects.equals(this.startsAt, pixRecurring.startsAt);
  }

  @Override
  public int hashCode() {
    return Objects.hash(billingDate, endsAt, frequency, minAmount, originalPspReference, recurringAmount, recurringStatement, retryPolicy, startsAt);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PixRecurring {\n");
    sb.append("    billingDate: ").append(toIndentedString(billingDate)).append("\n");
    sb.append("    endsAt: ").append(toIndentedString(endsAt)).append("\n");
    sb.append("    frequency: ").append(toIndentedString(frequency)).append("\n");
    sb.append("    minAmount: ").append(toIndentedString(minAmount)).append("\n");
    sb.append("    originalPspReference: ").append(toIndentedString(originalPspReference)).append("\n");
    sb.append("    recurringAmount: ").append(toIndentedString(recurringAmount)).append("\n");
    sb.append("    recurringStatement: ").append(toIndentedString(recurringStatement)).append("\n");
    sb.append("    retryPolicy: ").append(toIndentedString(retryPolicy)).append("\n");
    sb.append("    startsAt: ").append(toIndentedString(startsAt)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of PixRecurring given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of PixRecurring
   * @throws JsonProcessingException if the JSON string is invalid with respect to PixRecurring
   */
  public static PixRecurring fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, PixRecurring.class);
  }
/**
  * Convert an instance of PixRecurring to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
