/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 71
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.checkout;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * PseDetails
 */
@JsonPropertyOrder({
  PseDetails.JSON_PROPERTY_BANK,
  PseDetails.JSON_PROPERTY_CHECKOUT_ATTEMPT_ID,
  PseDetails.JSON_PROPERTY_CLIENT_TYPE,
  PseDetails.JSON_PROPERTY_IDENTIFICATION,
  PseDetails.JSON_PROPERTY_IDENTIFICATION_TYPE,
  PseDetails.JSON_PROPERTY_TYPE
})

public class PseDetails {
  public static final String JSON_PROPERTY_BANK = "bank";
  private String bank;

  public static final String JSON_PROPERTY_CHECKOUT_ATTEMPT_ID = "checkoutAttemptId";
  private String checkoutAttemptId;

  public static final String JSON_PROPERTY_CLIENT_TYPE = "clientType";
  private String clientType;

  public static final String JSON_PROPERTY_IDENTIFICATION = "identification";
  private String identification;

  public static final String JSON_PROPERTY_IDENTIFICATION_TYPE = "identificationType";
  private String identificationType;

  /**
   * The payment method type.
   */
  public enum TypeEnum {
    PSE_PAYULATAM(String.valueOf("pse_payulatam"));

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public PseDetails() { 
  }

  /**
   * The shopper&#39;s bank.
   *
   * @param bank
   * @return the current {@code PseDetails} instance, allowing for method chaining
   */
  public PseDetails bank(String bank) {
    this.bank = bank;
    return this;
  }

  /**
   * The shopper&#39;s bank.
   * @return bank
   */
  @JsonProperty(JSON_PROPERTY_BANK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getBank() {
    return bank;
  }

  /**
   * The shopper&#39;s bank.
   *
   * @param bank
   */
  @JsonProperty(JSON_PROPERTY_BANK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBank(String bank) {
    this.bank = bank;
  }

  /**
   * The checkout attempt identifier.
   *
   * @param checkoutAttemptId
   * @return the current {@code PseDetails} instance, allowing for method chaining
   */
  public PseDetails checkoutAttemptId(String checkoutAttemptId) {
    this.checkoutAttemptId = checkoutAttemptId;
    return this;
  }

  /**
   * The checkout attempt identifier.
   * @return checkoutAttemptId
   */
  @JsonProperty(JSON_PROPERTY_CHECKOUT_ATTEMPT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCheckoutAttemptId() {
    return checkoutAttemptId;
  }

  /**
   * The checkout attempt identifier.
   *
   * @param checkoutAttemptId
   */
  @JsonProperty(JSON_PROPERTY_CHECKOUT_ATTEMPT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCheckoutAttemptId(String checkoutAttemptId) {
    this.checkoutAttemptId = checkoutAttemptId;
  }

  /**
   * The client type.
   *
   * @param clientType
   * @return the current {@code PseDetails} instance, allowing for method chaining
   */
  public PseDetails clientType(String clientType) {
    this.clientType = clientType;
    return this;
  }

  /**
   * The client type.
   * @return clientType
   */
  @JsonProperty(JSON_PROPERTY_CLIENT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getClientType() {
    return clientType;
  }

  /**
   * The client type.
   *
   * @param clientType
   */
  @JsonProperty(JSON_PROPERTY_CLIENT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setClientType(String clientType) {
    this.clientType = clientType;
  }

  /**
   * The identification code.
   *
   * @param identification
   * @return the current {@code PseDetails} instance, allowing for method chaining
   */
  public PseDetails identification(String identification) {
    this.identification = identification;
    return this;
  }

  /**
   * The identification code.
   * @return identification
   */
  @JsonProperty(JSON_PROPERTY_IDENTIFICATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getIdentification() {
    return identification;
  }

  /**
   * The identification code.
   *
   * @param identification
   */
  @JsonProperty(JSON_PROPERTY_IDENTIFICATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdentification(String identification) {
    this.identification = identification;
  }

  /**
   * The identification type.
   *
   * @param identificationType
   * @return the current {@code PseDetails} instance, allowing for method chaining
   */
  public PseDetails identificationType(String identificationType) {
    this.identificationType = identificationType;
    return this;
  }

  /**
   * The identification type.
   * @return identificationType
   */
  @JsonProperty(JSON_PROPERTY_IDENTIFICATION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getIdentificationType() {
    return identificationType;
  }

  /**
   * The identification type.
   *
   * @param identificationType
   */
  @JsonProperty(JSON_PROPERTY_IDENTIFICATION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdentificationType(String identificationType) {
    this.identificationType = identificationType;
  }

  /**
   * The payment method type.
   *
   * @param type
   * @return the current {@code PseDetails} instance, allowing for method chaining
   */
  public PseDetails type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * The payment method type.
   * @return type
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TypeEnum getType() {
    return type;
  }

  /**
   * The payment method type.
   *
   * @param type
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }

  /**
   * Return true if this PseDetails object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PseDetails pseDetails = (PseDetails) o;
    return Objects.equals(this.bank, pseDetails.bank) &&
        Objects.equals(this.checkoutAttemptId, pseDetails.checkoutAttemptId) &&
        Objects.equals(this.clientType, pseDetails.clientType) &&
        Objects.equals(this.identification, pseDetails.identification) &&
        Objects.equals(this.identificationType, pseDetails.identificationType) &&
        Objects.equals(this.type, pseDetails.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(bank, checkoutAttemptId, clientType, identification, identificationType, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PseDetails {\n");
    sb.append("    bank: ").append(toIndentedString(bank)).append("\n");
    sb.append("    checkoutAttemptId: ").append(toIndentedString(checkoutAttemptId)).append("\n");
    sb.append("    clientType: ").append(toIndentedString(clientType)).append("\n");
    sb.append("    identification: ").append(toIndentedString(identification)).append("\n");
    sb.append("    identificationType: ").append(toIndentedString(identificationType)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of PseDetails given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of PseDetails
   * @throws JsonProcessingException if the JSON string is invalid with respect to PseDetails
   */
  public static PseDetails fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, PseDetails.class);
  }
/**
  * Convert an instance of PseDetails to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
