/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 71
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.checkout;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * ResponseAdditionalDataCommon
 */
@JsonPropertyOrder({
  ResponseAdditionalDataCommon.JSON_PROPERTY_ACQUIRER_ACCOUNT_CODE,
  ResponseAdditionalDataCommon.JSON_PROPERTY_ACQUIRER_CODE,
  ResponseAdditionalDataCommon.JSON_PROPERTY_ACQUIRER_REFERENCE,
  ResponseAdditionalDataCommon.JSON_PROPERTY_ALIAS,
  ResponseAdditionalDataCommon.JSON_PROPERTY_ALIAS_TYPE,
  ResponseAdditionalDataCommon.JSON_PROPERTY_AUTH_CODE,
  ResponseAdditionalDataCommon.JSON_PROPERTY_AUTHORISATION_MID,
  ResponseAdditionalDataCommon.JSON_PROPERTY_AUTHORISED_AMOUNT_CURRENCY,
  ResponseAdditionalDataCommon.JSON_PROPERTY_AUTHORISED_AMOUNT_VALUE,
  ResponseAdditionalDataCommon.JSON_PROPERTY_AVS_RESULT,
  ResponseAdditionalDataCommon.JSON_PROPERTY_AVS_RESULT_RAW,
  ResponseAdditionalDataCommon.JSON_PROPERTY_BIC,
  ResponseAdditionalDataCommon.JSON_PROPERTY_CO_BRANDED_WITH,
  ResponseAdditionalDataCommon.JSON_PROPERTY_CVC_RESULT,
  ResponseAdditionalDataCommon.JSON_PROPERTY_CVC_RESULT_RAW,
  ResponseAdditionalDataCommon.JSON_PROPERTY_DS_TRANS_I_D,
  ResponseAdditionalDataCommon.JSON_PROPERTY_ECI,
  ResponseAdditionalDataCommon.JSON_PROPERTY_EXPIRY_DATE,
  ResponseAdditionalDataCommon.JSON_PROPERTY_EXTRA_COSTS_CURRENCY,
  ResponseAdditionalDataCommon.JSON_PROPERTY_EXTRA_COSTS_VALUE,
  ResponseAdditionalDataCommon.JSON_PROPERTY_FRAUD_CHECK_ITEM_NR_FRAUD_CHECKNAME,
  ResponseAdditionalDataCommon.JSON_PROPERTY_FRAUD_MANUAL_REVIEW,
  ResponseAdditionalDataCommon.JSON_PROPERTY_FRAUD_RESULT_TYPE,
  ResponseAdditionalDataCommon.JSON_PROPERTY_FUNDING_SOURCE,
  ResponseAdditionalDataCommon.JSON_PROPERTY_FUNDS_AVAILABILITY,
  ResponseAdditionalDataCommon.JSON_PROPERTY_INFERRED_REFUSAL_REASON,
  ResponseAdditionalDataCommon.JSON_PROPERTY_IS_CARD_COMMERCIAL,
  ResponseAdditionalDataCommon.JSON_PROPERTY_ISSUER_COUNTRY,
  ResponseAdditionalDataCommon.JSON_PROPERTY_LIABILITY_SHIFT,
  ResponseAdditionalDataCommon.JSON_PROPERTY_MC_BANK_NET_REFERENCE_NUMBER,
  ResponseAdditionalDataCommon.JSON_PROPERTY_MERCHANT_ADVICE_CODE,
  ResponseAdditionalDataCommon.JSON_PROPERTY_MERCHANT_REFERENCE,
  ResponseAdditionalDataCommon.JSON_PROPERTY_NETWORK_TX_REFERENCE,
  ResponseAdditionalDataCommon.JSON_PROPERTY_OWNER_NAME,
  ResponseAdditionalDataCommon.JSON_PROPERTY_PAYMENT_ACCOUNT_REFERENCE,
  ResponseAdditionalDataCommon.JSON_PROPERTY_PAYMENT_METHOD,
  ResponseAdditionalDataCommon.JSON_PROPERTY_PAYMENT_METHOD_VARIANT,
  ResponseAdditionalDataCommon.JSON_PROPERTY_PAYOUT_ELIGIBLE,
  ResponseAdditionalDataCommon.JSON_PROPERTY_REALTIME_ACCOUNT_UPDATER_STATUS,
  ResponseAdditionalDataCommon.JSON_PROPERTY_RECEIPT_FREE_TEXT,
  ResponseAdditionalDataCommon.JSON_PROPERTY_RECURRING_CONTRACT_TYPES,
  ResponseAdditionalDataCommon.JSON_PROPERTY_RECURRING_FIRST_PSP_REFERENCE,
  ResponseAdditionalDataCommon.JSON_PROPERTY_RECURRING_RECURRING_DETAIL_REFERENCE,
  ResponseAdditionalDataCommon.JSON_PROPERTY_RECURRING_SHOPPER_REFERENCE,
  ResponseAdditionalDataCommon.JSON_PROPERTY_RECURRING_PROCESSING_MODEL,
  ResponseAdditionalDataCommon.JSON_PROPERTY_REFERRED,
  ResponseAdditionalDataCommon.JSON_PROPERTY_REFUSAL_REASON_RAW,
  ResponseAdditionalDataCommon.JSON_PROPERTY_REQUEST_AMOUNT,
  ResponseAdditionalDataCommon.JSON_PROPERTY_REQUEST_CURRENCY_CODE,
  ResponseAdditionalDataCommon.JSON_PROPERTY_SHOPPER_INTERACTION,
  ResponseAdditionalDataCommon.JSON_PROPERTY_SHOPPER_REFERENCE,
  ResponseAdditionalDataCommon.JSON_PROPERTY_TERMINAL_ID,
  ResponseAdditionalDataCommon.JSON_PROPERTY_THREE_D_AUTHENTICATED,
  ResponseAdditionalDataCommon.JSON_PROPERTY_THREE_D_AUTHENTICATED_RESPONSE,
  ResponseAdditionalDataCommon.JSON_PROPERTY_THREE_D_OFFERED,
  ResponseAdditionalDataCommon.JSON_PROPERTY_THREE_D_OFFERED_RESPONSE,
  ResponseAdditionalDataCommon.JSON_PROPERTY_THREE_D_S_VERSION,
  ResponseAdditionalDataCommon.JSON_PROPERTY_TOKENIZATION_SHOPPER_REFERENCE,
  ResponseAdditionalDataCommon.JSON_PROPERTY_TOKENIZATION_STORE_OPERATION_TYPE,
  ResponseAdditionalDataCommon.JSON_PROPERTY_TOKENIZATION_STORED_PAYMENT_METHOD_ID,
  ResponseAdditionalDataCommon.JSON_PROPERTY_VISA_TRANSACTION_ID,
  ResponseAdditionalDataCommon.JSON_PROPERTY_XID
})

public class ResponseAdditionalDataCommon {
  public static final String JSON_PROPERTY_ACQUIRER_ACCOUNT_CODE = "acquirerAccountCode";
  private String acquirerAccountCode;

  public static final String JSON_PROPERTY_ACQUIRER_CODE = "acquirerCode";
  private String acquirerCode;

  public static final String JSON_PROPERTY_ACQUIRER_REFERENCE = "acquirerReference";
  private String acquirerReference;

  public static final String JSON_PROPERTY_ALIAS = "alias";
  private String alias;

  public static final String JSON_PROPERTY_ALIAS_TYPE = "aliasType";
  private String aliasType;

  public static final String JSON_PROPERTY_AUTH_CODE = "authCode";
  private String authCode;

  public static final String JSON_PROPERTY_AUTHORISATION_MID = "authorisationMid";
  private String authorisationMid;

  public static final String JSON_PROPERTY_AUTHORISED_AMOUNT_CURRENCY = "authorisedAmountCurrency";
  private String authorisedAmountCurrency;

  public static final String JSON_PROPERTY_AUTHORISED_AMOUNT_VALUE = "authorisedAmountValue";
  private String authorisedAmountValue;

  public static final String JSON_PROPERTY_AVS_RESULT = "avsResult";
  private String avsResult;

  public static final String JSON_PROPERTY_AVS_RESULT_RAW = "avsResultRaw";
  private String avsResultRaw;

  public static final String JSON_PROPERTY_BIC = "bic";
  private String bic;

  public static final String JSON_PROPERTY_CO_BRANDED_WITH = "coBrandedWith";
  private String coBrandedWith;

  public static final String JSON_PROPERTY_CVC_RESULT = "cvcResult";
  private String cvcResult;

  public static final String JSON_PROPERTY_CVC_RESULT_RAW = "cvcResultRaw";
  private String cvcResultRaw;

  public static final String JSON_PROPERTY_DS_TRANS_I_D = "dsTransID";
  private String dsTransID;

  public static final String JSON_PROPERTY_ECI = "eci";
  private String eci;

  public static final String JSON_PROPERTY_EXPIRY_DATE = "expiryDate";
  private String expiryDate;

  public static final String JSON_PROPERTY_EXTRA_COSTS_CURRENCY = "extraCostsCurrency";
  private String extraCostsCurrency;

  public static final String JSON_PROPERTY_EXTRA_COSTS_VALUE = "extraCostsValue";
  private String extraCostsValue;

  public static final String JSON_PROPERTY_FRAUD_CHECK_ITEM_NR_FRAUD_CHECKNAME = "fraudCheck-[itemNr]-[FraudCheckname]";
  private String fraudCheckItemNrFraudCheckname;

  public static final String JSON_PROPERTY_FRAUD_MANUAL_REVIEW = "fraudManualReview";
  private String fraudManualReview;

  /**
   * The fraud result properties of the payment.
   */
  public enum FraudResultTypeEnum {
    GREEN(String.valueOf("GREEN")),
    
    FRAUD(String.valueOf("FRAUD"));

    private String value;

    FraudResultTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static FraudResultTypeEnum fromValue(String value) {
      for (FraudResultTypeEnum b : FraudResultTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_FRAUD_RESULT_TYPE = "fraudResultType";
  private FraudResultTypeEnum fraudResultType;

  public static final String JSON_PROPERTY_FUNDING_SOURCE = "fundingSource";
  private String fundingSource;

  public static final String JSON_PROPERTY_FUNDS_AVAILABILITY = "fundsAvailability";
  private String fundsAvailability;

  public static final String JSON_PROPERTY_INFERRED_REFUSAL_REASON = "inferredRefusalReason";
  private String inferredRefusalReason;

  public static final String JSON_PROPERTY_IS_CARD_COMMERCIAL = "isCardCommercial";
  private String isCardCommercial;

  public static final String JSON_PROPERTY_ISSUER_COUNTRY = "issuerCountry";
  private String issuerCountry;

  public static final String JSON_PROPERTY_LIABILITY_SHIFT = "liabilityShift";
  private String liabilityShift;

  public static final String JSON_PROPERTY_MC_BANK_NET_REFERENCE_NUMBER = "mcBankNetReferenceNumber";
  private String mcBankNetReferenceNumber;

  public static final String JSON_PROPERTY_MERCHANT_ADVICE_CODE = "merchantAdviceCode";
  private String merchantAdviceCode;

  public static final String JSON_PROPERTY_MERCHANT_REFERENCE = "merchantReference";
  private String merchantReference;

  public static final String JSON_PROPERTY_NETWORK_TX_REFERENCE = "networkTxReference";
  private String networkTxReference;

  public static final String JSON_PROPERTY_OWNER_NAME = "ownerName";
  private String ownerName;

  public static final String JSON_PROPERTY_PAYMENT_ACCOUNT_REFERENCE = "paymentAccountReference";
  private String paymentAccountReference;

  public static final String JSON_PROPERTY_PAYMENT_METHOD = "paymentMethod";
  private String paymentMethod;

  public static final String JSON_PROPERTY_PAYMENT_METHOD_VARIANT = "paymentMethodVariant";
  private String paymentMethodVariant;

  public static final String JSON_PROPERTY_PAYOUT_ELIGIBLE = "payoutEligible";
  private String payoutEligible;

  public static final String JSON_PROPERTY_REALTIME_ACCOUNT_UPDATER_STATUS = "realtimeAccountUpdaterStatus";
  private String realtimeAccountUpdaterStatus;

  public static final String JSON_PROPERTY_RECEIPT_FREE_TEXT = "receiptFreeText";
  private String receiptFreeText;

  public static final String JSON_PROPERTY_RECURRING_CONTRACT_TYPES = "recurring.contractTypes";
  private String recurringContractTypes;

  public static final String JSON_PROPERTY_RECURRING_FIRST_PSP_REFERENCE = "recurring.firstPspReference";
  private String recurringFirstPspReference;

  public static final String JSON_PROPERTY_RECURRING_RECURRING_DETAIL_REFERENCE = "recurring.recurringDetailReference";
  @Deprecated // deprecated since Adyen Checkout API v68: Use tokenization.storedPaymentMethodId instead.
  private String recurringRecurringDetailReference;

  public static final String JSON_PROPERTY_RECURRING_SHOPPER_REFERENCE = "recurring.shopperReference";
  @Deprecated // deprecated since Adyen Checkout API v68: Use tokenization.shopperReference instead.
  private String recurringShopperReference;

  /**
   * The processing model used for the recurring transaction.
   */
  public enum RecurringProcessingModelEnum {
    CARDONFILE(String.valueOf("CardOnFile")),
    
    SUBSCRIPTION(String.valueOf("Subscription")),
    
    UNSCHEDULEDCARDONFILE(String.valueOf("UnscheduledCardOnFile"));

    private String value;

    RecurringProcessingModelEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RecurringProcessingModelEnum fromValue(String value) {
      for (RecurringProcessingModelEnum b : RecurringProcessingModelEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_RECURRING_PROCESSING_MODEL = "recurringProcessingModel";
  private RecurringProcessingModelEnum recurringProcessingModel;

  public static final String JSON_PROPERTY_REFERRED = "referred";
  private String referred;

  public static final String JSON_PROPERTY_REFUSAL_REASON_RAW = "refusalReasonRaw";
  private String refusalReasonRaw;

  public static final String JSON_PROPERTY_REQUEST_AMOUNT = "requestAmount";
  private String requestAmount;

  public static final String JSON_PROPERTY_REQUEST_CURRENCY_CODE = "requestCurrencyCode";
  private String requestCurrencyCode;

  public static final String JSON_PROPERTY_SHOPPER_INTERACTION = "shopperInteraction";
  private String shopperInteraction;

  public static final String JSON_PROPERTY_SHOPPER_REFERENCE = "shopperReference";
  private String shopperReference;

  public static final String JSON_PROPERTY_TERMINAL_ID = "terminalId";
  private String terminalId;

  public static final String JSON_PROPERTY_THREE_D_AUTHENTICATED = "threeDAuthenticated";
  private String threeDAuthenticated;

  public static final String JSON_PROPERTY_THREE_D_AUTHENTICATED_RESPONSE = "threeDAuthenticatedResponse";
  private String threeDAuthenticatedResponse;

  public static final String JSON_PROPERTY_THREE_D_OFFERED = "threeDOffered";
  private String threeDOffered;

  public static final String JSON_PROPERTY_THREE_D_OFFERED_RESPONSE = "threeDOfferedResponse";
  private String threeDOfferedResponse;

  public static final String JSON_PROPERTY_THREE_D_S_VERSION = "threeDSVersion";
  private String threeDSVersion;

  public static final String JSON_PROPERTY_TOKENIZATION_SHOPPER_REFERENCE = "tokenization.shopperReference";
  private String tokenizationShopperReference;

  /**
   * The operation performed on the token. Possible values:  * **created**: the token has been created. * **updated**: the existing token has been updated. * **alreadyExisting**: the details have already been stored. 
   */
  public enum TokenizationStoreOperationTypeEnum {
    CREATED(String.valueOf("created")),
    
    UPDATED(String.valueOf("updated")),
    
    ALREADYEXISTING(String.valueOf("alreadyExisting"));

    private String value;

    TokenizationStoreOperationTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TokenizationStoreOperationTypeEnum fromValue(String value) {
      for (TokenizationStoreOperationTypeEnum b : TokenizationStoreOperationTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TOKENIZATION_STORE_OPERATION_TYPE = "tokenization.store.operationType";
  private TokenizationStoreOperationTypeEnum tokenizationStoreOperationType;

  public static final String JSON_PROPERTY_TOKENIZATION_STORED_PAYMENT_METHOD_ID = "tokenization.storedPaymentMethodId";
  private String tokenizationStoredPaymentMethodId;

  public static final String JSON_PROPERTY_VISA_TRANSACTION_ID = "visaTransactionId";
  private String visaTransactionId;

  public static final String JSON_PROPERTY_XID = "xid";
  private String xid;

  public ResponseAdditionalDataCommon() { 
  }

  /**
   * The name of the Adyen acquirer account.  Example: PayPalSandbox_TestAcquirer  &gt; Only relevant for PayPal transactions.
   *
   * @param acquirerAccountCode
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon acquirerAccountCode(String acquirerAccountCode) {
    this.acquirerAccountCode = acquirerAccountCode;
    return this;
  }

  /**
   * The name of the Adyen acquirer account.  Example: PayPalSandbox_TestAcquirer  &gt; Only relevant for PayPal transactions.
   * @return acquirerAccountCode
   */
  @JsonProperty(JSON_PROPERTY_ACQUIRER_ACCOUNT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getAcquirerAccountCode() {
    return acquirerAccountCode;
  }

  /**
   * The name of the Adyen acquirer account.  Example: PayPalSandbox_TestAcquirer  &gt; Only relevant for PayPal transactions.
   *
   * @param acquirerAccountCode
   */
  @JsonProperty(JSON_PROPERTY_ACQUIRER_ACCOUNT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAcquirerAccountCode(String acquirerAccountCode) {
    this.acquirerAccountCode = acquirerAccountCode;
  }

  /**
   * The name of the acquirer processing the payment request.  Example: TestPmmAcquirer
   *
   * @param acquirerCode
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon acquirerCode(String acquirerCode) {
    this.acquirerCode = acquirerCode;
    return this;
  }

  /**
   * The name of the acquirer processing the payment request.  Example: TestPmmAcquirer
   * @return acquirerCode
   */
  @JsonProperty(JSON_PROPERTY_ACQUIRER_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getAcquirerCode() {
    return acquirerCode;
  }

  /**
   * The name of the acquirer processing the payment request.  Example: TestPmmAcquirer
   *
   * @param acquirerCode
   */
  @JsonProperty(JSON_PROPERTY_ACQUIRER_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAcquirerCode(String acquirerCode) {
    this.acquirerCode = acquirerCode;
  }

  /**
   * The reference number that can be used for reconciliation in case a non-Adyen acquirer is used for settlement.  Example: 7C9N3FNBKT9
   *
   * @param acquirerReference
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon acquirerReference(String acquirerReference) {
    this.acquirerReference = acquirerReference;
    return this;
  }

  /**
   * The reference number that can be used for reconciliation in case a non-Adyen acquirer is used for settlement.  Example: 7C9N3FNBKT9
   * @return acquirerReference
   */
  @JsonProperty(JSON_PROPERTY_ACQUIRER_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getAcquirerReference() {
    return acquirerReference;
  }

  /**
   * The reference number that can be used for reconciliation in case a non-Adyen acquirer is used for settlement.  Example: 7C9N3FNBKT9
   *
   * @param acquirerReference
   */
  @JsonProperty(JSON_PROPERTY_ACQUIRER_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAcquirerReference(String acquirerReference) {
    this.acquirerReference = acquirerReference;
  }

  /**
   * The Adyen alias of the card.  Example: H167852639363479
   *
   * @param alias
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon alias(String alias) {
    this.alias = alias;
    return this;
  }

  /**
   * The Adyen alias of the card.  Example: H167852639363479
   * @return alias
   */
  @JsonProperty(JSON_PROPERTY_ALIAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getAlias() {
    return alias;
  }

  /**
   * The Adyen alias of the card.  Example: H167852639363479
   *
   * @param alias
   */
  @JsonProperty(JSON_PROPERTY_ALIAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAlias(String alias) {
    this.alias = alias;
  }

  /**
   * The type of the card alias.  Example: Default
   *
   * @param aliasType
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon aliasType(String aliasType) {
    this.aliasType = aliasType;
    return this;
  }

  /**
   * The type of the card alias.  Example: Default
   * @return aliasType
   */
  @JsonProperty(JSON_PROPERTY_ALIAS_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getAliasType() {
    return aliasType;
  }

  /**
   * The type of the card alias.  Example: Default
   *
   * @param aliasType
   */
  @JsonProperty(JSON_PROPERTY_ALIAS_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAliasType(String aliasType) {
    this.aliasType = aliasType;
  }

  /**
   * Authorisation code: * When the payment is authorised successfully, this field holds the authorisation code for the payment. * When the payment is not authorised, this field is empty.  Example: 58747
   *
   * @param authCode
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon authCode(String authCode) {
    this.authCode = authCode;
    return this;
  }

  /**
   * Authorisation code: * When the payment is authorised successfully, this field holds the authorisation code for the payment. * When the payment is not authorised, this field is empty.  Example: 58747
   * @return authCode
   */
  @JsonProperty(JSON_PROPERTY_AUTH_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getAuthCode() {
    return authCode;
  }

  /**
   * Authorisation code: * When the payment is authorised successfully, this field holds the authorisation code for the payment. * When the payment is not authorised, this field is empty.  Example: 58747
   *
   * @param authCode
   */
  @JsonProperty(JSON_PROPERTY_AUTH_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAuthCode(String authCode) {
    this.authCode = authCode;
  }

  /**
   * Merchant ID known by the acquirer.
   *
   * @param authorisationMid
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon authorisationMid(String authorisationMid) {
    this.authorisationMid = authorisationMid;
    return this;
  }

  /**
   * Merchant ID known by the acquirer.
   * @return authorisationMid
   */
  @JsonProperty(JSON_PROPERTY_AUTHORISATION_MID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getAuthorisationMid() {
    return authorisationMid;
  }

  /**
   * Merchant ID known by the acquirer.
   *
   * @param authorisationMid
   */
  @JsonProperty(JSON_PROPERTY_AUTHORISATION_MID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAuthorisationMid(String authorisationMid) {
    this.authorisationMid = authorisationMid;
  }

  /**
   * The currency of the authorised amount, as a three-character [ISO currency code](https://docs.adyen.com/development-resources/currency-codes).
   *
   * @param authorisedAmountCurrency
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon authorisedAmountCurrency(String authorisedAmountCurrency) {
    this.authorisedAmountCurrency = authorisedAmountCurrency;
    return this;
  }

  /**
   * The currency of the authorised amount, as a three-character [ISO currency code](https://docs.adyen.com/development-resources/currency-codes).
   * @return authorisedAmountCurrency
   */
  @JsonProperty(JSON_PROPERTY_AUTHORISED_AMOUNT_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getAuthorisedAmountCurrency() {
    return authorisedAmountCurrency;
  }

  /**
   * The currency of the authorised amount, as a three-character [ISO currency code](https://docs.adyen.com/development-resources/currency-codes).
   *
   * @param authorisedAmountCurrency
   */
  @JsonProperty(JSON_PROPERTY_AUTHORISED_AMOUNT_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAuthorisedAmountCurrency(String authorisedAmountCurrency) {
    this.authorisedAmountCurrency = authorisedAmountCurrency;
  }

  /**
   * Value of the amount authorised.  This amount is represented in minor units according to the [following table](https://docs.adyen.com/development-resources/currency-codes).
   *
   * @param authorisedAmountValue
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon authorisedAmountValue(String authorisedAmountValue) {
    this.authorisedAmountValue = authorisedAmountValue;
    return this;
  }

  /**
   * Value of the amount authorised.  This amount is represented in minor units according to the [following table](https://docs.adyen.com/development-resources/currency-codes).
   * @return authorisedAmountValue
   */
  @JsonProperty(JSON_PROPERTY_AUTHORISED_AMOUNT_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getAuthorisedAmountValue() {
    return authorisedAmountValue;
  }

  /**
   * Value of the amount authorised.  This amount is represented in minor units according to the [following table](https://docs.adyen.com/development-resources/currency-codes).
   *
   * @param authorisedAmountValue
   */
  @JsonProperty(JSON_PROPERTY_AUTHORISED_AMOUNT_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAuthorisedAmountValue(String authorisedAmountValue) {
    this.authorisedAmountValue = authorisedAmountValue;
  }

  /**
   * The AVS result code of the payment, which provides information about the outcome of the AVS check.  For possible values, see [AVS](https://docs.adyen.com/risk-management/configure-standard-risk-rules/consistency-rules#billing-address-does-not-match-cardholder-address-avs).
   *
   * @param avsResult
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon avsResult(String avsResult) {
    this.avsResult = avsResult;
    return this;
  }

  /**
   * The AVS result code of the payment, which provides information about the outcome of the AVS check.  For possible values, see [AVS](https://docs.adyen.com/risk-management/configure-standard-risk-rules/consistency-rules#billing-address-does-not-match-cardholder-address-avs).
   * @return avsResult
   */
  @JsonProperty(JSON_PROPERTY_AVS_RESULT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getAvsResult() {
    return avsResult;
  }

  /**
   * The AVS result code of the payment, which provides information about the outcome of the AVS check.  For possible values, see [AVS](https://docs.adyen.com/risk-management/configure-standard-risk-rules/consistency-rules#billing-address-does-not-match-cardholder-address-avs).
   *
   * @param avsResult
   */
  @JsonProperty(JSON_PROPERTY_AVS_RESULT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAvsResult(String avsResult) {
    this.avsResult = avsResult;
  }

  /**
   * Raw AVS result received from the acquirer, where available.  Example: D
   *
   * @param avsResultRaw
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon avsResultRaw(String avsResultRaw) {
    this.avsResultRaw = avsResultRaw;
    return this;
  }

  /**
   * Raw AVS result received from the acquirer, where available.  Example: D
   * @return avsResultRaw
   */
  @JsonProperty(JSON_PROPERTY_AVS_RESULT_RAW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getAvsResultRaw() {
    return avsResultRaw;
  }

  /**
   * Raw AVS result received from the acquirer, where available.  Example: D
   *
   * @param avsResultRaw
   */
  @JsonProperty(JSON_PROPERTY_AVS_RESULT_RAW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAvsResultRaw(String avsResultRaw) {
    this.avsResultRaw = avsResultRaw;
  }

  /**
   * BIC of a bank account.  Example: TESTNL01  &gt; Only relevant for SEPA Direct Debit transactions.
   *
   * @param bic
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon bic(String bic) {
    this.bic = bic;
    return this;
  }

  /**
   * BIC of a bank account.  Example: TESTNL01  &gt; Only relevant for SEPA Direct Debit transactions.
   * @return bic
   */
  @JsonProperty(JSON_PROPERTY_BIC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getBic() {
    return bic;
  }

  /**
   * BIC of a bank account.  Example: TESTNL01  &gt; Only relevant for SEPA Direct Debit transactions.
   *
   * @param bic
   */
  @JsonProperty(JSON_PROPERTY_BIC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBic(String bic) {
    this.bic = bic;
  }

  /**
   * Includes the co-branded card information.
   *
   * @param coBrandedWith
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon coBrandedWith(String coBrandedWith) {
    this.coBrandedWith = coBrandedWith;
    return this;
  }

  /**
   * Includes the co-branded card information.
   * @return coBrandedWith
   */
  @JsonProperty(JSON_PROPERTY_CO_BRANDED_WITH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCoBrandedWith() {
    return coBrandedWith;
  }

  /**
   * Includes the co-branded card information.
   *
   * @param coBrandedWith
   */
  @JsonProperty(JSON_PROPERTY_CO_BRANDED_WITH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCoBrandedWith(String coBrandedWith) {
    this.coBrandedWith = coBrandedWith;
  }

  /**
   * The result of CVC verification.
   *
   * @param cvcResult
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon cvcResult(String cvcResult) {
    this.cvcResult = cvcResult;
    return this;
  }

  /**
   * The result of CVC verification.
   * @return cvcResult
   */
  @JsonProperty(JSON_PROPERTY_CVC_RESULT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCvcResult() {
    return cvcResult;
  }

  /**
   * The result of CVC verification.
   *
   * @param cvcResult
   */
  @JsonProperty(JSON_PROPERTY_CVC_RESULT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCvcResult(String cvcResult) {
    this.cvcResult = cvcResult;
  }

  /**
   * The raw result of CVC verification.
   *
   * @param cvcResultRaw
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon cvcResultRaw(String cvcResultRaw) {
    this.cvcResultRaw = cvcResultRaw;
    return this;
  }

  /**
   * The raw result of CVC verification.
   * @return cvcResultRaw
   */
  @JsonProperty(JSON_PROPERTY_CVC_RESULT_RAW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCvcResultRaw() {
    return cvcResultRaw;
  }

  /**
   * The raw result of CVC verification.
   *
   * @param cvcResultRaw
   */
  @JsonProperty(JSON_PROPERTY_CVC_RESULT_RAW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCvcResultRaw(String cvcResultRaw) {
    this.cvcResultRaw = cvcResultRaw;
  }

  /**
   * Supported for 3D Secure 2. The unique transaction identifier assigned by the DS to identify a single transaction.
   *
   * @param dsTransID
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon dsTransID(String dsTransID) {
    this.dsTransID = dsTransID;
    return this;
  }

  /**
   * Supported for 3D Secure 2. The unique transaction identifier assigned by the DS to identify a single transaction.
   * @return dsTransID
   */
  @JsonProperty(JSON_PROPERTY_DS_TRANS_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDsTransID() {
    return dsTransID;
  }

  /**
   * Supported for 3D Secure 2. The unique transaction identifier assigned by the DS to identify a single transaction.
   *
   * @param dsTransID
   */
  @JsonProperty(JSON_PROPERTY_DS_TRANS_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDsTransID(String dsTransID) {
    this.dsTransID = dsTransID;
  }

  /**
   * The Electronic Commerce Indicator returned from the schemes for the 3DS payment session.  Example: 02
   *
   * @param eci
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon eci(String eci) {
    this.eci = eci;
    return this;
  }

  /**
   * The Electronic Commerce Indicator returned from the schemes for the 3DS payment session.  Example: 02
   * @return eci
   */
  @JsonProperty(JSON_PROPERTY_ECI)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getEci() {
    return eci;
  }

  /**
   * The Electronic Commerce Indicator returned from the schemes for the 3DS payment session.  Example: 02
   *
   * @param eci
   */
  @JsonProperty(JSON_PROPERTY_ECI)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEci(String eci) {
    this.eci = eci;
  }

  /**
   * The expiry date on the card.  Example: 6/2016  &gt; Returned only in case of a card payment.
   *
   * @param expiryDate
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon expiryDate(String expiryDate) {
    this.expiryDate = expiryDate;
    return this;
  }

  /**
   * The expiry date on the card.  Example: 6/2016  &gt; Returned only in case of a card payment.
   * @return expiryDate
   */
  @JsonProperty(JSON_PROPERTY_EXPIRY_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getExpiryDate() {
    return expiryDate;
  }

  /**
   * The expiry date on the card.  Example: 6/2016  &gt; Returned only in case of a card payment.
   *
   * @param expiryDate
   */
  @JsonProperty(JSON_PROPERTY_EXPIRY_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExpiryDate(String expiryDate) {
    this.expiryDate = expiryDate;
  }

  /**
   * The currency of the extra amount charged due to additional amounts set in the skin used in the HPP payment request.  Example: EUR
   *
   * @param extraCostsCurrency
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon extraCostsCurrency(String extraCostsCurrency) {
    this.extraCostsCurrency = extraCostsCurrency;
    return this;
  }

  /**
   * The currency of the extra amount charged due to additional amounts set in the skin used in the HPP payment request.  Example: EUR
   * @return extraCostsCurrency
   */
  @JsonProperty(JSON_PROPERTY_EXTRA_COSTS_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getExtraCostsCurrency() {
    return extraCostsCurrency;
  }

  /**
   * The currency of the extra amount charged due to additional amounts set in the skin used in the HPP payment request.  Example: EUR
   *
   * @param extraCostsCurrency
   */
  @JsonProperty(JSON_PROPERTY_EXTRA_COSTS_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExtraCostsCurrency(String extraCostsCurrency) {
    this.extraCostsCurrency = extraCostsCurrency;
  }

  /**
   * The value of the extra amount charged due to additional amounts set in the skin used in the HPP payment request. The amount is in minor units.
   *
   * @param extraCostsValue
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon extraCostsValue(String extraCostsValue) {
    this.extraCostsValue = extraCostsValue;
    return this;
  }

  /**
   * The value of the extra amount charged due to additional amounts set in the skin used in the HPP payment request. The amount is in minor units.
   * @return extraCostsValue
   */
  @JsonProperty(JSON_PROPERTY_EXTRA_COSTS_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getExtraCostsValue() {
    return extraCostsValue;
  }

  /**
   * The value of the extra amount charged due to additional amounts set in the skin used in the HPP payment request. The amount is in minor units.
   *
   * @param extraCostsValue
   */
  @JsonProperty(JSON_PROPERTY_EXTRA_COSTS_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExtraCostsValue(String extraCostsValue) {
    this.extraCostsValue = extraCostsValue;
  }

  /**
   * The fraud score due to a particular fraud check. The fraud check name is found in the key of the key-value pair.
   *
   * @param fraudCheckItemNrFraudCheckname
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon fraudCheckItemNrFraudCheckname(String fraudCheckItemNrFraudCheckname) {
    this.fraudCheckItemNrFraudCheckname = fraudCheckItemNrFraudCheckname;
    return this;
  }

  /**
   * The fraud score due to a particular fraud check. The fraud check name is found in the key of the key-value pair.
   * @return fraudCheckItemNrFraudCheckname
   */
  @JsonProperty(JSON_PROPERTY_FRAUD_CHECK_ITEM_NR_FRAUD_CHECKNAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getFraudCheckItemNrFraudCheckname() {
    return fraudCheckItemNrFraudCheckname;
  }

  /**
   * The fraud score due to a particular fraud check. The fraud check name is found in the key of the key-value pair.
   *
   * @param fraudCheckItemNrFraudCheckname
   */
  @JsonProperty(JSON_PROPERTY_FRAUD_CHECK_ITEM_NR_FRAUD_CHECKNAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFraudCheckItemNrFraudCheckname(String fraudCheckItemNrFraudCheckname) {
    this.fraudCheckItemNrFraudCheckname = fraudCheckItemNrFraudCheckname;
  }

  /**
   * Indicates if the payment is sent to manual review.
   *
   * @param fraudManualReview
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon fraudManualReview(String fraudManualReview) {
    this.fraudManualReview = fraudManualReview;
    return this;
  }

  /**
   * Indicates if the payment is sent to manual review.
   * @return fraudManualReview
   */
  @JsonProperty(JSON_PROPERTY_FRAUD_MANUAL_REVIEW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getFraudManualReview() {
    return fraudManualReview;
  }

  /**
   * Indicates if the payment is sent to manual review.
   *
   * @param fraudManualReview
   */
  @JsonProperty(JSON_PROPERTY_FRAUD_MANUAL_REVIEW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFraudManualReview(String fraudManualReview) {
    this.fraudManualReview = fraudManualReview;
  }

  /**
   * The fraud result properties of the payment.
   *
   * @param fraudResultType
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon fraudResultType(FraudResultTypeEnum fraudResultType) {
    this.fraudResultType = fraudResultType;
    return this;
  }

  /**
   * The fraud result properties of the payment.
   * @return fraudResultType
   */
  @JsonProperty(JSON_PROPERTY_FRAUD_RESULT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public FraudResultTypeEnum getFraudResultType() {
    return fraudResultType;
  }

  /**
   * The fraud result properties of the payment.
   *
   * @param fraudResultType
   */
  @JsonProperty(JSON_PROPERTY_FRAUD_RESULT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFraudResultType(FraudResultTypeEnum fraudResultType) {
    this.fraudResultType = fraudResultType;
  }

  /**
   * Information regarding the funding type of the card. The possible return values are: * CHARGE * CREDIT * DEBIT * PREPAID * PREPAID_RELOADABLE  * PREPAID_NONRELOADABLE * DEFFERED_DEBIT  &gt; This functionality requires additional configuration on Adyen&#39;s end. To enable it, contact the Support Team.  For receiving this field in the notification, enable **Include Funding Source** in **Notifications** &gt; **Additional settings**.
   *
   * @param fundingSource
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon fundingSource(String fundingSource) {
    this.fundingSource = fundingSource;
    return this;
  }

  /**
   * Information regarding the funding type of the card. The possible return values are: * CHARGE * CREDIT * DEBIT * PREPAID * PREPAID_RELOADABLE  * PREPAID_NONRELOADABLE * DEFFERED_DEBIT  &gt; This functionality requires additional configuration on Adyen&#39;s end. To enable it, contact the Support Team.  For receiving this field in the notification, enable **Include Funding Source** in **Notifications** &gt; **Additional settings**.
   * @return fundingSource
   */
  @JsonProperty(JSON_PROPERTY_FUNDING_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getFundingSource() {
    return fundingSource;
  }

  /**
   * Information regarding the funding type of the card. The possible return values are: * CHARGE * CREDIT * DEBIT * PREPAID * PREPAID_RELOADABLE  * PREPAID_NONRELOADABLE * DEFFERED_DEBIT  &gt; This functionality requires additional configuration on Adyen&#39;s end. To enable it, contact the Support Team.  For receiving this field in the notification, enable **Include Funding Source** in **Notifications** &gt; **Additional settings**.
   *
   * @param fundingSource
   */
  @JsonProperty(JSON_PROPERTY_FUNDING_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFundingSource(String fundingSource) {
    this.fundingSource = fundingSource;
  }

  /**
   * Indicates availability of funds.  Visa: * \&quot;I\&quot; (fast funds are supported) * \&quot;N\&quot; (otherwise)  Mastercard: * \&quot;I\&quot; (product type is Prepaid or Debit, or issuing country is in CEE/HGEM list) * \&quot;N\&quot; (otherwise)  &gt; Returned when you verify a card BIN or estimate costs, and only if payoutEligible is \&quot;Y\&quot; or \&quot;D\&quot;.
   *
   * @param fundsAvailability
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon fundsAvailability(String fundsAvailability) {
    this.fundsAvailability = fundsAvailability;
    return this;
  }

  /**
   * Indicates availability of funds.  Visa: * \&quot;I\&quot; (fast funds are supported) * \&quot;N\&quot; (otherwise)  Mastercard: * \&quot;I\&quot; (product type is Prepaid or Debit, or issuing country is in CEE/HGEM list) * \&quot;N\&quot; (otherwise)  &gt; Returned when you verify a card BIN or estimate costs, and only if payoutEligible is \&quot;Y\&quot; or \&quot;D\&quot;.
   * @return fundsAvailability
   */
  @JsonProperty(JSON_PROPERTY_FUNDS_AVAILABILITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getFundsAvailability() {
    return fundsAvailability;
  }

  /**
   * Indicates availability of funds.  Visa: * \&quot;I\&quot; (fast funds are supported) * \&quot;N\&quot; (otherwise)  Mastercard: * \&quot;I\&quot; (product type is Prepaid or Debit, or issuing country is in CEE/HGEM list) * \&quot;N\&quot; (otherwise)  &gt; Returned when you verify a card BIN or estimate costs, and only if payoutEligible is \&quot;Y\&quot; or \&quot;D\&quot;.
   *
   * @param fundsAvailability
   */
  @JsonProperty(JSON_PROPERTY_FUNDS_AVAILABILITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFundsAvailability(String fundsAvailability) {
    this.fundsAvailability = fundsAvailability;
  }

  /**
   * Provides the more granular indication of why a transaction was refused. When a transaction fails with either \&quot;Refused\&quot;, \&quot;Restricted Card\&quot;, \&quot;Transaction Not Permitted\&quot;, \&quot;Not supported\&quot; or \&quot;DeclinedNon Generic\&quot; refusalReason from the issuer, Adyen cross references its PSP-wide data for extra insight into the refusal reason. If an inferred refusal reason is available, the &#x60;inferredRefusalReason&#x60;, field is populated and the &#x60;refusalReason&#x60;, is set to \&quot;Not Supported\&quot;.  Possible values:  * 3D Secure Mandated * Closed Account * ContAuth Not Supported * CVC Mandated * Ecommerce Not Allowed * Crossborder Not Supported * Card Updated  * Low Authrate Bin * Non-reloadable prepaid card
   *
   * @param inferredRefusalReason
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon inferredRefusalReason(String inferredRefusalReason) {
    this.inferredRefusalReason = inferredRefusalReason;
    return this;
  }

  /**
   * Provides the more granular indication of why a transaction was refused. When a transaction fails with either \&quot;Refused\&quot;, \&quot;Restricted Card\&quot;, \&quot;Transaction Not Permitted\&quot;, \&quot;Not supported\&quot; or \&quot;DeclinedNon Generic\&quot; refusalReason from the issuer, Adyen cross references its PSP-wide data for extra insight into the refusal reason. If an inferred refusal reason is available, the &#x60;inferredRefusalReason&#x60;, field is populated and the &#x60;refusalReason&#x60;, is set to \&quot;Not Supported\&quot;.  Possible values:  * 3D Secure Mandated * Closed Account * ContAuth Not Supported * CVC Mandated * Ecommerce Not Allowed * Crossborder Not Supported * Card Updated  * Low Authrate Bin * Non-reloadable prepaid card
   * @return inferredRefusalReason
   */
  @JsonProperty(JSON_PROPERTY_INFERRED_REFUSAL_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getInferredRefusalReason() {
    return inferredRefusalReason;
  }

  /**
   * Provides the more granular indication of why a transaction was refused. When a transaction fails with either \&quot;Refused\&quot;, \&quot;Restricted Card\&quot;, \&quot;Transaction Not Permitted\&quot;, \&quot;Not supported\&quot; or \&quot;DeclinedNon Generic\&quot; refusalReason from the issuer, Adyen cross references its PSP-wide data for extra insight into the refusal reason. If an inferred refusal reason is available, the &#x60;inferredRefusalReason&#x60;, field is populated and the &#x60;refusalReason&#x60;, is set to \&quot;Not Supported\&quot;.  Possible values:  * 3D Secure Mandated * Closed Account * ContAuth Not Supported * CVC Mandated * Ecommerce Not Allowed * Crossborder Not Supported * Card Updated  * Low Authrate Bin * Non-reloadable prepaid card
   *
   * @param inferredRefusalReason
   */
  @JsonProperty(JSON_PROPERTY_INFERRED_REFUSAL_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInferredRefusalReason(String inferredRefusalReason) {
    this.inferredRefusalReason = inferredRefusalReason;
  }

  /**
   * Indicates if the card is used for business purposes only.
   *
   * @param isCardCommercial
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon isCardCommercial(String isCardCommercial) {
    this.isCardCommercial = isCardCommercial;
    return this;
  }

  /**
   * Indicates if the card is used for business purposes only.
   * @return isCardCommercial
   */
  @JsonProperty(JSON_PROPERTY_IS_CARD_COMMERCIAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getIsCardCommercial() {
    return isCardCommercial;
  }

  /**
   * Indicates if the card is used for business purposes only.
   *
   * @param isCardCommercial
   */
  @JsonProperty(JSON_PROPERTY_IS_CARD_COMMERCIAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsCardCommercial(String isCardCommercial) {
    this.isCardCommercial = isCardCommercial;
  }

  /**
   * The issuing country of the card based on the BIN list that Adyen maintains.  Example: JP
   *
   * @param issuerCountry
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon issuerCountry(String issuerCountry) {
    this.issuerCountry = issuerCountry;
    return this;
  }

  /**
   * The issuing country of the card based on the BIN list that Adyen maintains.  Example: JP
   * @return issuerCountry
   */
  @JsonProperty(JSON_PROPERTY_ISSUER_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getIssuerCountry() {
    return issuerCountry;
  }

  /**
   * The issuing country of the card based on the BIN list that Adyen maintains.  Example: JP
   *
   * @param issuerCountry
   */
  @JsonProperty(JSON_PROPERTY_ISSUER_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIssuerCountry(String issuerCountry) {
    this.issuerCountry = issuerCountry;
  }

  /**
   * A Boolean value indicating whether a liability shift was offered for this payment.
   *
   * @param liabilityShift
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon liabilityShift(String liabilityShift) {
    this.liabilityShift = liabilityShift;
    return this;
  }

  /**
   * A Boolean value indicating whether a liability shift was offered for this payment.
   * @return liabilityShift
   */
  @JsonProperty(JSON_PROPERTY_LIABILITY_SHIFT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getLiabilityShift() {
    return liabilityShift;
  }

  /**
   * A Boolean value indicating whether a liability shift was offered for this payment.
   *
   * @param liabilityShift
   */
  @JsonProperty(JSON_PROPERTY_LIABILITY_SHIFT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLiabilityShift(String liabilityShift) {
    this.liabilityShift = liabilityShift;
  }

  /**
   * The &#x60;mcBankNetReferenceNumber&#x60;, is a minimum of six characters and a maximum of nine characters long.  &gt; Contact Support Team to enable this field.
   *
   * @param mcBankNetReferenceNumber
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon mcBankNetReferenceNumber(String mcBankNetReferenceNumber) {
    this.mcBankNetReferenceNumber = mcBankNetReferenceNumber;
    return this;
  }

  /**
   * The &#x60;mcBankNetReferenceNumber&#x60;, is a minimum of six characters and a maximum of nine characters long.  &gt; Contact Support Team to enable this field.
   * @return mcBankNetReferenceNumber
   */
  @JsonProperty(JSON_PROPERTY_MC_BANK_NET_REFERENCE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMcBankNetReferenceNumber() {
    return mcBankNetReferenceNumber;
  }

  /**
   * The &#x60;mcBankNetReferenceNumber&#x60;, is a minimum of six characters and a maximum of nine characters long.  &gt; Contact Support Team to enable this field.
   *
   * @param mcBankNetReferenceNumber
   */
  @JsonProperty(JSON_PROPERTY_MC_BANK_NET_REFERENCE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMcBankNetReferenceNumber(String mcBankNetReferenceNumber) {
    this.mcBankNetReferenceNumber = mcBankNetReferenceNumber;
  }

  /**
   * The Merchant Advice Code (MAC) can be returned by Mastercard issuers for refused payments. If present, the MAC contains information about why the payment failed, and whether it can be retried.  For more information see [Mastercard Merchant Advice Codes](https://docs.adyen.com/development-resources/raw-acquirer-responses#mastercard-merchant-advice-codes).
   *
   * @param merchantAdviceCode
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon merchantAdviceCode(String merchantAdviceCode) {
    this.merchantAdviceCode = merchantAdviceCode;
    return this;
  }

  /**
   * The Merchant Advice Code (MAC) can be returned by Mastercard issuers for refused payments. If present, the MAC contains information about why the payment failed, and whether it can be retried.  For more information see [Mastercard Merchant Advice Codes](https://docs.adyen.com/development-resources/raw-acquirer-responses#mastercard-merchant-advice-codes).
   * @return merchantAdviceCode
   */
  @JsonProperty(JSON_PROPERTY_MERCHANT_ADVICE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMerchantAdviceCode() {
    return merchantAdviceCode;
  }

  /**
   * The Merchant Advice Code (MAC) can be returned by Mastercard issuers for refused payments. If present, the MAC contains information about why the payment failed, and whether it can be retried.  For more information see [Mastercard Merchant Advice Codes](https://docs.adyen.com/development-resources/raw-acquirer-responses#mastercard-merchant-advice-codes).
   *
   * @param merchantAdviceCode
   */
  @JsonProperty(JSON_PROPERTY_MERCHANT_ADVICE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMerchantAdviceCode(String merchantAdviceCode) {
    this.merchantAdviceCode = merchantAdviceCode;
  }

  /**
   * The reference provided for the transaction.
   *
   * @param merchantReference
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon merchantReference(String merchantReference) {
    this.merchantReference = merchantReference;
    return this;
  }

  /**
   * The reference provided for the transaction.
   * @return merchantReference
   */
  @JsonProperty(JSON_PROPERTY_MERCHANT_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMerchantReference() {
    return merchantReference;
  }

  /**
   * The reference provided for the transaction.
   *
   * @param merchantReference
   */
  @JsonProperty(JSON_PROPERTY_MERCHANT_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMerchantReference(String merchantReference) {
    this.merchantReference = merchantReference;
  }

  /**
   * Returned in the response if you are not tokenizing with Adyen and are using the Merchant-initiated transactions (MIT) framework from Mastercard or Visa.  This contains either the Mastercard Trace ID or the Visa Transaction ID.
   *
   * @param networkTxReference
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon networkTxReference(String networkTxReference) {
    this.networkTxReference = networkTxReference;
    return this;
  }

  /**
   * Returned in the response if you are not tokenizing with Adyen and are using the Merchant-initiated transactions (MIT) framework from Mastercard or Visa.  This contains either the Mastercard Trace ID or the Visa Transaction ID.
   * @return networkTxReference
   */
  @JsonProperty(JSON_PROPERTY_NETWORK_TX_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getNetworkTxReference() {
    return networkTxReference;
  }

  /**
   * Returned in the response if you are not tokenizing with Adyen and are using the Merchant-initiated transactions (MIT) framework from Mastercard or Visa.  This contains either the Mastercard Trace ID or the Visa Transaction ID.
   *
   * @param networkTxReference
   */
  @JsonProperty(JSON_PROPERTY_NETWORK_TX_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetworkTxReference(String networkTxReference) {
    this.networkTxReference = networkTxReference;
  }

  /**
   * The owner name of a bank account.  Only relevant for SEPA Direct Debit transactions.
   *
   * @param ownerName
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon ownerName(String ownerName) {
    this.ownerName = ownerName;
    return this;
  }

  /**
   * The owner name of a bank account.  Only relevant for SEPA Direct Debit transactions.
   * @return ownerName
   */
  @JsonProperty(JSON_PROPERTY_OWNER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getOwnerName() {
    return ownerName;
  }

  /**
   * The owner name of a bank account.  Only relevant for SEPA Direct Debit transactions.
   *
   * @param ownerName
   */
  @JsonProperty(JSON_PROPERTY_OWNER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwnerName(String ownerName) {
    this.ownerName = ownerName;
  }

  /**
   * The Payment Account Reference (PAR) value links a network token with the underlying primary account number (PAN). The PAR value consists of 29 uppercase alphanumeric characters.
   *
   * @param paymentAccountReference
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon paymentAccountReference(String paymentAccountReference) {
    this.paymentAccountReference = paymentAccountReference;
    return this;
  }

  /**
   * The Payment Account Reference (PAR) value links a network token with the underlying primary account number (PAN). The PAR value consists of 29 uppercase alphanumeric characters.
   * @return paymentAccountReference
   */
  @JsonProperty(JSON_PROPERTY_PAYMENT_ACCOUNT_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getPaymentAccountReference() {
    return paymentAccountReference;
  }

  /**
   * The Payment Account Reference (PAR) value links a network token with the underlying primary account number (PAN). The PAR value consists of 29 uppercase alphanumeric characters.
   *
   * @param paymentAccountReference
   */
  @JsonProperty(JSON_PROPERTY_PAYMENT_ACCOUNT_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaymentAccountReference(String paymentAccountReference) {
    this.paymentAccountReference = paymentAccountReference;
  }

  /**
   * The payment method used in the transaction.
   *
   * @param paymentMethod
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon paymentMethod(String paymentMethod) {
    this.paymentMethod = paymentMethod;
    return this;
  }

  /**
   * The payment method used in the transaction.
   * @return paymentMethod
   */
  @JsonProperty(JSON_PROPERTY_PAYMENT_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getPaymentMethod() {
    return paymentMethod;
  }

  /**
   * The payment method used in the transaction.
   *
   * @param paymentMethod
   */
  @JsonProperty(JSON_PROPERTY_PAYMENT_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaymentMethod(String paymentMethod) {
    this.paymentMethod = paymentMethod;
  }

  /**
   * The Adyen sub-variant of the payment method used for the payment request.  For more information, refer to [PaymentMethodVariant](https://docs.adyen.com/development-resources/paymentmethodvariant).  Example: mcpro
   *
   * @param paymentMethodVariant
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon paymentMethodVariant(String paymentMethodVariant) {
    this.paymentMethodVariant = paymentMethodVariant;
    return this;
  }

  /**
   * The Adyen sub-variant of the payment method used for the payment request.  For more information, refer to [PaymentMethodVariant](https://docs.adyen.com/development-resources/paymentmethodvariant).  Example: mcpro
   * @return paymentMethodVariant
   */
  @JsonProperty(JSON_PROPERTY_PAYMENT_METHOD_VARIANT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getPaymentMethodVariant() {
    return paymentMethodVariant;
  }

  /**
   * The Adyen sub-variant of the payment method used for the payment request.  For more information, refer to [PaymentMethodVariant](https://docs.adyen.com/development-resources/paymentmethodvariant).  Example: mcpro
   *
   * @param paymentMethodVariant
   */
  @JsonProperty(JSON_PROPERTY_PAYMENT_METHOD_VARIANT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaymentMethodVariant(String paymentMethodVariant) {
    this.paymentMethodVariant = paymentMethodVariant;
  }

  /**
   * Indicates whether a payout is eligible or not for this card.  Visa: * \&quot;Y\&quot; * \&quot;N\&quot;  Mastercard: * \&quot;Y\&quot; (domestic and cross-border)  * \&quot;D\&quot; (only domestic) * \&quot;N\&quot; (no MoneySend) * \&quot;U\&quot; (unknown)
   *
   * @param payoutEligible
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon payoutEligible(String payoutEligible) {
    this.payoutEligible = payoutEligible;
    return this;
  }

  /**
   * Indicates whether a payout is eligible or not for this card.  Visa: * \&quot;Y\&quot; * \&quot;N\&quot;  Mastercard: * \&quot;Y\&quot; (domestic and cross-border)  * \&quot;D\&quot; (only domestic) * \&quot;N\&quot; (no MoneySend) * \&quot;U\&quot; (unknown)
   * @return payoutEligible
   */
  @JsonProperty(JSON_PROPERTY_PAYOUT_ELIGIBLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getPayoutEligible() {
    return payoutEligible;
  }

  /**
   * Indicates whether a payout is eligible or not for this card.  Visa: * \&quot;Y\&quot; * \&quot;N\&quot;  Mastercard: * \&quot;Y\&quot; (domestic and cross-border)  * \&quot;D\&quot; (only domestic) * \&quot;N\&quot; (no MoneySend) * \&quot;U\&quot; (unknown)
   *
   * @param payoutEligible
   */
  @JsonProperty(JSON_PROPERTY_PAYOUT_ELIGIBLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPayoutEligible(String payoutEligible) {
    this.payoutEligible = payoutEligible;
  }

  /**
   * The response code from the Real Time Account Updater service.  Possible return values are: * CardChanged * CardExpiryChanged * CloseAccount  * ContactCardAccountHolder
   *
   * @param realtimeAccountUpdaterStatus
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon realtimeAccountUpdaterStatus(String realtimeAccountUpdaterStatus) {
    this.realtimeAccountUpdaterStatus = realtimeAccountUpdaterStatus;
    return this;
  }

  /**
   * The response code from the Real Time Account Updater service.  Possible return values are: * CardChanged * CardExpiryChanged * CloseAccount  * ContactCardAccountHolder
   * @return realtimeAccountUpdaterStatus
   */
  @JsonProperty(JSON_PROPERTY_REALTIME_ACCOUNT_UPDATER_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getRealtimeAccountUpdaterStatus() {
    return realtimeAccountUpdaterStatus;
  }

  /**
   * The response code from the Real Time Account Updater service.  Possible return values are: * CardChanged * CardExpiryChanged * CloseAccount  * ContactCardAccountHolder
   *
   * @param realtimeAccountUpdaterStatus
   */
  @JsonProperty(JSON_PROPERTY_REALTIME_ACCOUNT_UPDATER_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRealtimeAccountUpdaterStatus(String realtimeAccountUpdaterStatus) {
    this.realtimeAccountUpdaterStatus = realtimeAccountUpdaterStatus;
  }

  /**
   * Message to be displayed on the terminal.
   *
   * @param receiptFreeText
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon receiptFreeText(String receiptFreeText) {
    this.receiptFreeText = receiptFreeText;
    return this;
  }

  /**
   * Message to be displayed on the terminal.
   * @return receiptFreeText
   */
  @JsonProperty(JSON_PROPERTY_RECEIPT_FREE_TEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getReceiptFreeText() {
    return receiptFreeText;
  }

  /**
   * Message to be displayed on the terminal.
   *
   * @param receiptFreeText
   */
  @JsonProperty(JSON_PROPERTY_RECEIPT_FREE_TEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReceiptFreeText(String receiptFreeText) {
    this.receiptFreeText = receiptFreeText;
  }

  /**
   * The recurring contract types applicable to the transaction.
   *
   * @param recurringContractTypes
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon recurringContractTypes(String recurringContractTypes) {
    this.recurringContractTypes = recurringContractTypes;
    return this;
  }

  /**
   * The recurring contract types applicable to the transaction.
   * @return recurringContractTypes
   */
  @JsonProperty(JSON_PROPERTY_RECURRING_CONTRACT_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getRecurringContractTypes() {
    return recurringContractTypes;
  }

  /**
   * The recurring contract types applicable to the transaction.
   *
   * @param recurringContractTypes
   */
  @JsonProperty(JSON_PROPERTY_RECURRING_CONTRACT_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecurringContractTypes(String recurringContractTypes) {
    this.recurringContractTypes = recurringContractTypes;
  }

  /**
   * The &#x60;pspReference&#x60;, of the first recurring payment that created the recurring detail.  This functionality requires additional configuration on Adyen&#39;s end. To enable it, contact the Support Team.
   *
   * @param recurringFirstPspReference
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon recurringFirstPspReference(String recurringFirstPspReference) {
    this.recurringFirstPspReference = recurringFirstPspReference;
    return this;
  }

  /**
   * The &#x60;pspReference&#x60;, of the first recurring payment that created the recurring detail.  This functionality requires additional configuration on Adyen&#39;s end. To enable it, contact the Support Team.
   * @return recurringFirstPspReference
   */
  @JsonProperty(JSON_PROPERTY_RECURRING_FIRST_PSP_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getRecurringFirstPspReference() {
    return recurringFirstPspReference;
  }

  /**
   * The &#x60;pspReference&#x60;, of the first recurring payment that created the recurring detail.  This functionality requires additional configuration on Adyen&#39;s end. To enable it, contact the Support Team.
   *
   * @param recurringFirstPspReference
   */
  @JsonProperty(JSON_PROPERTY_RECURRING_FIRST_PSP_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecurringFirstPspReference(String recurringFirstPspReference) {
    this.recurringFirstPspReference = recurringFirstPspReference;
  }

  /**
   * The reference that uniquely identifies the recurring transaction.
   *
   * @param recurringRecurringDetailReference
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   *
   * @deprecated since Adyen Checkout API v68
   * Use tokenization.storedPaymentMethodId instead.
   */
  @Deprecated // deprecated since Adyen Checkout API v68: Use tokenization.storedPaymentMethodId instead.
  public ResponseAdditionalDataCommon recurringRecurringDetailReference(String recurringRecurringDetailReference) {
    this.recurringRecurringDetailReference = recurringRecurringDetailReference;
    return this;
  }

  /**
   * The reference that uniquely identifies the recurring transaction.
   * @return recurringRecurringDetailReference
   * @deprecated // deprecated since Adyen Checkout API v68: Use tokenization.storedPaymentMethodId instead.
   */
  @Deprecated // deprecated since Adyen Checkout API v68: Use tokenization.storedPaymentMethodId instead.
  @JsonProperty(JSON_PROPERTY_RECURRING_RECURRING_DETAIL_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getRecurringRecurringDetailReference() {
    return recurringRecurringDetailReference;
  }

  /**
   * The reference that uniquely identifies the recurring transaction.
   *
   * @param recurringRecurringDetailReference
   *
   * @deprecated since Adyen Checkout API v68
   * Use tokenization.storedPaymentMethodId instead.
   */
  @Deprecated // deprecated since Adyen Checkout API v68: Use tokenization.storedPaymentMethodId instead.
  @JsonProperty(JSON_PROPERTY_RECURRING_RECURRING_DETAIL_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecurringRecurringDetailReference(String recurringRecurringDetailReference) {
    this.recurringRecurringDetailReference = recurringRecurringDetailReference;
  }

  /**
   * The provided reference of the shopper for a recurring transaction.
   *
   * @param recurringShopperReference
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   *
   * @deprecated since Adyen Checkout API v68
   * Use tokenization.shopperReference instead.
   */
  @Deprecated // deprecated since Adyen Checkout API v68: Use tokenization.shopperReference instead.
  public ResponseAdditionalDataCommon recurringShopperReference(String recurringShopperReference) {
    this.recurringShopperReference = recurringShopperReference;
    return this;
  }

  /**
   * The provided reference of the shopper for a recurring transaction.
   * @return recurringShopperReference
   * @deprecated // deprecated since Adyen Checkout API v68: Use tokenization.shopperReference instead.
   */
  @Deprecated // deprecated since Adyen Checkout API v68: Use tokenization.shopperReference instead.
  @JsonProperty(JSON_PROPERTY_RECURRING_SHOPPER_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getRecurringShopperReference() {
    return recurringShopperReference;
  }

  /**
   * The provided reference of the shopper for a recurring transaction.
   *
   * @param recurringShopperReference
   *
   * @deprecated since Adyen Checkout API v68
   * Use tokenization.shopperReference instead.
   */
  @Deprecated // deprecated since Adyen Checkout API v68: Use tokenization.shopperReference instead.
  @JsonProperty(JSON_PROPERTY_RECURRING_SHOPPER_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecurringShopperReference(String recurringShopperReference) {
    this.recurringShopperReference = recurringShopperReference;
  }

  /**
   * The processing model used for the recurring transaction.
   *
   * @param recurringProcessingModel
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon recurringProcessingModel(RecurringProcessingModelEnum recurringProcessingModel) {
    this.recurringProcessingModel = recurringProcessingModel;
    return this;
  }

  /**
   * The processing model used for the recurring transaction.
   * @return recurringProcessingModel
   */
  @JsonProperty(JSON_PROPERTY_RECURRING_PROCESSING_MODEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public RecurringProcessingModelEnum getRecurringProcessingModel() {
    return recurringProcessingModel;
  }

  /**
   * The processing model used for the recurring transaction.
   *
   * @param recurringProcessingModel
   */
  @JsonProperty(JSON_PROPERTY_RECURRING_PROCESSING_MODEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecurringProcessingModel(RecurringProcessingModelEnum recurringProcessingModel) {
    this.recurringProcessingModel = recurringProcessingModel;
  }

  /**
   * If the payment is referred, this field is set to true.  This field is unavailable if the payment is referred and is usually not returned with ecommerce transactions.  Example: true
   *
   * @param referred
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon referred(String referred) {
    this.referred = referred;
    return this;
  }

  /**
   * If the payment is referred, this field is set to true.  This field is unavailable if the payment is referred and is usually not returned with ecommerce transactions.  Example: true
   * @return referred
   */
  @JsonProperty(JSON_PROPERTY_REFERRED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getReferred() {
    return referred;
  }

  /**
   * If the payment is referred, this field is set to true.  This field is unavailable if the payment is referred and is usually not returned with ecommerce transactions.  Example: true
   *
   * @param referred
   */
  @JsonProperty(JSON_PROPERTY_REFERRED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReferred(String referred) {
    this.referred = referred;
  }

  /**
   * Raw refusal reason received from the acquirer, where available.  Example: AUTHORISED
   *
   * @param refusalReasonRaw
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon refusalReasonRaw(String refusalReasonRaw) {
    this.refusalReasonRaw = refusalReasonRaw;
    return this;
  }

  /**
   * Raw refusal reason received from the acquirer, where available.  Example: AUTHORISED
   * @return refusalReasonRaw
   */
  @JsonProperty(JSON_PROPERTY_REFUSAL_REASON_RAW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getRefusalReasonRaw() {
    return refusalReasonRaw;
  }

  /**
   * Raw refusal reason received from the acquirer, where available.  Example: AUTHORISED
   *
   * @param refusalReasonRaw
   */
  @JsonProperty(JSON_PROPERTY_REFUSAL_REASON_RAW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRefusalReasonRaw(String refusalReasonRaw) {
    this.refusalReasonRaw = refusalReasonRaw;
  }

  /**
   * The amount of the payment request.
   *
   * @param requestAmount
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon requestAmount(String requestAmount) {
    this.requestAmount = requestAmount;
    return this;
  }

  /**
   * The amount of the payment request.
   * @return requestAmount
   */
  @JsonProperty(JSON_PROPERTY_REQUEST_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getRequestAmount() {
    return requestAmount;
  }

  /**
   * The amount of the payment request.
   *
   * @param requestAmount
   */
  @JsonProperty(JSON_PROPERTY_REQUEST_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRequestAmount(String requestAmount) {
    this.requestAmount = requestAmount;
  }

  /**
   * The currency of the payment request.
   *
   * @param requestCurrencyCode
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon requestCurrencyCode(String requestCurrencyCode) {
    this.requestCurrencyCode = requestCurrencyCode;
    return this;
  }

  /**
   * The currency of the payment request.
   * @return requestCurrencyCode
   */
  @JsonProperty(JSON_PROPERTY_REQUEST_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getRequestCurrencyCode() {
    return requestCurrencyCode;
  }

  /**
   * The currency of the payment request.
   *
   * @param requestCurrencyCode
   */
  @JsonProperty(JSON_PROPERTY_REQUEST_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRequestCurrencyCode(String requestCurrencyCode) {
    this.requestCurrencyCode = requestCurrencyCode;
  }

  /**
   * The shopper interaction type of the payment request.  Example: Ecommerce
   *
   * @param shopperInteraction
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon shopperInteraction(String shopperInteraction) {
    this.shopperInteraction = shopperInteraction;
    return this;
  }

  /**
   * The shopper interaction type of the payment request.  Example: Ecommerce
   * @return shopperInteraction
   */
  @JsonProperty(JSON_PROPERTY_SHOPPER_INTERACTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getShopperInteraction() {
    return shopperInteraction;
  }

  /**
   * The shopper interaction type of the payment request.  Example: Ecommerce
   *
   * @param shopperInteraction
   */
  @JsonProperty(JSON_PROPERTY_SHOPPER_INTERACTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShopperInteraction(String shopperInteraction) {
    this.shopperInteraction = shopperInteraction;
  }

  /**
   * The shopperReference passed in the payment request.  Example: AdyenTestShopperXX
   *
   * @param shopperReference
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon shopperReference(String shopperReference) {
    this.shopperReference = shopperReference;
    return this;
  }

  /**
   * The shopperReference passed in the payment request.  Example: AdyenTestShopperXX
   * @return shopperReference
   */
  @JsonProperty(JSON_PROPERTY_SHOPPER_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getShopperReference() {
    return shopperReference;
  }

  /**
   * The shopperReference passed in the payment request.  Example: AdyenTestShopperXX
   *
   * @param shopperReference
   */
  @JsonProperty(JSON_PROPERTY_SHOPPER_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShopperReference(String shopperReference) {
    this.shopperReference = shopperReference;
  }

  /**
   * The terminal ID used in a point-of-sale payment.  Example: 06022622
   *
   * @param terminalId
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon terminalId(String terminalId) {
    this.terminalId = terminalId;
    return this;
  }

  /**
   * The terminal ID used in a point-of-sale payment.  Example: 06022622
   * @return terminalId
   */
  @JsonProperty(JSON_PROPERTY_TERMINAL_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getTerminalId() {
    return terminalId;
  }

  /**
   * The terminal ID used in a point-of-sale payment.  Example: 06022622
   *
   * @param terminalId
   */
  @JsonProperty(JSON_PROPERTY_TERMINAL_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTerminalId(String terminalId) {
    this.terminalId = terminalId;
  }

  /**
   * A Boolean value indicating whether 3DS authentication was completed on this payment.  Example: true
   *
   * @param threeDAuthenticated
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon threeDAuthenticated(String threeDAuthenticated) {
    this.threeDAuthenticated = threeDAuthenticated;
    return this;
  }

  /**
   * A Boolean value indicating whether 3DS authentication was completed on this payment.  Example: true
   * @return threeDAuthenticated
   */
  @JsonProperty(JSON_PROPERTY_THREE_D_AUTHENTICATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getThreeDAuthenticated() {
    return threeDAuthenticated;
  }

  /**
   * A Boolean value indicating whether 3DS authentication was completed on this payment.  Example: true
   *
   * @param threeDAuthenticated
   */
  @JsonProperty(JSON_PROPERTY_THREE_D_AUTHENTICATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setThreeDAuthenticated(String threeDAuthenticated) {
    this.threeDAuthenticated = threeDAuthenticated;
  }

  /**
   * The raw 3DS authentication result from the card issuer.  Example: N
   *
   * @param threeDAuthenticatedResponse
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon threeDAuthenticatedResponse(String threeDAuthenticatedResponse) {
    this.threeDAuthenticatedResponse = threeDAuthenticatedResponse;
    return this;
  }

  /**
   * The raw 3DS authentication result from the card issuer.  Example: N
   * @return threeDAuthenticatedResponse
   */
  @JsonProperty(JSON_PROPERTY_THREE_D_AUTHENTICATED_RESPONSE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getThreeDAuthenticatedResponse() {
    return threeDAuthenticatedResponse;
  }

  /**
   * The raw 3DS authentication result from the card issuer.  Example: N
   *
   * @param threeDAuthenticatedResponse
   */
  @JsonProperty(JSON_PROPERTY_THREE_D_AUTHENTICATED_RESPONSE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setThreeDAuthenticatedResponse(String threeDAuthenticatedResponse) {
    this.threeDAuthenticatedResponse = threeDAuthenticatedResponse;
  }

  /**
   * A Boolean value indicating whether 3DS was offered for this payment.  Example: true
   *
   * @param threeDOffered
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon threeDOffered(String threeDOffered) {
    this.threeDOffered = threeDOffered;
    return this;
  }

  /**
   * A Boolean value indicating whether 3DS was offered for this payment.  Example: true
   * @return threeDOffered
   */
  @JsonProperty(JSON_PROPERTY_THREE_D_OFFERED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getThreeDOffered() {
    return threeDOffered;
  }

  /**
   * A Boolean value indicating whether 3DS was offered for this payment.  Example: true
   *
   * @param threeDOffered
   */
  @JsonProperty(JSON_PROPERTY_THREE_D_OFFERED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setThreeDOffered(String threeDOffered) {
    this.threeDOffered = threeDOffered;
  }

  /**
   * The raw enrollment result from the 3DS directory services of the card schemes.  Example: Y
   *
   * @param threeDOfferedResponse
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon threeDOfferedResponse(String threeDOfferedResponse) {
    this.threeDOfferedResponse = threeDOfferedResponse;
    return this;
  }

  /**
   * The raw enrollment result from the 3DS directory services of the card schemes.  Example: Y
   * @return threeDOfferedResponse
   */
  @JsonProperty(JSON_PROPERTY_THREE_D_OFFERED_RESPONSE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getThreeDOfferedResponse() {
    return threeDOfferedResponse;
  }

  /**
   * The raw enrollment result from the 3DS directory services of the card schemes.  Example: Y
   *
   * @param threeDOfferedResponse
   */
  @JsonProperty(JSON_PROPERTY_THREE_D_OFFERED_RESPONSE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setThreeDOfferedResponse(String threeDOfferedResponse) {
    this.threeDOfferedResponse = threeDOfferedResponse;
  }

  /**
   * The 3D Secure 2 version.
   *
   * @param threeDSVersion
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon threeDSVersion(String threeDSVersion) {
    this.threeDSVersion = threeDSVersion;
    return this;
  }

  /**
   * The 3D Secure 2 version.
   * @return threeDSVersion
   */
  @JsonProperty(JSON_PROPERTY_THREE_D_S_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getThreeDSVersion() {
    return threeDSVersion;
  }

  /**
   * The 3D Secure 2 version.
   *
   * @param threeDSVersion
   */
  @JsonProperty(JSON_PROPERTY_THREE_D_S_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setThreeDSVersion(String threeDSVersion) {
    this.threeDSVersion = threeDSVersion;
  }

  /**
   * The reference for the shopper that you sent when tokenizing the payment details.
   *
   * @param tokenizationShopperReference
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon tokenizationShopperReference(String tokenizationShopperReference) {
    this.tokenizationShopperReference = tokenizationShopperReference;
    return this;
  }

  /**
   * The reference for the shopper that you sent when tokenizing the payment details.
   * @return tokenizationShopperReference
   */
  @JsonProperty(JSON_PROPERTY_TOKENIZATION_SHOPPER_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getTokenizationShopperReference() {
    return tokenizationShopperReference;
  }

  /**
   * The reference for the shopper that you sent when tokenizing the payment details.
   *
   * @param tokenizationShopperReference
   */
  @JsonProperty(JSON_PROPERTY_TOKENIZATION_SHOPPER_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTokenizationShopperReference(String tokenizationShopperReference) {
    this.tokenizationShopperReference = tokenizationShopperReference;
  }

  /**
   * The operation performed on the token. Possible values:  * **created**: the token has been created. * **updated**: the existing token has been updated. * **alreadyExisting**: the details have already been stored. 
   *
   * @param tokenizationStoreOperationType
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon tokenizationStoreOperationType(TokenizationStoreOperationTypeEnum tokenizationStoreOperationType) {
    this.tokenizationStoreOperationType = tokenizationStoreOperationType;
    return this;
  }

  /**
   * The operation performed on the token. Possible values:  * **created**: the token has been created. * **updated**: the existing token has been updated. * **alreadyExisting**: the details have already been stored. 
   * @return tokenizationStoreOperationType
   */
  @JsonProperty(JSON_PROPERTY_TOKENIZATION_STORE_OPERATION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TokenizationStoreOperationTypeEnum getTokenizationStoreOperationType() {
    return tokenizationStoreOperationType;
  }

  /**
   * The operation performed on the token. Possible values:  * **created**: the token has been created. * **updated**: the existing token has been updated. * **alreadyExisting**: the details have already been stored. 
   *
   * @param tokenizationStoreOperationType
   */
  @JsonProperty(JSON_PROPERTY_TOKENIZATION_STORE_OPERATION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTokenizationStoreOperationType(TokenizationStoreOperationTypeEnum tokenizationStoreOperationType) {
    this.tokenizationStoreOperationType = tokenizationStoreOperationType;
  }

  /**
   * The reference that uniquely identifies tokenized payment details.
   *
   * @param tokenizationStoredPaymentMethodId
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon tokenizationStoredPaymentMethodId(String tokenizationStoredPaymentMethodId) {
    this.tokenizationStoredPaymentMethodId = tokenizationStoredPaymentMethodId;
    return this;
  }

  /**
   * The reference that uniquely identifies tokenized payment details.
   * @return tokenizationStoredPaymentMethodId
   */
  @JsonProperty(JSON_PROPERTY_TOKENIZATION_STORED_PAYMENT_METHOD_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getTokenizationStoredPaymentMethodId() {
    return tokenizationStoredPaymentMethodId;
  }

  /**
   * The reference that uniquely identifies tokenized payment details.
   *
   * @param tokenizationStoredPaymentMethodId
   */
  @JsonProperty(JSON_PROPERTY_TOKENIZATION_STORED_PAYMENT_METHOD_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTokenizationStoredPaymentMethodId(String tokenizationStoredPaymentMethodId) {
    this.tokenizationStoredPaymentMethodId = tokenizationStoredPaymentMethodId;
  }

  /**
   * The &#x60;visaTransactionId&#x60;, has a fixed length of 15 numeric characters.  &gt; Contact Support Team to enable this field.
   *
   * @param visaTransactionId
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon visaTransactionId(String visaTransactionId) {
    this.visaTransactionId = visaTransactionId;
    return this;
  }

  /**
   * The &#x60;visaTransactionId&#x60;, has a fixed length of 15 numeric characters.  &gt; Contact Support Team to enable this field.
   * @return visaTransactionId
   */
  @JsonProperty(JSON_PROPERTY_VISA_TRANSACTION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getVisaTransactionId() {
    return visaTransactionId;
  }

  /**
   * The &#x60;visaTransactionId&#x60;, has a fixed length of 15 numeric characters.  &gt; Contact Support Team to enable this field.
   *
   * @param visaTransactionId
   */
  @JsonProperty(JSON_PROPERTY_VISA_TRANSACTION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVisaTransactionId(String visaTransactionId) {
    this.visaTransactionId = visaTransactionId;
  }

  /**
   * The 3DS transaction ID of the 3DS session sent in notifications. The value is Base64-encoded and is returned for transactions with directoryResponse &#39;N&#39; or &#39;Y&#39;.   Example: ODgxNDc2MDg2MDExODk5MAAAAAA&#x3D;
   *
   * @param xid
   * @return the current {@code ResponseAdditionalDataCommon} instance, allowing for method chaining
   */
  public ResponseAdditionalDataCommon xid(String xid) {
    this.xid = xid;
    return this;
  }

  /**
   * The 3DS transaction ID of the 3DS session sent in notifications. The value is Base64-encoded and is returned for transactions with directoryResponse &#39;N&#39; or &#39;Y&#39;.   Example: ODgxNDc2MDg2MDExODk5MAAAAAA&#x3D;
   * @return xid
   */
  @JsonProperty(JSON_PROPERTY_XID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getXid() {
    return xid;
  }

  /**
   * The 3DS transaction ID of the 3DS session sent in notifications. The value is Base64-encoded and is returned for transactions with directoryResponse &#39;N&#39; or &#39;Y&#39;.   Example: ODgxNDc2MDg2MDExODk5MAAAAAA&#x3D;
   *
   * @param xid
   */
  @JsonProperty(JSON_PROPERTY_XID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setXid(String xid) {
    this.xid = xid;
  }

  /**
   * Return true if this ResponseAdditionalDataCommon object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ResponseAdditionalDataCommon responseAdditionalDataCommon = (ResponseAdditionalDataCommon) o;
    return Objects.equals(this.acquirerAccountCode, responseAdditionalDataCommon.acquirerAccountCode) &&
        Objects.equals(this.acquirerCode, responseAdditionalDataCommon.acquirerCode) &&
        Objects.equals(this.acquirerReference, responseAdditionalDataCommon.acquirerReference) &&
        Objects.equals(this.alias, responseAdditionalDataCommon.alias) &&
        Objects.equals(this.aliasType, responseAdditionalDataCommon.aliasType) &&
        Objects.equals(this.authCode, responseAdditionalDataCommon.authCode) &&
        Objects.equals(this.authorisationMid, responseAdditionalDataCommon.authorisationMid) &&
        Objects.equals(this.authorisedAmountCurrency, responseAdditionalDataCommon.authorisedAmountCurrency) &&
        Objects.equals(this.authorisedAmountValue, responseAdditionalDataCommon.authorisedAmountValue) &&
        Objects.equals(this.avsResult, responseAdditionalDataCommon.avsResult) &&
        Objects.equals(this.avsResultRaw, responseAdditionalDataCommon.avsResultRaw) &&
        Objects.equals(this.bic, responseAdditionalDataCommon.bic) &&
        Objects.equals(this.coBrandedWith, responseAdditionalDataCommon.coBrandedWith) &&
        Objects.equals(this.cvcResult, responseAdditionalDataCommon.cvcResult) &&
        Objects.equals(this.cvcResultRaw, responseAdditionalDataCommon.cvcResultRaw) &&
        Objects.equals(this.dsTransID, responseAdditionalDataCommon.dsTransID) &&
        Objects.equals(this.eci, responseAdditionalDataCommon.eci) &&
        Objects.equals(this.expiryDate, responseAdditionalDataCommon.expiryDate) &&
        Objects.equals(this.extraCostsCurrency, responseAdditionalDataCommon.extraCostsCurrency) &&
        Objects.equals(this.extraCostsValue, responseAdditionalDataCommon.extraCostsValue) &&
        Objects.equals(this.fraudCheckItemNrFraudCheckname, responseAdditionalDataCommon.fraudCheckItemNrFraudCheckname) &&
        Objects.equals(this.fraudManualReview, responseAdditionalDataCommon.fraudManualReview) &&
        Objects.equals(this.fraudResultType, responseAdditionalDataCommon.fraudResultType) &&
        Objects.equals(this.fundingSource, responseAdditionalDataCommon.fundingSource) &&
        Objects.equals(this.fundsAvailability, responseAdditionalDataCommon.fundsAvailability) &&
        Objects.equals(this.inferredRefusalReason, responseAdditionalDataCommon.inferredRefusalReason) &&
        Objects.equals(this.isCardCommercial, responseAdditionalDataCommon.isCardCommercial) &&
        Objects.equals(this.issuerCountry, responseAdditionalDataCommon.issuerCountry) &&
        Objects.equals(this.liabilityShift, responseAdditionalDataCommon.liabilityShift) &&
        Objects.equals(this.mcBankNetReferenceNumber, responseAdditionalDataCommon.mcBankNetReferenceNumber) &&
        Objects.equals(this.merchantAdviceCode, responseAdditionalDataCommon.merchantAdviceCode) &&
        Objects.equals(this.merchantReference, responseAdditionalDataCommon.merchantReference) &&
        Objects.equals(this.networkTxReference, responseAdditionalDataCommon.networkTxReference) &&
        Objects.equals(this.ownerName, responseAdditionalDataCommon.ownerName) &&
        Objects.equals(this.paymentAccountReference, responseAdditionalDataCommon.paymentAccountReference) &&
        Objects.equals(this.paymentMethod, responseAdditionalDataCommon.paymentMethod) &&
        Objects.equals(this.paymentMethodVariant, responseAdditionalDataCommon.paymentMethodVariant) &&
        Objects.equals(this.payoutEligible, responseAdditionalDataCommon.payoutEligible) &&
        Objects.equals(this.realtimeAccountUpdaterStatus, responseAdditionalDataCommon.realtimeAccountUpdaterStatus) &&
        Objects.equals(this.receiptFreeText, responseAdditionalDataCommon.receiptFreeText) &&
        Objects.equals(this.recurringContractTypes, responseAdditionalDataCommon.recurringContractTypes) &&
        Objects.equals(this.recurringFirstPspReference, responseAdditionalDataCommon.recurringFirstPspReference) &&
        Objects.equals(this.recurringRecurringDetailReference, responseAdditionalDataCommon.recurringRecurringDetailReference) &&
        Objects.equals(this.recurringShopperReference, responseAdditionalDataCommon.recurringShopperReference) &&
        Objects.equals(this.recurringProcessingModel, responseAdditionalDataCommon.recurringProcessingModel) &&
        Objects.equals(this.referred, responseAdditionalDataCommon.referred) &&
        Objects.equals(this.refusalReasonRaw, responseAdditionalDataCommon.refusalReasonRaw) &&
        Objects.equals(this.requestAmount, responseAdditionalDataCommon.requestAmount) &&
        Objects.equals(this.requestCurrencyCode, responseAdditionalDataCommon.requestCurrencyCode) &&
        Objects.equals(this.shopperInteraction, responseAdditionalDataCommon.shopperInteraction) &&
        Objects.equals(this.shopperReference, responseAdditionalDataCommon.shopperReference) &&
        Objects.equals(this.terminalId, responseAdditionalDataCommon.terminalId) &&
        Objects.equals(this.threeDAuthenticated, responseAdditionalDataCommon.threeDAuthenticated) &&
        Objects.equals(this.threeDAuthenticatedResponse, responseAdditionalDataCommon.threeDAuthenticatedResponse) &&
        Objects.equals(this.threeDOffered, responseAdditionalDataCommon.threeDOffered) &&
        Objects.equals(this.threeDOfferedResponse, responseAdditionalDataCommon.threeDOfferedResponse) &&
        Objects.equals(this.threeDSVersion, responseAdditionalDataCommon.threeDSVersion) &&
        Objects.equals(this.tokenizationShopperReference, responseAdditionalDataCommon.tokenizationShopperReference) &&
        Objects.equals(this.tokenizationStoreOperationType, responseAdditionalDataCommon.tokenizationStoreOperationType) &&
        Objects.equals(this.tokenizationStoredPaymentMethodId, responseAdditionalDataCommon.tokenizationStoredPaymentMethodId) &&
        Objects.equals(this.visaTransactionId, responseAdditionalDataCommon.visaTransactionId) &&
        Objects.equals(this.xid, responseAdditionalDataCommon.xid);
  }

  @Override
  public int hashCode() {
    return Objects.hash(acquirerAccountCode, acquirerCode, acquirerReference, alias, aliasType, authCode, authorisationMid, authorisedAmountCurrency, authorisedAmountValue, avsResult, avsResultRaw, bic, coBrandedWith, cvcResult, cvcResultRaw, dsTransID, eci, expiryDate, extraCostsCurrency, extraCostsValue, fraudCheckItemNrFraudCheckname, fraudManualReview, fraudResultType, fundingSource, fundsAvailability, inferredRefusalReason, isCardCommercial, issuerCountry, liabilityShift, mcBankNetReferenceNumber, merchantAdviceCode, merchantReference, networkTxReference, ownerName, paymentAccountReference, paymentMethod, paymentMethodVariant, payoutEligible, realtimeAccountUpdaterStatus, receiptFreeText, recurringContractTypes, recurringFirstPspReference, recurringRecurringDetailReference, recurringShopperReference, recurringProcessingModel, referred, refusalReasonRaw, requestAmount, requestCurrencyCode, shopperInteraction, shopperReference, terminalId, threeDAuthenticated, threeDAuthenticatedResponse, threeDOffered, threeDOfferedResponse, threeDSVersion, tokenizationShopperReference, tokenizationStoreOperationType, tokenizationStoredPaymentMethodId, visaTransactionId, xid);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ResponseAdditionalDataCommon {\n");
    sb.append("    acquirerAccountCode: ").append(toIndentedString(acquirerAccountCode)).append("\n");
    sb.append("    acquirerCode: ").append(toIndentedString(acquirerCode)).append("\n");
    sb.append("    acquirerReference: ").append(toIndentedString(acquirerReference)).append("\n");
    sb.append("    alias: ").append(toIndentedString(alias)).append("\n");
    sb.append("    aliasType: ").append(toIndentedString(aliasType)).append("\n");
    sb.append("    authCode: ").append(toIndentedString(authCode)).append("\n");
    sb.append("    authorisationMid: ").append(toIndentedString(authorisationMid)).append("\n");
    sb.append("    authorisedAmountCurrency: ").append(toIndentedString(authorisedAmountCurrency)).append("\n");
    sb.append("    authorisedAmountValue: ").append(toIndentedString(authorisedAmountValue)).append("\n");
    sb.append("    avsResult: ").append(toIndentedString(avsResult)).append("\n");
    sb.append("    avsResultRaw: ").append(toIndentedString(avsResultRaw)).append("\n");
    sb.append("    bic: ").append(toIndentedString(bic)).append("\n");
    sb.append("    coBrandedWith: ").append(toIndentedString(coBrandedWith)).append("\n");
    sb.append("    cvcResult: ").append(toIndentedString(cvcResult)).append("\n");
    sb.append("    cvcResultRaw: ").append(toIndentedString(cvcResultRaw)).append("\n");
    sb.append("    dsTransID: ").append(toIndentedString(dsTransID)).append("\n");
    sb.append("    eci: ").append(toIndentedString(eci)).append("\n");
    sb.append("    expiryDate: ").append(toIndentedString(expiryDate)).append("\n");
    sb.append("    extraCostsCurrency: ").append(toIndentedString(extraCostsCurrency)).append("\n");
    sb.append("    extraCostsValue: ").append(toIndentedString(extraCostsValue)).append("\n");
    sb.append("    fraudCheckItemNrFraudCheckname: ").append(toIndentedString(fraudCheckItemNrFraudCheckname)).append("\n");
    sb.append("    fraudManualReview: ").append(toIndentedString(fraudManualReview)).append("\n");
    sb.append("    fraudResultType: ").append(toIndentedString(fraudResultType)).append("\n");
    sb.append("    fundingSource: ").append(toIndentedString(fundingSource)).append("\n");
    sb.append("    fundsAvailability: ").append(toIndentedString(fundsAvailability)).append("\n");
    sb.append("    inferredRefusalReason: ").append(toIndentedString(inferredRefusalReason)).append("\n");
    sb.append("    isCardCommercial: ").append(toIndentedString(isCardCommercial)).append("\n");
    sb.append("    issuerCountry: ").append(toIndentedString(issuerCountry)).append("\n");
    sb.append("    liabilityShift: ").append(toIndentedString(liabilityShift)).append("\n");
    sb.append("    mcBankNetReferenceNumber: ").append(toIndentedString(mcBankNetReferenceNumber)).append("\n");
    sb.append("    merchantAdviceCode: ").append(toIndentedString(merchantAdviceCode)).append("\n");
    sb.append("    merchantReference: ").append(toIndentedString(merchantReference)).append("\n");
    sb.append("    networkTxReference: ").append(toIndentedString(networkTxReference)).append("\n");
    sb.append("    ownerName: ").append(toIndentedString(ownerName)).append("\n");
    sb.append("    paymentAccountReference: ").append(toIndentedString(paymentAccountReference)).append("\n");
    sb.append("    paymentMethod: ").append(toIndentedString(paymentMethod)).append("\n");
    sb.append("    paymentMethodVariant: ").append(toIndentedString(paymentMethodVariant)).append("\n");
    sb.append("    payoutEligible: ").append(toIndentedString(payoutEligible)).append("\n");
    sb.append("    realtimeAccountUpdaterStatus: ").append(toIndentedString(realtimeAccountUpdaterStatus)).append("\n");
    sb.append("    receiptFreeText: ").append(toIndentedString(receiptFreeText)).append("\n");
    sb.append("    recurringContractTypes: ").append(toIndentedString(recurringContractTypes)).append("\n");
    sb.append("    recurringFirstPspReference: ").append(toIndentedString(recurringFirstPspReference)).append("\n");
    sb.append("    recurringRecurringDetailReference: ").append(toIndentedString(recurringRecurringDetailReference)).append("\n");
    sb.append("    recurringShopperReference: ").append(toIndentedString(recurringShopperReference)).append("\n");
    sb.append("    recurringProcessingModel: ").append(toIndentedString(recurringProcessingModel)).append("\n");
    sb.append("    referred: ").append(toIndentedString(referred)).append("\n");
    sb.append("    refusalReasonRaw: ").append(toIndentedString(refusalReasonRaw)).append("\n");
    sb.append("    requestAmount: ").append(toIndentedString(requestAmount)).append("\n");
    sb.append("    requestCurrencyCode: ").append(toIndentedString(requestCurrencyCode)).append("\n");
    sb.append("    shopperInteraction: ").append(toIndentedString(shopperInteraction)).append("\n");
    sb.append("    shopperReference: ").append(toIndentedString(shopperReference)).append("\n");
    sb.append("    terminalId: ").append(toIndentedString(terminalId)).append("\n");
    sb.append("    threeDAuthenticated: ").append(toIndentedString(threeDAuthenticated)).append("\n");
    sb.append("    threeDAuthenticatedResponse: ").append(toIndentedString(threeDAuthenticatedResponse)).append("\n");
    sb.append("    threeDOffered: ").append(toIndentedString(threeDOffered)).append("\n");
    sb.append("    threeDOfferedResponse: ").append(toIndentedString(threeDOfferedResponse)).append("\n");
    sb.append("    threeDSVersion: ").append(toIndentedString(threeDSVersion)).append("\n");
    sb.append("    tokenizationShopperReference: ").append(toIndentedString(tokenizationShopperReference)).append("\n");
    sb.append("    tokenizationStoreOperationType: ").append(toIndentedString(tokenizationStoreOperationType)).append("\n");
    sb.append("    tokenizationStoredPaymentMethodId: ").append(toIndentedString(tokenizationStoredPaymentMethodId)).append("\n");
    sb.append("    visaTransactionId: ").append(toIndentedString(visaTransactionId)).append("\n");
    sb.append("    xid: ").append(toIndentedString(xid)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of ResponseAdditionalDataCommon given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of ResponseAdditionalDataCommon
   * @throws JsonProcessingException if the JSON string is invalid with respect to ResponseAdditionalDataCommon
   */
  public static ResponseAdditionalDataCommon fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, ResponseAdditionalDataCommon.class);
  }
/**
  * Convert an instance of ResponseAdditionalDataCommon to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
