/*
 * Legal Entity Management API
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.legalentitymanagement;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * FinancialReport
 */
@JsonPropertyOrder({
  FinancialReport.JSON_PROPERTY_ANNUAL_TURNOVER,
  FinancialReport.JSON_PROPERTY_BALANCE_SHEET_TOTAL,
  FinancialReport.JSON_PROPERTY_CURRENCY_OF_FINANCIAL_DATA,
  FinancialReport.JSON_PROPERTY_DATE_OF_FINANCIAL_DATA,
  FinancialReport.JSON_PROPERTY_EMPLOYEE_COUNT,
  FinancialReport.JSON_PROPERTY_NET_ASSETS
})

public class FinancialReport {
  public static final String JSON_PROPERTY_ANNUAL_TURNOVER = "annualTurnover";
  private String annualTurnover;

  public static final String JSON_PROPERTY_BALANCE_SHEET_TOTAL = "balanceSheetTotal";
  private String balanceSheetTotal;

  public static final String JSON_PROPERTY_CURRENCY_OF_FINANCIAL_DATA = "currencyOfFinancialData";
  private String currencyOfFinancialData;

  public static final String JSON_PROPERTY_DATE_OF_FINANCIAL_DATA = "dateOfFinancialData";
  private String dateOfFinancialData;

  public static final String JSON_PROPERTY_EMPLOYEE_COUNT = "employeeCount";
  private String employeeCount;

  public static final String JSON_PROPERTY_NET_ASSETS = "netAssets";
  private String netAssets;

  public FinancialReport() { 
  }

  /**
   * The annual turnover of the business.
   *
   * @param annualTurnover
   * @return the current {@code FinancialReport} instance, allowing for method chaining
   */
  public FinancialReport annualTurnover(String annualTurnover) {
    this.annualTurnover = annualTurnover;
    return this;
  }

  /**
   * The annual turnover of the business.
   * @return annualTurnover
   */
  @JsonProperty(JSON_PROPERTY_ANNUAL_TURNOVER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getAnnualTurnover() {
    return annualTurnover;
  }

  /**
   * The annual turnover of the business.
   *
   * @param annualTurnover
   */
  @JsonProperty(JSON_PROPERTY_ANNUAL_TURNOVER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAnnualTurnover(String annualTurnover) {
    this.annualTurnover = annualTurnover;
  }

  /**
   * The balance sheet total of the business.
   *
   * @param balanceSheetTotal
   * @return the current {@code FinancialReport} instance, allowing for method chaining
   */
  public FinancialReport balanceSheetTotal(String balanceSheetTotal) {
    this.balanceSheetTotal = balanceSheetTotal;
    return this;
  }

  /**
   * The balance sheet total of the business.
   * @return balanceSheetTotal
   */
  @JsonProperty(JSON_PROPERTY_BALANCE_SHEET_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getBalanceSheetTotal() {
    return balanceSheetTotal;
  }

  /**
   * The balance sheet total of the business.
   *
   * @param balanceSheetTotal
   */
  @JsonProperty(JSON_PROPERTY_BALANCE_SHEET_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBalanceSheetTotal(String balanceSheetTotal) {
    this.balanceSheetTotal = balanceSheetTotal;
  }

  /**
   * The currency used for the net assets and balance sheet total.
   *
   * @param currencyOfFinancialData
   * @return the current {@code FinancialReport} instance, allowing for method chaining
   */
  public FinancialReport currencyOfFinancialData(String currencyOfFinancialData) {
    this.currencyOfFinancialData = currencyOfFinancialData;
    return this;
  }

  /**
   * The currency used for the net assets and balance sheet total.
   * @return currencyOfFinancialData
   */
  @JsonProperty(JSON_PROPERTY_CURRENCY_OF_FINANCIAL_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCurrencyOfFinancialData() {
    return currencyOfFinancialData;
  }

  /**
   * The currency used for the net assets and balance sheet total.
   *
   * @param currencyOfFinancialData
   */
  @JsonProperty(JSON_PROPERTY_CURRENCY_OF_FINANCIAL_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrencyOfFinancialData(String currencyOfFinancialData) {
    this.currencyOfFinancialData = currencyOfFinancialData;
  }

  /**
   * The date the financial data were provided, in YYYY-MM-DD format.
   *
   * @param dateOfFinancialData
   * @return the current {@code FinancialReport} instance, allowing for method chaining
   */
  public FinancialReport dateOfFinancialData(String dateOfFinancialData) {
    this.dateOfFinancialData = dateOfFinancialData;
    return this;
  }

  /**
   * The date the financial data were provided, in YYYY-MM-DD format.
   * @return dateOfFinancialData
   */
  @JsonProperty(JSON_PROPERTY_DATE_OF_FINANCIAL_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDateOfFinancialData() {
    return dateOfFinancialData;
  }

  /**
   * The date the financial data were provided, in YYYY-MM-DD format.
   *
   * @param dateOfFinancialData
   */
  @JsonProperty(JSON_PROPERTY_DATE_OF_FINANCIAL_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDateOfFinancialData(String dateOfFinancialData) {
    this.dateOfFinancialData = dateOfFinancialData;
  }

  /**
   * The number of employees of the business.
   *
   * @param employeeCount
   * @return the current {@code FinancialReport} instance, allowing for method chaining
   */
  public FinancialReport employeeCount(String employeeCount) {
    this.employeeCount = employeeCount;
    return this;
  }

  /**
   * The number of employees of the business.
   * @return employeeCount
   */
  @JsonProperty(JSON_PROPERTY_EMPLOYEE_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getEmployeeCount() {
    return employeeCount;
  }

  /**
   * The number of employees of the business.
   *
   * @param employeeCount
   */
  @JsonProperty(JSON_PROPERTY_EMPLOYEE_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEmployeeCount(String employeeCount) {
    this.employeeCount = employeeCount;
  }

  /**
   * The net assets of the business.
   *
   * @param netAssets
   * @return the current {@code FinancialReport} instance, allowing for method chaining
   */
  public FinancialReport netAssets(String netAssets) {
    this.netAssets = netAssets;
    return this;
  }

  /**
   * The net assets of the business.
   * @return netAssets
   */
  @JsonProperty(JSON_PROPERTY_NET_ASSETS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getNetAssets() {
    return netAssets;
  }

  /**
   * The net assets of the business.
   *
   * @param netAssets
   */
  @JsonProperty(JSON_PROPERTY_NET_ASSETS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetAssets(String netAssets) {
    this.netAssets = netAssets;
  }

  /**
   * Return true if this FinancialReport object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FinancialReport financialReport = (FinancialReport) o;
    return Objects.equals(this.annualTurnover, financialReport.annualTurnover) &&
        Objects.equals(this.balanceSheetTotal, financialReport.balanceSheetTotal) &&
        Objects.equals(this.currencyOfFinancialData, financialReport.currencyOfFinancialData) &&
        Objects.equals(this.dateOfFinancialData, financialReport.dateOfFinancialData) &&
        Objects.equals(this.employeeCount, financialReport.employeeCount) &&
        Objects.equals(this.netAssets, financialReport.netAssets);
  }

  @Override
  public int hashCode() {
    return Objects.hash(annualTurnover, balanceSheetTotal, currencyOfFinancialData, dateOfFinancialData, employeeCount, netAssets);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FinancialReport {\n");
    sb.append("    annualTurnover: ").append(toIndentedString(annualTurnover)).append("\n");
    sb.append("    balanceSheetTotal: ").append(toIndentedString(balanceSheetTotal)).append("\n");
    sb.append("    currencyOfFinancialData: ").append(toIndentedString(currencyOfFinancialData)).append("\n");
    sb.append("    dateOfFinancialData: ").append(toIndentedString(dateOfFinancialData)).append("\n");
    sb.append("    employeeCount: ").append(toIndentedString(employeeCount)).append("\n");
    sb.append("    netAssets: ").append(toIndentedString(netAssets)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of FinancialReport given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of FinancialReport
   * @throws JsonProcessingException if the JSON string is invalid with respect to FinancialReport
   */
  public static FinancialReport fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, FinancialReport.class);
  }
/**
  * Convert an instance of FinancialReport to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
