/*
 * Legal Entity Management API
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.legalentitymanagement;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.legalentitymanagement.Address;
import com.adyen.model.legalentitymanagement.BirthData;
import com.adyen.model.legalentitymanagement.IdentificationData;
import com.adyen.model.legalentitymanagement.Name;
import com.adyen.model.legalentitymanagement.PhoneNumber;
import com.adyen.model.legalentitymanagement.TaxInformation;
import com.adyen.model.legalentitymanagement.WebData;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * Individual
 */
@JsonPropertyOrder({
  Individual.JSON_PROPERTY_BIRTH_DATA,
  Individual.JSON_PROPERTY_EMAIL,
  Individual.JSON_PROPERTY_IDENTIFICATION_DATA,
  Individual.JSON_PROPERTY_NAME,
  Individual.JSON_PROPERTY_NATIONALITY,
  Individual.JSON_PROPERTY_PHONE,
  Individual.JSON_PROPERTY_RESIDENTIAL_ADDRESS,
  Individual.JSON_PROPERTY_TAX_INFORMATION,
  Individual.JSON_PROPERTY_WEB_DATA
})

public class Individual {
  public static final String JSON_PROPERTY_BIRTH_DATA = "birthData";
  private BirthData birthData;

  public static final String JSON_PROPERTY_EMAIL = "email";
  private String email;

  public static final String JSON_PROPERTY_IDENTIFICATION_DATA = "identificationData";
  private IdentificationData identificationData;

  public static final String JSON_PROPERTY_NAME = "name";
  private Name name;

  public static final String JSON_PROPERTY_NATIONALITY = "nationality";
  private String nationality;

  public static final String JSON_PROPERTY_PHONE = "phone";
  private PhoneNumber phone;

  public static final String JSON_PROPERTY_RESIDENTIAL_ADDRESS = "residentialAddress";
  private Address residentialAddress;

  public static final String JSON_PROPERTY_TAX_INFORMATION = "taxInformation";
  private List<TaxInformation> taxInformation = new ArrayList<>();

  public static final String JSON_PROPERTY_WEB_DATA = "webData";
  private WebData webData;

  public Individual() { 
  }

  /**
   * birthData
   *
   * @param birthData
   * @return the current {@code Individual} instance, allowing for method chaining
   */
  public Individual birthData(BirthData birthData) {
    this.birthData = birthData;
    return this;
  }

  /**
   * Get birthData
   * @return birthData
   */
  @JsonProperty(JSON_PROPERTY_BIRTH_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public BirthData getBirthData() {
    return birthData;
  }

  /**
   * birthData
   *
   * @param birthData
   */
  @JsonProperty(JSON_PROPERTY_BIRTH_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBirthData(BirthData birthData) {
    this.birthData = birthData;
  }

  /**
   * The email address of the legal entity.
   *
   * @param email
   * @return the current {@code Individual} instance, allowing for method chaining
   */
  public Individual email(String email) {
    this.email = email;
    return this;
  }

  /**
   * The email address of the legal entity.
   * @return email
   */
  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getEmail() {
    return email;
  }

  /**
   * The email address of the legal entity.
   *
   * @param email
   */
  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEmail(String email) {
    this.email = email;
  }

  /**
   * identificationData
   *
   * @param identificationData
   * @return the current {@code Individual} instance, allowing for method chaining
   */
  public Individual identificationData(IdentificationData identificationData) {
    this.identificationData = identificationData;
    return this;
  }

  /**
   * Get identificationData
   * @return identificationData
   */
  @JsonProperty(JSON_PROPERTY_IDENTIFICATION_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public IdentificationData getIdentificationData() {
    return identificationData;
  }

  /**
   * identificationData
   *
   * @param identificationData
   */
  @JsonProperty(JSON_PROPERTY_IDENTIFICATION_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdentificationData(IdentificationData identificationData) {
    this.identificationData = identificationData;
  }

  /**
   * name
   *
   * @param name
   * @return the current {@code Individual} instance, allowing for method chaining
   */
  public Individual name(Name name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
   */
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Name getName() {
    return name;
  }

  /**
   * name
   *
   * @param name
   */
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(Name name) {
    this.name = name;
  }

  /**
   * The individual&#39;s nationality.
   *
   * @param nationality
   * @return the current {@code Individual} instance, allowing for method chaining
   */
  public Individual nationality(String nationality) {
    this.nationality = nationality;
    return this;
  }

  /**
   * The individual&#39;s nationality.
   * @return nationality
   */
  @JsonProperty(JSON_PROPERTY_NATIONALITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getNationality() {
    return nationality;
  }

  /**
   * The individual&#39;s nationality.
   *
   * @param nationality
   */
  @JsonProperty(JSON_PROPERTY_NATIONALITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNationality(String nationality) {
    this.nationality = nationality;
  }

  /**
   * phone
   *
   * @param phone
   * @return the current {@code Individual} instance, allowing for method chaining
   */
  public Individual phone(PhoneNumber phone) {
    this.phone = phone;
    return this;
  }

  /**
   * Get phone
   * @return phone
   */
  @JsonProperty(JSON_PROPERTY_PHONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public PhoneNumber getPhone() {
    return phone;
  }

  /**
   * phone
   *
   * @param phone
   */
  @JsonProperty(JSON_PROPERTY_PHONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPhone(PhoneNumber phone) {
    this.phone = phone;
  }

  /**
   * residentialAddress
   *
   * @param residentialAddress
   * @return the current {@code Individual} instance, allowing for method chaining
   */
  public Individual residentialAddress(Address residentialAddress) {
    this.residentialAddress = residentialAddress;
    return this;
  }

  /**
   * Get residentialAddress
   * @return residentialAddress
   */
  @JsonProperty(JSON_PROPERTY_RESIDENTIAL_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Address getResidentialAddress() {
    return residentialAddress;
  }

  /**
   * residentialAddress
   *
   * @param residentialAddress
   */
  @JsonProperty(JSON_PROPERTY_RESIDENTIAL_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setResidentialAddress(Address residentialAddress) {
    this.residentialAddress = residentialAddress;
  }

  /**
   * The tax information of the individual.
   *
   * @param taxInformation
   * @return the current {@code Individual} instance, allowing for method chaining
   */
  public Individual taxInformation(List<TaxInformation> taxInformation) {
    this.taxInformation = taxInformation;
    return this;
  }

  public Individual addTaxInformationItem(TaxInformation taxInformationItem) {
    if (this.taxInformation == null) {
      this.taxInformation = new ArrayList<>();
    }
    this.taxInformation.add(taxInformationItem);
    return this;
  }

  /**
   * The tax information of the individual.
   * @return taxInformation
   */
  @JsonProperty(JSON_PROPERTY_TAX_INFORMATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<TaxInformation> getTaxInformation() {
    return taxInformation;
  }

  /**
   * The tax information of the individual.
   *
   * @param taxInformation
   */
  @JsonProperty(JSON_PROPERTY_TAX_INFORMATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTaxInformation(List<TaxInformation> taxInformation) {
    this.taxInformation = taxInformation;
  }

  /**
   * webData
   *
   * @param webData
   * @return the current {@code Individual} instance, allowing for method chaining
   */
  public Individual webData(WebData webData) {
    this.webData = webData;
    return this;
  }

  /**
   * Get webData
   * @return webData
   */
  @JsonProperty(JSON_PROPERTY_WEB_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public WebData getWebData() {
    return webData;
  }

  /**
   * webData
   *
   * @param webData
   */
  @JsonProperty(JSON_PROPERTY_WEB_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWebData(WebData webData) {
    this.webData = webData;
  }

  /**
   * Return true if this Individual object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Individual individual = (Individual) o;
    return Objects.equals(this.birthData, individual.birthData) &&
        Objects.equals(this.email, individual.email) &&
        Objects.equals(this.identificationData, individual.identificationData) &&
        Objects.equals(this.name, individual.name) &&
        Objects.equals(this.nationality, individual.nationality) &&
        Objects.equals(this.phone, individual.phone) &&
        Objects.equals(this.residentialAddress, individual.residentialAddress) &&
        Objects.equals(this.taxInformation, individual.taxInformation) &&
        Objects.equals(this.webData, individual.webData);
  }

  @Override
  public int hashCode() {
    return Objects.hash(birthData, email, identificationData, name, nationality, phone, residentialAddress, taxInformation, webData);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Individual {\n");
    sb.append("    birthData: ").append(toIndentedString(birthData)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    identificationData: ").append(toIndentedString(identificationData)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    nationality: ").append(toIndentedString(nationality)).append("\n");
    sb.append("    phone: ").append(toIndentedString(phone)).append("\n");
    sb.append("    residentialAddress: ").append(toIndentedString(residentialAddress)).append("\n");
    sb.append("    taxInformation: ").append(toIndentedString(taxInformation)).append("\n");
    sb.append("    webData: ").append(toIndentedString(webData)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of Individual given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of Individual
   * @throws JsonProcessingException if the JSON string is invalid with respect to Individual
   */
  public static Individual fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, Individual.class);
  }
/**
  * Convert an instance of Individual to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
