/*
 * Legal Entity Management API
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.legalentitymanagement;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * SupportingEntityCapability
 */
@JsonPropertyOrder({
  SupportingEntityCapability.JSON_PROPERTY_ALLOWED,
  SupportingEntityCapability.JSON_PROPERTY_ID,
  SupportingEntityCapability.JSON_PROPERTY_REQUESTED,
  SupportingEntityCapability.JSON_PROPERTY_VERIFICATION_STATUS
})

public class SupportingEntityCapability {
  public static final String JSON_PROPERTY_ALLOWED = "allowed";
  private Boolean allowed;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_REQUESTED = "requested";
  private Boolean requested;

  public static final String JSON_PROPERTY_VERIFICATION_STATUS = "verificationStatus";
  private String verificationStatus;

  public SupportingEntityCapability() { 
  }

  @JsonCreator
  public SupportingEntityCapability(
    @JsonProperty(JSON_PROPERTY_ALLOWED) Boolean allowed, 
    @JsonProperty(JSON_PROPERTY_ID) String id, 
    @JsonProperty(JSON_PROPERTY_REQUESTED) Boolean requested, 
    @JsonProperty(JSON_PROPERTY_VERIFICATION_STATUS) String verificationStatus
  ) {
    this();
    this.allowed = allowed;
    this.id = id;
    this.requested = requested;
    this.verificationStatus = verificationStatus;
  }

  /**
   * Indicates whether the capability is allowed for the supporting entity.  If a capability is allowed for a supporting entity but not for the parent legal entity, this means the legal entity has other supporting entities that failed verification.  **You can use the allowed supporting entity** regardless of the verification status of other supporting entities.
   * @return allowed
   */
  @JsonProperty(JSON_PROPERTY_ALLOWED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getAllowed() {
    return allowed;
  }


  /**
   * Supporting entity reference 
   * @return id
   */
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getId() {
    return id;
  }


  /**
   * Indicates whether the supporting entity capability is requested. 
   * @return requested
   */
  @JsonProperty(JSON_PROPERTY_REQUESTED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getRequested() {
    return requested;
  }


  /**
   * The status of the verification checks for the capability of the supporting entity.  Possible values:  * **pending**: Adyen is running the verification.  * **invalid**: The verification failed. Check if the &#x60;errors&#x60; array contains more information.  * **valid**: The verification has been successfully completed.  * **rejected**: Adyen has verified the information, but found reasons to not allow the capability. 
   * @return verificationStatus
   */
  @JsonProperty(JSON_PROPERTY_VERIFICATION_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getVerificationStatus() {
    return verificationStatus;
  }


  /**
   * Return true if this SupportingEntityCapability object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SupportingEntityCapability supportingEntityCapability = (SupportingEntityCapability) o;
    return Objects.equals(this.allowed, supportingEntityCapability.allowed) &&
        Objects.equals(this.id, supportingEntityCapability.id) &&
        Objects.equals(this.requested, supportingEntityCapability.requested) &&
        Objects.equals(this.verificationStatus, supportingEntityCapability.verificationStatus);
  }

  @Override
  public int hashCode() {
    return Objects.hash(allowed, id, requested, verificationStatus);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SupportingEntityCapability {\n");
    sb.append("    allowed: ").append(toIndentedString(allowed)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    requested: ").append(toIndentedString(requested)).append("\n");
    sb.append("    verificationStatus: ").append(toIndentedString(verificationStatus)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of SupportingEntityCapability given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of SupportingEntityCapability
   * @throws JsonProcessingException if the JSON string is invalid with respect to SupportingEntityCapability
   */
  public static SupportingEntityCapability fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, SupportingEntityCapability.class);
  }
/**
  * Convert an instance of SupportingEntityCapability to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
