/*
 * Legal Entity Management API
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.legalentitymanagement;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * VerificationDeadline
 */
@JsonPropertyOrder({
  VerificationDeadline.JSON_PROPERTY_CAPABILITIES,
  VerificationDeadline.JSON_PROPERTY_ENTITY_IDS,
  VerificationDeadline.JSON_PROPERTY_EXPIRES_AT
})

public class VerificationDeadline {
  /**
   * Gets or Sets capabilities
   */
  public enum CapabilitiesEnum {
    ACCEPTEXTERNALFUNDING(String.valueOf("acceptExternalFunding")),
    
    ACCEPTPSPFUNDING(String.valueOf("acceptPspFunding")),
    
    ACCEPTTRANSACTIONINRESTRICTEDCOUNTRIES(String.valueOf("acceptTransactionInRestrictedCountries")),
    
    ACCEPTTRANSACTIONINRESTRICTEDCOUNTRIESCOMMERCIAL(String.valueOf("acceptTransactionInRestrictedCountriesCommercial")),
    
    ACCEPTTRANSACTIONINRESTRICTEDCOUNTRIESCONSUMER(String.valueOf("acceptTransactionInRestrictedCountriesConsumer")),
    
    ACCEPTTRANSACTIONINRESTRICTEDINDUSTRIES(String.valueOf("acceptTransactionInRestrictedIndustries")),
    
    ACCEPTTRANSACTIONINRESTRICTEDINDUSTRIESCOMMERCIAL(String.valueOf("acceptTransactionInRestrictedIndustriesCommercial")),
    
    ACCEPTTRANSACTIONINRESTRICTEDINDUSTRIESCONSUMER(String.valueOf("acceptTransactionInRestrictedIndustriesConsumer")),
    
    ACQUIRING(String.valueOf("acquiring")),
    
    ATMWITHDRAWAL(String.valueOf("atmWithdrawal")),
    
    ATMWITHDRAWALCOMMERCIAL(String.valueOf("atmWithdrawalCommercial")),
    
    ATMWITHDRAWALCONSUMER(String.valueOf("atmWithdrawalConsumer")),
    
    ATMWITHDRAWALINRESTRICTEDCOUNTRIES(String.valueOf("atmWithdrawalInRestrictedCountries")),
    
    ATMWITHDRAWALINRESTRICTEDCOUNTRIESCOMMERCIAL(String.valueOf("atmWithdrawalInRestrictedCountriesCommercial")),
    
    ATMWITHDRAWALINRESTRICTEDCOUNTRIESCONSUMER(String.valueOf("atmWithdrawalInRestrictedCountriesConsumer")),
    
    AUTHORISEDPAYMENTINSTRUMENTUSER(String.valueOf("authorisedPaymentInstrumentUser")),
    
    GETGRANTOFFERS(String.valueOf("getGrantOffers")),
    
    ISSUEBANKACCOUNT(String.valueOf("issueBankAccount")),
    
    ISSUECARD(String.valueOf("issueCard")),
    
    ISSUECARDCOMMERCIAL(String.valueOf("issueCardCommercial")),
    
    ISSUECARDCONSUMER(String.valueOf("issueCardConsumer")),
    
    ISSUECHARGECARD(String.valueOf("issueChargeCard")),
    
    ISSUECHARGECARDCOMMERCIAL(String.valueOf("issueChargeCardCommercial")),
    
    ISSUECREDITLIMIT(String.valueOf("issueCreditLimit")),
    
    LOCALACCEPTANCE(String.valueOf("localAcceptance")),
    
    PAYOUT(String.valueOf("payout")),
    
    PAYOUTTOTRANSFERINSTRUMENT(String.valueOf("payoutToTransferInstrument")),
    
    PROCESSING(String.valueOf("processing")),
    
    RECEIVEFROMBALANCEACCOUNT(String.valueOf("receiveFromBalanceAccount")),
    
    RECEIVEFROMPLATFORMPAYMENTS(String.valueOf("receiveFromPlatformPayments")),
    
    RECEIVEFROMTHIRDPARTY(String.valueOf("receiveFromThirdParty")),
    
    RECEIVEFROMTRANSFERINSTRUMENT(String.valueOf("receiveFromTransferInstrument")),
    
    RECEIVEGRANTS(String.valueOf("receiveGrants")),
    
    RECEIVEPAYMENTS(String.valueOf("receivePayments")),
    
    SENDTOBALANCEACCOUNT(String.valueOf("sendToBalanceAccount")),
    
    SENDTOTHIRDPARTY(String.valueOf("sendToThirdParty")),
    
    SENDTOTRANSFERINSTRUMENT(String.valueOf("sendToTransferInstrument")),
    
    THIRDPARTYFUNDING(String.valueOf("thirdPartyFunding")),
    
    USECARD(String.valueOf("useCard")),
    
    USECARDCOMMERCIAL(String.valueOf("useCardCommercial")),
    
    USECARDCONSUMER(String.valueOf("useCardConsumer")),
    
    USECARDINRESTRICTEDCOUNTRIES(String.valueOf("useCardInRestrictedCountries")),
    
    USECARDINRESTRICTEDCOUNTRIESCOMMERCIAL(String.valueOf("useCardInRestrictedCountriesCommercial")),
    
    USECARDINRESTRICTEDCOUNTRIESCONSUMER(String.valueOf("useCardInRestrictedCountriesConsumer")),
    
    USECARDINRESTRICTEDINDUSTRIES(String.valueOf("useCardInRestrictedIndustries")),
    
    USECARDINRESTRICTEDINDUSTRIESCOMMERCIAL(String.valueOf("useCardInRestrictedIndustriesCommercial")),
    
    USECARDINRESTRICTEDINDUSTRIESCONSUMER(String.valueOf("useCardInRestrictedIndustriesConsumer")),
    
    USECHARGECARD(String.valueOf("useChargeCard")),
    
    USECHARGECARDCOMMERCIAL(String.valueOf("useChargeCardCommercial")),
    
    WITHDRAWFROMATM(String.valueOf("withdrawFromAtm")),
    
    WITHDRAWFROMATMCOMMERCIAL(String.valueOf("withdrawFromAtmCommercial")),
    
    WITHDRAWFROMATMCONSUMER(String.valueOf("withdrawFromAtmConsumer")),
    
    WITHDRAWFROMATMINRESTRICTEDCOUNTRIES(String.valueOf("withdrawFromAtmInRestrictedCountries")),
    
    WITHDRAWFROMATMINRESTRICTEDCOUNTRIESCOMMERCIAL(String.valueOf("withdrawFromAtmInRestrictedCountriesCommercial")),
    
    WITHDRAWFROMATMINRESTRICTEDCOUNTRIESCONSUMER(String.valueOf("withdrawFromAtmInRestrictedCountriesConsumer"));

    private String value;

    CapabilitiesEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CapabilitiesEnum fromValue(String value) {
      for (CapabilitiesEnum b : CapabilitiesEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CAPABILITIES = "capabilities";
  private List<CapabilitiesEnum> capabilities = new ArrayList<>();

  public static final String JSON_PROPERTY_ENTITY_IDS = "entityIds";
  private List<String> entityIds = new ArrayList<>();

  public static final String JSON_PROPERTY_EXPIRES_AT = "expiresAt";
  private OffsetDateTime expiresAt;

  public VerificationDeadline() { 
  }

  @JsonCreator
  public VerificationDeadline(
    @JsonProperty(JSON_PROPERTY_CAPABILITIES) List<CapabilitiesEnum> capabilities, 
    @JsonProperty(JSON_PROPERTY_ENTITY_IDS) List<String> entityIds, 
    @JsonProperty(JSON_PROPERTY_EXPIRES_AT) OffsetDateTime expiresAt
  ) {
    this();
    this.capabilities = capabilities;
    this.entityIds = entityIds;
    this.expiresAt = expiresAt;
  }

  /**
   * The list of capabilities that will be disallowed if information is not reviewed by the time of the deadline
   * @return capabilities
   */
  @JsonProperty(JSON_PROPERTY_CAPABILITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<CapabilitiesEnum> getCapabilities() {
    return capabilities;
  }


  /**
   * The unique identifiers of the legal entity or supporting entities that the deadline applies to
   * @return entityIds
   */
  @JsonProperty(JSON_PROPERTY_ENTITY_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getEntityIds() {
    return entityIds;
  }


  /**
   * The date that verification is due by before capabilities are disallowed.
   * @return expiresAt
   */
  @JsonProperty(JSON_PROPERTY_EXPIRES_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OffsetDateTime getExpiresAt() {
    return expiresAt;
  }


  /**
   * Return true if this VerificationDeadline object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    VerificationDeadline verificationDeadline = (VerificationDeadline) o;
    return Objects.equals(this.capabilities, verificationDeadline.capabilities) &&
        Objects.equals(this.entityIds, verificationDeadline.entityIds) &&
        Objects.equals(this.expiresAt, verificationDeadline.expiresAt);
  }

  @Override
  public int hashCode() {
    return Objects.hash(capabilities, entityIds, expiresAt);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class VerificationDeadline {\n");
    sb.append("    capabilities: ").append(toIndentedString(capabilities)).append("\n");
    sb.append("    entityIds: ").append(toIndentedString(entityIds)).append("\n");
    sb.append("    expiresAt: ").append(toIndentedString(expiresAt)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of VerificationDeadline given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of VerificationDeadline
   * @throws JsonProcessingException if the JSON string is invalid with respect to VerificationDeadline
   */
  public static VerificationDeadline fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, VerificationDeadline.class);
  }
/**
  * Convert an instance of VerificationDeadline to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
