/*
 * Management API
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.management;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * PayToInfo
 */
@JsonPropertyOrder({
  PayToInfo.JSON_PROPERTY_MERCHANT_NAME,
  PayToInfo.JSON_PROPERTY_PAY_TO_PURPOSE
})

public class PayToInfo {
  public static final String JSON_PROPERTY_MERCHANT_NAME = "merchantName";
  private String merchantName;

  public static final String JSON_PROPERTY_PAY_TO_PURPOSE = "payToPurpose";
  private String payToPurpose;

  public PayToInfo() { 
  }

  /**
   * Merchant name displayed to the shopper in the Agreements
   *
   * @param merchantName
   * @return the current {@code PayToInfo} instance, allowing for method chaining
   */
  public PayToInfo merchantName(String merchantName) {
    this.merchantName = merchantName;
    return this;
  }

  /**
   * Merchant name displayed to the shopper in the Agreements
   * @return merchantName
   */
  @ApiModelProperty(required = true, value = "Merchant name displayed to the shopper in the Agreements")
  @JsonProperty(JSON_PROPERTY_MERCHANT_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMerchantName() {
    return merchantName;
  }

  /**
   * Merchant name displayed to the shopper in the Agreements
   *
   * @param merchantName
   */ 
  @JsonProperty(JSON_PROPERTY_MERCHANT_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMerchantName(String merchantName) {
    this.merchantName = merchantName;
  }

  /**
   * Represents the purpose of the Agreements created, it relates to the business type **Allowed values**: mortgage, utility, loan, gambling, retail, salary, personal, government, pension, tax, other
   *
   * @param payToPurpose
   * @return the current {@code PayToInfo} instance, allowing for method chaining
   */
  public PayToInfo payToPurpose(String payToPurpose) {
    this.payToPurpose = payToPurpose;
    return this;
  }

  /**
   * Represents the purpose of the Agreements created, it relates to the business type **Allowed values**: mortgage, utility, loan, gambling, retail, salary, personal, government, pension, tax, other
   * @return payToPurpose
   */
  @ApiModelProperty(required = true, value = "Represents the purpose of the Agreements created, it relates to the business type **Allowed values**: mortgage, utility, loan, gambling, retail, salary, personal, government, pension, tax, other")
  @JsonProperty(JSON_PROPERTY_PAY_TO_PURPOSE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getPayToPurpose() {
    return payToPurpose;
  }

  /**
   * Represents the purpose of the Agreements created, it relates to the business type **Allowed values**: mortgage, utility, loan, gambling, retail, salary, personal, government, pension, tax, other
   *
   * @param payToPurpose
   */ 
  @JsonProperty(JSON_PROPERTY_PAY_TO_PURPOSE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPayToPurpose(String payToPurpose) {
    this.payToPurpose = payToPurpose;
  }

  /**
   * Return true if this PayToInfo object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PayToInfo payToInfo = (PayToInfo) o;
    return Objects.equals(this.merchantName, payToInfo.merchantName) &&
        Objects.equals(this.payToPurpose, payToInfo.payToPurpose);
  }

  @Override
  public int hashCode() {
    return Objects.hash(merchantName, payToPurpose);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PayToInfo {\n");
    sb.append("    merchantName: ").append(toIndentedString(merchantName)).append("\n");
    sb.append("    payToPurpose: ").append(toIndentedString(payToPurpose)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of PayToInfo given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of PayToInfo
   * @throws JsonProcessingException if the JSON string is invalid with respect to PayToInfo
   */
  public static PayToInfo fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, PayToInfo.class);
  }
/**
  * Convert an instance of PayToInfo to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
