/*
 * Adyen Payment API
 *
 * The version of the OpenAPI document: 68
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.payment;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * AdditionalDataCarRental
 */
@JsonPropertyOrder({
  AdditionalDataCarRental.JSON_PROPERTY_CAR_RENTAL_CHECK_OUT_DATE,
  AdditionalDataCarRental.JSON_PROPERTY_CAR_RENTAL_CUSTOMER_SERVICE_TOLL_FREE_NUMBER,
  AdditionalDataCarRental.JSON_PROPERTY_CAR_RENTAL_DAYS_RENTED,
  AdditionalDataCarRental.JSON_PROPERTY_CAR_RENTAL_FUEL_CHARGES,
  AdditionalDataCarRental.JSON_PROPERTY_CAR_RENTAL_INSURANCE_CHARGES,
  AdditionalDataCarRental.JSON_PROPERTY_CAR_RENTAL_LOCATION_CITY,
  AdditionalDataCarRental.JSON_PROPERTY_CAR_RENTAL_LOCATION_COUNTRY,
  AdditionalDataCarRental.JSON_PROPERTY_CAR_RENTAL_LOCATION_STATE_PROVINCE,
  AdditionalDataCarRental.JSON_PROPERTY_CAR_RENTAL_NO_SHOW_INDICATOR,
  AdditionalDataCarRental.JSON_PROPERTY_CAR_RENTAL_ONE_WAY_DROP_OFF_CHARGES,
  AdditionalDataCarRental.JSON_PROPERTY_CAR_RENTAL_RATE,
  AdditionalDataCarRental.JSON_PROPERTY_CAR_RENTAL_RATE_INDICATOR,
  AdditionalDataCarRental.JSON_PROPERTY_CAR_RENTAL_RENTAL_AGREEMENT_NUMBER,
  AdditionalDataCarRental.JSON_PROPERTY_CAR_RENTAL_RENTAL_CLASS_ID,
  AdditionalDataCarRental.JSON_PROPERTY_CAR_RENTAL_RENTER_NAME,
  AdditionalDataCarRental.JSON_PROPERTY_CAR_RENTAL_RETURN_CITY,
  AdditionalDataCarRental.JSON_PROPERTY_CAR_RENTAL_RETURN_COUNTRY,
  AdditionalDataCarRental.JSON_PROPERTY_CAR_RENTAL_RETURN_DATE,
  AdditionalDataCarRental.JSON_PROPERTY_CAR_RENTAL_RETURN_LOCATION_ID,
  AdditionalDataCarRental.JSON_PROPERTY_CAR_RENTAL_RETURN_STATE_PROVINCE,
  AdditionalDataCarRental.JSON_PROPERTY_CAR_RENTAL_TAX_EXEMPT_INDICATOR,
  AdditionalDataCarRental.JSON_PROPERTY_TRAVEL_ENTERTAINMENT_AUTH_DATA_DURATION,
  AdditionalDataCarRental.JSON_PROPERTY_TRAVEL_ENTERTAINMENT_AUTH_DATA_MARKET
})

public class AdditionalDataCarRental {
  public static final String JSON_PROPERTY_CAR_RENTAL_CHECK_OUT_DATE = "carRental.checkOutDate";
  private String carRentalCheckOutDate;

  public static final String JSON_PROPERTY_CAR_RENTAL_CUSTOMER_SERVICE_TOLL_FREE_NUMBER = "carRental.customerServiceTollFreeNumber";
  private String carRentalCustomerServiceTollFreeNumber;

  public static final String JSON_PROPERTY_CAR_RENTAL_DAYS_RENTED = "carRental.daysRented";
  private String carRentalDaysRented;

  public static final String JSON_PROPERTY_CAR_RENTAL_FUEL_CHARGES = "carRental.fuelCharges";
  private String carRentalFuelCharges;

  public static final String JSON_PROPERTY_CAR_RENTAL_INSURANCE_CHARGES = "carRental.insuranceCharges";
  private String carRentalInsuranceCharges;

  public static final String JSON_PROPERTY_CAR_RENTAL_LOCATION_CITY = "carRental.locationCity";
  private String carRentalLocationCity;

  public static final String JSON_PROPERTY_CAR_RENTAL_LOCATION_COUNTRY = "carRental.locationCountry";
  private String carRentalLocationCountry;

  public static final String JSON_PROPERTY_CAR_RENTAL_LOCATION_STATE_PROVINCE = "carRental.locationStateProvince";
  private String carRentalLocationStateProvince;

  public static final String JSON_PROPERTY_CAR_RENTAL_NO_SHOW_INDICATOR = "carRental.noShowIndicator";
  private String carRentalNoShowIndicator;

  public static final String JSON_PROPERTY_CAR_RENTAL_ONE_WAY_DROP_OFF_CHARGES = "carRental.oneWayDropOffCharges";
  private String carRentalOneWayDropOffCharges;

  public static final String JSON_PROPERTY_CAR_RENTAL_RATE = "carRental.rate";
  private String carRentalRate;

  public static final String JSON_PROPERTY_CAR_RENTAL_RATE_INDICATOR = "carRental.rateIndicator";
  private String carRentalRateIndicator;

  public static final String JSON_PROPERTY_CAR_RENTAL_RENTAL_AGREEMENT_NUMBER = "carRental.rentalAgreementNumber";
  private String carRentalRentalAgreementNumber;

  public static final String JSON_PROPERTY_CAR_RENTAL_RENTAL_CLASS_ID = "carRental.rentalClassId";
  private String carRentalRentalClassId;

  public static final String JSON_PROPERTY_CAR_RENTAL_RENTER_NAME = "carRental.renterName";
  private String carRentalRenterName;

  public static final String JSON_PROPERTY_CAR_RENTAL_RETURN_CITY = "carRental.returnCity";
  private String carRentalReturnCity;

  public static final String JSON_PROPERTY_CAR_RENTAL_RETURN_COUNTRY = "carRental.returnCountry";
  private String carRentalReturnCountry;

  public static final String JSON_PROPERTY_CAR_RENTAL_RETURN_DATE = "carRental.returnDate";
  private String carRentalReturnDate;

  public static final String JSON_PROPERTY_CAR_RENTAL_RETURN_LOCATION_ID = "carRental.returnLocationId";
  private String carRentalReturnLocationId;

  public static final String JSON_PROPERTY_CAR_RENTAL_RETURN_STATE_PROVINCE = "carRental.returnStateProvince";
  private String carRentalReturnStateProvince;

  public static final String JSON_PROPERTY_CAR_RENTAL_TAX_EXEMPT_INDICATOR = "carRental.taxExemptIndicator";
  private String carRentalTaxExemptIndicator;

  public static final String JSON_PROPERTY_TRAVEL_ENTERTAINMENT_AUTH_DATA_DURATION = "travelEntertainmentAuthData.duration";
  private String travelEntertainmentAuthDataDuration;

  public static final String JSON_PROPERTY_TRAVEL_ENTERTAINMENT_AUTH_DATA_MARKET = "travelEntertainmentAuthData.market";
  private String travelEntertainmentAuthDataMarket;

  public AdditionalDataCarRental() { 
  }

  /**
   * The pick-up date. * Date format: &#x60;yyyyMMdd&#x60;
   *
   * @param carRentalCheckOutDate
   * @return the current {@code AdditionalDataCarRental} instance, allowing for method chaining
   */
  public AdditionalDataCarRental carRentalCheckOutDate(String carRentalCheckOutDate) {
    this.carRentalCheckOutDate = carRentalCheckOutDate;
    return this;
  }

  /**
   * The pick-up date. * Date format: &#x60;yyyyMMdd&#x60;
   * @return carRentalCheckOutDate
   */
  @JsonProperty(JSON_PROPERTY_CAR_RENTAL_CHECK_OUT_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCarRentalCheckOutDate() {
    return carRentalCheckOutDate;
  }

  /**
   * The pick-up date. * Date format: &#x60;yyyyMMdd&#x60;
   *
   * @param carRentalCheckOutDate
   */
  @JsonProperty(JSON_PROPERTY_CAR_RENTAL_CHECK_OUT_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCarRentalCheckOutDate(String carRentalCheckOutDate) {
    this.carRentalCheckOutDate = carRentalCheckOutDate;
  }

  /**
   * The customer service phone number of the car rental company. * Format: Alphanumeric * maxLength: 17 * For US and CA numbers must be 10 characters in length * Must not start with a space * Must not contain any special characters such as + or - *Must not be all zeros.
   *
   * @param carRentalCustomerServiceTollFreeNumber
   * @return the current {@code AdditionalDataCarRental} instance, allowing for method chaining
   */
  public AdditionalDataCarRental carRentalCustomerServiceTollFreeNumber(String carRentalCustomerServiceTollFreeNumber) {
    this.carRentalCustomerServiceTollFreeNumber = carRentalCustomerServiceTollFreeNumber;
    return this;
  }

  /**
   * The customer service phone number of the car rental company. * Format: Alphanumeric * maxLength: 17 * For US and CA numbers must be 10 characters in length * Must not start with a space * Must not contain any special characters such as + or - *Must not be all zeros.
   * @return carRentalCustomerServiceTollFreeNumber
   */
  @JsonProperty(JSON_PROPERTY_CAR_RENTAL_CUSTOMER_SERVICE_TOLL_FREE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCarRentalCustomerServiceTollFreeNumber() {
    return carRentalCustomerServiceTollFreeNumber;
  }

  /**
   * The customer service phone number of the car rental company. * Format: Alphanumeric * maxLength: 17 * For US and CA numbers must be 10 characters in length * Must not start with a space * Must not contain any special characters such as + or - *Must not be all zeros.
   *
   * @param carRentalCustomerServiceTollFreeNumber
   */
  @JsonProperty(JSON_PROPERTY_CAR_RENTAL_CUSTOMER_SERVICE_TOLL_FREE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCarRentalCustomerServiceTollFreeNumber(String carRentalCustomerServiceTollFreeNumber) {
    this.carRentalCustomerServiceTollFreeNumber = carRentalCustomerServiceTollFreeNumber;
  }

  /**
   * Number of days for which the car is being rented. * Format: Numeric * maxLength: 4 * Must not be all spaces
   *
   * @param carRentalDaysRented
   * @return the current {@code AdditionalDataCarRental} instance, allowing for method chaining
   */
  public AdditionalDataCarRental carRentalDaysRented(String carRentalDaysRented) {
    this.carRentalDaysRented = carRentalDaysRented;
    return this;
  }

  /**
   * Number of days for which the car is being rented. * Format: Numeric * maxLength: 4 * Must not be all spaces
   * @return carRentalDaysRented
   */
  @JsonProperty(JSON_PROPERTY_CAR_RENTAL_DAYS_RENTED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCarRentalDaysRented() {
    return carRentalDaysRented;
  }

  /**
   * Number of days for which the car is being rented. * Format: Numeric * maxLength: 4 * Must not be all spaces
   *
   * @param carRentalDaysRented
   */
  @JsonProperty(JSON_PROPERTY_CAR_RENTAL_DAYS_RENTED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCarRentalDaysRented(String carRentalDaysRented) {
    this.carRentalDaysRented = carRentalDaysRented;
  }

  /**
   * Any fuel charges associated with the rental, in [minor units](https://docs.adyen.com/development-resources/currency-codes). * Format: Numeric * maxLength: 12
   *
   * @param carRentalFuelCharges
   * @return the current {@code AdditionalDataCarRental} instance, allowing for method chaining
   */
  public AdditionalDataCarRental carRentalFuelCharges(String carRentalFuelCharges) {
    this.carRentalFuelCharges = carRentalFuelCharges;
    return this;
  }

  /**
   * Any fuel charges associated with the rental, in [minor units](https://docs.adyen.com/development-resources/currency-codes). * Format: Numeric * maxLength: 12
   * @return carRentalFuelCharges
   */
  @JsonProperty(JSON_PROPERTY_CAR_RENTAL_FUEL_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCarRentalFuelCharges() {
    return carRentalFuelCharges;
  }

  /**
   * Any fuel charges associated with the rental, in [minor units](https://docs.adyen.com/development-resources/currency-codes). * Format: Numeric * maxLength: 12
   *
   * @param carRentalFuelCharges
   */
  @JsonProperty(JSON_PROPERTY_CAR_RENTAL_FUEL_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCarRentalFuelCharges(String carRentalFuelCharges) {
    this.carRentalFuelCharges = carRentalFuelCharges;
  }

  /**
   * Any insurance charges associated with the rental, in [minor units](https://docs.adyen.com/development-resources/currency-codes). * Format: Numeric * maxLength: 12 * Must not be all spaces *Must not be all zeros.
   *
   * @param carRentalInsuranceCharges
   * @return the current {@code AdditionalDataCarRental} instance, allowing for method chaining
   */
  public AdditionalDataCarRental carRentalInsuranceCharges(String carRentalInsuranceCharges) {
    this.carRentalInsuranceCharges = carRentalInsuranceCharges;
    return this;
  }

  /**
   * Any insurance charges associated with the rental, in [minor units](https://docs.adyen.com/development-resources/currency-codes). * Format: Numeric * maxLength: 12 * Must not be all spaces *Must not be all zeros.
   * @return carRentalInsuranceCharges
   */
  @JsonProperty(JSON_PROPERTY_CAR_RENTAL_INSURANCE_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCarRentalInsuranceCharges() {
    return carRentalInsuranceCharges;
  }

  /**
   * Any insurance charges associated with the rental, in [minor units](https://docs.adyen.com/development-resources/currency-codes). * Format: Numeric * maxLength: 12 * Must not be all spaces *Must not be all zeros.
   *
   * @param carRentalInsuranceCharges
   */
  @JsonProperty(JSON_PROPERTY_CAR_RENTAL_INSURANCE_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCarRentalInsuranceCharges(String carRentalInsuranceCharges) {
    this.carRentalInsuranceCharges = carRentalInsuranceCharges;
  }

  /**
   * The city where the car is rented. * Format: Alphanumeric * maxLength: 18 * Must not start with a space or be all spaces *Must not be all zeros.
   *
   * @param carRentalLocationCity
   * @return the current {@code AdditionalDataCarRental} instance, allowing for method chaining
   */
  public AdditionalDataCarRental carRentalLocationCity(String carRentalLocationCity) {
    this.carRentalLocationCity = carRentalLocationCity;
    return this;
  }

  /**
   * The city where the car is rented. * Format: Alphanumeric * maxLength: 18 * Must not start with a space or be all spaces *Must not be all zeros.
   * @return carRentalLocationCity
   */
  @JsonProperty(JSON_PROPERTY_CAR_RENTAL_LOCATION_CITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCarRentalLocationCity() {
    return carRentalLocationCity;
  }

  /**
   * The city where the car is rented. * Format: Alphanumeric * maxLength: 18 * Must not start with a space or be all spaces *Must not be all zeros.
   *
   * @param carRentalLocationCity
   */
  @JsonProperty(JSON_PROPERTY_CAR_RENTAL_LOCATION_CITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCarRentalLocationCity(String carRentalLocationCity) {
    this.carRentalLocationCity = carRentalLocationCity;
  }

  /**
   * The country where the car is rented, in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format. * Format: Alphanumeric * maxLength: 2
   *
   * @param carRentalLocationCountry
   * @return the current {@code AdditionalDataCarRental} instance, allowing for method chaining
   */
  public AdditionalDataCarRental carRentalLocationCountry(String carRentalLocationCountry) {
    this.carRentalLocationCountry = carRentalLocationCountry;
    return this;
  }

  /**
   * The country where the car is rented, in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format. * Format: Alphanumeric * maxLength: 2
   * @return carRentalLocationCountry
   */
  @JsonProperty(JSON_PROPERTY_CAR_RENTAL_LOCATION_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCarRentalLocationCountry() {
    return carRentalLocationCountry;
  }

  /**
   * The country where the car is rented, in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format. * Format: Alphanumeric * maxLength: 2
   *
   * @param carRentalLocationCountry
   */
  @JsonProperty(JSON_PROPERTY_CAR_RENTAL_LOCATION_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCarRentalLocationCountry(String carRentalLocationCountry) {
    this.carRentalLocationCountry = carRentalLocationCountry;
  }

  /**
   * The state or province where the car is rented. * Format: Alphanumeric * maxLength: 2 * Must not start with a space or be all spaces *Must not be all zeros.
   *
   * @param carRentalLocationStateProvince
   * @return the current {@code AdditionalDataCarRental} instance, allowing for method chaining
   */
  public AdditionalDataCarRental carRentalLocationStateProvince(String carRentalLocationStateProvince) {
    this.carRentalLocationStateProvince = carRentalLocationStateProvince;
    return this;
  }

  /**
   * The state or province where the car is rented. * Format: Alphanumeric * maxLength: 2 * Must not start with a space or be all spaces *Must not be all zeros.
   * @return carRentalLocationStateProvince
   */
  @JsonProperty(JSON_PROPERTY_CAR_RENTAL_LOCATION_STATE_PROVINCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCarRentalLocationStateProvince() {
    return carRentalLocationStateProvince;
  }

  /**
   * The state or province where the car is rented. * Format: Alphanumeric * maxLength: 2 * Must not start with a space or be all spaces *Must not be all zeros.
   *
   * @param carRentalLocationStateProvince
   */
  @JsonProperty(JSON_PROPERTY_CAR_RENTAL_LOCATION_STATE_PROVINCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCarRentalLocationStateProvince(String carRentalLocationStateProvince) {
    this.carRentalLocationStateProvince = carRentalLocationStateProvince;
  }

  /**
   * Indicates if the customer didn&#39;t pick up their rental car. * Y - Customer did not pick up their car * N - Not applicable
   *
   * @param carRentalNoShowIndicator
   * @return the current {@code AdditionalDataCarRental} instance, allowing for method chaining
   */
  public AdditionalDataCarRental carRentalNoShowIndicator(String carRentalNoShowIndicator) {
    this.carRentalNoShowIndicator = carRentalNoShowIndicator;
    return this;
  }

  /**
   * Indicates if the customer didn&#39;t pick up their rental car. * Y - Customer did not pick up their car * N - Not applicable
   * @return carRentalNoShowIndicator
   */
  @JsonProperty(JSON_PROPERTY_CAR_RENTAL_NO_SHOW_INDICATOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCarRentalNoShowIndicator() {
    return carRentalNoShowIndicator;
  }

  /**
   * Indicates if the customer didn&#39;t pick up their rental car. * Y - Customer did not pick up their car * N - Not applicable
   *
   * @param carRentalNoShowIndicator
   */
  @JsonProperty(JSON_PROPERTY_CAR_RENTAL_NO_SHOW_INDICATOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCarRentalNoShowIndicator(String carRentalNoShowIndicator) {
    this.carRentalNoShowIndicator = carRentalNoShowIndicator;
  }

  /**
   * The charge for not returning a car to the original rental location, in [minor units](https://docs.adyen.com/development-resources/currency-codes). * maxLength: 12
   *
   * @param carRentalOneWayDropOffCharges
   * @return the current {@code AdditionalDataCarRental} instance, allowing for method chaining
   */
  public AdditionalDataCarRental carRentalOneWayDropOffCharges(String carRentalOneWayDropOffCharges) {
    this.carRentalOneWayDropOffCharges = carRentalOneWayDropOffCharges;
    return this;
  }

  /**
   * The charge for not returning a car to the original rental location, in [minor units](https://docs.adyen.com/development-resources/currency-codes). * maxLength: 12
   * @return carRentalOneWayDropOffCharges
   */
  @JsonProperty(JSON_PROPERTY_CAR_RENTAL_ONE_WAY_DROP_OFF_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCarRentalOneWayDropOffCharges() {
    return carRentalOneWayDropOffCharges;
  }

  /**
   * The charge for not returning a car to the original rental location, in [minor units](https://docs.adyen.com/development-resources/currency-codes). * maxLength: 12
   *
   * @param carRentalOneWayDropOffCharges
   */
  @JsonProperty(JSON_PROPERTY_CAR_RENTAL_ONE_WAY_DROP_OFF_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCarRentalOneWayDropOffCharges(String carRentalOneWayDropOffCharges) {
    this.carRentalOneWayDropOffCharges = carRentalOneWayDropOffCharges;
  }

  /**
   * The daily rental rate, in [minor units](https://docs.adyen.com/development-resources/currency-codes). * Format: Alphanumeric * maxLength: 12
   *
   * @param carRentalRate
   * @return the current {@code AdditionalDataCarRental} instance, allowing for method chaining
   */
  public AdditionalDataCarRental carRentalRate(String carRentalRate) {
    this.carRentalRate = carRentalRate;
    return this;
  }

  /**
   * The daily rental rate, in [minor units](https://docs.adyen.com/development-resources/currency-codes). * Format: Alphanumeric * maxLength: 12
   * @return carRentalRate
   */
  @JsonProperty(JSON_PROPERTY_CAR_RENTAL_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCarRentalRate() {
    return carRentalRate;
  }

  /**
   * The daily rental rate, in [minor units](https://docs.adyen.com/development-resources/currency-codes). * Format: Alphanumeric * maxLength: 12
   *
   * @param carRentalRate
   */
  @JsonProperty(JSON_PROPERTY_CAR_RENTAL_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCarRentalRate(String carRentalRate) {
    this.carRentalRate = carRentalRate;
  }

  /**
   * Specifies whether the given rate is applied daily or weekly. * D - Daily rate * W - Weekly rate
   *
   * @param carRentalRateIndicator
   * @return the current {@code AdditionalDataCarRental} instance, allowing for method chaining
   */
  public AdditionalDataCarRental carRentalRateIndicator(String carRentalRateIndicator) {
    this.carRentalRateIndicator = carRentalRateIndicator;
    return this;
  }

  /**
   * Specifies whether the given rate is applied daily or weekly. * D - Daily rate * W - Weekly rate
   * @return carRentalRateIndicator
   */
  @JsonProperty(JSON_PROPERTY_CAR_RENTAL_RATE_INDICATOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCarRentalRateIndicator() {
    return carRentalRateIndicator;
  }

  /**
   * Specifies whether the given rate is applied daily or weekly. * D - Daily rate * W - Weekly rate
   *
   * @param carRentalRateIndicator
   */
  @JsonProperty(JSON_PROPERTY_CAR_RENTAL_RATE_INDICATOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCarRentalRateIndicator(String carRentalRateIndicator) {
    this.carRentalRateIndicator = carRentalRateIndicator;
  }

  /**
   * The rental agreement number for the car rental. * Format: Alphanumeric * maxLength: 9 * Must not start with a space or be all spaces *Must not be all zeros.
   *
   * @param carRentalRentalAgreementNumber
   * @return the current {@code AdditionalDataCarRental} instance, allowing for method chaining
   */
  public AdditionalDataCarRental carRentalRentalAgreementNumber(String carRentalRentalAgreementNumber) {
    this.carRentalRentalAgreementNumber = carRentalRentalAgreementNumber;
    return this;
  }

  /**
   * The rental agreement number for the car rental. * Format: Alphanumeric * maxLength: 9 * Must not start with a space or be all spaces *Must not be all zeros.
   * @return carRentalRentalAgreementNumber
   */
  @JsonProperty(JSON_PROPERTY_CAR_RENTAL_RENTAL_AGREEMENT_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCarRentalRentalAgreementNumber() {
    return carRentalRentalAgreementNumber;
  }

  /**
   * The rental agreement number for the car rental. * Format: Alphanumeric * maxLength: 9 * Must not start with a space or be all spaces *Must not be all zeros.
   *
   * @param carRentalRentalAgreementNumber
   */
  @JsonProperty(JSON_PROPERTY_CAR_RENTAL_RENTAL_AGREEMENT_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCarRentalRentalAgreementNumber(String carRentalRentalAgreementNumber) {
    this.carRentalRentalAgreementNumber = carRentalRentalAgreementNumber;
  }

  /**
   * The classification of the rental car. * Format: Alphanumeric * maxLength: 4 * Must not start with a space or be all spaces *Must not be all zeros.
   *
   * @param carRentalRentalClassId
   * @return the current {@code AdditionalDataCarRental} instance, allowing for method chaining
   */
  public AdditionalDataCarRental carRentalRentalClassId(String carRentalRentalClassId) {
    this.carRentalRentalClassId = carRentalRentalClassId;
    return this;
  }

  /**
   * The classification of the rental car. * Format: Alphanumeric * maxLength: 4 * Must not start with a space or be all spaces *Must not be all zeros.
   * @return carRentalRentalClassId
   */
  @JsonProperty(JSON_PROPERTY_CAR_RENTAL_RENTAL_CLASS_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCarRentalRentalClassId() {
    return carRentalRentalClassId;
  }

  /**
   * The classification of the rental car. * Format: Alphanumeric * maxLength: 4 * Must not start with a space or be all spaces *Must not be all zeros.
   *
   * @param carRentalRentalClassId
   */
  @JsonProperty(JSON_PROPERTY_CAR_RENTAL_RENTAL_CLASS_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCarRentalRentalClassId(String carRentalRentalClassId) {
    this.carRentalRentalClassId = carRentalRentalClassId;
  }

  /**
   * The name of the person renting the car. * Format: Alphanumeric * maxLength: 26 * If you send more than 26 characters, the name is truncated * Must not start with a space or be all spaces *Must not be all zeros.
   *
   * @param carRentalRenterName
   * @return the current {@code AdditionalDataCarRental} instance, allowing for method chaining
   */
  public AdditionalDataCarRental carRentalRenterName(String carRentalRenterName) {
    this.carRentalRenterName = carRentalRenterName;
    return this;
  }

  /**
   * The name of the person renting the car. * Format: Alphanumeric * maxLength: 26 * If you send more than 26 characters, the name is truncated * Must not start with a space or be all spaces *Must not be all zeros.
   * @return carRentalRenterName
   */
  @JsonProperty(JSON_PROPERTY_CAR_RENTAL_RENTER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCarRentalRenterName() {
    return carRentalRenterName;
  }

  /**
   * The name of the person renting the car. * Format: Alphanumeric * maxLength: 26 * If you send more than 26 characters, the name is truncated * Must not start with a space or be all spaces *Must not be all zeros.
   *
   * @param carRentalRenterName
   */
  @JsonProperty(JSON_PROPERTY_CAR_RENTAL_RENTER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCarRentalRenterName(String carRentalRenterName) {
    this.carRentalRenterName = carRentalRenterName;
  }

  /**
   * The city where the car must be returned. * Format: Alphanumeric * maxLength: 18 * Must not start with a space or be all spaces *Must not be all zeros.
   *
   * @param carRentalReturnCity
   * @return the current {@code AdditionalDataCarRental} instance, allowing for method chaining
   */
  public AdditionalDataCarRental carRentalReturnCity(String carRentalReturnCity) {
    this.carRentalReturnCity = carRentalReturnCity;
    return this;
  }

  /**
   * The city where the car must be returned. * Format: Alphanumeric * maxLength: 18 * Must not start with a space or be all spaces *Must not be all zeros.
   * @return carRentalReturnCity
   */
  @JsonProperty(JSON_PROPERTY_CAR_RENTAL_RETURN_CITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCarRentalReturnCity() {
    return carRentalReturnCity;
  }

  /**
   * The city where the car must be returned. * Format: Alphanumeric * maxLength: 18 * Must not start with a space or be all spaces *Must not be all zeros.
   *
   * @param carRentalReturnCity
   */
  @JsonProperty(JSON_PROPERTY_CAR_RENTAL_RETURN_CITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCarRentalReturnCity(String carRentalReturnCity) {
    this.carRentalReturnCity = carRentalReturnCity;
  }

  /**
   * The country where the car must be returned, in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format. * Format: Alphanumeric * maxLength: 2
   *
   * @param carRentalReturnCountry
   * @return the current {@code AdditionalDataCarRental} instance, allowing for method chaining
   */
  public AdditionalDataCarRental carRentalReturnCountry(String carRentalReturnCountry) {
    this.carRentalReturnCountry = carRentalReturnCountry;
    return this;
  }

  /**
   * The country where the car must be returned, in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format. * Format: Alphanumeric * maxLength: 2
   * @return carRentalReturnCountry
   */
  @JsonProperty(JSON_PROPERTY_CAR_RENTAL_RETURN_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCarRentalReturnCountry() {
    return carRentalReturnCountry;
  }

  /**
   * The country where the car must be returned, in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format. * Format: Alphanumeric * maxLength: 2
   *
   * @param carRentalReturnCountry
   */
  @JsonProperty(JSON_PROPERTY_CAR_RENTAL_RETURN_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCarRentalReturnCountry(String carRentalReturnCountry) {
    this.carRentalReturnCountry = carRentalReturnCountry;
  }

  /**
   * The last date to return the car by. * Date format: &#x60;yyyyMMdd&#x60; * maxLength: 8
   *
   * @param carRentalReturnDate
   * @return the current {@code AdditionalDataCarRental} instance, allowing for method chaining
   */
  public AdditionalDataCarRental carRentalReturnDate(String carRentalReturnDate) {
    this.carRentalReturnDate = carRentalReturnDate;
    return this;
  }

  /**
   * The last date to return the car by. * Date format: &#x60;yyyyMMdd&#x60; * maxLength: 8
   * @return carRentalReturnDate
   */
  @JsonProperty(JSON_PROPERTY_CAR_RENTAL_RETURN_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCarRentalReturnDate() {
    return carRentalReturnDate;
  }

  /**
   * The last date to return the car by. * Date format: &#x60;yyyyMMdd&#x60; * maxLength: 8
   *
   * @param carRentalReturnDate
   */
  @JsonProperty(JSON_PROPERTY_CAR_RENTAL_RETURN_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCarRentalReturnDate(String carRentalReturnDate) {
    this.carRentalReturnDate = carRentalReturnDate;
  }

  /**
   * The agency code, phone number, or address abbreviation * Format: Alphanumeric * maxLength: 10 * Must not start with a space or be all spaces *Must not be all zeros.
   *
   * @param carRentalReturnLocationId
   * @return the current {@code AdditionalDataCarRental} instance, allowing for method chaining
   */
  public AdditionalDataCarRental carRentalReturnLocationId(String carRentalReturnLocationId) {
    this.carRentalReturnLocationId = carRentalReturnLocationId;
    return this;
  }

  /**
   * The agency code, phone number, or address abbreviation * Format: Alphanumeric * maxLength: 10 * Must not start with a space or be all spaces *Must not be all zeros.
   * @return carRentalReturnLocationId
   */
  @JsonProperty(JSON_PROPERTY_CAR_RENTAL_RETURN_LOCATION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCarRentalReturnLocationId() {
    return carRentalReturnLocationId;
  }

  /**
   * The agency code, phone number, or address abbreviation * Format: Alphanumeric * maxLength: 10 * Must not start with a space or be all spaces *Must not be all zeros.
   *
   * @param carRentalReturnLocationId
   */
  @JsonProperty(JSON_PROPERTY_CAR_RENTAL_RETURN_LOCATION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCarRentalReturnLocationId(String carRentalReturnLocationId) {
    this.carRentalReturnLocationId = carRentalReturnLocationId;
  }

  /**
   * The state or province where the car must be returned. * Format: Alphanumeric * maxLength: 3 * Must not start with a space or be all spaces *Must not be all zeros.
   *
   * @param carRentalReturnStateProvince
   * @return the current {@code AdditionalDataCarRental} instance, allowing for method chaining
   */
  public AdditionalDataCarRental carRentalReturnStateProvince(String carRentalReturnStateProvince) {
    this.carRentalReturnStateProvince = carRentalReturnStateProvince;
    return this;
  }

  /**
   * The state or province where the car must be returned. * Format: Alphanumeric * maxLength: 3 * Must not start with a space or be all spaces *Must not be all zeros.
   * @return carRentalReturnStateProvince
   */
  @JsonProperty(JSON_PROPERTY_CAR_RENTAL_RETURN_STATE_PROVINCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCarRentalReturnStateProvince() {
    return carRentalReturnStateProvince;
  }

  /**
   * The state or province where the car must be returned. * Format: Alphanumeric * maxLength: 3 * Must not start with a space or be all spaces *Must not be all zeros.
   *
   * @param carRentalReturnStateProvince
   */
  @JsonProperty(JSON_PROPERTY_CAR_RENTAL_RETURN_STATE_PROVINCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCarRentalReturnStateProvince(String carRentalReturnStateProvince) {
    this.carRentalReturnStateProvince = carRentalReturnStateProvince;
  }

  /**
   * Indicates if the goods or services were tax-exempt, or if tax was not paid on them.  Values: * Y - Goods or services were tax exempt * N - Tax was not collected
   *
   * @param carRentalTaxExemptIndicator
   * @return the current {@code AdditionalDataCarRental} instance, allowing for method chaining
   */
  public AdditionalDataCarRental carRentalTaxExemptIndicator(String carRentalTaxExemptIndicator) {
    this.carRentalTaxExemptIndicator = carRentalTaxExemptIndicator;
    return this;
  }

  /**
   * Indicates if the goods or services were tax-exempt, or if tax was not paid on them.  Values: * Y - Goods or services were tax exempt * N - Tax was not collected
   * @return carRentalTaxExemptIndicator
   */
  @JsonProperty(JSON_PROPERTY_CAR_RENTAL_TAX_EXEMPT_INDICATOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCarRentalTaxExemptIndicator() {
    return carRentalTaxExemptIndicator;
  }

  /**
   * Indicates if the goods or services were tax-exempt, or if tax was not paid on them.  Values: * Y - Goods or services were tax exempt * N - Tax was not collected
   *
   * @param carRentalTaxExemptIndicator
   */
  @JsonProperty(JSON_PROPERTY_CAR_RENTAL_TAX_EXEMPT_INDICATOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCarRentalTaxExemptIndicator(String carRentalTaxExemptIndicator) {
    this.carRentalTaxExemptIndicator = carRentalTaxExemptIndicator;
  }

  /**
   * Number of days the car is rented for. This should be included in the auth message. * Format: Numeric * maxLength: 4
   *
   * @param travelEntertainmentAuthDataDuration
   * @return the current {@code AdditionalDataCarRental} instance, allowing for method chaining
   */
  public AdditionalDataCarRental travelEntertainmentAuthDataDuration(String travelEntertainmentAuthDataDuration) {
    this.travelEntertainmentAuthDataDuration = travelEntertainmentAuthDataDuration;
    return this;
  }

  /**
   * Number of days the car is rented for. This should be included in the auth message. * Format: Numeric * maxLength: 4
   * @return travelEntertainmentAuthDataDuration
   */
  @JsonProperty(JSON_PROPERTY_TRAVEL_ENTERTAINMENT_AUTH_DATA_DURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getTravelEntertainmentAuthDataDuration() {
    return travelEntertainmentAuthDataDuration;
  }

  /**
   * Number of days the car is rented for. This should be included in the auth message. * Format: Numeric * maxLength: 4
   *
   * @param travelEntertainmentAuthDataDuration
   */
  @JsonProperty(JSON_PROPERTY_TRAVEL_ENTERTAINMENT_AUTH_DATA_DURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTravelEntertainmentAuthDataDuration(String travelEntertainmentAuthDataDuration) {
    this.travelEntertainmentAuthDataDuration = travelEntertainmentAuthDataDuration;
  }

  /**
   * Indicates what market-specific dataset will be submitted or is being submitted. Value should be &#39;A&#39; for car rental. This should be included in the auth message. * Format: Alphanumeric * maxLength: 1
   *
   * @param travelEntertainmentAuthDataMarket
   * @return the current {@code AdditionalDataCarRental} instance, allowing for method chaining
   */
  public AdditionalDataCarRental travelEntertainmentAuthDataMarket(String travelEntertainmentAuthDataMarket) {
    this.travelEntertainmentAuthDataMarket = travelEntertainmentAuthDataMarket;
    return this;
  }

  /**
   * Indicates what market-specific dataset will be submitted or is being submitted. Value should be &#39;A&#39; for car rental. This should be included in the auth message. * Format: Alphanumeric * maxLength: 1
   * @return travelEntertainmentAuthDataMarket
   */
  @JsonProperty(JSON_PROPERTY_TRAVEL_ENTERTAINMENT_AUTH_DATA_MARKET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getTravelEntertainmentAuthDataMarket() {
    return travelEntertainmentAuthDataMarket;
  }

  /**
   * Indicates what market-specific dataset will be submitted or is being submitted. Value should be &#39;A&#39; for car rental. This should be included in the auth message. * Format: Alphanumeric * maxLength: 1
   *
   * @param travelEntertainmentAuthDataMarket
   */
  @JsonProperty(JSON_PROPERTY_TRAVEL_ENTERTAINMENT_AUTH_DATA_MARKET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTravelEntertainmentAuthDataMarket(String travelEntertainmentAuthDataMarket) {
    this.travelEntertainmentAuthDataMarket = travelEntertainmentAuthDataMarket;
  }

  /**
   * Return true if this AdditionalDataCarRental object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AdditionalDataCarRental additionalDataCarRental = (AdditionalDataCarRental) o;
    return Objects.equals(this.carRentalCheckOutDate, additionalDataCarRental.carRentalCheckOutDate) &&
        Objects.equals(this.carRentalCustomerServiceTollFreeNumber, additionalDataCarRental.carRentalCustomerServiceTollFreeNumber) &&
        Objects.equals(this.carRentalDaysRented, additionalDataCarRental.carRentalDaysRented) &&
        Objects.equals(this.carRentalFuelCharges, additionalDataCarRental.carRentalFuelCharges) &&
        Objects.equals(this.carRentalInsuranceCharges, additionalDataCarRental.carRentalInsuranceCharges) &&
        Objects.equals(this.carRentalLocationCity, additionalDataCarRental.carRentalLocationCity) &&
        Objects.equals(this.carRentalLocationCountry, additionalDataCarRental.carRentalLocationCountry) &&
        Objects.equals(this.carRentalLocationStateProvince, additionalDataCarRental.carRentalLocationStateProvince) &&
        Objects.equals(this.carRentalNoShowIndicator, additionalDataCarRental.carRentalNoShowIndicator) &&
        Objects.equals(this.carRentalOneWayDropOffCharges, additionalDataCarRental.carRentalOneWayDropOffCharges) &&
        Objects.equals(this.carRentalRate, additionalDataCarRental.carRentalRate) &&
        Objects.equals(this.carRentalRateIndicator, additionalDataCarRental.carRentalRateIndicator) &&
        Objects.equals(this.carRentalRentalAgreementNumber, additionalDataCarRental.carRentalRentalAgreementNumber) &&
        Objects.equals(this.carRentalRentalClassId, additionalDataCarRental.carRentalRentalClassId) &&
        Objects.equals(this.carRentalRenterName, additionalDataCarRental.carRentalRenterName) &&
        Objects.equals(this.carRentalReturnCity, additionalDataCarRental.carRentalReturnCity) &&
        Objects.equals(this.carRentalReturnCountry, additionalDataCarRental.carRentalReturnCountry) &&
        Objects.equals(this.carRentalReturnDate, additionalDataCarRental.carRentalReturnDate) &&
        Objects.equals(this.carRentalReturnLocationId, additionalDataCarRental.carRentalReturnLocationId) &&
        Objects.equals(this.carRentalReturnStateProvince, additionalDataCarRental.carRentalReturnStateProvince) &&
        Objects.equals(this.carRentalTaxExemptIndicator, additionalDataCarRental.carRentalTaxExemptIndicator) &&
        Objects.equals(this.travelEntertainmentAuthDataDuration, additionalDataCarRental.travelEntertainmentAuthDataDuration) &&
        Objects.equals(this.travelEntertainmentAuthDataMarket, additionalDataCarRental.travelEntertainmentAuthDataMarket);
  }

  @Override
  public int hashCode() {
    return Objects.hash(carRentalCheckOutDate, carRentalCustomerServiceTollFreeNumber, carRentalDaysRented, carRentalFuelCharges, carRentalInsuranceCharges, carRentalLocationCity, carRentalLocationCountry, carRentalLocationStateProvince, carRentalNoShowIndicator, carRentalOneWayDropOffCharges, carRentalRate, carRentalRateIndicator, carRentalRentalAgreementNumber, carRentalRentalClassId, carRentalRenterName, carRentalReturnCity, carRentalReturnCountry, carRentalReturnDate, carRentalReturnLocationId, carRentalReturnStateProvince, carRentalTaxExemptIndicator, travelEntertainmentAuthDataDuration, travelEntertainmentAuthDataMarket);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AdditionalDataCarRental {\n");
    sb.append("    carRentalCheckOutDate: ").append(toIndentedString(carRentalCheckOutDate)).append("\n");
    sb.append("    carRentalCustomerServiceTollFreeNumber: ").append(toIndentedString(carRentalCustomerServiceTollFreeNumber)).append("\n");
    sb.append("    carRentalDaysRented: ").append(toIndentedString(carRentalDaysRented)).append("\n");
    sb.append("    carRentalFuelCharges: ").append(toIndentedString(carRentalFuelCharges)).append("\n");
    sb.append("    carRentalInsuranceCharges: ").append(toIndentedString(carRentalInsuranceCharges)).append("\n");
    sb.append("    carRentalLocationCity: ").append(toIndentedString(carRentalLocationCity)).append("\n");
    sb.append("    carRentalLocationCountry: ").append(toIndentedString(carRentalLocationCountry)).append("\n");
    sb.append("    carRentalLocationStateProvince: ").append(toIndentedString(carRentalLocationStateProvince)).append("\n");
    sb.append("    carRentalNoShowIndicator: ").append(toIndentedString(carRentalNoShowIndicator)).append("\n");
    sb.append("    carRentalOneWayDropOffCharges: ").append(toIndentedString(carRentalOneWayDropOffCharges)).append("\n");
    sb.append("    carRentalRate: ").append(toIndentedString(carRentalRate)).append("\n");
    sb.append("    carRentalRateIndicator: ").append(toIndentedString(carRentalRateIndicator)).append("\n");
    sb.append("    carRentalRentalAgreementNumber: ").append(toIndentedString(carRentalRentalAgreementNumber)).append("\n");
    sb.append("    carRentalRentalClassId: ").append(toIndentedString(carRentalRentalClassId)).append("\n");
    sb.append("    carRentalRenterName: ").append(toIndentedString(carRentalRenterName)).append("\n");
    sb.append("    carRentalReturnCity: ").append(toIndentedString(carRentalReturnCity)).append("\n");
    sb.append("    carRentalReturnCountry: ").append(toIndentedString(carRentalReturnCountry)).append("\n");
    sb.append("    carRentalReturnDate: ").append(toIndentedString(carRentalReturnDate)).append("\n");
    sb.append("    carRentalReturnLocationId: ").append(toIndentedString(carRentalReturnLocationId)).append("\n");
    sb.append("    carRentalReturnStateProvince: ").append(toIndentedString(carRentalReturnStateProvince)).append("\n");
    sb.append("    carRentalTaxExemptIndicator: ").append(toIndentedString(carRentalTaxExemptIndicator)).append("\n");
    sb.append("    travelEntertainmentAuthDataDuration: ").append(toIndentedString(travelEntertainmentAuthDataDuration)).append("\n");
    sb.append("    travelEntertainmentAuthDataMarket: ").append(toIndentedString(travelEntertainmentAuthDataMarket)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of AdditionalDataCarRental given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of AdditionalDataCarRental
   * @throws JsonProcessingException if the JSON string is invalid with respect to AdditionalDataCarRental
   */
  public static AdditionalDataCarRental fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, AdditionalDataCarRental.class);
  }
/**
  * Convert an instance of AdditionalDataCarRental to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
