/*
 * Adyen Payment API
 *
 * The version of the OpenAPI document: 68
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.payment;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.payment.PlatformChargebackLogic;
import com.adyen.model.payment.ThreeDSecureData;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * CancelOrRefundRequest
 */
@JsonPropertyOrder({
  CancelOrRefundRequest.JSON_PROPERTY_ADDITIONAL_DATA,
  CancelOrRefundRequest.JSON_PROPERTY_MERCHANT_ACCOUNT,
  CancelOrRefundRequest.JSON_PROPERTY_MPI_DATA,
  CancelOrRefundRequest.JSON_PROPERTY_ORIGINAL_MERCHANT_REFERENCE,
  CancelOrRefundRequest.JSON_PROPERTY_ORIGINAL_REFERENCE,
  CancelOrRefundRequest.JSON_PROPERTY_PLATFORM_CHARGEBACK_LOGIC,
  CancelOrRefundRequest.JSON_PROPERTY_REFERENCE,
  CancelOrRefundRequest.JSON_PROPERTY_TENDER_REFERENCE,
  CancelOrRefundRequest.JSON_PROPERTY_UNIQUE_TERMINAL_ID
})

public class CancelOrRefundRequest {
  public static final String JSON_PROPERTY_ADDITIONAL_DATA = "additionalData";
  private Map<String, String> additionalData = new HashMap<>();

  public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
  private String merchantAccount;

  public static final String JSON_PROPERTY_MPI_DATA = "mpiData";
  private ThreeDSecureData mpiData;

  public static final String JSON_PROPERTY_ORIGINAL_MERCHANT_REFERENCE = "originalMerchantReference";
  private String originalMerchantReference;

  public static final String JSON_PROPERTY_ORIGINAL_REFERENCE = "originalReference";
  private String originalReference;

  public static final String JSON_PROPERTY_PLATFORM_CHARGEBACK_LOGIC = "platformChargebackLogic";
  private PlatformChargebackLogic platformChargebackLogic;

  public static final String JSON_PROPERTY_REFERENCE = "reference";
  private String reference;

  public static final String JSON_PROPERTY_TENDER_REFERENCE = "tenderReference";
  private String tenderReference;

  public static final String JSON_PROPERTY_UNIQUE_TERMINAL_ID = "uniqueTerminalId";
  private String uniqueTerminalId;

  public CancelOrRefundRequest() { 
  }

  /**
   * This field contains additional data, which may be required for a particular modification request.  The additionalData object consists of entries, each of which includes the key and value.
   *
   * @param additionalData
   * @return the current {@code CancelOrRefundRequest} instance, allowing for method chaining
   */
  public CancelOrRefundRequest additionalData(Map<String, String> additionalData) {
    this.additionalData = additionalData;
    return this;
  }

  public CancelOrRefundRequest putAdditionalDataItem(String key, String additionalDataItem) {
    if (this.additionalData == null) {
      this.additionalData = new HashMap<>();
    }
    this.additionalData.put(key, additionalDataItem);
    return this;
  }

  /**
   * This field contains additional data, which may be required for a particular modification request.  The additionalData object consists of entries, each of which includes the key and value.
   * @return additionalData
   */
  @JsonProperty(JSON_PROPERTY_ADDITIONAL_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Map<String, String> getAdditionalData() {
    return additionalData;
  }

  /**
   * This field contains additional data, which may be required for a particular modification request.  The additionalData object consists of entries, each of which includes the key and value.
   *
   * @param additionalData
   */
  @JsonProperty(JSON_PROPERTY_ADDITIONAL_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAdditionalData(Map<String, String> additionalData) {
    this.additionalData = additionalData;
  }

  /**
   * The merchant account that is used to process the payment.
   *
   * @param merchantAccount
   * @return the current {@code CancelOrRefundRequest} instance, allowing for method chaining
   */
  public CancelOrRefundRequest merchantAccount(String merchantAccount) {
    this.merchantAccount = merchantAccount;
    return this;
  }

  /**
   * The merchant account that is used to process the payment.
   * @return merchantAccount
   */
  @JsonProperty(JSON_PROPERTY_MERCHANT_ACCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMerchantAccount() {
    return merchantAccount;
  }

  /**
   * The merchant account that is used to process the payment.
   *
   * @param merchantAccount
   */
  @JsonProperty(JSON_PROPERTY_MERCHANT_ACCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMerchantAccount(String merchantAccount) {
    this.merchantAccount = merchantAccount;
  }

  /**
   * mpiData
   *
   * @param mpiData
   * @return the current {@code CancelOrRefundRequest} instance, allowing for method chaining
   */
  public CancelOrRefundRequest mpiData(ThreeDSecureData mpiData) {
    this.mpiData = mpiData;
    return this;
  }

  /**
   * Get mpiData
   * @return mpiData
   */
  @JsonProperty(JSON_PROPERTY_MPI_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ThreeDSecureData getMpiData() {
    return mpiData;
  }

  /**
   * mpiData
   *
   * @param mpiData
   */
  @JsonProperty(JSON_PROPERTY_MPI_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMpiData(ThreeDSecureData mpiData) {
    this.mpiData = mpiData;
  }

  /**
   * The original merchant reference to cancel.
   *
   * @param originalMerchantReference
   * @return the current {@code CancelOrRefundRequest} instance, allowing for method chaining
   */
  public CancelOrRefundRequest originalMerchantReference(String originalMerchantReference) {
    this.originalMerchantReference = originalMerchantReference;
    return this;
  }

  /**
   * The original merchant reference to cancel.
   * @return originalMerchantReference
   */
  @JsonProperty(JSON_PROPERTY_ORIGINAL_MERCHANT_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getOriginalMerchantReference() {
    return originalMerchantReference;
  }

  /**
   * The original merchant reference to cancel.
   *
   * @param originalMerchantReference
   */
  @JsonProperty(JSON_PROPERTY_ORIGINAL_MERCHANT_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOriginalMerchantReference(String originalMerchantReference) {
    this.originalMerchantReference = originalMerchantReference;
  }

  /**
   * The original pspReference of the payment to modify. This reference is returned in: * authorisation response * authorisation notification  
   *
   * @param originalReference
   * @return the current {@code CancelOrRefundRequest} instance, allowing for method chaining
   */
  public CancelOrRefundRequest originalReference(String originalReference) {
    this.originalReference = originalReference;
    return this;
  }

  /**
   * The original pspReference of the payment to modify. This reference is returned in: * authorisation response * authorisation notification  
   * @return originalReference
   */
  @JsonProperty(JSON_PROPERTY_ORIGINAL_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getOriginalReference() {
    return originalReference;
  }

  /**
   * The original pspReference of the payment to modify. This reference is returned in: * authorisation response * authorisation notification  
   *
   * @param originalReference
   */
  @JsonProperty(JSON_PROPERTY_ORIGINAL_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOriginalReference(String originalReference) {
    this.originalReference = originalReference;
  }

  /**
   * platformChargebackLogic
   *
   * @param platformChargebackLogic
   * @return the current {@code CancelOrRefundRequest} instance, allowing for method chaining
   */
  public CancelOrRefundRequest platformChargebackLogic(PlatformChargebackLogic platformChargebackLogic) {
    this.platformChargebackLogic = platformChargebackLogic;
    return this;
  }

  /**
   * Get platformChargebackLogic
   * @return platformChargebackLogic
   */
  @JsonProperty(JSON_PROPERTY_PLATFORM_CHARGEBACK_LOGIC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public PlatformChargebackLogic getPlatformChargebackLogic() {
    return platformChargebackLogic;
  }

  /**
   * platformChargebackLogic
   *
   * @param platformChargebackLogic
   */
  @JsonProperty(JSON_PROPERTY_PLATFORM_CHARGEBACK_LOGIC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPlatformChargebackLogic(PlatformChargebackLogic platformChargebackLogic) {
    this.platformChargebackLogic = platformChargebackLogic;
  }

  /**
   * Your reference for the payment modification. This reference is visible in Customer Area and in reports. Maximum length: 80 characters.
   *
   * @param reference
   * @return the current {@code CancelOrRefundRequest} instance, allowing for method chaining
   */
  public CancelOrRefundRequest reference(String reference) {
    this.reference = reference;
    return this;
  }

  /**
   * Your reference for the payment modification. This reference is visible in Customer Area and in reports. Maximum length: 80 characters.
   * @return reference
   */
  @JsonProperty(JSON_PROPERTY_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getReference() {
    return reference;
  }

  /**
   * Your reference for the payment modification. This reference is visible in Customer Area and in reports. Maximum length: 80 characters.
   *
   * @param reference
   */
  @JsonProperty(JSON_PROPERTY_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReference(String reference) {
    this.reference = reference;
  }

  /**
   * The transaction reference provided by the PED. For point-of-sale integrations only.
   *
   * @param tenderReference
   * @return the current {@code CancelOrRefundRequest} instance, allowing for method chaining
   */
  public CancelOrRefundRequest tenderReference(String tenderReference) {
    this.tenderReference = tenderReference;
    return this;
  }

  /**
   * The transaction reference provided by the PED. For point-of-sale integrations only.
   * @return tenderReference
   */
  @JsonProperty(JSON_PROPERTY_TENDER_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getTenderReference() {
    return tenderReference;
  }

  /**
   * The transaction reference provided by the PED. For point-of-sale integrations only.
   *
   * @param tenderReference
   */
  @JsonProperty(JSON_PROPERTY_TENDER_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTenderReference(String tenderReference) {
    this.tenderReference = tenderReference;
  }

  /**
   * Unique terminal ID for the PED that originally processed the request. For point-of-sale integrations only.
   *
   * @param uniqueTerminalId
   * @return the current {@code CancelOrRefundRequest} instance, allowing for method chaining
   */
  public CancelOrRefundRequest uniqueTerminalId(String uniqueTerminalId) {
    this.uniqueTerminalId = uniqueTerminalId;
    return this;
  }

  /**
   * Unique terminal ID for the PED that originally processed the request. For point-of-sale integrations only.
   * @return uniqueTerminalId
   */
  @JsonProperty(JSON_PROPERTY_UNIQUE_TERMINAL_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getUniqueTerminalId() {
    return uniqueTerminalId;
  }

  /**
   * Unique terminal ID for the PED that originally processed the request. For point-of-sale integrations only.
   *
   * @param uniqueTerminalId
   */
  @JsonProperty(JSON_PROPERTY_UNIQUE_TERMINAL_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUniqueTerminalId(String uniqueTerminalId) {
    this.uniqueTerminalId = uniqueTerminalId;
  }

  /**
   * Return true if this CancelOrRefundRequest object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CancelOrRefundRequest cancelOrRefundRequest = (CancelOrRefundRequest) o;
    return Objects.equals(this.additionalData, cancelOrRefundRequest.additionalData) &&
        Objects.equals(this.merchantAccount, cancelOrRefundRequest.merchantAccount) &&
        Objects.equals(this.mpiData, cancelOrRefundRequest.mpiData) &&
        Objects.equals(this.originalMerchantReference, cancelOrRefundRequest.originalMerchantReference) &&
        Objects.equals(this.originalReference, cancelOrRefundRequest.originalReference) &&
        Objects.equals(this.platformChargebackLogic, cancelOrRefundRequest.platformChargebackLogic) &&
        Objects.equals(this.reference, cancelOrRefundRequest.reference) &&
        Objects.equals(this.tenderReference, cancelOrRefundRequest.tenderReference) &&
        Objects.equals(this.uniqueTerminalId, cancelOrRefundRequest.uniqueTerminalId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(additionalData, merchantAccount, mpiData, originalMerchantReference, originalReference, platformChargebackLogic, reference, tenderReference, uniqueTerminalId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CancelOrRefundRequest {\n");
    sb.append("    additionalData: ").append(toIndentedString(additionalData)).append("\n");
    sb.append("    merchantAccount: ").append(toIndentedString(merchantAccount)).append("\n");
    sb.append("    mpiData: ").append(toIndentedString(mpiData)).append("\n");
    sb.append("    originalMerchantReference: ").append(toIndentedString(originalMerchantReference)).append("\n");
    sb.append("    originalReference: ").append(toIndentedString(originalReference)).append("\n");
    sb.append("    platformChargebackLogic: ").append(toIndentedString(platformChargebackLogic)).append("\n");
    sb.append("    reference: ").append(toIndentedString(reference)).append("\n");
    sb.append("    tenderReference: ").append(toIndentedString(tenderReference)).append("\n");
    sb.append("    uniqueTerminalId: ").append(toIndentedString(uniqueTerminalId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of CancelOrRefundRequest given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of CancelOrRefundRequest
   * @throws JsonProcessingException if the JSON string is invalid with respect to CancelOrRefundRequest
   */
  public static CancelOrRefundRequest fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, CancelOrRefundRequest.class);
  }
/**
  * Convert an instance of CancelOrRefundRequest to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
