/*
 * Transfers API
 *
 * The version of the OpenAPI document: 4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.transfers;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * CancelTransfersRequest
 */
@JsonPropertyOrder({
  CancelTransfersRequest.JSON_PROPERTY_TRANSFER_IDS
})

public class CancelTransfersRequest {
  public static final String JSON_PROPERTY_TRANSFER_IDS = "transferIds";
  private List<String> transferIds = new ArrayList<>();

  public CancelTransfersRequest() { 
  }

  /**
   * Contains the unique identifiers of the transfers that you want to cancel.
   *
   * @param transferIds
   * @return the current {@code CancelTransfersRequest} instance, allowing for method chaining
   */
  public CancelTransfersRequest transferIds(List<String> transferIds) {
    this.transferIds = transferIds;
    return this;
  }

  public CancelTransfersRequest addTransferIdsItem(String transferIdsItem) {
    if (this.transferIds == null) {
      this.transferIds = new ArrayList<>();
    }
    this.transferIds.add(transferIdsItem);
    return this;
  }

  /**
   * Contains the unique identifiers of the transfers that you want to cancel.
   * @return transferIds
   */
  @JsonProperty(JSON_PROPERTY_TRANSFER_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getTransferIds() {
    return transferIds;
  }

  /**
   * Contains the unique identifiers of the transfers that you want to cancel.
   *
   * @param transferIds
   */
  @JsonProperty(JSON_PROPERTY_TRANSFER_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTransferIds(List<String> transferIds) {
    this.transferIds = transferIds;
  }

  /**
   * Return true if this CancelTransfersRequest object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CancelTransfersRequest cancelTransfersRequest = (CancelTransfersRequest) o;
    return Objects.equals(this.transferIds, cancelTransfersRequest.transferIds);
  }

  @Override
  public int hashCode() {
    return Objects.hash(transferIds);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CancelTransfersRequest {\n");
    sb.append("    transferIds: ").append(toIndentedString(transferIds)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of CancelTransfersRequest given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of CancelTransfersRequest
   * @throws JsonProcessingException if the JSON string is invalid with respect to CancelTransfersRequest
   */
  public static CancelTransfersRequest fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, CancelTransfersRequest.class);
  }
/**
  * Convert an instance of CancelTransfersRequest to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
