/*
 * Transfers API
 *
 * The version of the OpenAPI document: 4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.transfers;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * ConfirmationTrackingData
 */
@JsonPropertyOrder({
  ConfirmationTrackingData.JSON_PROPERTY_STATUS,
  ConfirmationTrackingData.JSON_PROPERTY_TYPE
})

public class ConfirmationTrackingData {
  /**
   * The status of the transfer.  Possible values:    - **credited**: the funds are credited to your user&#39;s transfer instrument or bank account.
   */
  public enum StatusEnum {
    CREDITED(String.valueOf("credited"));

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  private StatusEnum status;

  /**
   * The type of the tracking event.  Possible values:   - **confirmation**: the transfer passed Adyen&#39;s internal review.
   */
  public enum TypeEnum {
    CONFIRMATION(String.valueOf("confirmation"));

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type = TypeEnum.CONFIRMATION;

  public ConfirmationTrackingData() { 
  }

  /**
   * The status of the transfer.  Possible values:    - **credited**: the funds are credited to your user&#39;s transfer instrument or bank account.
   *
   * @param status
   * @return the current {@code ConfirmationTrackingData} instance, allowing for method chaining
   */
  public ConfirmationTrackingData status(StatusEnum status) {
    this.status = status;
    return this;
  }

  /**
   * The status of the transfer.  Possible values:    - **credited**: the funds are credited to your user&#39;s transfer instrument or bank account.
   * @return status
   */
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public StatusEnum getStatus() {
    return status;
  }

  /**
   * The status of the transfer.  Possible values:    - **credited**: the funds are credited to your user&#39;s transfer instrument or bank account.
   *
   * @param status
   */
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  /**
   * The type of the tracking event.  Possible values:   - **confirmation**: the transfer passed Adyen&#39;s internal review.
   *
   * @param type
   * @return the current {@code ConfirmationTrackingData} instance, allowing for method chaining
   */
  public ConfirmationTrackingData type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * The type of the tracking event.  Possible values:   - **confirmation**: the transfer passed Adyen&#39;s internal review.
   * @return type
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TypeEnum getType() {
    return type;
  }

  /**
   * The type of the tracking event.  Possible values:   - **confirmation**: the transfer passed Adyen&#39;s internal review.
   *
   * @param type
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }

  /**
   * Return true if this ConfirmationTrackingData object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ConfirmationTrackingData confirmationTrackingData = (ConfirmationTrackingData) o;
    return Objects.equals(this.status, confirmationTrackingData.status) &&
        Objects.equals(this.type, confirmationTrackingData.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(status, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ConfirmationTrackingData {\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of ConfirmationTrackingData given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of ConfirmationTrackingData
   * @throws JsonProcessingException if the JSON string is invalid with respect to ConfirmationTrackingData
   */
  public static ConfirmationTrackingData fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, ConfirmationTrackingData.class);
  }
/**
  * Convert an instance of ConfirmationTrackingData to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
