/*
 * Adyen Recurring API (deprecated)
 *
 * The version of the OpenAPI document: 68
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.service;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.recurring.CreatePermitRequest;
import com.adyen.model.recurring.CreatePermitResult;
import com.adyen.model.recurring.DisablePermitRequest;
import com.adyen.model.recurring.DisablePermitResult;
import com.adyen.model.recurring.DisableRequest;
import com.adyen.model.recurring.DisableResult;
import com.adyen.model.recurring.NotifyShopperRequest;
import com.adyen.model.recurring.NotifyShopperResult;
import com.adyen.model.recurring.RecurringDetailsRequest;
import com.adyen.model.recurring.RecurringDetailsResult;
import com.adyen.model.recurring.ScheduleAccountUpdaterRequest;
import com.adyen.model.recurring.ScheduleAccountUpdaterResult;
import com.adyen.model.recurring.ServiceError;
import com.adyen.model.RequestOptions;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
public class RecurringApi extends Service {

    public static final String API_VERSION = "68";

    protected String baseURL;

    /**
    * Default constructor in {@link com.adyen.service package}.
    * @param client {@link Client }  (required)
    */
    public RecurringApi(Client client) {
        super(client);
        this.baseURL = createBaseURL("https://pal-test.adyen.com/pal/servlet/Recurring/v68");
    }

    /**
    * Alternative constructor in {@link com.adyen.service package}.
    * Please use this constructor only if you would like to pass along your own url for routing or testing purposes. The latest API version is defined in this class as a constant.
    * @param client {@link Client }  (required)
    * @param baseURL {@link String }  (required)
    */
    public RecurringApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    /**
    * Create new permits linked to a recurring contract.
    *
    * @param createPermitRequest {@link CreatePermitRequest }  (required)
    * @return {@link CreatePermitResult }
    * @throws ApiException if fails to make API call
    */
    public CreatePermitResult createPermit(CreatePermitRequest createPermitRequest) throws ApiException, IOException {
        return createPermit(createPermitRequest, null);
    }

    /**
    * Create new permits linked to a recurring contract.
    *
    * @param createPermitRequest {@link CreatePermitRequest }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link CreatePermitResult }
    * @throws ApiException if fails to make API call
    */
    public CreatePermitResult createPermit(CreatePermitRequest createPermitRequest, RequestOptions requestOptions) throws ApiException, IOException {

        String requestBody = createPermitRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/createPermit", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return CreatePermitResult.fromJson(jsonResult);
    }

    /**
    * Disable stored payment details
    *
    * @param disableRequest {@link DisableRequest }  (required)
    * @return {@link DisableResult }
    * @throws ApiException if fails to make API call
    */
    public DisableResult disable(DisableRequest disableRequest) throws ApiException, IOException {
        return disable(disableRequest, null);
    }

    /**
    * Disable stored payment details
    *
    * @param disableRequest {@link DisableRequest }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link DisableResult }
    * @throws ApiException if fails to make API call
    */
    public DisableResult disable(DisableRequest disableRequest, RequestOptions requestOptions) throws ApiException, IOException {

        String requestBody = disableRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/disable", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return DisableResult.fromJson(jsonResult);
    }

    /**
    * Disable an existing permit.
    *
    * @param disablePermitRequest {@link DisablePermitRequest }  (required)
    * @return {@link DisablePermitResult }
    * @throws ApiException if fails to make API call
    */
    public DisablePermitResult disablePermit(DisablePermitRequest disablePermitRequest) throws ApiException, IOException {
        return disablePermit(disablePermitRequest, null);
    }

    /**
    * Disable an existing permit.
    *
    * @param disablePermitRequest {@link DisablePermitRequest }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link DisablePermitResult }
    * @throws ApiException if fails to make API call
    */
    public DisablePermitResult disablePermit(DisablePermitRequest disablePermitRequest, RequestOptions requestOptions) throws ApiException, IOException {

        String requestBody = disablePermitRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/disablePermit", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return DisablePermitResult.fromJson(jsonResult);
    }

    /**
    * Get stored payment details
    *
    * @param recurringDetailsRequest {@link RecurringDetailsRequest }  (required)
    * @return {@link RecurringDetailsResult }
    * @throws ApiException if fails to make API call
    */
    public RecurringDetailsResult listRecurringDetails(RecurringDetailsRequest recurringDetailsRequest) throws ApiException, IOException {
        return listRecurringDetails(recurringDetailsRequest, null);
    }

    /**
    * Get stored payment details
    *
    * @param recurringDetailsRequest {@link RecurringDetailsRequest }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link RecurringDetailsResult }
    * @throws ApiException if fails to make API call
    */
    public RecurringDetailsResult listRecurringDetails(RecurringDetailsRequest recurringDetailsRequest, RequestOptions requestOptions) throws ApiException, IOException {

        String requestBody = recurringDetailsRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/listRecurringDetails", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return RecurringDetailsResult.fromJson(jsonResult);
    }

    /**
    * Ask issuer to notify the shopper
    *
    * @param notifyShopperRequest {@link NotifyShopperRequest }  (required)
    * @return {@link NotifyShopperResult }
    * @throws ApiException if fails to make API call
    */
    public NotifyShopperResult notifyShopper(NotifyShopperRequest notifyShopperRequest) throws ApiException, IOException {
        return notifyShopper(notifyShopperRequest, null);
    }

    /**
    * Ask issuer to notify the shopper
    *
    * @param notifyShopperRequest {@link NotifyShopperRequest }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link NotifyShopperResult }
    * @throws ApiException if fails to make API call
    */
    public NotifyShopperResult notifyShopper(NotifyShopperRequest notifyShopperRequest, RequestOptions requestOptions) throws ApiException, IOException {

        String requestBody = notifyShopperRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/notifyShopper", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return NotifyShopperResult.fromJson(jsonResult);
    }

    /**
    * Schedule running the Account Updater
    *
    * @param scheduleAccountUpdaterRequest {@link ScheduleAccountUpdaterRequest }  (required)
    * @return {@link ScheduleAccountUpdaterResult }
    * @throws ApiException if fails to make API call
    */
    public ScheduleAccountUpdaterResult scheduleAccountUpdater(ScheduleAccountUpdaterRequest scheduleAccountUpdaterRequest) throws ApiException, IOException {
        return scheduleAccountUpdater(scheduleAccountUpdaterRequest, null);
    }

    /**
    * Schedule running the Account Updater
    *
    * @param scheduleAccountUpdaterRequest {@link ScheduleAccountUpdaterRequest }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link ScheduleAccountUpdaterResult }
    * @throws ApiException if fails to make API call
    */
    public ScheduleAccountUpdaterResult scheduleAccountUpdater(ScheduleAccountUpdaterRequest scheduleAccountUpdaterRequest, RequestOptions requestOptions) throws ApiException, IOException {

        String requestBody = scheduleAccountUpdaterRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/scheduleAccountUpdater", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return ScheduleAccountUpdaterResult.fromJson(jsonResult);
    }
}
