/*
 * Authentication webhooks
 *
 * The version of the OpenAPI document: 1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.acswebhooks;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.acswebhooks.Purchase;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * RelayedAuthenticationRequest
 */
@JsonPropertyOrder({
  RelayedAuthenticationRequest.JSON_PROPERTY_ID,
  RelayedAuthenticationRequest.JSON_PROPERTY_PAYMENT_INSTRUMENT_ID,
  RelayedAuthenticationRequest.JSON_PROPERTY_PURCHASE
})

public class RelayedAuthenticationRequest {
  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_PAYMENT_INSTRUMENT_ID = "paymentInstrumentId";
  private String paymentInstrumentId;

  public static final String JSON_PROPERTY_PURCHASE = "purchase";
  private Purchase purchase;

  public RelayedAuthenticationRequest() { 
  }

  /**
   * The unique identifier of the challenge.
   *
   * @param id The unique identifier of the challenge.
   * @return the current {@code RelayedAuthenticationRequest} instance, allowing for method chaining
   */
  public RelayedAuthenticationRequest id(String id) {
    this.id = id;
    return this;
  }

  /**
   * The unique identifier of the challenge.
   * @return id The unique identifier of the challenge.
   */
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getId() {
    return id;
  }

  /**
   * The unique identifier of the challenge.
   *
   * @param id The unique identifier of the challenge.
   */
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }

  /**
   * The unique identifier of the [payment instrument](https://docs.adyen.com/api-explorer/balanceplatform/latest/get/paymentInstruments/_id_) used for the purchase.
   *
   * @param paymentInstrumentId The unique identifier of the [payment instrument](https://docs.adyen.com/api-explorer/balanceplatform/latest/get/paymentInstruments/_id_) used for the purchase.
   * @return the current {@code RelayedAuthenticationRequest} instance, allowing for method chaining
   */
  public RelayedAuthenticationRequest paymentInstrumentId(String paymentInstrumentId) {
    this.paymentInstrumentId = paymentInstrumentId;
    return this;
  }

  /**
   * The unique identifier of the [payment instrument](https://docs.adyen.com/api-explorer/balanceplatform/latest/get/paymentInstruments/_id_) used for the purchase.
   * @return paymentInstrumentId The unique identifier of the [payment instrument](https://docs.adyen.com/api-explorer/balanceplatform/latest/get/paymentInstruments/_id_) used for the purchase.
   */
  @JsonProperty(JSON_PROPERTY_PAYMENT_INSTRUMENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getPaymentInstrumentId() {
    return paymentInstrumentId;
  }

  /**
   * The unique identifier of the [payment instrument](https://docs.adyen.com/api-explorer/balanceplatform/latest/get/paymentInstruments/_id_) used for the purchase.
   *
   * @param paymentInstrumentId The unique identifier of the [payment instrument](https://docs.adyen.com/api-explorer/balanceplatform/latest/get/paymentInstruments/_id_) used for the purchase.
   */
  @JsonProperty(JSON_PROPERTY_PAYMENT_INSTRUMENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaymentInstrumentId(String paymentInstrumentId) {
    this.paymentInstrumentId = paymentInstrumentId;
  }

  /**
   * purchase
   *
   * @param purchase 
   * @return the current {@code RelayedAuthenticationRequest} instance, allowing for method chaining
   */
  public RelayedAuthenticationRequest purchase(Purchase purchase) {
    this.purchase = purchase;
    return this;
  }

  /**
   * Get purchase
   * @return purchase 
   */
  @JsonProperty(JSON_PROPERTY_PURCHASE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Purchase getPurchase() {
    return purchase;
  }

  /**
   * purchase
   *
   * @param purchase 
   */
  @JsonProperty(JSON_PROPERTY_PURCHASE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPurchase(Purchase purchase) {
    this.purchase = purchase;
  }

  /**
   * Return true if this RelayedAuthenticationRequest object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RelayedAuthenticationRequest relayedAuthenticationRequest = (RelayedAuthenticationRequest) o;
    return Objects.equals(this.id, relayedAuthenticationRequest.id) &&
        Objects.equals(this.paymentInstrumentId, relayedAuthenticationRequest.paymentInstrumentId) &&
        Objects.equals(this.purchase, relayedAuthenticationRequest.purchase);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, paymentInstrumentId, purchase);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RelayedAuthenticationRequest {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    paymentInstrumentId: ").append(toIndentedString(paymentInstrumentId)).append("\n");
    sb.append("    purchase: ").append(toIndentedString(purchase)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of RelayedAuthenticationRequest given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of RelayedAuthenticationRequest
   * @throws JsonProcessingException if the JSON string is invalid with respect to RelayedAuthenticationRequest
   */
  public static RelayedAuthenticationRequest fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, RelayedAuthenticationRequest.class);
  }
/**
  * Convert an instance of RelayedAuthenticationRequest to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
