/*
 * Configuration API
 *
 * The version of the OpenAPI document: 2
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.balanceplatform;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * AmountNonZeroDecimalsRequirement
 */
@JsonPropertyOrder({
  AmountNonZeroDecimalsRequirement.JSON_PROPERTY_DESCRIPTION,
  AmountNonZeroDecimalsRequirement.JSON_PROPERTY_TYPE
})

public class AmountNonZeroDecimalsRequirement {
  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  /**
   * **amountNonZeroDecimalsRequirement**
   */
  public enum TypeEnum {
    AMOUNTNONZERODECIMALSREQUIREMENT(String.valueOf("amountNonZeroDecimalsRequirement"));

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type = TypeEnum.AMOUNTNONZERODECIMALSREQUIREMENT;

  public AmountNonZeroDecimalsRequirement() { 
  }

  /**
   * Specifies for which routes the amount in a transfer request must have no non-zero decimal places, so the transfer can only be processed if the amount consists of round numbers.
   *
   * @param description Specifies for which routes the amount in a transfer request must have no non-zero decimal places, so the transfer can only be processed if the amount consists of round numbers.
   * @return the current {@code AmountNonZeroDecimalsRequirement} instance, allowing for method chaining
   */
  public AmountNonZeroDecimalsRequirement description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Specifies for which routes the amount in a transfer request must have no non-zero decimal places, so the transfer can only be processed if the amount consists of round numbers.
   * @return description Specifies for which routes the amount in a transfer request must have no non-zero decimal places, so the transfer can only be processed if the amount consists of round numbers.
   */
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDescription() {
    return description;
  }

  /**
   * Specifies for which routes the amount in a transfer request must have no non-zero decimal places, so the transfer can only be processed if the amount consists of round numbers.
   *
   * @param description Specifies for which routes the amount in a transfer request must have no non-zero decimal places, so the transfer can only be processed if the amount consists of round numbers.
   */
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }

  /**
   * **amountNonZeroDecimalsRequirement**
   *
   * @param type **amountNonZeroDecimalsRequirement**
   * @return the current {@code AmountNonZeroDecimalsRequirement} instance, allowing for method chaining
   */
  public AmountNonZeroDecimalsRequirement type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * **amountNonZeroDecimalsRequirement**
   * @return type **amountNonZeroDecimalsRequirement**
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TypeEnum getType() {
    return type;
  }

  /**
   * **amountNonZeroDecimalsRequirement**
   *
   * @param type **amountNonZeroDecimalsRequirement**
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }

  /**
   * Return true if this AmountNonZeroDecimalsRequirement object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AmountNonZeroDecimalsRequirement amountNonZeroDecimalsRequirement = (AmountNonZeroDecimalsRequirement) o;
    return Objects.equals(this.description, amountNonZeroDecimalsRequirement.description) &&
        Objects.equals(this.type, amountNonZeroDecimalsRequirement.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(description, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AmountNonZeroDecimalsRequirement {\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of AmountNonZeroDecimalsRequirement given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of AmountNonZeroDecimalsRequirement
   * @throws JsonProcessingException if the JSON string is invalid with respect to AmountNonZeroDecimalsRequirement
   */
  public static AmountNonZeroDecimalsRequirement fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, AmountNonZeroDecimalsRequirement.class);
  }
/**
  * Convert an instance of AmountNonZeroDecimalsRequirement to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
