/*
 * Configuration API
 *
 * The version of the OpenAPI document: 2
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.balanceplatform;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.balanceplatform.Condition;
import com.adyen.model.balanceplatform.TargetUpdate;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * BalanceWebhookSettingInfoUpdate
 */
@JsonPropertyOrder({
  BalanceWebhookSettingInfoUpdate.JSON_PROPERTY_CONDITIONS,
  BalanceWebhookSettingInfoUpdate.JSON_PROPERTY_CURRENCY,
  BalanceWebhookSettingInfoUpdate.JSON_PROPERTY_STATUS,
  BalanceWebhookSettingInfoUpdate.JSON_PROPERTY_TARGET,
  BalanceWebhookSettingInfoUpdate.JSON_PROPERTY_TYPE
})

public class BalanceWebhookSettingInfoUpdate {
  public static final String JSON_PROPERTY_CONDITIONS = "conditions";
  private List<Condition> conditions;

  public static final String JSON_PROPERTY_CURRENCY = "currency";
  private String currency;

  /**
   * The status of the webhook setting. Possible values:  * **active**: You receive a balance webhook if any of the conditions in this setting are met. * **inactive**: You do not receive a balance webhook even if the conditions in this settings are met.
   */
  public enum StatusEnum {
    ACTIVE(String.valueOf("active")),
    
    INACTIVE(String.valueOf("inactive"));

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  private StatusEnum status;

  public static final String JSON_PROPERTY_TARGET = "target";
  private TargetUpdate target;

  /**
   * The type of the webhook you are configuring. Set to **balance**.
   */
  public enum TypeEnum {
    BALANCE(String.valueOf("balance"));

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public BalanceWebhookSettingInfoUpdate() { 
  }

  /**
   * The array of conditions a balance change must meet for Adyen to send the webhook.
   *
   * @param conditions The array of conditions a balance change must meet for Adyen to send the webhook.
   * @return the current {@code BalanceWebhookSettingInfoUpdate} instance, allowing for method chaining
   */
  public BalanceWebhookSettingInfoUpdate conditions(List<Condition> conditions) {
    this.conditions = conditions;
    return this;
  }

  public BalanceWebhookSettingInfoUpdate addConditionsItem(Condition conditionsItem) {
    if (this.conditions == null) {
      this.conditions = new ArrayList<>();
    }
    this.conditions.add(conditionsItem);
    return this;
  }

  /**
   * The array of conditions a balance change must meet for Adyen to send the webhook.
   * @return conditions The array of conditions a balance change must meet for Adyen to send the webhook.
   */
  @JsonProperty(JSON_PROPERTY_CONDITIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<Condition> getConditions() {
    return conditions;
  }

  /**
   * The array of conditions a balance change must meet for Adyen to send the webhook.
   *
   * @param conditions The array of conditions a balance change must meet for Adyen to send the webhook.
   */
  @JsonProperty(JSON_PROPERTY_CONDITIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setConditions(List<Condition> conditions) {
    this.conditions = conditions;
  }

  /**
   * The three-character [ISO currency code](https://docs.adyen.com/development-resources/currency-codes) of the balance.
   *
   * @param currency The three-character [ISO currency code](https://docs.adyen.com/development-resources/currency-codes) of the balance.
   * @return the current {@code BalanceWebhookSettingInfoUpdate} instance, allowing for method chaining
   */
  public BalanceWebhookSettingInfoUpdate currency(String currency) {
    this.currency = currency;
    return this;
  }

  /**
   * The three-character [ISO currency code](https://docs.adyen.com/development-resources/currency-codes) of the balance.
   * @return currency The three-character [ISO currency code](https://docs.adyen.com/development-resources/currency-codes) of the balance.
   */
  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCurrency() {
    return currency;
  }

  /**
   * The three-character [ISO currency code](https://docs.adyen.com/development-resources/currency-codes) of the balance.
   *
   * @param currency The three-character [ISO currency code](https://docs.adyen.com/development-resources/currency-codes) of the balance.
   */
  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrency(String currency) {
    this.currency = currency;
  }

  /**
   * The status of the webhook setting. Possible values:  * **active**: You receive a balance webhook if any of the conditions in this setting are met. * **inactive**: You do not receive a balance webhook even if the conditions in this settings are met.
   *
   * @param status The status of the webhook setting. Possible values:  * **active**: You receive a balance webhook if any of the conditions in this setting are met. * **inactive**: You do not receive a balance webhook even if the conditions in this settings are met.
   * @return the current {@code BalanceWebhookSettingInfoUpdate} instance, allowing for method chaining
   */
  public BalanceWebhookSettingInfoUpdate status(StatusEnum status) {
    this.status = status;
    return this;
  }

  /**
   * The status of the webhook setting. Possible values:  * **active**: You receive a balance webhook if any of the conditions in this setting are met. * **inactive**: You do not receive a balance webhook even if the conditions in this settings are met.
   * @return status The status of the webhook setting. Possible values:  * **active**: You receive a balance webhook if any of the conditions in this setting are met. * **inactive**: You do not receive a balance webhook even if the conditions in this settings are met.
   */
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public StatusEnum getStatus() {
    return status;
  }

  /**
   * The status of the webhook setting. Possible values:  * **active**: You receive a balance webhook if any of the conditions in this setting are met. * **inactive**: You do not receive a balance webhook even if the conditions in this settings are met.
   *
   * @param status The status of the webhook setting. Possible values:  * **active**: You receive a balance webhook if any of the conditions in this setting are met. * **inactive**: You do not receive a balance webhook even if the conditions in this settings are met.
   */
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  /**
   * target
   *
   * @param target 
   * @return the current {@code BalanceWebhookSettingInfoUpdate} instance, allowing for method chaining
   */
  public BalanceWebhookSettingInfoUpdate target(TargetUpdate target) {
    this.target = target;
    return this;
  }

  /**
   * Get target
   * @return target 
   */
  @JsonProperty(JSON_PROPERTY_TARGET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TargetUpdate getTarget() {
    return target;
  }

  /**
   * target
   *
   * @param target 
   */
  @JsonProperty(JSON_PROPERTY_TARGET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTarget(TargetUpdate target) {
    this.target = target;
  }

  /**
   * The type of the webhook you are configuring. Set to **balance**.
   *
   * @param type The type of the webhook you are configuring. Set to **balance**.
   * @return the current {@code BalanceWebhookSettingInfoUpdate} instance, allowing for method chaining
   */
  public BalanceWebhookSettingInfoUpdate type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * The type of the webhook you are configuring. Set to **balance**.
   * @return type The type of the webhook you are configuring. Set to **balance**.
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TypeEnum getType() {
    return type;
  }

  /**
   * The type of the webhook you are configuring. Set to **balance**.
   *
   * @param type The type of the webhook you are configuring. Set to **balance**.
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }

  /**
   * Return true if this BalanceWebhookSettingInfoUpdate object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BalanceWebhookSettingInfoUpdate balanceWebhookSettingInfoUpdate = (BalanceWebhookSettingInfoUpdate) o;
    return Objects.equals(this.conditions, balanceWebhookSettingInfoUpdate.conditions) &&
        Objects.equals(this.currency, balanceWebhookSettingInfoUpdate.currency) &&
        Objects.equals(this.status, balanceWebhookSettingInfoUpdate.status) &&
        Objects.equals(this.target, balanceWebhookSettingInfoUpdate.target) &&
        Objects.equals(this.type, balanceWebhookSettingInfoUpdate.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(conditions, currency, status, target, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BalanceWebhookSettingInfoUpdate {\n");
    sb.append("    conditions: ").append(toIndentedString(conditions)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    target: ").append(toIndentedString(target)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of BalanceWebhookSettingInfoUpdate given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of BalanceWebhookSettingInfoUpdate
   * @throws JsonProcessingException if the JSON string is invalid with respect to BalanceWebhookSettingInfoUpdate
   */
  public static BalanceWebhookSettingInfoUpdate fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, BalanceWebhookSettingInfoUpdate.class);
  }
/**
  * Convert an instance of BalanceWebhookSettingInfoUpdate to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
