/*
 * Configuration API
 *
 * The version of the OpenAPI document: 2
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.balanceplatform;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * GetTaxFormResponse
 */
@JsonPropertyOrder({
  GetTaxFormResponse.JSON_PROPERTY_CONTENT,
  GetTaxFormResponse.JSON_PROPERTY_CONTENT_TYPE
})

public class GetTaxFormResponse {
  public static final String JSON_PROPERTY_CONTENT = "content";
  private byte[] content;

  /**
   * The content type of the tax form.  Possible values: *  **application/pdf**  
   */
  public enum ContentTypeEnum {
    APPLICATION_PDF(String.valueOf("application/pdf"));

    private String value;

    ContentTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ContentTypeEnum fromValue(String value) {
      for (ContentTypeEnum b : ContentTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CONTENT_TYPE = "contentType";
  private ContentTypeEnum contentType;

  public GetTaxFormResponse() { 
  }

  /**
   * The content of the tax form in Base64 format.
   *
   * @param content The content of the tax form in Base64 format.
   * @return the current {@code GetTaxFormResponse} instance, allowing for method chaining
   */
  public GetTaxFormResponse content(byte[] content) {
    this.content = content;
    return this;
  }

  /**
   * The content of the tax form in Base64 format.
   * @return content The content of the tax form in Base64 format.
   */
  @JsonProperty(JSON_PROPERTY_CONTENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public byte[] getContent() {
    return content;
  }

  /**
   * The content of the tax form in Base64 format.
   *
   * @param content The content of the tax form in Base64 format.
   */
  @JsonProperty(JSON_PROPERTY_CONTENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContent(byte[] content) {
    this.content = content;
  }

  /**
   * The content type of the tax form.  Possible values: *  **application/pdf**  
   *
   * @param contentType The content type of the tax form.  Possible values: *  **application/pdf**  
   * @return the current {@code GetTaxFormResponse} instance, allowing for method chaining
   */
  public GetTaxFormResponse contentType(ContentTypeEnum contentType) {
    this.contentType = contentType;
    return this;
  }

  /**
   * The content type of the tax form.  Possible values: *  **application/pdf**  
   * @return contentType The content type of the tax form.  Possible values: *  **application/pdf**  
   */
  @JsonProperty(JSON_PROPERTY_CONTENT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ContentTypeEnum getContentType() {
    return contentType;
  }

  /**
   * The content type of the tax form.  Possible values: *  **application/pdf**  
   *
   * @param contentType The content type of the tax form.  Possible values: *  **application/pdf**  
   */
  @JsonProperty(JSON_PROPERTY_CONTENT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContentType(ContentTypeEnum contentType) {
    this.contentType = contentType;
  }

  /**
   * Return true if this GetTaxFormResponse object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetTaxFormResponse getTaxFormResponse = (GetTaxFormResponse) o;
    return Arrays.equals(this.content, getTaxFormResponse.content) &&
        Objects.equals(this.contentType, getTaxFormResponse.contentType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(Arrays.hashCode(content), contentType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetTaxFormResponse {\n");
    sb.append("    content: ").append(toIndentedString(content)).append("\n");
    sb.append("    contentType: ").append(toIndentedString(contentType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of GetTaxFormResponse given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of GetTaxFormResponse
   * @throws JsonProcessingException if the JSON string is invalid with respect to GetTaxFormResponse
   */
  public static GetTaxFormResponse fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, GetTaxFormResponse.class);
  }
/**
  * Convert an instance of GetTaxFormResponse to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
