/*
 * Configuration API
 *
 * The version of the OpenAPI document: 2
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.balanceplatform;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * IbanAccountIdentificationRequirement
 */
@JsonPropertyOrder({
  IbanAccountIdentificationRequirement.JSON_PROPERTY_DESCRIPTION,
  IbanAccountIdentificationRequirement.JSON_PROPERTY_IBAN_PREFIXES,
  IbanAccountIdentificationRequirement.JSON_PROPERTY_TYPE
})

public class IbanAccountIdentificationRequirement {
  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_IBAN_PREFIXES = "ibanPrefixes";
  private List<String> ibanPrefixes;

  /**
   * **ibanAccountIdentificationRequirement**
   */
  public enum TypeEnum {
    IBANACCOUNTIDENTIFICATIONREQUIREMENT(String.valueOf("ibanAccountIdentificationRequirement"));

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type = TypeEnum.IBANACCOUNTIDENTIFICATIONREQUIREMENT;

  public IbanAccountIdentificationRequirement() { 
  }

  /**
   * Specifies the allowed prefixes for the international bank account number as defined in the ISO-13616 standard.
   *
   * @param description Specifies the allowed prefixes for the international bank account number as defined in the ISO-13616 standard.
   * @return the current {@code IbanAccountIdentificationRequirement} instance, allowing for method chaining
   */
  public IbanAccountIdentificationRequirement description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Specifies the allowed prefixes for the international bank account number as defined in the ISO-13616 standard.
   * @return description Specifies the allowed prefixes for the international bank account number as defined in the ISO-13616 standard.
   */
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDescription() {
    return description;
  }

  /**
   * Specifies the allowed prefixes for the international bank account number as defined in the ISO-13616 standard.
   *
   * @param description Specifies the allowed prefixes for the international bank account number as defined in the ISO-13616 standard.
   */
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }

  /**
   * Contains the list of allowed prefixes for international bank accounts. For example: NL, US, UK.
   *
   * @param ibanPrefixes Contains the list of allowed prefixes for international bank accounts. For example: NL, US, UK.
   * @return the current {@code IbanAccountIdentificationRequirement} instance, allowing for method chaining
   */
  public IbanAccountIdentificationRequirement ibanPrefixes(List<String> ibanPrefixes) {
    this.ibanPrefixes = ibanPrefixes;
    return this;
  }

  public IbanAccountIdentificationRequirement addIbanPrefixesItem(String ibanPrefixesItem) {
    if (this.ibanPrefixes == null) {
      this.ibanPrefixes = new ArrayList<>();
    }
    this.ibanPrefixes.add(ibanPrefixesItem);
    return this;
  }

  /**
   * Contains the list of allowed prefixes for international bank accounts. For example: NL, US, UK.
   * @return ibanPrefixes Contains the list of allowed prefixes for international bank accounts. For example: NL, US, UK.
   */
  @JsonProperty(JSON_PROPERTY_IBAN_PREFIXES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getIbanPrefixes() {
    return ibanPrefixes;
  }

  /**
   * Contains the list of allowed prefixes for international bank accounts. For example: NL, US, UK.
   *
   * @param ibanPrefixes Contains the list of allowed prefixes for international bank accounts. For example: NL, US, UK.
   */
  @JsonProperty(JSON_PROPERTY_IBAN_PREFIXES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIbanPrefixes(List<String> ibanPrefixes) {
    this.ibanPrefixes = ibanPrefixes;
  }

  /**
   * **ibanAccountIdentificationRequirement**
   *
   * @param type **ibanAccountIdentificationRequirement**
   * @return the current {@code IbanAccountIdentificationRequirement} instance, allowing for method chaining
   */
  public IbanAccountIdentificationRequirement type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * **ibanAccountIdentificationRequirement**
   * @return type **ibanAccountIdentificationRequirement**
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TypeEnum getType() {
    return type;
  }

  /**
   * **ibanAccountIdentificationRequirement**
   *
   * @param type **ibanAccountIdentificationRequirement**
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }

  /**
   * Return true if this IbanAccountIdentificationRequirement object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    IbanAccountIdentificationRequirement ibanAccountIdentificationRequirement = (IbanAccountIdentificationRequirement) o;
    return Objects.equals(this.description, ibanAccountIdentificationRequirement.description) &&
        Objects.equals(this.ibanPrefixes, ibanAccountIdentificationRequirement.ibanPrefixes) &&
        Objects.equals(this.type, ibanAccountIdentificationRequirement.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(description, ibanPrefixes, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class IbanAccountIdentificationRequirement {\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    ibanPrefixes: ").append(toIndentedString(ibanPrefixes)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of IbanAccountIdentificationRequirement given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of IbanAccountIdentificationRequirement
   * @throws JsonProcessingException if the JSON string is invalid with respect to IbanAccountIdentificationRequirement
   */
  public static IbanAccountIdentificationRequirement fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, IbanAccountIdentificationRequirement.class);
  }
/**
  * Convert an instance of IbanAccountIdentificationRequirement to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
