/*
 * Configuration API
 *
 * The version of the OpenAPI document: 2
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.balanceplatform;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * RevealPinResponse
 */
@JsonPropertyOrder({
  RevealPinResponse.JSON_PROPERTY_ENCRYPTED_PIN_BLOCK,
  RevealPinResponse.JSON_PROPERTY_TOKEN
})

public class RevealPinResponse {
  public static final String JSON_PROPERTY_ENCRYPTED_PIN_BLOCK = "encryptedPinBlock";
  private String encryptedPinBlock;

  public static final String JSON_PROPERTY_TOKEN = "token";
  private String token;

  public RevealPinResponse() { 
  }

  /**
   * The encrypted [PIN block](https://www.pcisecuritystandards.org/glossary/pin-block).
   *
   * @param encryptedPinBlock The encrypted [PIN block](https://www.pcisecuritystandards.org/glossary/pin-block).
   * @return the current {@code RevealPinResponse} instance, allowing for method chaining
   */
  public RevealPinResponse encryptedPinBlock(String encryptedPinBlock) {
    this.encryptedPinBlock = encryptedPinBlock;
    return this;
  }

  /**
   * The encrypted [PIN block](https://www.pcisecuritystandards.org/glossary/pin-block).
   * @return encryptedPinBlock The encrypted [PIN block](https://www.pcisecuritystandards.org/glossary/pin-block).
   */
  @JsonProperty(JSON_PROPERTY_ENCRYPTED_PIN_BLOCK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getEncryptedPinBlock() {
    return encryptedPinBlock;
  }

  /**
   * The encrypted [PIN block](https://www.pcisecuritystandards.org/glossary/pin-block).
   *
   * @param encryptedPinBlock The encrypted [PIN block](https://www.pcisecuritystandards.org/glossary/pin-block).
   */
  @JsonProperty(JSON_PROPERTY_ENCRYPTED_PIN_BLOCK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEncryptedPinBlock(String encryptedPinBlock) {
    this.encryptedPinBlock = encryptedPinBlock;
  }

  /**
   * The 16-digit token that you need to extract the &#x60;encryptedPinBlock&#x60;.
   *
   * @param token The 16-digit token that you need to extract the &#x60;encryptedPinBlock&#x60;.
   * @return the current {@code RevealPinResponse} instance, allowing for method chaining
   */
  public RevealPinResponse token(String token) {
    this.token = token;
    return this;
  }

  /**
   * The 16-digit token that you need to extract the &#x60;encryptedPinBlock&#x60;.
   * @return token The 16-digit token that you need to extract the &#x60;encryptedPinBlock&#x60;.
   */
  @JsonProperty(JSON_PROPERTY_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getToken() {
    return token;
  }

  /**
   * The 16-digit token that you need to extract the &#x60;encryptedPinBlock&#x60;.
   *
   * @param token The 16-digit token that you need to extract the &#x60;encryptedPinBlock&#x60;.
   */
  @JsonProperty(JSON_PROPERTY_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setToken(String token) {
    this.token = token;
  }

  /**
   * Return true if this RevealPinResponse object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RevealPinResponse revealPinResponse = (RevealPinResponse) o;
    return Objects.equals(this.encryptedPinBlock, revealPinResponse.encryptedPinBlock) &&
        Objects.equals(this.token, revealPinResponse.token);
  }

  @Override
  public int hashCode() {
    return Objects.hash(encryptedPinBlock, token);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RevealPinResponse {\n");
    sb.append("    encryptedPinBlock: ").append(toIndentedString(encryptedPinBlock)).append("\n");
    sb.append("    token: ").append(toIndentedString(token)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of RevealPinResponse given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of RevealPinResponse
   * @throws JsonProcessingException if the JSON string is invalid with respect to RevealPinResponse
   */
  public static RevealPinResponse fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, RevealPinResponse.class);
  }
/**
  * Convert an instance of RevealPinResponse to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
