/*
 * Configuration API
 *
 * The version of the OpenAPI document: 2
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.balanceplatform;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * TargetUpdate
 */
@JsonPropertyOrder({
  TargetUpdate.JSON_PROPERTY_ID,
  TargetUpdate.JSON_PROPERTY_TYPE
})

public class TargetUpdate {
  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  /**
   * The resource for which you want to receive notifications. Possible values:  * **balancePlatform**: receive notifications about balance changes in your entire balance platform.  * **accountHolder**: receive notifications about balance changes of a specific user.  * **balanceAccount**: receive notifications about balance changes in a specific balance account.
   */
  public enum TypeEnum {
    BALANCEACCOUNT(String.valueOf("balanceAccount")),
    
    ACCOUNTHOLDER(String.valueOf("accountHolder")),
    
    BALANCEPLATFORM(String.valueOf("balancePlatform"));

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public TargetUpdate() { 
  }

  /**
   * The unique identifier of the &#x60;target.type&#x60;. This can be the ID of your:  * balance platform * account holder * account holder&#39;s balance account
   *
   * @param id The unique identifier of the &#x60;target.type&#x60;. This can be the ID of your:  * balance platform * account holder * account holder&#39;s balance account
   * @return the current {@code TargetUpdate} instance, allowing for method chaining
   */
  public TargetUpdate id(String id) {
    this.id = id;
    return this;
  }

  /**
   * The unique identifier of the &#x60;target.type&#x60;. This can be the ID of your:  * balance platform * account holder * account holder&#39;s balance account
   * @return id The unique identifier of the &#x60;target.type&#x60;. This can be the ID of your:  * balance platform * account holder * account holder&#39;s balance account
   */
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getId() {
    return id;
  }

  /**
   * The unique identifier of the &#x60;target.type&#x60;. This can be the ID of your:  * balance platform * account holder * account holder&#39;s balance account
   *
   * @param id The unique identifier of the &#x60;target.type&#x60;. This can be the ID of your:  * balance platform * account holder * account holder&#39;s balance account
   */
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }

  /**
   * The resource for which you want to receive notifications. Possible values:  * **balancePlatform**: receive notifications about balance changes in your entire balance platform.  * **accountHolder**: receive notifications about balance changes of a specific user.  * **balanceAccount**: receive notifications about balance changes in a specific balance account.
   *
   * @param type The resource for which you want to receive notifications. Possible values:  * **balancePlatform**: receive notifications about balance changes in your entire balance platform.  * **accountHolder**: receive notifications about balance changes of a specific user.  * **balanceAccount**: receive notifications about balance changes in a specific balance account.
   * @return the current {@code TargetUpdate} instance, allowing for method chaining
   */
  public TargetUpdate type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * The resource for which you want to receive notifications. Possible values:  * **balancePlatform**: receive notifications about balance changes in your entire balance platform.  * **accountHolder**: receive notifications about balance changes of a specific user.  * **balanceAccount**: receive notifications about balance changes in a specific balance account.
   * @return type The resource for which you want to receive notifications. Possible values:  * **balancePlatform**: receive notifications about balance changes in your entire balance platform.  * **accountHolder**: receive notifications about balance changes of a specific user.  * **balanceAccount**: receive notifications about balance changes in a specific balance account.
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TypeEnum getType() {
    return type;
  }

  /**
   * The resource for which you want to receive notifications. Possible values:  * **balancePlatform**: receive notifications about balance changes in your entire balance platform.  * **accountHolder**: receive notifications about balance changes of a specific user.  * **balanceAccount**: receive notifications about balance changes in a specific balance account.
   *
   * @param type The resource for which you want to receive notifications. Possible values:  * **balancePlatform**: receive notifications about balance changes in your entire balance platform.  * **accountHolder**: receive notifications about balance changes of a specific user.  * **balanceAccount**: receive notifications about balance changes in a specific balance account.
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }

  /**
   * Return true if this TargetUpdate object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TargetUpdate targetUpdate = (TargetUpdate) o;
    return Objects.equals(this.id, targetUpdate.id) &&
        Objects.equals(this.type, targetUpdate.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TargetUpdate {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of TargetUpdate given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of TargetUpdate
   * @throws JsonProcessingException if the JSON string is invalid with respect to TargetUpdate
   */
  public static TargetUpdate fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, TargetUpdate.class);
  }
/**
  * Convert an instance of TargetUpdate to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
