/*
 * Balance webhook
 *
 * The version of the OpenAPI document: 1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.balancewebhooks;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * Balances
 */
@JsonPropertyOrder({
  Balances.JSON_PROPERTY_AVAILABLE,
  Balances.JSON_PROPERTY_BALANCE,
  Balances.JSON_PROPERTY_PENDING,
  Balances.JSON_PROPERTY_RESERVED
})

public class Balances {
  public static final String JSON_PROPERTY_AVAILABLE = "available";
  private Long available;

  public static final String JSON_PROPERTY_BALANCE = "balance";
  private Long balance;

  public static final String JSON_PROPERTY_PENDING = "pending";
  private Long pending;

  public static final String JSON_PROPERTY_RESERVED = "reserved";
  private Long reserved;

  public Balances() { 
  }

  /**
   * The balance that is available for use.
   *
   * @param available The balance that is available for use.
   * @return the current {@code Balances} instance, allowing for method chaining
   */
  public Balances available(Long available) {
    this.available = available;
    return this;
  }

  /**
   * The balance that is available for use.
   * @return available The balance that is available for use.
   */
  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Long getAvailable() {
    return available;
  }

  /**
   * The balance that is available for use.
   *
   * @param available The balance that is available for use.
   */
  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAvailable(Long available) {
    this.available = available;
  }

  /**
   * The sum of transactions that have already been settled.
   *
   * @param balance The sum of transactions that have already been settled.
   * @return the current {@code Balances} instance, allowing for method chaining
   */
  public Balances balance(Long balance) {
    this.balance = balance;
    return this;
  }

  /**
   * The sum of transactions that have already been settled.
   * @return balance The sum of transactions that have already been settled.
   */
  @JsonProperty(JSON_PROPERTY_BALANCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Long getBalance() {
    return balance;
  }

  /**
   * The sum of transactions that have already been settled.
   *
   * @param balance The sum of transactions that have already been settled.
   */
  @JsonProperty(JSON_PROPERTY_BALANCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBalance(Long balance) {
    this.balance = balance;
  }

  /**
   * The sum of transactions that will be settled in the future.
   *
   * @param pending The sum of transactions that will be settled in the future.
   * @return the current {@code Balances} instance, allowing for method chaining
   */
  public Balances pending(Long pending) {
    this.pending = pending;
    return this;
  }

  /**
   * The sum of transactions that will be settled in the future.
   * @return pending The sum of transactions that will be settled in the future.
   */
  @JsonProperty(JSON_PROPERTY_PENDING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Long getPending() {
    return pending;
  }

  /**
   * The sum of transactions that will be settled in the future.
   *
   * @param pending The sum of transactions that will be settled in the future.
   */
  @JsonProperty(JSON_PROPERTY_PENDING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPending(Long pending) {
    this.pending = pending;
  }

  /**
   * The balance currently held in reserve.
   *
   * @param reserved The balance currently held in reserve.
   * @return the current {@code Balances} instance, allowing for method chaining
   */
  public Balances reserved(Long reserved) {
    this.reserved = reserved;
    return this;
  }

  /**
   * The balance currently held in reserve.
   * @return reserved The balance currently held in reserve.
   */
  @JsonProperty(JSON_PROPERTY_RESERVED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Long getReserved() {
    return reserved;
  }

  /**
   * The balance currently held in reserve.
   *
   * @param reserved The balance currently held in reserve.
   */
  @JsonProperty(JSON_PROPERTY_RESERVED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReserved(Long reserved) {
    this.reserved = reserved;
  }

  /**
   * Return true if this Balances object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Balances balances = (Balances) o;
    return Objects.equals(this.available, balances.available) &&
        Objects.equals(this.balance, balances.balance) &&
        Objects.equals(this.pending, balances.pending) &&
        Objects.equals(this.reserved, balances.reserved);
  }

  @Override
  public int hashCode() {
    return Objects.hash(available, balance, pending, reserved);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Balances {\n");
    sb.append("    available: ").append(toIndentedString(available)).append("\n");
    sb.append("    balance: ").append(toIndentedString(balance)).append("\n");
    sb.append("    pending: ").append(toIndentedString(pending)).append("\n");
    sb.append("    reserved: ").append(toIndentedString(reserved)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of Balances given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of Balances
   * @throws JsonProcessingException if the JSON string is invalid with respect to Balances
   */
  public static Balances fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, Balances.class);
  }
/**
  * Convert an instance of Balances to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
