/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 71
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.checkout;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * PaymentMethodIssuer
 */
@JsonPropertyOrder({
  PaymentMethodIssuer.JSON_PROPERTY_DISABLED,
  PaymentMethodIssuer.JSON_PROPERTY_ID,
  PaymentMethodIssuer.JSON_PROPERTY_NAME
})

public class PaymentMethodIssuer {
  public static final String JSON_PROPERTY_DISABLED = "disabled";
  private Boolean disabled = false;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public PaymentMethodIssuer() { 
  }

  /**
   * A boolean value indicating whether this issuer is unavailable. Can be &#x60;true&#x60; whenever the issuer is offline.
   *
   * @param disabled A boolean value indicating whether this issuer is unavailable. Can be &#x60;true&#x60; whenever the issuer is offline.
   * @return the current {@code PaymentMethodIssuer} instance, allowing for method chaining
   */
  public PaymentMethodIssuer disabled(Boolean disabled) {
    this.disabled = disabled;
    return this;
  }

  /**
   * A boolean value indicating whether this issuer is unavailable. Can be &#x60;true&#x60; whenever the issuer is offline.
   * @return disabled A boolean value indicating whether this issuer is unavailable. Can be &#x60;true&#x60; whenever the issuer is offline.
   */
  @JsonProperty(JSON_PROPERTY_DISABLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getDisabled() {
    return disabled;
  }

  /**
   * A boolean value indicating whether this issuer is unavailable. Can be &#x60;true&#x60; whenever the issuer is offline.
   *
   * @param disabled A boolean value indicating whether this issuer is unavailable. Can be &#x60;true&#x60; whenever the issuer is offline.
   */
  @JsonProperty(JSON_PROPERTY_DISABLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisabled(Boolean disabled) {
    this.disabled = disabled;
  }

  /**
   * The unique identifier of this issuer, to submit in requests to /payments.
   *
   * @param id The unique identifier of this issuer, to submit in requests to /payments.
   * @return the current {@code PaymentMethodIssuer} instance, allowing for method chaining
   */
  public PaymentMethodIssuer id(String id) {
    this.id = id;
    return this;
  }

  /**
   * The unique identifier of this issuer, to submit in requests to /payments.
   * @return id The unique identifier of this issuer, to submit in requests to /payments.
   */
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getId() {
    return id;
  }

  /**
   * The unique identifier of this issuer, to submit in requests to /payments.
   *
   * @param id The unique identifier of this issuer, to submit in requests to /payments.
   */
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }

  /**
   * A localized name of the issuer.
   *
   * @param name A localized name of the issuer.
   * @return the current {@code PaymentMethodIssuer} instance, allowing for method chaining
   */
  public PaymentMethodIssuer name(String name) {
    this.name = name;
    return this;
  }

  /**
   * A localized name of the issuer.
   * @return name A localized name of the issuer.
   */
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getName() {
    return name;
  }

  /**
   * A localized name of the issuer.
   *
   * @param name A localized name of the issuer.
   */
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }

  /**
   * Return true if this PaymentMethodIssuer object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentMethodIssuer paymentMethodIssuer = (PaymentMethodIssuer) o;
    return Objects.equals(this.disabled, paymentMethodIssuer.disabled) &&
        Objects.equals(this.id, paymentMethodIssuer.id) &&
        Objects.equals(this.name, paymentMethodIssuer.name);
  }

  @Override
  public int hashCode() {
    return Objects.hash(disabled, id, name);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentMethodIssuer {\n");
    sb.append("    disabled: ").append(toIndentedString(disabled)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of PaymentMethodIssuer given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of PaymentMethodIssuer
   * @throws JsonProcessingException if the JSON string is invalid with respect to PaymentMethodIssuer
   */
  public static PaymentMethodIssuer fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, PaymentMethodIssuer.class);
  }
/**
  * Convert an instance of PaymentMethodIssuer to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
