/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 71
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.checkout;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.checkout.PaymentMethodToStore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * StoredPaymentMethodRequest
 */
@JsonPropertyOrder({
  StoredPaymentMethodRequest.JSON_PROPERTY_MERCHANT_ACCOUNT,
  StoredPaymentMethodRequest.JSON_PROPERTY_PAYMENT_METHOD,
  StoredPaymentMethodRequest.JSON_PROPERTY_RECURRING_PROCESSING_MODEL,
  StoredPaymentMethodRequest.JSON_PROPERTY_SHOPPER_EMAIL,
  StoredPaymentMethodRequest.JSON_PROPERTY_SHOPPER_I_P,
  StoredPaymentMethodRequest.JSON_PROPERTY_SHOPPER_REFERENCE
})

public class StoredPaymentMethodRequest {
  public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
  private String merchantAccount;

  public static final String JSON_PROPERTY_PAYMENT_METHOD = "paymentMethod";
  private PaymentMethodToStore paymentMethod;

  /**
   * Defines a recurring payment type. Required when creating a token to store payment details. Allowed values: * &#x60;Subscription&#x60; – A transaction for a fixed or variable amount, which follows a fixed schedule. * &#x60;CardOnFile&#x60; – With a card-on-file (CoF) transaction, card details are stored to enable one-click or omnichannel journeys, or simply to streamline the checkout process. Any subscription not following a fixed schedule is also considered a card-on-file transaction. * &#x60;UnscheduledCardOnFile&#x60; – An unscheduled card-on-file (UCoF) transaction is a transaction that occurs on a non-fixed schedule and/or have variable amounts. For example, automatic top-ups when a cardholder&#39;s balance drops below a certain amount. 
   */
  public enum RecurringProcessingModelEnum {
    CARDONFILE(String.valueOf("CardOnFile")),
    
    SUBSCRIPTION(String.valueOf("Subscription")),
    
    UNSCHEDULEDCARDONFILE(String.valueOf("UnscheduledCardOnFile"));

    private String value;

    RecurringProcessingModelEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RecurringProcessingModelEnum fromValue(String value) {
      for (RecurringProcessingModelEnum b : RecurringProcessingModelEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_RECURRING_PROCESSING_MODEL = "recurringProcessingModel";
  private RecurringProcessingModelEnum recurringProcessingModel;

  public static final String JSON_PROPERTY_SHOPPER_EMAIL = "shopperEmail";
  private String shopperEmail;

  public static final String JSON_PROPERTY_SHOPPER_I_P = "shopperIP";
  private String shopperIP;

  public static final String JSON_PROPERTY_SHOPPER_REFERENCE = "shopperReference";
  private String shopperReference;

  public StoredPaymentMethodRequest() { 
  }

  /**
   * The merchant account identifier, with which you want to process the transaction.
   *
   * @param merchantAccount The merchant account identifier, with which you want to process the transaction.
   * @return the current {@code StoredPaymentMethodRequest} instance, allowing for method chaining
   */
  public StoredPaymentMethodRequest merchantAccount(String merchantAccount) {
    this.merchantAccount = merchantAccount;
    return this;
  }

  /**
   * The merchant account identifier, with which you want to process the transaction.
   * @return merchantAccount The merchant account identifier, with which you want to process the transaction.
   */
  @JsonProperty(JSON_PROPERTY_MERCHANT_ACCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMerchantAccount() {
    return merchantAccount;
  }

  /**
   * The merchant account identifier, with which you want to process the transaction.
   *
   * @param merchantAccount The merchant account identifier, with which you want to process the transaction.
   */
  @JsonProperty(JSON_PROPERTY_MERCHANT_ACCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMerchantAccount(String merchantAccount) {
    this.merchantAccount = merchantAccount;
  }

  /**
   * paymentMethod
   *
   * @param paymentMethod 
   * @return the current {@code StoredPaymentMethodRequest} instance, allowing for method chaining
   */
  public StoredPaymentMethodRequest paymentMethod(PaymentMethodToStore paymentMethod) {
    this.paymentMethod = paymentMethod;
    return this;
  }

  /**
   * Get paymentMethod
   * @return paymentMethod 
   */
  @JsonProperty(JSON_PROPERTY_PAYMENT_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public PaymentMethodToStore getPaymentMethod() {
    return paymentMethod;
  }

  /**
   * paymentMethod
   *
   * @param paymentMethod 
   */
  @JsonProperty(JSON_PROPERTY_PAYMENT_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaymentMethod(PaymentMethodToStore paymentMethod) {
    this.paymentMethod = paymentMethod;
  }

  /**
   * Defines a recurring payment type. Required when creating a token to store payment details. Allowed values: * &#x60;Subscription&#x60; – A transaction for a fixed or variable amount, which follows a fixed schedule. * &#x60;CardOnFile&#x60; – With a card-on-file (CoF) transaction, card details are stored to enable one-click or omnichannel journeys, or simply to streamline the checkout process. Any subscription not following a fixed schedule is also considered a card-on-file transaction. * &#x60;UnscheduledCardOnFile&#x60; – An unscheduled card-on-file (UCoF) transaction is a transaction that occurs on a non-fixed schedule and/or have variable amounts. For example, automatic top-ups when a cardholder&#39;s balance drops below a certain amount. 
   *
   * @param recurringProcessingModel Defines a recurring payment type. Required when creating a token to store payment details. Allowed values: * &#x60;Subscription&#x60; – A transaction for a fixed or variable amount, which follows a fixed schedule. * &#x60;CardOnFile&#x60; – With a card-on-file (CoF) transaction, card details are stored to enable one-click or omnichannel journeys, or simply to streamline the checkout process. Any subscription not following a fixed schedule is also considered a card-on-file transaction. * &#x60;UnscheduledCardOnFile&#x60; – An unscheduled card-on-file (UCoF) transaction is a transaction that occurs on a non-fixed schedule and/or have variable amounts. For example, automatic top-ups when a cardholder&#39;s balance drops below a certain amount. 
   * @return the current {@code StoredPaymentMethodRequest} instance, allowing for method chaining
   */
  public StoredPaymentMethodRequest recurringProcessingModel(RecurringProcessingModelEnum recurringProcessingModel) {
    this.recurringProcessingModel = recurringProcessingModel;
    return this;
  }

  /**
   * Defines a recurring payment type. Required when creating a token to store payment details. Allowed values: * &#x60;Subscription&#x60; – A transaction for a fixed or variable amount, which follows a fixed schedule. * &#x60;CardOnFile&#x60; – With a card-on-file (CoF) transaction, card details are stored to enable one-click or omnichannel journeys, or simply to streamline the checkout process. Any subscription not following a fixed schedule is also considered a card-on-file transaction. * &#x60;UnscheduledCardOnFile&#x60; – An unscheduled card-on-file (UCoF) transaction is a transaction that occurs on a non-fixed schedule and/or have variable amounts. For example, automatic top-ups when a cardholder&#39;s balance drops below a certain amount. 
   * @return recurringProcessingModel Defines a recurring payment type. Required when creating a token to store payment details. Allowed values: * &#x60;Subscription&#x60; – A transaction for a fixed or variable amount, which follows a fixed schedule. * &#x60;CardOnFile&#x60; – With a card-on-file (CoF) transaction, card details are stored to enable one-click or omnichannel journeys, or simply to streamline the checkout process. Any subscription not following a fixed schedule is also considered a card-on-file transaction. * &#x60;UnscheduledCardOnFile&#x60; – An unscheduled card-on-file (UCoF) transaction is a transaction that occurs on a non-fixed schedule and/or have variable amounts. For example, automatic top-ups when a cardholder&#39;s balance drops below a certain amount. 
   */
  @JsonProperty(JSON_PROPERTY_RECURRING_PROCESSING_MODEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public RecurringProcessingModelEnum getRecurringProcessingModel() {
    return recurringProcessingModel;
  }

  /**
   * Defines a recurring payment type. Required when creating a token to store payment details. Allowed values: * &#x60;Subscription&#x60; – A transaction for a fixed or variable amount, which follows a fixed schedule. * &#x60;CardOnFile&#x60; – With a card-on-file (CoF) transaction, card details are stored to enable one-click or omnichannel journeys, or simply to streamline the checkout process. Any subscription not following a fixed schedule is also considered a card-on-file transaction. * &#x60;UnscheduledCardOnFile&#x60; – An unscheduled card-on-file (UCoF) transaction is a transaction that occurs on a non-fixed schedule and/or have variable amounts. For example, automatic top-ups when a cardholder&#39;s balance drops below a certain amount. 
   *
   * @param recurringProcessingModel Defines a recurring payment type. Required when creating a token to store payment details. Allowed values: * &#x60;Subscription&#x60; – A transaction for a fixed or variable amount, which follows a fixed schedule. * &#x60;CardOnFile&#x60; – With a card-on-file (CoF) transaction, card details are stored to enable one-click or omnichannel journeys, or simply to streamline the checkout process. Any subscription not following a fixed schedule is also considered a card-on-file transaction. * &#x60;UnscheduledCardOnFile&#x60; – An unscheduled card-on-file (UCoF) transaction is a transaction that occurs on a non-fixed schedule and/or have variable amounts. For example, automatic top-ups when a cardholder&#39;s balance drops below a certain amount. 
   */
  @JsonProperty(JSON_PROPERTY_RECURRING_PROCESSING_MODEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecurringProcessingModel(RecurringProcessingModelEnum recurringProcessingModel) {
    this.recurringProcessingModel = recurringProcessingModel;
  }

  /**
   * The shopper&#39;s email address. We recommend that you provide this data, as it is used in velocity fraud checks.
   *
   * @param shopperEmail The shopper&#39;s email address. We recommend that you provide this data, as it is used in velocity fraud checks.
   * @return the current {@code StoredPaymentMethodRequest} instance, allowing for method chaining
   */
  public StoredPaymentMethodRequest shopperEmail(String shopperEmail) {
    this.shopperEmail = shopperEmail;
    return this;
  }

  /**
   * The shopper&#39;s email address. We recommend that you provide this data, as it is used in velocity fraud checks.
   * @return shopperEmail The shopper&#39;s email address. We recommend that you provide this data, as it is used in velocity fraud checks.
   */
  @JsonProperty(JSON_PROPERTY_SHOPPER_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getShopperEmail() {
    return shopperEmail;
  }

  /**
   * The shopper&#39;s email address. We recommend that you provide this data, as it is used in velocity fraud checks.
   *
   * @param shopperEmail The shopper&#39;s email address. We recommend that you provide this data, as it is used in velocity fraud checks.
   */
  @JsonProperty(JSON_PROPERTY_SHOPPER_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShopperEmail(String shopperEmail) {
    this.shopperEmail = shopperEmail;
  }

  /**
   * The IP address of a shopper.
   *
   * @param shopperIP The IP address of a shopper.
   * @return the current {@code StoredPaymentMethodRequest} instance, allowing for method chaining
   */
  public StoredPaymentMethodRequest shopperIP(String shopperIP) {
    this.shopperIP = shopperIP;
    return this;
  }

  /**
   * The IP address of a shopper.
   * @return shopperIP The IP address of a shopper.
   */
  @JsonProperty(JSON_PROPERTY_SHOPPER_I_P)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getShopperIP() {
    return shopperIP;
  }

  /**
   * The IP address of a shopper.
   *
   * @param shopperIP The IP address of a shopper.
   */
  @JsonProperty(JSON_PROPERTY_SHOPPER_I_P)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShopperIP(String shopperIP) {
    this.shopperIP = shopperIP;
  }

  /**
   * A unique identifier for the shopper (for example, user ID or account ID).
   *
   * @param shopperReference A unique identifier for the shopper (for example, user ID or account ID).
   * @return the current {@code StoredPaymentMethodRequest} instance, allowing for method chaining
   */
  public StoredPaymentMethodRequest shopperReference(String shopperReference) {
    this.shopperReference = shopperReference;
    return this;
  }

  /**
   * A unique identifier for the shopper (for example, user ID or account ID).
   * @return shopperReference A unique identifier for the shopper (for example, user ID or account ID).
   */
  @JsonProperty(JSON_PROPERTY_SHOPPER_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getShopperReference() {
    return shopperReference;
  }

  /**
   * A unique identifier for the shopper (for example, user ID or account ID).
   *
   * @param shopperReference A unique identifier for the shopper (for example, user ID or account ID).
   */
  @JsonProperty(JSON_PROPERTY_SHOPPER_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShopperReference(String shopperReference) {
    this.shopperReference = shopperReference;
  }

  /**
   * Return true if this StoredPaymentMethodRequest object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    StoredPaymentMethodRequest storedPaymentMethodRequest = (StoredPaymentMethodRequest) o;
    return Objects.equals(this.merchantAccount, storedPaymentMethodRequest.merchantAccount) &&
        Objects.equals(this.paymentMethod, storedPaymentMethodRequest.paymentMethod) &&
        Objects.equals(this.recurringProcessingModel, storedPaymentMethodRequest.recurringProcessingModel) &&
        Objects.equals(this.shopperEmail, storedPaymentMethodRequest.shopperEmail) &&
        Objects.equals(this.shopperIP, storedPaymentMethodRequest.shopperIP) &&
        Objects.equals(this.shopperReference, storedPaymentMethodRequest.shopperReference);
  }

  @Override
  public int hashCode() {
    return Objects.hash(merchantAccount, paymentMethod, recurringProcessingModel, shopperEmail, shopperIP, shopperReference);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class StoredPaymentMethodRequest {\n");
    sb.append("    merchantAccount: ").append(toIndentedString(merchantAccount)).append("\n");
    sb.append("    paymentMethod: ").append(toIndentedString(paymentMethod)).append("\n");
    sb.append("    recurringProcessingModel: ").append(toIndentedString(recurringProcessingModel)).append("\n");
    sb.append("    shopperEmail: ").append(toIndentedString(shopperEmail)).append("\n");
    sb.append("    shopperIP: ").append(toIndentedString(shopperIP)).append("\n");
    sb.append("    shopperReference: ").append(toIndentedString(shopperReference)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of StoredPaymentMethodRequest given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of StoredPaymentMethodRequest
   * @throws JsonProcessingException if the JSON string is invalid with respect to StoredPaymentMethodRequest
   */
  public static StoredPaymentMethodRequest fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, StoredPaymentMethodRequest.class);
  }
/**
  * Convert an instance of StoredPaymentMethodRequest to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
