/*
 * Configuration webhooks
 *
 * The version of the OpenAPI document: 2
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.configurationwebhooks;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.configurationwebhooks.CardOrderItem;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * CardOrderNotificationRequest
 */
@JsonPropertyOrder({
  CardOrderNotificationRequest.JSON_PROPERTY_DATA,
  CardOrderNotificationRequest.JSON_PROPERTY_ENVIRONMENT,
  CardOrderNotificationRequest.JSON_PROPERTY_TIMESTAMP,
  CardOrderNotificationRequest.JSON_PROPERTY_TYPE
})

public class CardOrderNotificationRequest {
  public static final String JSON_PROPERTY_DATA = "data";
  private CardOrderItem data;

  public static final String JSON_PROPERTY_ENVIRONMENT = "environment";
  private String environment;

  public static final String JSON_PROPERTY_TIMESTAMP = "timestamp";
  private OffsetDateTime timestamp;

  /**
   * Type of webhook.
   */
  public enum TypeEnum {
    BALANCEPLATFORM_CARDORDER_CREATED(String.valueOf("balancePlatform.cardorder.created")),
    
    BALANCEPLATFORM_CARDORDER_UPDATED(String.valueOf("balancePlatform.cardorder.updated"));

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public CardOrderNotificationRequest() { 
  }

  /**
   * data
   *
   * @param data 
   * @return the current {@code CardOrderNotificationRequest} instance, allowing for method chaining
   */
  public CardOrderNotificationRequest data(CardOrderItem data) {
    this.data = data;
    return this;
  }

  /**
   * Get data
   * @return data 
   */
  @JsonProperty(JSON_PROPERTY_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public CardOrderItem getData() {
    return data;
  }

  /**
   * data
   *
   * @param data 
   */
  @JsonProperty(JSON_PROPERTY_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setData(CardOrderItem data) {
    this.data = data;
  }

  /**
   * The environment from which the webhook originated.  Possible values: **test**, **live**.
   *
   * @param environment The environment from which the webhook originated.  Possible values: **test**, **live**.
   * @return the current {@code CardOrderNotificationRequest} instance, allowing for method chaining
   */
  public CardOrderNotificationRequest environment(String environment) {
    this.environment = environment;
    return this;
  }

  /**
   * The environment from which the webhook originated.  Possible values: **test**, **live**.
   * @return environment The environment from which the webhook originated.  Possible values: **test**, **live**.
   */
  @JsonProperty(JSON_PROPERTY_ENVIRONMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getEnvironment() {
    return environment;
  }

  /**
   * The environment from which the webhook originated.  Possible values: **test**, **live**.
   *
   * @param environment The environment from which the webhook originated.  Possible values: **test**, **live**.
   */
  @JsonProperty(JSON_PROPERTY_ENVIRONMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEnvironment(String environment) {
    this.environment = environment;
  }

  /**
   * When the event was queued.
   *
   * @param timestamp When the event was queued.
   * @return the current {@code CardOrderNotificationRequest} instance, allowing for method chaining
   */
  public CardOrderNotificationRequest timestamp(OffsetDateTime timestamp) {
    this.timestamp = timestamp;
    return this;
  }

  /**
   * When the event was queued.
   * @return timestamp When the event was queued.
   */
  @JsonProperty(JSON_PROPERTY_TIMESTAMP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OffsetDateTime getTimestamp() {
    return timestamp;
  }

  /**
   * When the event was queued.
   *
   * @param timestamp When the event was queued.
   */
  @JsonProperty(JSON_PROPERTY_TIMESTAMP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTimestamp(OffsetDateTime timestamp) {
    this.timestamp = timestamp;
  }

  /**
   * Type of webhook.
   *
   * @param type Type of webhook.
   * @return the current {@code CardOrderNotificationRequest} instance, allowing for method chaining
   */
  public CardOrderNotificationRequest type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * Type of webhook.
   * @return type Type of webhook.
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TypeEnum getType() {
    return type;
  }

  /**
   * Type of webhook.
   *
   * @param type Type of webhook.
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }

  /**
   * Return true if this CardOrderNotificationRequest object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CardOrderNotificationRequest cardOrderNotificationRequest = (CardOrderNotificationRequest) o;
    return Objects.equals(this.data, cardOrderNotificationRequest.data) &&
        Objects.equals(this.environment, cardOrderNotificationRequest.environment) &&
        Objects.equals(this.timestamp, cardOrderNotificationRequest.timestamp) &&
        Objects.equals(this.type, cardOrderNotificationRequest.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(data, environment, timestamp, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CardOrderNotificationRequest {\n");
    sb.append("    data: ").append(toIndentedString(data)).append("\n");
    sb.append("    environment: ").append(toIndentedString(environment)).append("\n");
    sb.append("    timestamp: ").append(toIndentedString(timestamp)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of CardOrderNotificationRequest given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of CardOrderNotificationRequest
   * @throws JsonProcessingException if the JSON string is invalid with respect to CardOrderNotificationRequest
   */
  public static CardOrderNotificationRequest fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, CardOrderNotificationRequest.class);
  }
/**
  * Convert an instance of CardOrderNotificationRequest to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
