/*
 * Configuration webhooks
 *
 * The version of the OpenAPI document: 2
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.configurationwebhooks;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.configurationwebhooks.RemediatingAction;
import com.adyen.model.configurationwebhooks.VerificationErrorRecursive;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * VerificationError
 */
@JsonPropertyOrder({
  VerificationError.JSON_PROPERTY_CAPABILITIES,
  VerificationError.JSON_PROPERTY_CODE,
  VerificationError.JSON_PROPERTY_MESSAGE,
  VerificationError.JSON_PROPERTY_REMEDIATING_ACTIONS,
  VerificationError.JSON_PROPERTY_SUB_ERRORS,
  VerificationError.JSON_PROPERTY_TYPE
})

public class VerificationError {
  /**
   * Gets or Sets capabilities
   */
  public enum CapabilitiesEnum {
    ACCEPTEXTERNALFUNDING(String.valueOf("acceptExternalFunding")),
    
    ACCEPTPSPFUNDING(String.valueOf("acceptPspFunding")),
    
    ACCEPTTRANSACTIONINRESTRICTEDCOUNTRIES(String.valueOf("acceptTransactionInRestrictedCountries")),
    
    ACCEPTTRANSACTIONINRESTRICTEDCOUNTRIESCOMMERCIAL(String.valueOf("acceptTransactionInRestrictedCountriesCommercial")),
    
    ACCEPTTRANSACTIONINRESTRICTEDCOUNTRIESCONSUMER(String.valueOf("acceptTransactionInRestrictedCountriesConsumer")),
    
    ACCEPTTRANSACTIONINRESTRICTEDINDUSTRIES(String.valueOf("acceptTransactionInRestrictedIndustries")),
    
    ACCEPTTRANSACTIONINRESTRICTEDINDUSTRIESCOMMERCIAL(String.valueOf("acceptTransactionInRestrictedIndustriesCommercial")),
    
    ACCEPTTRANSACTIONINRESTRICTEDINDUSTRIESCONSUMER(String.valueOf("acceptTransactionInRestrictedIndustriesConsumer")),
    
    ACQUIRING(String.valueOf("acquiring")),
    
    ATMWITHDRAWAL(String.valueOf("atmWithdrawal")),
    
    ATMWITHDRAWALCOMMERCIAL(String.valueOf("atmWithdrawalCommercial")),
    
    ATMWITHDRAWALCONSUMER(String.valueOf("atmWithdrawalConsumer")),
    
    ATMWITHDRAWALINRESTRICTEDCOUNTRIES(String.valueOf("atmWithdrawalInRestrictedCountries")),
    
    ATMWITHDRAWALINRESTRICTEDCOUNTRIESCOMMERCIAL(String.valueOf("atmWithdrawalInRestrictedCountriesCommercial")),
    
    ATMWITHDRAWALINRESTRICTEDCOUNTRIESCONSUMER(String.valueOf("atmWithdrawalInRestrictedCountriesConsumer")),
    
    AUTHORISEDPAYMENTINSTRUMENTUSER(String.valueOf("authorisedPaymentInstrumentUser")),
    
    GETGRANTOFFERS(String.valueOf("getGrantOffers")),
    
    ISSUEBANKACCOUNT(String.valueOf("issueBankAccount")),
    
    ISSUECARD(String.valueOf("issueCard")),
    
    ISSUECARDCOMMERCIAL(String.valueOf("issueCardCommercial")),
    
    ISSUECARDCONSUMER(String.valueOf("issueCardConsumer")),
    
    ISSUECHARGECARD(String.valueOf("issueChargeCard")),
    
    ISSUECHARGECARDCOMMERCIAL(String.valueOf("issueChargeCardCommercial")),
    
    ISSUECREDITLIMIT(String.valueOf("issueCreditLimit")),
    
    LOCALACCEPTANCE(String.valueOf("localAcceptance")),
    
    PAYOUT(String.valueOf("payout")),
    
    PAYOUTTOTRANSFERINSTRUMENT(String.valueOf("payoutToTransferInstrument")),
    
    PROCESSING(String.valueOf("processing")),
    
    RECEIVEFROMBALANCEACCOUNT(String.valueOf("receiveFromBalanceAccount")),
    
    RECEIVEFROMPLATFORMPAYMENTS(String.valueOf("receiveFromPlatformPayments")),
    
    RECEIVEFROMTHIRDPARTY(String.valueOf("receiveFromThirdParty")),
    
    RECEIVEFROMTRANSFERINSTRUMENT(String.valueOf("receiveFromTransferInstrument")),
    
    RECEIVEGRANTS(String.valueOf("receiveGrants")),
    
    RECEIVEPAYMENTS(String.valueOf("receivePayments")),
    
    SENDTOBALANCEACCOUNT(String.valueOf("sendToBalanceAccount")),
    
    SENDTOTHIRDPARTY(String.valueOf("sendToThirdParty")),
    
    SENDTOTRANSFERINSTRUMENT(String.valueOf("sendToTransferInstrument")),
    
    THIRDPARTYFUNDING(String.valueOf("thirdPartyFunding")),
    
    USECARD(String.valueOf("useCard")),
    
    USECARDCOMMERCIAL(String.valueOf("useCardCommercial")),
    
    USECARDCONSUMER(String.valueOf("useCardConsumer")),
    
    USECARDINRESTRICTEDCOUNTRIES(String.valueOf("useCardInRestrictedCountries")),
    
    USECARDINRESTRICTEDCOUNTRIESCOMMERCIAL(String.valueOf("useCardInRestrictedCountriesCommercial")),
    
    USECARDINRESTRICTEDCOUNTRIESCONSUMER(String.valueOf("useCardInRestrictedCountriesConsumer")),
    
    USECARDINRESTRICTEDINDUSTRIES(String.valueOf("useCardInRestrictedIndustries")),
    
    USECARDINRESTRICTEDINDUSTRIESCOMMERCIAL(String.valueOf("useCardInRestrictedIndustriesCommercial")),
    
    USECARDINRESTRICTEDINDUSTRIESCONSUMER(String.valueOf("useCardInRestrictedIndustriesConsumer")),
    
    USECHARGECARD(String.valueOf("useChargeCard")),
    
    USECHARGECARDCOMMERCIAL(String.valueOf("useChargeCardCommercial")),
    
    WITHDRAWFROMATM(String.valueOf("withdrawFromAtm")),
    
    WITHDRAWFROMATMCOMMERCIAL(String.valueOf("withdrawFromAtmCommercial")),
    
    WITHDRAWFROMATMCONSUMER(String.valueOf("withdrawFromAtmConsumer")),
    
    WITHDRAWFROMATMINRESTRICTEDCOUNTRIES(String.valueOf("withdrawFromAtmInRestrictedCountries")),
    
    WITHDRAWFROMATMINRESTRICTEDCOUNTRIESCOMMERCIAL(String.valueOf("withdrawFromAtmInRestrictedCountriesCommercial")),
    
    WITHDRAWFROMATMINRESTRICTEDCOUNTRIESCONSUMER(String.valueOf("withdrawFromAtmInRestrictedCountriesConsumer"));

    private String value;

    CapabilitiesEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CapabilitiesEnum fromValue(String value) {
      for (CapabilitiesEnum b : CapabilitiesEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CAPABILITIES = "capabilities";
  private List<CapabilitiesEnum> capabilities;

  public static final String JSON_PROPERTY_CODE = "code";
  private String code;

  public static final String JSON_PROPERTY_MESSAGE = "message";
  private String message;

  public static final String JSON_PROPERTY_REMEDIATING_ACTIONS = "remediatingActions";
  private List<RemediatingAction> remediatingActions;

  public static final String JSON_PROPERTY_SUB_ERRORS = "subErrors";
  private List<VerificationErrorRecursive> subErrors;

  /**
   * The type of error.   Possible values: **invalidInput**, **dataMissing**.
   */
  public enum TypeEnum {
    DATAMISSING(String.valueOf("dataMissing")),
    
    INVALIDINPUT(String.valueOf("invalidInput")),
    
    PENDINGSTATUS(String.valueOf("pendingStatus"));

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public VerificationError() { 
  }

  /**
   * Contains the capabilities that the verification error applies to.
   *
   * @param capabilities Contains the capabilities that the verification error applies to.
   * @return the current {@code VerificationError} instance, allowing for method chaining
   */
  public VerificationError capabilities(List<CapabilitiesEnum> capabilities) {
    this.capabilities = capabilities;
    return this;
  }

  public VerificationError addCapabilitiesItem(CapabilitiesEnum capabilitiesItem) {
    if (this.capabilities == null) {
      this.capabilities = new ArrayList<>();
    }
    this.capabilities.add(capabilitiesItem);
    return this;
  }

  /**
   * Contains the capabilities that the verification error applies to.
   * @return capabilities Contains the capabilities that the verification error applies to.
   */
  @JsonProperty(JSON_PROPERTY_CAPABILITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<CapabilitiesEnum> getCapabilities() {
    return capabilities;
  }

  /**
   * Contains the capabilities that the verification error applies to.
   *
   * @param capabilities Contains the capabilities that the verification error applies to.
   */
  @JsonProperty(JSON_PROPERTY_CAPABILITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCapabilities(List<CapabilitiesEnum> capabilities) {
    this.capabilities = capabilities;
  }

  /**
   * The verification error code.
   *
   * @param code The verification error code.
   * @return the current {@code VerificationError} instance, allowing for method chaining
   */
  public VerificationError code(String code) {
    this.code = code;
    return this;
  }

  /**
   * The verification error code.
   * @return code The verification error code.
   */
  @JsonProperty(JSON_PROPERTY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCode() {
    return code;
  }

  /**
   * The verification error code.
   *
   * @param code The verification error code.
   */
  @JsonProperty(JSON_PROPERTY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCode(String code) {
    this.code = code;
  }

  /**
   * A description of the error.
   *
   * @param message A description of the error.
   * @return the current {@code VerificationError} instance, allowing for method chaining
   */
  public VerificationError message(String message) {
    this.message = message;
    return this;
  }

  /**
   * A description of the error.
   * @return message A description of the error.
   */
  @JsonProperty(JSON_PROPERTY_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMessage() {
    return message;
  }

  /**
   * A description of the error.
   *
   * @param message A description of the error.
   */
  @JsonProperty(JSON_PROPERTY_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMessage(String message) {
    this.message = message;
  }

  /**
   * Contains the actions that you can take to resolve the verification error.
   *
   * @param remediatingActions Contains the actions that you can take to resolve the verification error.
   * @return the current {@code VerificationError} instance, allowing for method chaining
   */
  public VerificationError remediatingActions(List<RemediatingAction> remediatingActions) {
    this.remediatingActions = remediatingActions;
    return this;
  }

  public VerificationError addRemediatingActionsItem(RemediatingAction remediatingActionsItem) {
    if (this.remediatingActions == null) {
      this.remediatingActions = new ArrayList<>();
    }
    this.remediatingActions.add(remediatingActionsItem);
    return this;
  }

  /**
   * Contains the actions that you can take to resolve the verification error.
   * @return remediatingActions Contains the actions that you can take to resolve the verification error.
   */
  @JsonProperty(JSON_PROPERTY_REMEDIATING_ACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<RemediatingAction> getRemediatingActions() {
    return remediatingActions;
  }

  /**
   * Contains the actions that you can take to resolve the verification error.
   *
   * @param remediatingActions Contains the actions that you can take to resolve the verification error.
   */
  @JsonProperty(JSON_PROPERTY_REMEDIATING_ACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRemediatingActions(List<RemediatingAction> remediatingActions) {
    this.remediatingActions = remediatingActions;
  }

  /**
   * Contains more granular information about the verification error.
   *
   * @param subErrors Contains more granular information about the verification error.
   * @return the current {@code VerificationError} instance, allowing for method chaining
   */
  public VerificationError subErrors(List<VerificationErrorRecursive> subErrors) {
    this.subErrors = subErrors;
    return this;
  }

  public VerificationError addSubErrorsItem(VerificationErrorRecursive subErrorsItem) {
    if (this.subErrors == null) {
      this.subErrors = new ArrayList<>();
    }
    this.subErrors.add(subErrorsItem);
    return this;
  }

  /**
   * Contains more granular information about the verification error.
   * @return subErrors Contains more granular information about the verification error.
   */
  @JsonProperty(JSON_PROPERTY_SUB_ERRORS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<VerificationErrorRecursive> getSubErrors() {
    return subErrors;
  }

  /**
   * Contains more granular information about the verification error.
   *
   * @param subErrors Contains more granular information about the verification error.
   */
  @JsonProperty(JSON_PROPERTY_SUB_ERRORS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubErrors(List<VerificationErrorRecursive> subErrors) {
    this.subErrors = subErrors;
  }

  /**
   * The type of error.   Possible values: **invalidInput**, **dataMissing**.
   *
   * @param type The type of error.   Possible values: **invalidInput**, **dataMissing**.
   * @return the current {@code VerificationError} instance, allowing for method chaining
   */
  public VerificationError type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * The type of error.   Possible values: **invalidInput**, **dataMissing**.
   * @return type The type of error.   Possible values: **invalidInput**, **dataMissing**.
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TypeEnum getType() {
    return type;
  }

  /**
   * The type of error.   Possible values: **invalidInput**, **dataMissing**.
   *
   * @param type The type of error.   Possible values: **invalidInput**, **dataMissing**.
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }

  /**
   * Return true if this VerificationError object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    VerificationError verificationError = (VerificationError) o;
    return Objects.equals(this.capabilities, verificationError.capabilities) &&
        Objects.equals(this.code, verificationError.code) &&
        Objects.equals(this.message, verificationError.message) &&
        Objects.equals(this.remediatingActions, verificationError.remediatingActions) &&
        Objects.equals(this.subErrors, verificationError.subErrors) &&
        Objects.equals(this.type, verificationError.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(capabilities, code, message, remediatingActions, subErrors, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class VerificationError {\n");
    sb.append("    capabilities: ").append(toIndentedString(capabilities)).append("\n");
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    remediatingActions: ").append(toIndentedString(remediatingActions)).append("\n");
    sb.append("    subErrors: ").append(toIndentedString(subErrors)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of VerificationError given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of VerificationError
   * @throws JsonProcessingException if the JSON string is invalid with respect to VerificationError
   */
  public static VerificationError fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, VerificationError.class);
  }
/**
  * Convert an instance of VerificationError to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
