/*
 * Disputes API
 *
 * The version of the OpenAPI document: 30
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.disputes;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * DefenseDocument
 */
@JsonPropertyOrder({
  DefenseDocument.JSON_PROPERTY_CONTENT,
  DefenseDocument.JSON_PROPERTY_CONTENT_TYPE,
  DefenseDocument.JSON_PROPERTY_DEFENSE_DOCUMENT_TYPE_CODE
})

public class DefenseDocument {
  public static final String JSON_PROPERTY_CONTENT = "content";
  private byte[] content;

  public static final String JSON_PROPERTY_CONTENT_TYPE = "contentType";
  private String contentType;

  public static final String JSON_PROPERTY_DEFENSE_DOCUMENT_TYPE_CODE = "defenseDocumentTypeCode";
  private String defenseDocumentTypeCode;

  public DefenseDocument() { 
  }

  /**
   * The content of the defense document.
   *
   * @param content The content of the defense document.
   * @return the current {@code DefenseDocument} instance, allowing for method chaining
   */
  public DefenseDocument content(byte[] content) {
    this.content = content;
    return this;
  }

  /**
   * The content of the defense document.
   * @return content The content of the defense document.
   */
  @JsonProperty(JSON_PROPERTY_CONTENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public byte[] getContent() {
    return content;
  }

  /**
   * The content of the defense document.
   *
   * @param content The content of the defense document.
   */
  @JsonProperty(JSON_PROPERTY_CONTENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContent(byte[] content) {
    this.content = content;
  }

  /**
   * The content type of the defense document.
   *
   * @param contentType The content type of the defense document.
   * @return the current {@code DefenseDocument} instance, allowing for method chaining
   */
  public DefenseDocument contentType(String contentType) {
    this.contentType = contentType;
    return this;
  }

  /**
   * The content type of the defense document.
   * @return contentType The content type of the defense document.
   */
  @JsonProperty(JSON_PROPERTY_CONTENT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getContentType() {
    return contentType;
  }

  /**
   * The content type of the defense document.
   *
   * @param contentType The content type of the defense document.
   */
  @JsonProperty(JSON_PROPERTY_CONTENT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContentType(String contentType) {
    this.contentType = contentType;
  }

  /**
   * The document type code of the defense document.
   *
   * @param defenseDocumentTypeCode The document type code of the defense document.
   * @return the current {@code DefenseDocument} instance, allowing for method chaining
   */
  public DefenseDocument defenseDocumentTypeCode(String defenseDocumentTypeCode) {
    this.defenseDocumentTypeCode = defenseDocumentTypeCode;
    return this;
  }

  /**
   * The document type code of the defense document.
   * @return defenseDocumentTypeCode The document type code of the defense document.
   */
  @JsonProperty(JSON_PROPERTY_DEFENSE_DOCUMENT_TYPE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDefenseDocumentTypeCode() {
    return defenseDocumentTypeCode;
  }

  /**
   * The document type code of the defense document.
   *
   * @param defenseDocumentTypeCode The document type code of the defense document.
   */
  @JsonProperty(JSON_PROPERTY_DEFENSE_DOCUMENT_TYPE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDefenseDocumentTypeCode(String defenseDocumentTypeCode) {
    this.defenseDocumentTypeCode = defenseDocumentTypeCode;
  }

  /**
   * Return true if this DefenseDocument object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DefenseDocument defenseDocument = (DefenseDocument) o;
    return Arrays.equals(this.content, defenseDocument.content) &&
        Objects.equals(this.contentType, defenseDocument.contentType) &&
        Objects.equals(this.defenseDocumentTypeCode, defenseDocument.defenseDocumentTypeCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(Arrays.hashCode(content), contentType, defenseDocumentTypeCode);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DefenseDocument {\n");
    sb.append("    content: ").append(toIndentedString(content)).append("\n");
    sb.append("    contentType: ").append(toIndentedString(contentType)).append("\n");
    sb.append("    defenseDocumentTypeCode: ").append(toIndentedString(defenseDocumentTypeCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of DefenseDocument given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of DefenseDocument
   * @throws JsonProcessingException if the JSON string is invalid with respect to DefenseDocument
   */
  public static DefenseDocument fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, DefenseDocument.class);
  }
/**
  * Convert an instance of DefenseDocument to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
